/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.immoxml.Anbieter;
import com.openindex.openestate.impl.xml.immoxml.Anhang;
import com.openindex.openestate.impl.xml.immoxml.Immobilie;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmoPoolExportPanel;
import com.openindex.openestate.tool.agency.export.ImmoXmlExport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ImmoPoolExport
extends ImmoXmlExport {
    private final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmm");

    public ImmoPoolExport() {
        this.setLanguage(Locale.GERMAN);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new ImmoPoolExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        Immoxml immoxml = (Immoxml)super.doConvert(agencyExportSummary, serializableXmlElement, bl, map);
        for (Anbieter anbieter : immoxml.getAnbieter()) {
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                if (immobilie.getAnhaenge() == null) continue;
                ArrayList<Anhang> arrayList = new ArrayList<Anhang>();
                for (Anhang anhang : immobilie.getAnhaenge().getAnhang()) {
                    String string = anhang.getFormat();
                    if ("image/bmp".equals(string)) {
                        anhang.setFormat("bmp");
                        continue;
                    }
                    if ("image/gif".equals(string)) {
                        anhang.setFormat("gif");
                        continue;
                    }
                    if ("image/jpeg".equals(string)) {
                        anhang.setFormat("jpg");
                        continue;
                    }
                    if ("image/png".equals(string)) {
                        anhang.setFormat("png");
                        continue;
                    }
                    arrayList.add(anhang);
                }
                for (Anhang anhang : arrayList) {
                    immobilie.getAnhaenge().getAnhang().remove(anhang);
                }
            }
        }
        return immoxml;
    }

    @Override
    public String getName() {
        return "immopool";
    }

    @Override
    public List<String> getRequiredMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("image/jpeg");
        arrayList.add("image/png");
        return arrayList;
    }

    @Override
    public String getTitle() {
        return "Portal: Immopool.de";
    }

    @Override
    public String getXmlFileName() {
        String string = this.getAgentId();
        if (string == null || string.trim().length() == 0) {
            string = "";
        }
        return "IMMOPOOL-" + string.replaceAll("\\W", "") + "-" + this.DATEFORMAT.format(new Date()) + ".xml";
    }

    @Override
    public String getZipFileName() {
        String string = this.getAgentId();
        if (string == null || string.trim().length() == 0) {
            string = "";
        }
        return this.isZipped() ? "IMMOPOOL-" + string.replaceAll("\\W", "") + "-" + this.DATEFORMAT.format(new Date()) + ".zip" : null;
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }
}

