/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmoPoolExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.ResourceMap;

public class ImmoPoolExportPanel
extends AbstractExportPanel {
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JTextField estateIdPrefixField;
    private JTextField technMailField;
    private JComboBox exportModeBox;
    private JComboBox imageTypeBox;
    private JComboBox exportPricesBox;
    private JCheckBox zipExportBox;
    private JCheckBox energyCertificateBox;
    private JMimeTypeButton exportMimeTypesButton;

    public ImmoPoolExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoPoolExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.technMailField = new JTextField();
        this.technMailField.setName("technMailField");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportPricesBox = new JComboBox(new DefaultComboBoxModel());
        this.exportPricesBox.setName("exportPricesBox");
        this.exportPricesBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.always", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.never", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.default", new Object[0]));
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.technMail", new Object[0]), (Component)this.technMailField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportPrices", new Object[0]), (Component)this.exportPricesBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.exportModeBox.getSelectedIndex() != 0) {
            list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.exportModeBox.setSelectedIndex(-1);
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportPricesBox.setSelectedIndex(-1);
            this.zipExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
            this.agentIdField.setText("");
            this.technMailField.setText("");
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
            this.estateIdPrefixField.setText("");
        } else if (abstractExport instanceof ImmoPoolExport) {
            ImmoPoolExport immoPoolExport = (ImmoPoolExport)abstractExport;
            this.zipExportBox.setSelected(immoPoolExport.isZipped());
            this.energyCertificateBox.setSelected(immoPoolExport.isEnergyCertificateAppendedToDescription());
            this.agentIdField.setText(immoPoolExport.getAgentId());
            this.estateIdPrefixField.setText(immoPoolExport.getIdPrefix());
            this.technMailField.setText(immoPoolExport.getTechnMail());
            if (immoPoolExport.isIncremental()) {
                this.exportModeBox.setSelectedIndex(0);
            } else {
                this.exportModeBox.setSelectedIndex(1);
            }
            if ("default".equals(immoPoolExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(2);
            } else if ("always".equals(immoPoolExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(0);
            } else if ("never".equals(immoPoolExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(1);
            } else {
                this.exportPricesBox.setSelectedIndex(0);
            }
            if (immoPoolExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof ImmoPoolExport) {
            ImmoPoolExport immoPoolExport = (ImmoPoolExport)abstractExport;
            immoPoolExport.setZipped(this.zipExportBox.isSelected());
            immoPoolExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            immoPoolExport.setAgentId(this.agentIdField.getText().trim());
            immoPoolExport.setIdPrefix(this.estateIdPrefixField.getText().trim());
            immoPoolExport.setTechnMail(this.technMailField.getText().trim());
            immoPoolExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            if (this.exportPricesBox.getSelectedIndex() == 0) {
                immoPoolExport.setPricePublishing("always");
            } else if (this.exportPricesBox.getSelectedIndex() == 1) {
                immoPoolExport.setPricePublishing("never");
            } else if (this.exportPricesBox.getSelectedIndex() == 2) {
                immoPoolExport.setPricePublishing("default");
            } else {
                immoPoolExport.setPricePublishing(null);
            }
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                immoPoolExport.setImageMode("file");
            } else {
                immoPoolExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

