/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExport;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExportPanel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImmoWeltExport
extends OpenImmoXmlExport {
    private static final Logger LOGGER = Logger.getLogger(ImmoWeltExport.class);

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new OpenImmoXmlExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        Openimmo openimmo = (Openimmo)super.doConvert(agencyExportSummary, serializableXmlElement, bl, map);
        if (openimmo == null) {
            return null;
        }
        if (openimmo.getUebertragung() != null) {
            openimmo.getUebertragung().setVersion("1.2.6");
        }
        return openimmo;
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        Object object2;
        Openimmo openimmo = (Openimmo)object;
        if (openimmo == null) {
            return;
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            OpenImmoUtils.createMarshaller().marshal((Object)openimmo, (Node)document);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write OpenImmo-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write OpenImmo-XML!", (Throwable)exception);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            object2 = (NodeList)xPath.evaluate("/openimmo/anbieter/immobilie/zustand_angaben/energiepass/art", document.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < object2.getLength(); ++i) {
                Element element = (Element)object2.item(i);
                document.renameNode(element, element.getNamespaceURI(), "epart");
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't lookup 'energiepass/art'!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        try {
            object2 = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object2).setOutputProperty("encoding", "UTF-8");
            ((Transformer)object2).setOutputProperty("standalone", "yes");
            ((Transformer)object2).setOutputProperty("indent", "yes");
            ((Transformer)object2).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ((Transformer)object2).transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write OpenImmo-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write OpenImmo-XML!", (Throwable)exception);
        }
    }

    @Override
    public String getName() {
        return "immowelt";
    }

    @Override
    public String getTitle() {
        return "Portal: Immowelt.de";
    }
}

