/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.ImmoXmlUtils;
import com.openindex.openestate.impl.xml.immoxml.Aktion;
import com.openindex.openestate.impl.xml.immoxml.Anbieter;
import com.openindex.openestate.impl.xml.immoxml.Anhang;
import com.openindex.openestate.impl.xml.immoxml.Immobilie;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.impl.xml.immoxml.Uebertragung;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.ImmoXmlExportPanel;
import com.openindex.openestate.tool.agency.utils.ImmoXmlWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class ImmoXmlExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(ImmoXmlExport.class);
    public static final String NAME = "immoxml_xml";
    public static final String KEY_AGENT_ID = "export.immoxml.agent_id";
    public static final String KEY_TECHN_MAIL = "export.immoxml.techn_mail";
    public static final String KEY_IMMOXML_AGENT_ID = "export.immoxml.immoxml_agent_id";
    public static final String KEY_PUBLIC_ID_SUBMITTED = "export.immoxml.submit_public_id";
    public static final String KEY_PRICE_PUBLISHING = "export.immoxml.publish_prices";
    public static final String KEY_ATTACHMENT_LOCATION = "export.immoxml.attachment_location";
    public static final String ATTACHMENT_LOCATION_EXTERN = "extern";
    public static final String ATTACHMENT_LOCATION_INTERN = "intern";
    private String agentId = "";
    private String attachmentLocation = null;
    private String immoxmlAgentId = "";
    private String technMail = "";
    private boolean publicIdSubmitted = true;
    private String pricePublishing = null;

    public ImmoXmlExport() {
        this.setIncremental(true);
        this.setZipped(true);
        this.setPublicIdSubmitted(true);
        this.setLanguage(Locale.GERMAN);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new ImmoXmlExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        ImmoXmlWriter immoXmlWriter = new ImmoXmlWriter();
        immoXmlWriter.setPricePublishMode(this.getPricePublishing());
        if ("xhtml".equals(this.getLineBreak())) {
            immoXmlWriter.setXmlLineSeparator("<br/>");
        } else if ("html".equals(this.getLineBreak())) {
            immoXmlWriter.setXmlLineSeparator("<br>");
        } else if ("native".equals(this.getLineBreak())) {
            immoXmlWriter.setXmlLineSeparator(SystemUtils.LINE_SEPARATOR);
        }
        immoXmlWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        Locale locale = this.getLocale();
        if (locale != null) {
            immoXmlWriter.setOpenEstateLanguage(locale);
        }
        Immoxml immoxml = immoXmlWriter.write(serializableXmlElement);
        map.putAll(immoXmlWriter.getErrorMap());
        String string = this.getTechnMail();
        if (string == null || string.trim().length() == 0) {
            try {
                string = ImmoToolApp.getApplication().getProject().getAdress().getCompanyMail();
                if (string == null) {
                    string = "";
                }
            }
            catch (Exception exception) {
                string = "";
                LOGGER.warn((Object)"could not load 'techn_mail'!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        immoxml.getUebertragung().setTechnEmail(string.trim());
        immoxml.getUebertragung().setUmfang(bl ? Uebertragung.Umfang.TEIL : Uebertragung.Umfang.VOLL);
        String string2 = this.getAgentId();
        String string3 = this.getImmoxmlAgentId();
        if (string2 != null && string2.trim().length() > 0 || string3 != null && string3.trim().length() > 0) {
            for (Anbieter anbieter : immoxml.getAnbieter()) {
                if (string2 != null && string2.trim().length() > 0) {
                    anbieter.setAnbieternr(string2.trim());
                }
                if (string3 == null || string3.trim().length() <= 0) continue;
                anbieter.setImmoxmlAnid(string3.trim());
            }
        }
        if (this.isPublicIdSubmitted()) {
            for (Anbieter anbieter : immoxml.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    try {
                        if (immobilie.getVerwaltungTechn().getAktion() == null || !Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart())) continue;
                        String[] stringArray = immobilie.getVerwaltungTechn().getObjektnrIntern().split("\\.");
                        Object object = Long.valueOf(stringArray[stringArray.length - 1]);
                        if (!agencyExportSummary.getRemovedEstatePublicIds().containsKey(object)) continue;
                        String string4 = agencyExportSummary.getRemovedEstatePublicIds().get(object);
                        String string5 = this.getIdPrefix();
                        if (string5 != null && string5.trim().length() > 0) {
                            string4 = string5.trim() + "-" + string4;
                        }
                        immobilie.getVerwaltungTechn().setObjektnrExtern(string4);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not update public estate-id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
        }
        if (this.getAttachmentLocation() != null && this.getAttachmentLocation().trim().length() > 0) {
            for (Anbieter anbieter : immoxml.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    if (immobilie.getAnhaenge() == null) continue;
                    for (Object object : immobilie.getAnhaenge().getAnhang()) {
                        if (object.getDaten() == null || object.getDaten().getAnhanginhalt() != null) continue;
                        if (ATTACHMENT_LOCATION_EXTERN.equals(this.getAttachmentLocation())) {
                            object.setLocation(Anhang.Location.EXTERN);
                            continue;
                        }
                        if (!ATTACHMENT_LOCATION_INTERN.equals(this.getAttachmentLocation())) continue;
                        object.setLocation(Anhang.Location.INTERN);
                    }
                }
            }
        }
        return immoxml;
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            ImmoXmlUtils.createMarshaller().marshal(object, writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write ImmoXML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write ImmoXML!", (Throwable)exception);
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getAttachmentLocation() {
        return this.attachmentLocation;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        if (!this.isPublicIdSubmitted()) {
            agencyEstate.setPublicId(agencyEstate.getId());
        }
        return true;
    }

    public String getImmoxmlAgentId() {
        return this.immoxmlAgentId;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getPricePublishing() {
        return this.pricePublishing != null ? this.pricePublishing : "always";
    }

    public String getTechnMail() {
        return this.technMail;
    }

    @Override
    public String getTitle() {
        return "ImmoXML (v1.1)";
    }

    public boolean isPublicIdSubmitted() {
        return this.publicIdSubmitted;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, ""));
        this.setAttachmentLocation(properties.getProperty(KEY_ATTACHMENT_LOCATION, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setImmoxmlAgentId(properties.getProperty(KEY_IMMOXML_AGENT_ID, ""));
        this.setIncremental(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)Boolean.FALSE, (Properties)properties));
        this.setLineBreak(properties.getProperty("export.linebreak", "xhtml"));
        this.setPricePublishing(properties.getProperty(KEY_PRICE_PUBLISHING, "always"));
        this.setPublicIdSubmitted(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_SUBMITTED, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setTechnMail(properties.getProperty(KEY_TECHN_MAIL, ""));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty(KEY_ATTACHMENT_LOCATION, this.getAttachmentLocation() != null ? this.getAttachmentLocation() : "");
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty(KEY_IMMOXML_AGENT_ID, this.getImmoxmlAgentId());
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty("export.linebreak", this.getLineBreak());
        properties.setProperty(KEY_PRICE_PUBLISHING, this.getPricePublishing());
        properties.setProperty(KEY_PUBLIC_ID_SUBMITTED, Boolean.valueOf(this.isPublicIdSubmitted()).toString());
        properties.setProperty(KEY_TECHN_MAIL, this.getTechnMail());
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    public void setAttachmentLocation(String string) {
        this.attachmentLocation = string != null && string.trim().length() > 0 ? string.trim() : null;
    }

    public void setImmoxmlAgentId(String string) {
        this.immoxmlAgentId = string != null ? string.trim() : "";
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setPricePublishing(String string) {
        this.pricePublishing = string;
    }

    public void setPublicIdSubmitted(boolean bl) {
        this.publicIdSubmitted = bl;
    }

    public void setTechnMail(String string) {
        this.technMail = string != null ? string.trim() : "";
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return true;
    }
}

