/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmoXmlExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.ResourceMap;

public class ImmoXmlExportPanel
extends AbstractExportPanel {
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JTextField immoxmlAgentIdField;
    private JTextField estateIdPrefixField;
    private JTextField technMailField;
    private JComboBox exportModeBox;
    private JComboBox exportLineBreakBox;
    private JComboBox exportPricesBox;
    private JComboBox imageTypeBox;
    private JComboBox imageLocationBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox zipExportBox;
    private JCheckBox publicIdExportBox;
    private JCheckBox unpublishedAddressHiddenBox;
    private JCheckBox energyCertificateBox;
    private OpenEstateLocaleComboBox exportLocaleBox;

    public ImmoXmlExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmoXmlExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmoXmlExportPanel.this.exportMimeTypesButton.setEnabled(ImmoXmlExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.immoxmlAgentIdField = new JTextField();
        this.immoxmlAgentIdField.setName("immoxmlAgentIdField");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.technMailField = new JTextField();
        this.technMailField.setName("technMailField");
        this.exportLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.exportLocaleBox.setName("exportLocaleBox");
        this.publicIdExportBox = new JCheckBox();
        this.publicIdExportBox.setName("publicIdExportBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.unpublishedAddressHiddenBox = new JCheckBox();
        this.unpublishedAddressHiddenBox.setName("unpublishedAddressHiddenBox");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.exportLineBreakBox = new JComboBox(new DefaultComboBoxModel());
        this.exportLineBreakBox.setName("exportLineBreakBox");
        this.exportLineBreakBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.xhtml", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.html", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.native", new Object[0]));
        this.exportPricesBox = new JComboBox(new DefaultComboBoxModel());
        this.exportPricesBox.setName("exportPricesBox");
        this.exportPricesBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.always", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.never", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.default", new Object[0]));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.base64", new Object[0]));
        this.imageLocationBox = new JComboBox(new DefaultComboBoxModel());
        this.imageLocationBox.setName("imageLocationBox");
        this.imageLocationBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageLocationBox.getModel()).addElement(this.resourceMap.getString("label.imageLocation.unchanged", new Object[0]));
        ((DefaultComboBoxModel)this.imageLocationBox.getModel()).addElement(this.resourceMap.getString("label.imageLocation.intern", new Object[0]));
        ((DefaultComboBoxModel)this.imageLocationBox.getModel()).addElement(this.resourceMap.getString("label.imageLocation.extern", new Object[0]));
        this.validationHandler.putRule((JComponent)this.agentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        this.validationHandler.putRule((JComponent)this.immoxmlAgentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 25dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField);
        defaultFormBuilder.append((Component)this.exportLocaleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.technMail", new Object[0]), (Component)this.technMailField);
        defaultFormBuilder.append(this.resourceMap.getString("label.immoxmlAgentId", new Object[0]), (Component)this.immoxmlAgentIdField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageLocation", new Object[0]), (Component)this.imageLocationBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportLineBreak", new Object[0]), (Component)this.exportLineBreakBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportPrices", new Object[0]), (Component)this.exportPricesBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.publicIdExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.unpublishedAddressHiddenBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.exportModeBox.getSelectedIndex() != 0) {
            list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.exportModeBox.setSelectedIndex(-1);
            this.exportLineBreakBox.setSelectedIndex(-1);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.imageTypeBox.setSelectedIndex(-1);
            this.imageLocationBox.setSelectedIndex(-1);
            this.exportPricesBox.setSelectedIndex(-1);
            this.zipExportBox.setSelected(true);
            this.publicIdExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
            this.agentIdField.setText("");
            this.immoxmlAgentIdField.setText("");
            this.estateIdPrefixField.setText("");
            this.technMailField.setText("");
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
            this.unpublishedAddressHiddenBox.setSelected(false);
        } else if (abstractExport instanceof ImmoXmlExport) {
            ImmoXmlExport immoXmlExport = (ImmoXmlExport)abstractExport;
            this.zipExportBox.setSelected(immoXmlExport.isZipped());
            this.publicIdExportBox.setSelected(immoXmlExport.isPublicIdSubmitted());
            this.energyCertificateBox.setSelected(immoXmlExport.isEnergyCertificateAppendedToDescription());
            this.unpublishedAddressHiddenBox.setSelected(immoXmlExport.isUnpublishedAddressHidden());
            this.agentIdField.setText(immoXmlExport.getAgentId());
            this.immoxmlAgentIdField.setText(immoXmlExport.getImmoxmlAgentId());
            this.estateIdPrefixField.setText(immoXmlExport.getIdPrefix());
            this.technMailField.setText(immoXmlExport.getTechnMail());
            this.exportLocaleBox.setSelectedLocale(abstractExport.getLocale());
            this.exportModeBox.setSelectedIndex(immoXmlExport.isIncremental() ? 0 : 1);
            if ("native".equals(immoXmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(2);
            } else if ("html".equals(immoXmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(1);
            } else {
                this.exportLineBreakBox.setSelectedIndex(0);
            }
            if (immoXmlExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else if (immoXmlExport.isImageModeBase64()) {
                this.imageTypeBox.setSelectedIndex(2);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
            if ("intern".equals(immoXmlExport.getAttachmentLocation())) {
                this.imageLocationBox.setSelectedIndex(1);
            } else if ("extern".equals(immoXmlExport.getAttachmentLocation())) {
                this.imageLocationBox.setSelectedIndex(2);
            } else {
                this.imageLocationBox.setSelectedIndex(0);
            }
            if ("default".equals(immoXmlExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(2);
            } else if ("always".equals(immoXmlExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(0);
            } else if ("never".equals(immoXmlExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(1);
            } else {
                this.exportPricesBox.setSelectedIndex(0);
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof ImmoXmlExport) {
            ImmoXmlExport immoXmlExport = (ImmoXmlExport)abstractExport;
            immoXmlExport.setZipped(this.zipExportBox.isSelected());
            immoXmlExport.setPublicIdSubmitted(this.publicIdExportBox.isSelected());
            immoXmlExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            immoXmlExport.setUnpublishedAddressHidden(this.unpublishedAddressHiddenBox.isSelected());
            immoXmlExport.setAgentId(this.agentIdField.getText().trim());
            immoXmlExport.setImmoxmlAgentId(this.immoxmlAgentIdField.getText().trim());
            immoXmlExport.setIdPrefix(this.estateIdPrefixField.getText().trim());
            immoXmlExport.setTechnMail(this.technMailField.getText().trim());
            immoXmlExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            immoXmlExport.setLanguage(this.exportLocaleBox.getSelectedLocale());
            if (this.exportLineBreakBox.getSelectedIndex() == 2) {
                immoXmlExport.setLineBreak("native");
            } else if (this.exportLineBreakBox.getSelectedIndex() == 1) {
                immoXmlExport.setLineBreak("html");
            } else {
                immoXmlExport.setLineBreak("xhtml");
            }
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                immoXmlExport.setImageMode("file");
            } else if (this.imageTypeBox.getSelectedIndex() == 2) {
                immoXmlExport.setImageMode("base64");
            } else {
                immoXmlExport.setImageMode("disabled");
            }
            if (this.imageLocationBox.getSelectedIndex() == 1) {
                immoXmlExport.setAttachmentLocation("intern");
            } else if (this.imageLocationBox.getSelectedIndex() == 2) {
                immoXmlExport.setAttachmentLocation("extern");
            } else {
                immoXmlExport.setAttachmentLocation(null);
            }
            if (this.exportPricesBox.getSelectedIndex() == 0) {
                immoXmlExport.setPricePublishing("always");
            } else if (this.exportPricesBox.getSelectedIndex() == 1) {
                immoXmlExport.setPricePublishing("never");
            } else if (this.exportPricesBox.getSelectedIndex() == 2) {
                immoXmlExport.setPricePublishing("default");
            } else {
                immoXmlExport.setPricePublishing(null);
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

