/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.ImmobiliareExportPanel;
import com.openindex.openestate.tool.agency.utils.ImmobiliareWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

public class ImmobiliareExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareExport.class);
    public static final String NAME = "immobiliare_xml";
    private static final String STAMP = "immobiliare.stamp";
    public static final String KEY_BASE_URL = "export.base.url";
    public static final String KEY_AGENT_MAIL = "export.immobiliare.agent_mail";
    public static final String KEY_PUBLISHER_MAIL = "export.immobiliare.publisher_mail";
    public static final String KEY_PUBLIC_ID_USED = "export.immobiliare.public_id_used";
    private String baseUrl = "";
    private String agentMail = "";
    private String publisherMail = "";
    private boolean publicIdUsed;

    public ImmobiliareExport() {
        this.setIncremental(false);
        this.setZipped(false);
        this.setLanguage(Locale.ITALIAN);
        this.setPublicIdUsed(false);
        this.setFullTransportWarningShown(false);
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        Object object;
        ImmobiliareWriter immobiliareWriter = new ImmobiliareWriter();
        immobiliareWriter.setBaseUrl(this.getBaseUrl());
        immobiliareWriter.setXmlLineSeparator("<br/>");
        immobiliareWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        Locale locale = this.getLocale();
        if (locale != null) {
            immobiliareWriter.setOpenEstateLanguage(locale);
        }
        Feed feed = immobiliareWriter.write(serializableXmlElement);
        map.putAll(immobiliareWriter.getErrorMap());
        String string = this.getPublisherMail();
        if (StringUtils.isBlank((String)string)) {
            try {
                string = ImmoToolApp.getApplication().getProject().getAdress().getCompanyMail();
                if (string == null) {
                    string = "";
                }
            }
            catch (Exception exception) {
                string = "";
                LOGGER.warn((Object)"could not load 'techn_mail'!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        feed.getMetadata().getPublisher().setEmail(string.trim());
        String string2 = this.getAgentMail();
        if (!StringUtils.isBlank((String)string2) && (object = feed.getProperties()) != null) {
            for (Feed.Properties.Property property : object.getProperty()) {
                if (property.getAgent() == null) {
                    property.setAgent(ImmobiliareUtils.getFactory().createFeedPropertiesPropertyAgent());
                }
                property.getAgent().setEmail(string2.trim());
            }
        }
        if ("disabled".equals(this.getImageMode()) && feed.getProperties() != null) {
            for (Feed.Properties.Property property : feed.getProperties().getProperty()) {
                property.setPictures(null);
                property.setBlueprints(null);
                property.setVideos(null);
            }
        }
        return feed;
    }

    @Override
    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        FileInputStream fileInputStream;
        Object object;
        StringBuilder stringBuilder;
        block21: {
            FileOutputStream fileOutputStream;
            block20: {
                boolean bl;
                if (!file.isDirectory()) {
                    return;
                }
                LOGGER.info((Object)"preparing transport for immobiliare_xml");
                callback.checkCancelled();
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.currentTimeMillis()).append("\n");
                for (File object2 : file.listFiles()) {
                    this.buildFileList(object2, "", stringBuilder);
                }
                Object object3 = null;
                try {
                    callback.checkCancelled();
                    String[] stringArray = fTPClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    fTPClient.sendNoOp();
                    object3 = Arrays.asList(stringArray);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read existing files from FTP server!", iOException);
                }
                boolean bl2 = bl = !object3.contains(STAMP);
                if (!bl) break block20;
                callback.checkCancelled();
                LOGGER.info((Object)"> first export!");
                for (File i : file.listFiles()) {
                    if (!object3.contains(i.getName())) continue;
                    throw new AgencyExportException("The file '" + i.getName() + "' already exists on the FTP server!");
                }
                break block21;
            }
            LOGGER.info((Object)"> load immobiliare.stamp");
            object = null;
            OutputStream fileInputStream2 = null;
            String[] stringArray = null;
            try {
                callback.checkCancelled();
                object = File.createTempFile("immobiliare.", ".stamp");
                fileOutputStream = new FileOutputStream((File)object);
                fTPClient.retrieveFile(STAMP, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                String iOException = ImmoToolUtils.readFile((File)object);
                stringArray = iOException.split("\\n");
            }
            catch (IOException iOException) {
                try {
                    throw new AgencyExportException("Can't read 'immobiliare.stamp' from FTP server!", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream2);
                    FileUtils.deleteQuietly((File)object);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)object);
            LOGGER.info((Object)"> full update");
            for (int i = 1; i < stringArray.length; ++i) {
                String string2;
                callback.checkCancelled();
                String string3 = string2 = stringArray[i] != null ? stringArray[i].trim() : null;
                if (StringUtils.isBlank((String)string2)) continue;
                try {
                    if (string2.endsWith("/")) {
                        String string4 = string2.substring(0, string2.length() - 1);
                        LOGGER.info((Object)("> remove dir: " + string4));
                        if (fTPClient.removeDirectory(string4)) continue;
                        LOGGER.warn((Object)("Can't remove directory '" + string4 + "'!"));
                        continue;
                    }
                    LOGGER.info((Object)("> remove file: " + string2));
                    if (fTPClient.deleteFile(string2)) continue;
                    LOGGER.warn((Object)("Can't remove file '" + string2 + "'!"));
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)("Can't delete '" + string2 + "' from FTP server!"));
                    LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                }
            }
        }
        LOGGER.info((Object)"save immobiliare.stamp");
        object = null;
        InputStream inputStream = null;
        File file2 = new File(ImmoToolApp.getApplication().getProject().getTempDirectory().getAbsolutePath() + File.separator + STAMP);
        try {
            object = new FileWriter(file2);
            ((Writer)object).write(stringBuilder.toString());
            ((OutputStreamWriter)object).flush();
            fTPClient.sendNoOp();
            fileInputStream = new FileInputStream(file2);
            if (!fTPClient.setFileType(2)) {
                LOGGER.warn((Object)"Can't change file-type!");
            }
            if (!fTPClient.storeFile(file2.getName(), (InputStream)fileInputStream)) {
                LOGGER.warn((Object)("Can't store file: " + file2.getName()));
            }
            fTPClient.sendNoOp();
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write 'immobiliare.stamp' to FTP server!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)object);
                IOUtils.closeQuietly(inputStream);
                FileUtils.deleteQuietly((File)file2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)object);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        FileUtils.deleteQuietly((File)file2);
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            ImmobiliareUtils.createMarshaller().marshal(object, writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write Immobiliare-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write Immobiliare-XML!", (Throwable)exception);
        }
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new ImmobiliareExportPanel();
    }

    public String getAgentMail() {
        return this.agentMail;
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            return null;
        }
        if (this.baseUrl.trim().length() == 0) {
            return "";
        }
        if (!this.baseUrl.trim().endsWith("/")) {
            return this.baseUrl.trim() + "/";
        }
        return this.baseUrl;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        if (agencyEstate == null) {
            return false;
        }
        if (!super.getEstateForUpdate(agencyEstate)) {
            return false;
        }
        if (this.isPublicIdUsed() && !StringUtils.isBlank((String)agencyEstate.getPublicId())) {
            agencyEstate.setId(agencyEstate.getPublicId().trim());
        }
        return true;
    }

    @Override
    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return this.isPublicIdUsed() && agencyExportSummary.getRemovedEstatePublicIds().containsKey(l) ? agencyExportSummary.getRemovedEstatePublicIds().get(l) : super.getEstateIdForRemoval(l, agencyExportSummary);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getPublisherMail() {
        return this.publisherMail;
    }

    @Override
    public String getTitle() {
        return "Immobiliare-XML (v2.5)";
    }

    @Override
    public String getXmlFileName() {
        return "properties-full.xml";
    }

    public boolean isPublicIdUsed() {
        return this.publicIdUsed;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentMail(properties.getProperty(KEY_AGENT_MAIL, ""));
        this.setBaseUrl(properties.getProperty(KEY_BASE_URL, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setPublisherMail(properties.getProperty(KEY_PUBLISHER_MAIL, ""));
        this.setPublicIdUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED, (Boolean)false, (Properties)properties));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_MAIL, this.getAgentMail());
        properties.setProperty(KEY_BASE_URL, this.getBaseUrl());
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty(KEY_PUBLISHER_MAIL, this.getPublisherMail());
        properties.setProperty(KEY_PUBLIC_ID_USED, Boolean.valueOf(this.isPublicIdUsed()).toString());
    }

    public void setAgentMail(String string) {
        this.agentMail = string != null ? string.trim() : "";
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setPublicIdUsed(boolean bl) {
        this.publicIdUsed = bl;
    }

    public void setPublisherMail(String string) {
        this.publisherMail = string != null ? string.trim() : "";
    }

    @Override
    public boolean supportsIncrementalUpdate() {
        return false;
    }
}

