/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmobiliareExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class ImmobiliareExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JTextField baseUrlField;
    private JTextField agentMailField;
    private JTextField technMailField;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;
    private JCheckBox zipExportBox;

    public ImmobiliareExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmobiliareExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmobiliareExportPanel.this.exportMimeTypesButton.setEnabled(ImmobiliareExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.baseUrlField = new JTextField();
        this.baseUrlField.setName("baseUrlField");
        this.publicIdBox = new JCheckBox();
        this.publicIdBox.setName("publicIdBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.technMailField = new JTextField();
        this.technMailField.setName("technMailField");
        this.agentMailField = new JTextField();
        this.agentMailField.setName("agentMailField");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        this.validationHandler.putRule((JComponent)this.agentMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu");
        defaultFormBuilder.append(this.resourceMap.getString("label.baseUrl", new Object[0]), (Component)this.baseUrlField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.technMail", new Object[0]), (Component)this.technMailField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.agentMail", new Object[0]), (Component)this.agentMailField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.publicIdBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        JPanel jPanel = new JPanel(new FlowLayout(1));
        String string = ImmoToolApp.getApplication().getApplicationResources().getString("label.supportedBy", new Object[0]);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel.setBorder(titledBorder);
        try {
            this.appendFooterImage(jPanel, "<html><div style=\"padding:3px; text-align:center;\"><b>Immobilien Siller Immobili</b><br>mediatore e consulente immobiliare<br>Sterzing / Vipiteno, S\u00fcdtirol, Italia<br><b style=\"color:blue;\">www.immobili.bz.it</b></div></html>", new URL("http://www.immobili.bz.it/"), ImmoToolApp.class.getResource("/com/openindex/openestate/tool/resources/logos/siller.png"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load partner-image!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        int n = titledBorder.getMinimumSize((Component)jPanel).width + 10;
        if (n > jPanel.getPreferredSize().width) {
            jPanel.setPreferredSize(new Dimension(n, jPanel.getPreferredSize().height));
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        defaultFormBuilder.border(Borders.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)defaultFormBuilder.getPanel(), "Center");
        this.add((Component)jPanel2, "South");
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        if (this.publicIdBox.isSelected()) {
            list.add(this.resourceMap.getString("warning.publicIdExport", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.imageTypeBox.setSelectedIndex(-1);
            this.zipExportBox.setSelected(false);
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
            this.agentMailField.setText("");
            this.technMailField.setText("");
            this.baseUrlField.setText("http://");
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof ImmobiliareExport) {
            ImmobiliareExport immobiliareExport = (ImmobiliareExport)abstractExport;
            this.zipExportBox.setSelected(immobiliareExport.isZipped());
            this.agentMailField.setText(immobiliareExport.getAgentMail());
            this.technMailField.setText(immobiliareExport.getPublisherMail());
            this.baseUrlField.setText(this.baseUrlField.isEnabled() ? immobiliareExport.getBaseUrl() : "http://");
            this.publicIdBox.setSelected(immobiliareExport.isPublicIdUsed());
            this.energyCertificateBox.setSelected(immobiliareExport.isEnergyCertificateAppendedToDescription());
            if (immobiliareExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof ImmobiliareExport) {
            ImmobiliareExport immobiliareExport = (ImmobiliareExport)abstractExport;
            immobiliareExport.setZipped(this.zipExportBox.isSelected());
            immobiliareExport.setAgentMail(this.agentMailField.getText().trim());
            immobiliareExport.setPublisherMail(this.technMailField.getText().trim());
            immobiliareExport.setBaseUrl(this.baseUrlField.isEnabled() ? this.baseUrlField.getText().trim() : "");
            immobiliareExport.setPublicIdUsed(this.publicIdBox.isSelected());
            immobiliareExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                immobiliareExport.setImageMode("file");
            } else {
                immobiliareExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

