/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportList;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmobilienNetExportPanel;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.exist.xmldb.EXistResource;
import org.xmldb.api.base.Collection;

public class ImmobilienNetExport
extends OpenImmoXmlExport {
    private static final Logger LOGGER = Logger.getLogger(ImmobilienNetExport.class);
    private AgencyExportList publishList = null;

    public ImmobilienNetExport() {
        this.setZipped(true);
        this.setLineBreak("xhtml");
        this.setIncremental(false);
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdSubmitted(true);
        this.setFullTransportWarningShown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canTransportAttachment(long l, EstateAttachmentImpl estateAttachmentImpl) {
        boolean bl;
        if (this.publishList == null) {
            return true;
        }
        if (!this.publishList.hasEstateId(l)) {
            return true;
        }
        long l2 = 0L;
        try {
            l2 = Long.valueOf(this.publishList.getEstateValue(l));
        }
        catch (NumberFormatException numberFormatException) {
            l2 = 0L;
        }
        ImmoToolDb immoToolDb = ImmoToolApp.getApplication().getDatabase();
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection(immoToolDb, "/estates/files/" + l);
            if (collection == null) {
                throw new Exception("Collection not found!");
            }
            EXistResource eXistResource = (EXistResource)collection.getResource(estateAttachmentImpl.getFileAsName());
            long l3 = eXistResource.getLastModificationTime().getTime();
            bl = l3 > l2;
        }
        catch (Exception exception) {
            try {
                LOGGER.warn((Object)"Can't determine date of last modification!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
            ImmoToolDbUtils.close((Collection)collection);
            return true;
        }
        ImmoToolDbUtils.close((Collection)collection);
        return bl;
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new ImmobilienNetExportPanel();
    }

    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        callback.checkCancelled();
        try {
            this.publishList = AgencyExportList.loadExportList(agencyExportSummary.getInterfaceId(), "published");
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't read publishings!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            this.publishList = null;
        }
        return super.doExport(agencyExportSummary, callback);
    }

    @Override
    public String getName() {
        return "immobilien.net";
    }

    @Override
    public List<String> getRequiredMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("image/jpeg");
        arrayList.add("image/png");
        return arrayList;
    }

    @Override
    public String getTitle() {
        return "Portal: Immobilien.net";
    }

    @Override
    public String getXmlFileName() {
        return "openimmo.xml";
    }

    @Override
    public String getZipFileName() {
        String string = this.getAgentId();
        if (StringUtils.isBlank((String)string)) {
            string = "";
        }
        return string.replaceAll("\\W", "") + "_" + System.currentTimeMillis() + ".zip";
    }
}

