/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.ImmobilienNetExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.ResourceMap;

public class ImmobilienNetExportPanel
extends AbstractExportPanel {
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JTextField technMailField;
    private JComboBox imageTypeBox;
    private JComboBox exportPricesBox;
    private JCheckBox publicIdExportBox;
    private JCheckBox energyCertificateBox;
    private JMimeTypeButton exportMimeTypesButton;

    public ImmobilienNetExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(ImmobilienNetExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImmobilienNetExportPanel.this.exportMimeTypesButton.setEnabled(ImmobilienNetExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.technMailField = new JTextField();
        this.technMailField.setName("technMailField");
        this.publicIdExportBox = new JCheckBox();
        this.publicIdExportBox.setName("publicIdExportBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportPricesBox = new JComboBox(new DefaultComboBoxModel());
        this.exportPricesBox.setName("exportPricesBox");
        this.exportPricesBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.always", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.never", new Object[0]));
        ((DefaultComboBoxModel)this.exportPricesBox.getModel()).addElement(this.resourceMap.getString("label.exportPrices.default", new Object[0]));
        this.validationHandler.putRule((JComponent)this.agentIdField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.technMailField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object == null || object.toString().trim().length() == 0 ? true : ValidationHandler.EMAIL.isValid(object);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.technMail", new Object[0]), (Component)this.technMailField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportPrices", new Object[0]), (Component)this.exportPricesBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.publicIdExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportPricesBox.setSelectedIndex(-1);
            this.agentIdField.setText("");
            this.technMailField.setText("");
            this.publicIdExportBox.setSelected(true);
            this.energyCertificateBox.setSelected(false);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof ImmobilienNetExport) {
            ImmobilienNetExport immobilienNetExport = (ImmobilienNetExport)abstractExport;
            this.agentIdField.setText(immobilienNetExport.getAgentId());
            this.technMailField.setText(immobilienNetExport.getTechnMail());
            this.publicIdExportBox.setSelected(immobilienNetExport.isPublicIdSubmitted());
            this.energyCertificateBox.setSelected(immobilienNetExport.isEnergyCertificateAppendedToDescription());
            if ("default".equals(immobilienNetExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(2);
            } else if ("always".equals(immobilienNetExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(0);
            } else if ("never".equals(immobilienNetExport.getPricePublishing())) {
                this.exportPricesBox.setSelectedIndex(1);
            } else {
                this.exportPricesBox.setSelectedIndex(0);
            }
            if (immobilienNetExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof ImmobilienNetExport) {
            ImmobilienNetExport immobilienNetExport = (ImmobilienNetExport)abstractExport;
            immobilienNetExport.setAgentId(this.agentIdField.getText().trim());
            immobilienNetExport.setTechnMail(this.technMailField.getText().trim());
            immobilienNetExport.setPublicIdSubmitted(this.publicIdExportBox.isSelected());
            immobilienNetExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            if (this.exportPricesBox.getSelectedIndex() == 0) {
                immobilienNetExport.setPricePublishing("always");
            } else if (this.exportPricesBox.getSelectedIndex() == 1) {
                immobilienNetExport.setPricePublishing("never");
            } else if (this.exportPricesBox.getSelectedIndex() == 2) {
                immobilienNetExport.setPricePublishing("default");
            } else {
                immobilienNetExport.setPricePublishing(null);
            }
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                immobilienNetExport.setImageMode("file");
            } else {
                immobilienNetExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

