/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.Anbieter;
import com.openindex.openestate.impl.xml.openimmo.Immobilie;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExport;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;

public class ImmowebItExport
extends OpenImmoXmlExport {
    public ImmowebItExport() {
        this.setZipped(true);
        this.setLineBreak("xhtml");
        this.setLanguage(Locale.GERMAN);
        this.setPublicIdSubmitted(true);
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        TransferImpl transferImpl = (TransferImpl)serializableXmlElement;
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
        Openimmo openimmo = (Openimmo)super.doConvert(agencyExportSummary, (SerializableXmlElement)transferImpl, bl, map);
        if (openimmo == null) {
            return null;
        }
        Anbieter anbieter = (Anbieter)openimmo.getAnbieter().get(0);
        for (Immobilie immobilie : anbieter.getImmobilie()) {
            Object object;
            ValueImpl valueImpl;
            Object object2;
            ValueImpl valueImpl2;
            ValueImpl valueImpl3;
            ValueImpl valueImpl4;
            ValueImpl valueImpl5;
            ValueImpl valueImpl6;
            String string;
            EstateImpl estateImpl;
            String string2 = immobilie.getVerwaltungTechn().getObjektnrIntern();
            if (string2 == null || (estateImpl = this.getEstate(transferAgencyImpl, string2)) == null) continue;
            if (immobilie.getFlaechen() != null && (immobilie.getFlaechen().getVerkaufsflaeche() == null || immobilie.getFlaechen().getVerkaufsflaeche().longValue() < 1L) && (string = estateImpl.getAttribute("FLAECHEN", "BRUTTOFLAECHE")) != null) {
                immobilie.getFlaechen().setVerkaufsflaeche(BigDecimal.valueOf(((Number)string.getValueObject()).doubleValue()));
            }
            if ((string = estateImpl.getTitle(Locale.ITALIAN)) != null && string.trim().length() > 0) {
                valueImpl6 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                valueImpl6.setFeldname("objekttitel_it");
                valueImpl6.setContent(string.trim());
                immobilie.getUserDefinedSimplefield().add(valueImpl6);
            }
            if ((valueImpl6 = estateImpl.getAttribute("FREITEXTE", "KURZ_BESCHR")) != null && valueImpl6.hasLanguage(Locale.ITALIAN.getLanguage())) {
                valueImpl5 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                valueImpl5.setFeldname("dreizeiler_it");
                valueImpl5.setContent(valueImpl6.writeValue(Locale.ITALIAN));
                immobilie.getUserDefinedSimplefield().add(valueImpl5);
            }
            if ((valueImpl5 = estateImpl.getAttribute("FREITEXTE", "AUSSTATT_BESCHR")) != null && valueImpl5.hasLanguage(Locale.ITALIAN.getLanguage())) {
                valueImpl4 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                valueImpl4.setFeldname("ausstatt_beschr_it");
                valueImpl4.setContent(valueImpl5.writeValue(Locale.ITALIAN));
                immobilie.getUserDefinedSimplefield().add(valueImpl4);
            }
            if ((valueImpl4 = estateImpl.getAttribute("FREITEXTE", "LAGE_BESCHR")) != null && valueImpl4.hasLanguage(Locale.ITALIAN.getLanguage())) {
                valueImpl3 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                valueImpl3.setFeldname("lage_it");
                valueImpl3.setContent(valueImpl4.writeValue(Locale.ITALIAN));
                immobilie.getUserDefinedSimplefield().add(valueImpl3);
            }
            if ((valueImpl3 = estateImpl.getAttribute("FREITEXTE", "OBJEKT_BESCHR")) != null && valueImpl3.hasLanguage(Locale.ITALIAN.getLanguage())) {
                valueImpl2 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                valueImpl2.setFeldname("objektbeschreibung_it");
                valueImpl2.setContent(valueImpl3.writeValue(Locale.ITALIAN));
                immobilie.getUserDefinedSimplefield().add(valueImpl2);
            }
            if ((valueImpl2 = estateImpl.getAttribute("FREITEXTE", "SONSTIGE_ANGABEN")) != null && valueImpl2.hasLanguage(Locale.ITALIAN.getLanguage())) {
                object2 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                object2.setFeldname("sonstige_angaben_it");
                object2.setContent(valueImpl2.writeValue(Locale.ITALIAN));
                immobilie.getUserDefinedSimplefield().add(object2);
            }
            if (Locale.ITALY.getCountry().equalsIgnoreCase(estateImpl.getAdress().getCountry())) {
                object2 = estateImpl.getAttribute("PREISE", "KONVENTIONIERT");
                if (object2 != null && "JA".equalsIgnoreCase(object2.getValueObject().toString())) {
                    valueImpl = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                    valueImpl.setFeldname("konventioniert");
                    valueImpl.setContent("true");
                    immobilie.getUserDefinedSimplefield().add(valueImpl);
                } else {
                    valueImpl = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                    valueImpl.setFeldname("konventioniert");
                    valueImpl.setContent("false");
                    immobilie.getUserDefinedSimplefield().add(valueImpl);
                }
            }
            object2 = null;
            valueImpl = estateImpl.getAttribute("ENERGIEPASS", "KLASSE");
            if (valueImpl != null) {
                object = (String)valueImpl.getValueObject();
                if ("A_PLUS".equals(object)) {
                    object2 = "A+";
                } else if ("A".equals(object)) {
                    object2 = "A";
                } else if ("B".equals(object)) {
                    object2 = "B";
                } else if ("C".equals(object)) {
                    object2 = "C";
                } else if ("D".equals(object)) {
                    object2 = "D";
                } else if ("E".equals(object)) {
                    object2 = "E";
                } else if ("F".equals(object)) {
                    object2 = "F";
                } else if ("G".equals(object)) {
                    object2 = "G";
                }
            }
            if (object2 == null) {
                valueImpl = estateImpl.getAttribute("ENERGIEPASS", "VERBRAUCH_GESAMT");
                if (valueImpl == null) {
                    valueImpl = estateImpl.getAttribute("ENERGIEPASS", "BEDARF_GESAMT");
                }
                object = (Number)(valueImpl != null ? valueImpl.getValueObject() : null);
                object2 = OpenEstateUtils.getEnergyCertificateClass((Number)object, (String)"it");
            }
            if (object2 == null) continue;
            object = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            object.setFeldname("energieklasse");
            object.setContent((String)object2);
            if (immobilie.getZustandAngaben() == null) {
                immobilie.setZustandAngaben(OpenImmoUtils.getFactory().createZustandAngaben());
            }
            immobilie.getZustandAngaben().getUserDefinedSimplefield().add(object);
        }
        return openimmo;
    }

    private EstateImpl getEstate(TransferAgencyImpl transferAgencyImpl, String string) {
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            if (!string.equalsIgnoreCase(estateImpl.getId())) continue;
            return estateImpl;
        }
        return null;
    }

    @Override
    public String getName() {
        return "immoweb.it";
    }

    @Override
    public String getTitle() {
        return "Portal: Immoweb.it";
    }
}

