/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.KyeroUtils;
import com.openindex.openestate.impl.xml.kyero.PropertyType;
import com.openindex.openestate.impl.xml.kyero.Root;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.KyeroExportPanel;
import com.openindex.openestate.tool.agency.utils.KyeroWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

public class KyeroExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(KyeroExport.class);
    public static final String NAME = "kyero_xml";
    private static final String STAMP = "kyero.stamp";
    public static final String KEY_BASE_URL = "export.base.url";
    private String baseUrl = "";
    private Map<Long, Integer> imgCounter = null;

    public KyeroExport() {
        this.setIncremental(false);
        this.setZipped(false);
        this.getMimeTypes().add("image/jpeg");
        this.getMimeTypes().add("image/gif");
        this.getMimeTypes().add("image/png");
        this.setFullTransportWarningShown(false);
    }

    @Override
    protected boolean canExportAttachment(long l, EstateAttachmentImpl estateAttachmentImpl) {
        boolean bl;
        boolean bl2 = bl = estateAttachmentImpl.isName() && estateAttachmentImpl.getMimeType().startsWith("image/") && super.canExportAttachment(l, estateAttachmentImpl);
        if (!bl) {
            return false;
        }
        if (!this.imgCounter.containsKey(l)) {
            this.imgCounter.put(l, 0);
        }
        if (this.imgCounter.get(l) > 10) {
            return false;
        }
        this.imgCounter.put(l, this.imgCounter.get(l) + 1);
        return true;
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        KyeroWriter kyeroWriter = new KyeroWriter();
        kyeroWriter.setBaseUrl(this.getBaseUrl());
        kyeroWriter.setXmlLineSeparator(SystemUtils.LINE_SEPARATOR);
        kyeroWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        Locale locale = this.getLocale();
        if (locale != null) {
            kyeroWriter.setOpenEstateLanguage(locale);
        }
        Root root = kyeroWriter.write(serializableXmlElement);
        map.putAll(kyeroWriter.getErrorMap());
        if ("disabled".equals(this.getImageMode())) {
            for (PropertyType propertyType : root.getProperty()) {
                propertyType.setImages(null);
            }
        }
        return root;
    }

    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        if (this.imgCounter == null) {
            this.imgCounter = new HashMap<Long, Integer>();
        } else {
            this.imgCounter.clear();
        }
        return super.doExport(agencyExportSummary, callback);
    }

    @Override
    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        FileInputStream fileInputStream;
        Object object;
        StringBuilder stringBuilder;
        block21: {
            FileOutputStream fileOutputStream;
            block20: {
                boolean bl;
                if (!file.isDirectory()) {
                    return;
                }
                LOGGER.info((Object)"preparing transport for kyero_xml");
                callback.checkCancelled();
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.currentTimeMillis()).append("\n");
                for (File object2 : file.listFiles()) {
                    this.buildFileList(object2, "", stringBuilder);
                }
                Object object3 = null;
                try {
                    callback.checkCancelled();
                    String[] stringArray = fTPClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    fTPClient.sendNoOp();
                    object3 = Arrays.asList(stringArray);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read existing files from FTP server!", iOException);
                }
                boolean bl2 = bl = !object3.contains(STAMP);
                if (!bl) break block20;
                callback.checkCancelled();
                LOGGER.info((Object)"> first export!");
                for (File i : file.listFiles()) {
                    if (!object3.contains(i.getName())) continue;
                    throw new AgencyExportException("The file '" + i.getName() + "' already exists on the FTP server!");
                }
                break block21;
            }
            LOGGER.info((Object)"> load kyero.stamp");
            object = null;
            OutputStream fileInputStream2 = null;
            String[] stringArray = null;
            try {
                callback.checkCancelled();
                object = File.createTempFile("kyero.", ".stamp");
                fileOutputStream = new FileOutputStream((File)object);
                fTPClient.retrieveFile(STAMP, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                String iOException = ImmoToolUtils.readFile((File)object);
                stringArray = iOException.split("\\n");
            }
            catch (IOException iOException) {
                try {
                    throw new AgencyExportException("Can't read 'kyero.stamp' from FTP server!", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream2);
                    FileUtils.deleteQuietly((File)object);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)object);
            LOGGER.info((Object)"> full update");
            for (int i = 1; i < stringArray.length; ++i) {
                String string2;
                callback.checkCancelled();
                String string3 = string2 = stringArray[i] != null ? stringArray[i].trim() : null;
                if (StringUtils.isBlank((String)string2)) continue;
                try {
                    if (string2.endsWith("/")) {
                        String string4 = string2.substring(0, string2.length() - 1);
                        LOGGER.info((Object)("> remove dir: " + string4));
                        if (fTPClient.removeDirectory(string4)) continue;
                        LOGGER.warn((Object)("Can't remove directory '" + string4 + "'!"));
                        continue;
                    }
                    LOGGER.info((Object)("> remove file: " + string2));
                    if (fTPClient.deleteFile(string2)) continue;
                    LOGGER.warn((Object)("Can't remove file '" + string2 + "'!"));
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)("Can't delete '" + string2 + "' from FTP server!"));
                    LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                }
            }
        }
        LOGGER.info((Object)"save kyero.stamp");
        object = null;
        InputStream inputStream = null;
        File file2 = new File(ImmoToolApp.getApplication().getProject().getTempDirectory().getAbsolutePath() + File.separator + STAMP);
        try {
            object = new FileWriter(file2);
            ((Writer)object).write(stringBuilder.toString());
            ((OutputStreamWriter)object).flush();
            fTPClient.sendNoOp();
            fileInputStream = new FileInputStream(file2);
            if (!fTPClient.setFileType(2)) {
                LOGGER.warn((Object)"Can't change file-type!");
            }
            if (!fTPClient.storeFile(file2.getName(), (InputStream)fileInputStream)) {
                LOGGER.warn((Object)("Can't store file: " + file2.getName()));
            }
            fTPClient.sendNoOp();
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write 'kyero.stamp' to FTP server!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)object);
                IOUtils.closeQuietly(inputStream);
                FileUtils.deleteQuietly((File)file2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)object);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        FileUtils.deleteQuietly((File)file2);
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            KyeroUtils.createMarshaller().marshal(object, writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write Kyero-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write Kyero-XML!", (Throwable)exception);
        }
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new KyeroExportPanel();
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            return null;
        }
        if (this.baseUrl.trim().length() == 0) {
            return "";
        }
        if (!this.baseUrl.trim().endsWith("/")) {
            return this.baseUrl.trim() + "/";
        }
        return this.baseUrl;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        if (agencyEstate == null) {
            return false;
        }
        return super.getEstateForUpdate(agencyEstate);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Kyero-XML (v2.1)";
    }

    @Override
    public String getXmlFileName() {
        return "kyero.xml";
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setBaseUrl(properties.getProperty(KEY_BASE_URL, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_BASE_URL, this.getBaseUrl());
        properties.setProperty("export.imagemode", this.getImageMode());
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    @Override
    public boolean supportsIncrementalUpdate() {
        return false;
    }
}

