/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.KyeroExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class KyeroExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(KyeroExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JTextField baseUrlField;
    private JCheckBox energyCertificateBox;
    private JCheckBox zipExportBox;

    public KyeroExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(KyeroExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KyeroExportPanel.this.exportMimeTypesButton.setEnabled(KyeroExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.baseUrlField = new JTextField();
        this.baseUrlField.setName("baseUrlField");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        try {
            this.exportMimeTypesButton.addImageTypes(new String[]{"image/gif", "image/jpeg", "image/png"});
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't register image mime-types!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.baseUrl", new Object[0]), (Component)this.baseUrlField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.imageTypeBox.setSelectedIndex(-1);
            this.energyCertificateBox.setSelected(false);
            this.zipExportBox.setSelected(false);
            this.baseUrlField.setText("http://");
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof KyeroExport) {
            KyeroExport kyeroExport = (KyeroExport)abstractExport;
            this.zipExportBox.setSelected(kyeroExport.isZipped());
            this.energyCertificateBox.setSelected(kyeroExport.isEnergyCertificateAppendedToDescription());
            this.baseUrlField.setText(this.baseUrlField.isEnabled() ? kyeroExport.getBaseUrl() : "http://");
            if (kyeroExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof KyeroExport) {
            KyeroExport kyeroExport = (KyeroExport)abstractExport;
            kyeroExport.setZipped(this.zipExportBox.isSelected());
            kyeroExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            kyeroExport.setBaseUrl(this.baseUrlField.isEnabled() ? this.baseUrlField.getText().trim() : "");
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                kyeroExport.setImageMode("file");
            } else {
                kyeroExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

