/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.LocalTransportPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jdesktop.application.ResourceMap;

public class LocalTransport
extends AbstractTransport {
    public static final String NAME = "local";
    public static final String KEY_LOCAL_DIRECTORY = "transport.local.directory";
    private ResourceMap resourceMap;
    private File localDirectory = new File("");

    public LocalTransport() {
        this.resourceMap = ImmoToolUtils.getResourceMap(LocalTransport.class);
    }

    @Override
    public AbstractTransportPanel createSetupPanel() {
        return new LocalTransportPanel();
    }

    private void doCopy(File file, File file2) throws IOException {
        if (file.isFile()) {
            File file3 = new File(file2.getAbsolutePath() + File.separator + file.getName());
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            fileInputStream.close();
        } else if (file.isDirectory()) {
            File file4 = new File(file2.getAbsolutePath() + File.separator + file.getName());
            if (!file4.exists() && !file4.mkdir()) {
                throw new IOException("could not create local directory: " + file4.getAbsolutePath());
            }
            for (File file5 : file.listFiles()) {
                this.doCopy(file5, file4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void doTransport(File file, AbstractExport abstractExport, AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        block8: {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH-mm");
            callback.checkCancelled();
            Date date = new Date();
            File file2 = null;
            int n = 0;
            while (file2 == null || file2.exists()) {
                void object;
                String iOException = simpleDateFormat.format(date) + "_" + simpleDateFormat2.format(date);
                if (n > 0) {
                    String string = iOException + "_" + n;
                }
                file2 = new File(this.getLocalDirectory().getAbsolutePath() + File.separator + (String)object);
                ++n;
            }
            if (!file2.exists() && !file2.mkdirs()) {
                throw new AgencyExportException("Can't create output directory '" + file2.getAbsolutePath() + "'!");
            }
            try {
                if (file.isDirectory()) {
                    for (File file3 : file.listFiles()) {
                        callback.checkCancelled();
                        this.doCopy(file3, file2);
                    }
                    break block8;
                }
                if (file.isFile()) {
                    callback.checkCancelled();
                    this.doCopy(file, file2);
                    break block8;
                }
                throw new AgencyExportException("Invalid export file '" + file.getAbsolutePath() + "'!");
            }
            catch (IOException iOException) {
                throw new AgencyExportException("Can't save exported file to '" + file2.getAbsolutePath() + "'!", iOException);
            }
        }
    }

    public File getLocalDirectory() {
        return this.localDirectory;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setLocalDirectory(new File(properties.getProperty(KEY_LOCAL_DIRECTORY, "")));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_LOCAL_DIRECTORY, this.getLocalDirectory() != null ? this.getLocalDirectory().getAbsolutePath() : "");
    }

    public void setLocalDirectory(File file) {
        this.localDirectory = file;
    }
}

