/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractTransport;
import com.openindex.openestate.tool.agency.export.AbstractTransportPanel;
import com.openindex.openestate.tool.agency.export.LocalTransport;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;

public class LocalTransportPanel
extends AbstractTransportPanel {
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField directoryField;
    private JButton directoryButton;

    public LocalTransportPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(LocalTransportPanel.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(LocalTransportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.validationHandler.init();
        this.directoryButton.setAction(this.actionMap.get(this.directoryButton.getText()));
    }

    private void buildForm() {
        this.directoryField = new JTextField();
        this.directoryField.setName("directoryField");
        this.directoryButton = new JButton();
        this.directoryButton.setText("doSelectDirectory");
        this.validationHandler.putRule((JComponent)this.directoryField, new ValidationRule(){

            public boolean isValid(Object object) {
                return new File((String)object).isDirectory();
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:50dlu, 3dlu, 30dlu:grow, 3dlu, pref", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.directory", new Object[0]), (Component)this.directoryField);
        defaultFormBuilder.append((Component)this.directoryButton);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Action
    public void doSelectDirectory() {
        int n;
        File file = AgencyPlugin.getLastExportLocation();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("doSelectDirectory.Title", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("doSelectDirectory.Button", new Object[0]));
        jFileChooser.setFileSelectionMode(1);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        if ((n = jFileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        AgencyPlugin.setLastExportLocation(jFileChooser.getSelectedFile());
        this.directoryField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        this.validationHandler.validate((JComponent)this.directoryField);
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractTransport abstractTransport) {
        if (abstractTransport == null) {
            this.directoryField.setText(SystemUtils.getUserHome().getAbsolutePath());
        } else if (abstractTransport instanceof LocalTransport) {
            LocalTransport localTransport = (LocalTransport)abstractTransport;
            File file = localTransport.getLocalDirectory() != null ? localTransport.getLocalDirectory() : new File("");
            this.directoryField.setText(file.getAbsolutePath());
        } else {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractTransport abstractTransport) {
        if (!(abstractTransport instanceof LocalTransport)) {
            throw new IllegalArgumentException("invalid transport-class: " + abstractTransport.getClass().getName());
        }
        LocalTransport localTransport = (LocalTransport)abstractTransport;
        localTransport.setLocalDirectory(new File(this.directoryField.getText().trim()));
    }
}

