/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.OpenEstateXmlExportPanel;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class OpenEstateXmlExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(OpenEstateXmlExport.class);
    public static final String NAME = "openestate_xml";

    public OpenEstateXmlExport() {
        this.setIncremental(false);
        this.setZipped(true);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new OpenEstateXmlExportPanel();
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            TransferImpl transferImpl = (TransferImpl)object;
            String string = null;
            if ("xhtml".equals(this.getLineBreak())) {
                string = "<br/>";
            } else if ("html".equals(this.getLineBreak())) {
                string = "<br>";
            } else if ("native".equals(this.getLineBreak())) {
                string = SystemUtils.LINE_SEPARATOR;
            }
            OpenEstateUtils.serializeToXML((SerializableXmlElement)transferImpl, (Writer)writer, (boolean)true, (String)"UTF-8", (String)string);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write OpenEstate-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write OpenEstate-XML!", (Throwable)exception);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "OpenEstate-XML (v1.0)";
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(properties.getProperty("export.incremental", Boolean.FALSE.toString()).trim().equalsIgnoreCase(Boolean.TRUE.toString()));
        this.setLineBreak(properties.getProperty("export.linebreak", "xhtml"));
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        agencyEstate.getCustomValues().getValueMap().clear();
        return true;
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty("export.imagemode", String.valueOf(this.getImageMode()));
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty("export.linebreak", this.getLineBreak());
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return true;
    }
}

