/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.OpenEstateXmlExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.ResourceMap;

public class OpenEstateXmlExportPanel
extends AbstractExportPanel {
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField estateIdPrefixField;
    private JComboBox exportModeBox;
    private JComboBox exportLineBreakBox;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox zipExportBox;

    public OpenEstateXmlExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(OpenEstateXmlExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenEstateXmlExportPanel.this.exportMimeTypesButton.setEnabled(OpenEstateXmlExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.zipExportBox = new JCheckBox();
        this.zipExportBox.setName("zipExportBox");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.exportLineBreakBox = new JComboBox(new DefaultComboBoxModel());
        this.exportLineBreakBox.setName("exportLineBreakBox");
        this.exportLineBreakBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.xhtml", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.html", new Object[0]));
        ((DefaultComboBoxModel)this.exportLineBreakBox.getModel()).addElement(this.resourceMap.getString("label.exportLineBreak.native", new Object[0]));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.base64", new Object[0]));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportLineBreak", new Object[0]), (Component)this.exportLineBreakBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.zipExportBox, 5);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        if (this.exportModeBox.getSelectedIndex() != 0) {
            list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.exportModeBox.setSelectedIndex(-1);
            this.exportLineBreakBox.setSelectedIndex(-1);
            this.imageTypeBox.setSelectedIndex(-1);
            this.zipExportBox.setSelected(true);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
            this.estateIdPrefixField.setText("");
        } else if (abstractExport instanceof OpenEstateXmlExport) {
            OpenEstateXmlExport openEstateXmlExport = (OpenEstateXmlExport)abstractExport;
            this.zipExportBox.setSelected(openEstateXmlExport.isZipped());
            this.estateIdPrefixField.setText(openEstateXmlExport.getIdPrefix());
            if (openEstateXmlExport.isIncremental()) {
                this.exportModeBox.setSelectedIndex(0);
            } else {
                this.exportModeBox.setSelectedIndex(1);
            }
            if ("native".equals(openEstateXmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(2);
            } else if ("html".equals(openEstateXmlExport.getLineBreak())) {
                this.exportLineBreakBox.setSelectedIndex(1);
            } else {
                this.exportLineBreakBox.setSelectedIndex(0);
            }
            if (openEstateXmlExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else if (openEstateXmlExport.isImageModeBase64()) {
                this.imageTypeBox.setSelectedIndex(2);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof OpenEstateXmlExport) {
            OpenEstateXmlExport openEstateXmlExport = (OpenEstateXmlExport)abstractExport;
            openEstateXmlExport.setZipped(this.zipExportBox.isSelected());
            openEstateXmlExport.setIdPrefix(this.estateIdPrefixField.getText().trim());
            openEstateXmlExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            if (this.exportLineBreakBox.getSelectedIndex() == 2) {
                openEstateXmlExport.setLineBreak("native");
            } else if (this.exportLineBreakBox.getSelectedIndex() == 1) {
                openEstateXmlExport.setLineBreak("html");
            } else {
                openEstateXmlExport.setLineBreak("xhtml");
            }
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                openEstateXmlExport.setImageMode("file");
            } else if (this.imageTypeBox.getSelectedIndex() == 2) {
                openEstateXmlExport.setImageMode("base64");
            } else {
                openEstateXmlExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

