/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.Aktion;
import com.openindex.openestate.impl.xml.openimmo.Anbieter;
import com.openindex.openestate.impl.xml.openimmo.Anhang;
import com.openindex.openestate.impl.xml.openimmo.Immobilie;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.impl.xml.openimmo.Uebertragung;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.OpenImmoXmlExportPanel;
import com.openindex.openestate.tool.agency.utils.OpenImmoWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class OpenImmoXmlExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(OpenImmoXmlExport.class);
    public static final String NAME = "openimmo_xml";
    public static final String KEY_AGENT_ID = "export.openimmo.agent_id";
    public static final String KEY_OPENIMMO_AGENT_ID = "export.openimmo.openimmo_agent_id";
    public static final String KEY_TECHN_MAIL = "export.openimmo.techn_mail";
    public static final String KEY_PUBLIC_ID_SUBMITTED = "export.openimmo.submit_public_id";
    public static final String KEY_PRICE_PUBLISHING = "export.openimmo.publish_prices";
    public static final String KEY_ATTACHMENT_LOCATION = "export.openimmo.attachment_location";
    public static final String ATTACHMENT_LOCATION_EXTERN = "extern";
    public static final String ATTACHMENT_LOCATION_INTERN = "intern";
    @Deprecated
    private static final String OLD_KEY_AGENT_ID = "export.agent_id";
    @Deprecated
    private static final String OLD_KEY_OPENIMMO_AGENT_ID = "export.openimmo_agent_id";
    @Deprecated
    private static final String OLD_KEY_ATTACHMENT_LOCATION = "export.immoxml.attachment_location";
    private String agentId = "";
    private String attachmentLocation = null;
    private String openimmoAgentId = "";
    private String technMail = "";
    private boolean publicIdSubmitted = false;
    private String pricePublishing = null;

    public OpenImmoXmlExport() {
        this.build();
    }

    private void build() {
        this.setIncremental(true);
        this.setZipped(true);
        this.setPublicIdSubmitted(true);
        this.setLanguage(Locale.GERMAN);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new OpenImmoXmlExportPanel();
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        OpenImmoWriter openImmoWriter = new OpenImmoWriter();
        openImmoWriter.setVersion(this.getOpenImmoVersion());
        openImmoWriter.setPricePublishMode(this.getPricePublishing());
        if ("xhtml".equals(this.getLineBreak())) {
            openImmoWriter.setXmlLineSeparator("<br/>");
        } else if ("html".equals(this.getLineBreak())) {
            openImmoWriter.setXmlLineSeparator("<br>");
        } else if ("native".equals(this.getLineBreak())) {
            openImmoWriter.setXmlLineSeparator(SystemUtils.LINE_SEPARATOR);
        }
        openImmoWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        Locale locale = this.getLocale();
        if (locale != null) {
            openImmoWriter.setOpenEstateLanguage(locale);
        }
        Openimmo openimmo = openImmoWriter.write(serializableXmlElement);
        map.putAll(openImmoWriter.getErrorMap());
        String string = this.getTechnMail();
        if (string == null || string.trim().length() == 0) {
            try {
                string = ImmoToolApp.getApplication().getProject().getAdress().getCompanyMail();
                if (string == null) {
                    string = "";
                }
            }
            catch (Exception exception) {
                string = "";
                LOGGER.warn((Object)"could not load 'techn_mail'!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        openimmo.getUebertragung().setTechnEmail(string.trim());
        openimmo.getUebertragung().setUmfang(bl ? Uebertragung.Umfang.TEIL : Uebertragung.Umfang.VOLL);
        String string2 = this.getAgentId();
        String string3 = this.getOpenimmoAgentId();
        if (string2 != null && string2.trim().length() > 0 || string3 != null && string3.trim().length() > 0) {
            for (Anbieter anbieter : openimmo.getAnbieter()) {
                if (string2 != null && string2.trim().length() > 0) {
                    anbieter.setAnbieternr(string2.trim());
                }
                if (string3 == null || string3.trim().length() <= 0) continue;
                anbieter.setOpenimmoAnid(string3.trim());
            }
        }
        if (this.isPublicIdSubmitted()) {
            for (Anbieter anbieter : openimmo.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    try {
                        if (immobilie.getVerwaltungTechn().getAktion() == null || !Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart())) continue;
                        String[] stringArray = immobilie.getVerwaltungTechn().getObjektnrIntern().split("\\.");
                        Object object = Long.valueOf(stringArray[stringArray.length - 1]);
                        if (!agencyExportSummary.getRemovedEstatePublicIds().containsKey(object)) continue;
                        String string4 = agencyExportSummary.getRemovedEstatePublicIds().get(object);
                        String string5 = this.getIdPrefix();
                        if (string5 != null && string5.trim().length() > 0) {
                            string4 = string5.trim() + "-" + string4;
                        }
                        immobilie.getVerwaltungTechn().setObjektnrExtern(string4);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"could not update public estate-id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
        }
        if (this.getAttachmentLocation() != null && this.getAttachmentLocation().trim().length() > 0) {
            for (Anbieter anbieter : openimmo.getAnbieter()) {
                for (Immobilie immobilie : anbieter.getImmobilie()) {
                    if (immobilie.getAnhaenge() == null) continue;
                    for (Object object : immobilie.getAnhaenge().getAnhang()) {
                        if (object.getDaten() == null || object.getDaten().getAnhanginhalt() != null) continue;
                        if (ATTACHMENT_LOCATION_EXTERN.equals(this.getAttachmentLocation())) {
                            object.setLocation(Anhang.Location.EXTERN);
                            continue;
                        }
                        if (!ATTACHMENT_LOCATION_INTERN.equals(this.getAttachmentLocation())) continue;
                        object.setLocation(Anhang.Location.INTERN);
                    }
                }
            }
        }
        return openimmo;
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            OpenImmoUtils.createMarshaller().marshal(object, writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write OpenImmo-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write OpenImmo-XML!", (Throwable)exception);
        }
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getAttachmentLocation() {
        return this.attachmentLocation;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        boolean bl = super.getEstateForUpdate(agencyEstate);
        if (!bl) {
            return false;
        }
        if (!this.isPublicIdSubmitted()) {
            agencyEstate.setPublicId(agencyEstate.getId());
        }
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getOpenimmoAgentId() {
        return this.openimmoAgentId;
    }

    protected String getOpenImmoVersion() {
        return "1.2.1";
    }

    public String getPricePublishing() {
        return this.pricePublishing != null ? this.pricePublishing : "always";
    }

    public String getTechnMail() {
        return this.technMail;
    }

    @Override
    public String getTitle() {
        return "OpenImmo-XML (v" + this.getOpenImmoVersion() + ")";
    }

    public boolean isPublicIdSubmitted() {
        return this.publicIdSubmitted;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, properties.getProperty(OLD_KEY_AGENT_ID, "")));
        this.setAttachmentLocation(properties.getProperty(KEY_ATTACHMENT_LOCATION, properties.getProperty(OLD_KEY_ATTACHMENT_LOCATION)));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)Boolean.FALSE, (Properties)properties));
        this.setLineBreak(properties.getProperty("export.linebreak", "xhtml"));
        this.setOpenimmoAgentId(properties.getProperty(KEY_OPENIMMO_AGENT_ID, properties.getProperty(OLD_KEY_OPENIMMO_AGENT_ID, "")));
        this.setPricePublishing(properties.getProperty(KEY_PRICE_PUBLISHING, "always"));
        this.setPublicIdSubmitted(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_SUBMITTED, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setTechnMail(properties.getProperty(KEY_TECHN_MAIL, ""));
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty(KEY_ATTACHMENT_LOCATION, this.getAttachmentLocation() != null ? this.getAttachmentLocation() : "");
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty("export.linebreak", this.getLineBreak());
        properties.setProperty(KEY_OPENIMMO_AGENT_ID, this.getOpenimmoAgentId());
        properties.setProperty(KEY_PRICE_PUBLISHING, this.getPricePublishing());
        properties.setProperty(KEY_PUBLIC_ID_SUBMITTED, Boolean.valueOf(this.isPublicIdSubmitted()).toString());
        properties.setProperty(KEY_TECHN_MAIL, this.getTechnMail());
        properties.remove(OLD_KEY_AGENT_ID);
        properties.remove(OLD_KEY_OPENIMMO_AGENT_ID);
        properties.remove(OLD_KEY_ATTACHMENT_LOCATION);
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    public void setAttachmentLocation(String string) {
        this.attachmentLocation = string != null && string.trim().length() > 0 ? string.trim() : null;
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setOpenimmoAgentId(String string) {
        this.openimmoAgentId = string != null ? string.trim() : "";
    }

    public void setPricePublishing(String string) {
        this.pricePublishing = string;
    }

    public void setPublicIdSubmitted(boolean bl) {
        this.publicIdSubmitted = bl;
    }

    public void setTechnMail(String string) {
        this.technMail = string != null ? string.trim() : "";
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return true;
    }
}

