/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ValidationHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class WebsiteExportFilterDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(WebsiteExportFilterDialog.class);
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private int status = 0;
    private boolean isActionRunning = false;
    private String selectedEstateAction = null;
    private OpenEstateType selectedEstateType = null;
    private JButton closeButton;
    private JComboBox estateActionField;
    private JXTitledSeparator estateActionLabel;
    private JComboBox estateType1Field;
    private JComboBox estateType2Field;
    private JComboBox estateType3Field;
    private JComboBox estateType4Field;
    private JXTitledSeparator estateTypeLabel;
    private JButton helpButton;
    private JLabel infoLabel;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public WebsiteExportFilterDialog() throws OpenEstateException {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public WebsiteExportFilterDialog(Frame frame, boolean bl) throws OpenEstateException {
        super(frame, bl);
        this.build();
    }

    private void build() throws OpenEstateException {
        this.actionMap = ImmoToolUtils.getActionMap(WebsiteExportFilterDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(WebsiteExportFilterDialog.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.closeButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        this.estateType1Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebsiteExportFilterDialog.this.isActionRunning) {
                    return;
                }
                WebsiteExportFilterDialog.this.isActionRunning = true;
                int n = WebsiteExportFilterDialog.this.estateType1Field.getSelectedIndex();
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType2Field);
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType3Field);
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType4Field);
                if (n <= 0) {
                    WebsiteExportFilterDialog.this.selectEstateType(null, null);
                } else {
                    EstateTypeItem estateTypeItem = (EstateTypeItem)WebsiteExportFilterDialog.this.estateType1Field.getSelectedItem();
                    WebsiteExportFilterDialog.this.doUpdateEstateTypesBox(WebsiteExportFilterDialog.this.estateType2Field, estateTypeItem.getName());
                    WebsiteExportFilterDialog.this.selectEstateType(estateTypeItem.getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                }
                WebsiteExportFilterDialog.this.isActionRunning = false;
            }
        });
        this.estateType2Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebsiteExportFilterDialog.this.isActionRunning) {
                    return;
                }
                WebsiteExportFilterDialog.this.isActionRunning = true;
                int n = WebsiteExportFilterDialog.this.estateType2Field.getSelectedIndex();
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType3Field);
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType4Field);
                if (n <= 0) {
                    if (WebsiteExportFilterDialog.this.estateType1Field.getSelectedIndex() > 0) {
                        WebsiteExportFilterDialog.this.selectEstateType(((EstateTypeItem)WebsiteExportFilterDialog.this.estateType1Field.getSelectedItem()).getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                    }
                } else {
                    EstateTypeItem estateTypeItem = (EstateTypeItem)WebsiteExportFilterDialog.this.estateType2Field.getSelectedItem();
                    WebsiteExportFilterDialog.this.doUpdateEstateTypesBox(WebsiteExportFilterDialog.this.estateType3Field, estateTypeItem.getName());
                    WebsiteExportFilterDialog.this.selectEstateType(estateTypeItem.getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                }
                WebsiteExportFilterDialog.this.isActionRunning = false;
            }
        });
        this.estateType3Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebsiteExportFilterDialog.this.isActionRunning) {
                    return;
                }
                WebsiteExportFilterDialog.this.isActionRunning = true;
                int n = WebsiteExportFilterDialog.this.estateType3Field.getSelectedIndex();
                WebsiteExportFilterDialog.this.doEmptyEstateTypesBox(WebsiteExportFilterDialog.this.estateType4Field);
                if (n <= 0) {
                    if (WebsiteExportFilterDialog.this.estateType2Field.getSelectedIndex() > 0) {
                        WebsiteExportFilterDialog.this.selectEstateType(((EstateTypeItem)WebsiteExportFilterDialog.this.estateType2Field.getSelectedItem()).getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                    }
                } else {
                    EstateTypeItem estateTypeItem = (EstateTypeItem)WebsiteExportFilterDialog.this.estateType3Field.getSelectedItem();
                    WebsiteExportFilterDialog.this.doUpdateEstateTypesBox(WebsiteExportFilterDialog.this.estateType4Field, estateTypeItem.getName());
                    WebsiteExportFilterDialog.this.selectEstateType(estateTypeItem.getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                }
                WebsiteExportFilterDialog.this.isActionRunning = false;
            }
        });
        this.estateType4Field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebsiteExportFilterDialog.this.isActionRunning) {
                    return;
                }
                WebsiteExportFilterDialog.this.isActionRunning = true;
                int n = WebsiteExportFilterDialog.this.estateType4Field.getSelectedIndex();
                if (n <= 0) {
                    if (WebsiteExportFilterDialog.this.estateType3Field.getSelectedIndex() > 0) {
                        WebsiteExportFilterDialog.this.selectEstateType(((EstateTypeItem)WebsiteExportFilterDialog.this.estateType3Field.getSelectedItem()).getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                    }
                } else {
                    EstateTypeItem estateTypeItem = (EstateTypeItem)WebsiteExportFilterDialog.this.estateType4Field.getSelectedItem();
                    WebsiteExportFilterDialog.this.selectEstateType(estateTypeItem.getType(), WebsiteExportFilterDialog.this.selectedEstateAction);
                }
                WebsiteExportFilterDialog.this.isActionRunning = false;
            }
        });
        this.estateActionField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebsiteExportFilterDialog.this.isActionRunning) {
                    return;
                }
                WebsiteExportFilterDialog.this.isActionRunning = true;
                int n = WebsiteExportFilterDialog.this.estateActionField.getSelectedIndex();
                if (n <= 0) {
                    WebsiteExportFilterDialog.this.selectEstateType(WebsiteExportFilterDialog.this.selectedEstateType, null);
                } else {
                    EstateActionItem estateActionItem = (EstateActionItem)WebsiteExportFilterDialog.this.estateActionField.getSelectedItem();
                    WebsiteExportFilterDialog.this.selectEstateType(WebsiteExportFilterDialog.this.selectedEstateType, estateActionItem.getName());
                }
                WebsiteExportFilterDialog.this.isActionRunning = false;
            }
        });
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.helpButton.setEnabled(false);
        this.doUpdateEstateTypesBox(this.estateType1Field, null);
        this.doEmptyEstateTypesBox(this.estateType2Field);
        this.doEmptyEstateTypesBox(this.estateType3Field);
        this.doEmptyEstateTypesBox(this.estateType4Field);
        this.load((String)null, null);
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    private void doEmptyEstateTypesBox(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.setEnabled(false);
    }

    @Action
    public void doHelp() {
    }

    private void doSelectEstateAction(JComboBox jComboBox, String string) {
        for (int i = 1; i < jComboBox.getItemCount(); ++i) {
            EstateActionItem estateActionItem = (EstateActionItem)jComboBox.getItemAt(i);
            if (!estateActionItem.getName().equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            return;
        }
        jComboBox.setSelectedIndex(0);
    }

    private void doSelectEstateType(JComboBox jComboBox, String string) {
        for (int i = 1; i < jComboBox.getItemCount(); ++i) {
            EstateTypeItem estateTypeItem = (EstateTypeItem)jComboBox.getItemAt(i);
            if (!estateTypeItem.getName().equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            return;
        }
        jComboBox.setSelectedIndex(0);
    }

    @Action
    public void doSubmit() {
        if (this.getSelectedEstateAction() == null && this.getSelectedEstateType() == null) {
            this.setAlwaysOnTop(false);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidSelection", new Object[0]));
            this.setAlwaysOnTop(true);
            return;
        }
        this.status = 2;
        this.setVisible(false);
    }

    private void doUpdateEstateTypesBox(JComboBox jComboBox, String string) {
        TreeMap<String, OpenEstateType> treeMap = new TreeMap<String, OpenEstateType>();
        try {
            if (string == null || string.trim().length() == 0) {
                for (OpenEstateType openEstateType : OpenEstateUtils.getEstateTypesOnRoot()) {
                    treeMap.put(openEstateType.getName(), openEstateType);
                }
            } else {
                OpenEstateType openEstateType = OpenEstateType.newInstance((String)string);
                for (String string2 : openEstateType.getChildren()) {
                    treeMap.put(string2, OpenEstateType.newInstance((String)string2));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"estate-type-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        if (!treeMap.isEmpty()) {
            jComboBox.setEnabled(true);
            if (jComboBox == this.estateType1Field) {
                jComboBox.addItem("[ " + this.resourceMap.getString("label.estateTypes.all", new Object[0]) + " ]");
            } else {
                jComboBox.addItem("[ " + this.resourceMap.getString("label.estateTypes.fromThis", new Object[0]) + " ]");
            }
            for (OpenEstateType openEstateType : treeMap.values()) {
                jComboBox.addItem(new EstateTypeItem(openEstateType));
            }
        } else {
            jComboBox.setEnabled(false);
            jComboBox.addItem("[ " + this.resourceMap.getString("label.estateTypes.noMorePrecision", new Object[0]) + " ]");
        }
    }

    public String getSelectedEstateAction() {
        return this.estateActionField.getSelectedIndex() > 0 ? ((EstateActionItem)this.estateActionField.getSelectedItem()).getName() : null;
    }

    public OpenEstateType getSelectedEstateType() {
        if (this.estateType4Field.getSelectedIndex() > 0) {
            return ((EstateTypeItem)this.estateType4Field.getSelectedItem()).getType();
        }
        if (this.estateType3Field.getSelectedIndex() > 0) {
            return ((EstateTypeItem)this.estateType3Field.getSelectedItem()).getType();
        }
        if (this.estateType2Field.getSelectedIndex() > 0) {
            return ((EstateTypeItem)this.estateType2Field.getSelectedItem()).getType();
        }
        if (this.estateType1Field.getSelectedIndex() > 0) {
            return ((EstateTypeItem)this.estateType1Field.getSelectedItem()).getType();
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public final void load(String string, String string2) throws OpenEstateException {
        this.load(string != null ? OpenEstateType.newInstance((String)string) : null, string2);
    }

    public void load(OpenEstateType openEstateType, String string) throws OpenEstateException {
        this.isActionRunning = true;
        this.selectEstateType(openEstateType, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (openEstateType != null) {
            arrayList.addAll(Arrays.asList(OpenEstateUtils.getEstateTypePath((OpenEstateType)openEstateType)));
        }
        this.estateType1Field.setSelectedIndex(0);
        this.estateType2Field.setSelectedIndex(-1);
        this.estateType3Field.setSelectedIndex(-1);
        this.estateType4Field.setSelectedIndex(-1);
        if (arrayList.size() > 0) {
            this.doSelectEstateType(this.estateType1Field, (String)arrayList.get(0));
            this.doUpdateEstateTypesBox(this.estateType2Field, (String)arrayList.get(0));
        }
        if (arrayList.size() > 1) {
            this.doSelectEstateType(this.estateType2Field, (String)arrayList.get(1));
            this.doUpdateEstateTypesBox(this.estateType3Field, (String)arrayList.get(1));
        }
        if (arrayList.size() > 2) {
            this.doSelectEstateType(this.estateType3Field, (String)arrayList.get(2));
            this.doUpdateEstateTypesBox(this.estateType4Field, (String)arrayList.get(2));
        }
        if (arrayList.size() > 3) {
            this.doSelectEstateType(this.estateType4Field, (String)arrayList.get(3));
        }
        this.estateActionField.setSelectedIndex(0);
        if (string != null) {
            this.doSelectEstateAction(this.estateActionField, string);
        }
        this.validationHandler.validate();
        this.isActionRunning = false;
    }

    private void selectEstateType(OpenEstateType openEstateType, String string) {
        String[] stringArray;
        String[] stringArray2;
        this.selectedEstateType = openEstateType;
        this.selectedEstateAction = string;
        this.estateActionField.setEnabled(false);
        this.estateActionField.removeAllItems();
        this.estateActionField.addItem("[ " + this.resourceMap.getString("label.estateActions.all", new Object[0]) + " ]");
        this.estateActionField.setSelectedIndex(0);
        if (this.selectedEstateType != null) {
            stringArray2 = this.selectedEstateType.getActions();
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "ERBPACHT";
            stringArray3[1] = "KAUF";
            stringArray3[2] = "MIETE";
            stringArray2 = stringArray3;
            stringArray3[3] = "PACHT";
        }
        for (String string2 : stringArray = stringArray2) {
            EstateActionItem estateActionItem = new EstateActionItem(string2);
            this.estateActionField.addItem(estateActionItem);
            if (!string2.equals(this.selectedEstateAction)) continue;
            this.estateActionField.setSelectedItem(estateActionItem);
        }
        this.estateActionField.setEnabled(true);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.infoLabel = new JLabel();
        this.estateTypeLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.estateType1Field = new JComboBox();
        this.estateType2Field = new JComboBox();
        this.estateType3Field = new JComboBox();
        this.estateType4Field = new JComboBox();
        this.estateActionLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.estateActionField = new JComboBox();
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.infoLabel.setText("infoLabel");
        this.infoLabel.setName("infoLabel");
        this.estateTypeLabel.setName("estateTypeLabel");
        this.estateTypeLabel.setTitle("estateTypeLabel");
        this.estateType1Field.setName("estateType1Field");
        this.estateType2Field.setName("estateType2Field");
        this.estateType3Field.setName("estateType3Field");
        this.estateType4Field.setName("estateType4Field");
        this.estateActionLabel.setName("estateActionLabel");
        this.estateActionLabel.setTitle("estateActionLabel");
        this.estateActionField.setName("estateActionField");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.closeButton.setText("doCancel");
        this.closeButton.setName("closeButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.infoLabel, -1, 520, Short.MAX_VALUE)).addComponent((Component)this.titleLabel, GroupLayout.Alignment.TRAILING, -1, 532, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 242, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent((Component)this.estateTypeLabel, -1, 532, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.estateType1Field, 0, 520, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.estateType2Field, 0, 520, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.estateType3Field, 0, 520, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.estateType4Field, 0, 520, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.estateActionField, 0, 520, Short.MAX_VALUE)).addComponent((Component)this.estateActionLabel, -1, 532, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.estateTypeLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateType1Field, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateType2Field, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateType3Field, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateType4Field, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.estateActionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.estateActionField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 92, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.submitButton).addComponent(this.helpButton)).addContainerGap()));
        this.pack();
    }

    private static final class EstateTypeItem {
        private OpenEstateType estateType;

        public EstateTypeItem(OpenEstateType openEstateType) {
            this.estateType = openEstateType;
        }

        public String getName() {
            return this.estateType.getName();
        }

        public OpenEstateType getType() {
            return this.estateType;
        }

        public String toString() {
            String string = OpenEstateUtils.translateEstate((String)this.estateType.getName());
            return string != null ? " " + string : " " + this.estateType.getName();
        }
    }

    private static final class EstateActionItem {
        private String estateAction;

        public EstateActionItem(String string) {
            this.estateAction = string;
        }

        public String getName() {
            return this.estateAction;
        }

        public String toString() {
            String string = OpenEstateUtils.translateAction((String)this.estateAction);
            return string != null ? " " + string : " " + this.estateAction;
        }
    }
}

