/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.KyeroUtils;
import com.openindex.openestate.impl.xml.TrovitUtils;
import com.openindex.openestate.impl.xml.TrovitWriter;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.impl.xml.kyero.ImagesType;
import com.openindex.openestate.impl.xml.kyero.PropertyType;
import com.openindex.openestate.impl.xml.trovit.Picture;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.WebsiteExportFilter;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlExportPanel;
import com.openindex.openestate.tool.agency.utils.HtmlExposeBuilder;
import com.openindex.openestate.tool.agency.utils.HtmlIndexBuilder;
import com.openindex.openestate.tool.agency.utils.ImmobiliareWriter;
import com.openindex.openestate.tool.agency.utils.KyeroWriter;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

public class WebsiteHtmlExport
extends AbstractExport {
    private static final Logger LOGGER = Logger.getLogger(WebsiteHtmlExport.class);
    public static final String KEY_EXPOSE_AGENT = "export.expose.agent";
    public static final String KEY_EXPOSE_CONTACT = "export.expose.contact";
    public static final String KEY_EXPOSE_PDF_SETUP = "export.expose.pdf.setup";
    public static final String KEY_EXPOSE_TERMS = "export.expose.terms";
    public static final String KEY_FILTER = "export.filter";
    public static final String KEY_STYLE_SRC = "export.style.src";
    public static final String KEY_BASE_URL = "export.base.url";
    public static final String KEY_FEED_TROVIT = "export.feed.trovit";
    public static final String KEY_FEED_RSS = "export.feed.rss";
    public static final String KEY_FEED_ATOM = "export.feed.atom";
    public static final String KEY_FEED_IMMOBILIARE = "export.feed.immobiliare";
    public static final String KEY_FEED_KYERO = "export.feed.kyero";
    public static final String KEY_COMPANY = "export.company";
    public static final String KEY_IMAGES_COLORBOX = "export.images.colorbox";
    public static final String KEY_MAP = "export.map";
    @Deprecated
    private static final String KEY_TROVIT = "export.trovit";
    @Deprecated
    private static final String KEY_MEDIA = "export.media";
    @Deprecated
    private static final String KEY_IMAGES = "export.images";
    @Deprecated
    private static final String KEY_INCLUDE_IMAGES = "export.include.images";
    public static final String MAP_OSM = "osm";
    public static final String MAP_GOOGLE = "google";
    public static final String NAME = "website_html";
    private static final String STAMP = "immotool.stamp";
    private String baseUrl = "";
    private String company = "";
    private String stylesheetUrl = "";
    private String map = null;
    private boolean exportImagesWithColorbox = true;
    private boolean exposeAgentVisible = true;
    private boolean exposeContactVisible = true;
    private boolean exposeTermsVisible = true;
    private boolean exportTrovitFeed = false;
    private boolean exportRssFeed = false;
    private boolean exportImmobiliareFeed = false;
    private boolean exportAtomFeed = false;
    private boolean exportKyeroFeed = false;
    private Long exposePdfSetupId = null;
    private List<WebsiteExportFilter> filters = null;

    public WebsiteHtmlExport() {
        this.build();
    }

    private void build() {
        this.setIncremental(false);
        this.setFullTransportWarningShown(false);
        this.setZipped(false);
        this.setLanguage(Locale.getDefault());
        this.filters = new ArrayList<WebsiteExportFilter>();
    }

    private void buildFileList(File file, String string, StringBuilder stringBuilder) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.buildFileList(file2, string + file.getName() + "/", stringBuilder);
            }
            stringBuilder.append(string).append(file.getName()).append("/\n");
        } else {
            stringBuilder.append(string).append(file.getName()).append("\n");
        }
    }

    public static WebsiteExportFilter createFilter(String string, String string2) {
        return new WebsiteExportFilter(string, string2);
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new WebsiteHtmlExportPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        Object object;
        File file;
        String string;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        SyndFeedImpl syndFeedImpl;
        SyndFeedImpl syndFeedImpl2;
        ArrayList<PropertyType> arrayList;
        KyeroWriter kyeroWriter;
        ArrayList<Feed.Properties.Property> arrayList2;
        ImmobiliareWriter immobiliareWriter;
        ArrayList<Object> arrayList3;
        TrovitWriter trovitWriter;
        HtmlExposeBuilder htmlExposeBuilder;
        HtmlIndexBuilder htmlIndexBuilder;
        File file2;
        File file3;
        AgencyAgent agencyAgent;
        block95: {
            callback.checkCancelled();
            agencyAgent = null;
            try {
                agencyAgent = AgencyAgent.loadAgent();
            }
            catch (ImmoToolDbException immoToolDbException) {
                throw new AgencyExportException("Can't load agency!");
            }
            callback.checkCancelled();
            file3 = this.getExportDirectory();
            if (file3 == null || !file3.exists() && !file3.mkdirs()) {
                throw new AgencyExportException("Can't create local export directory!");
            }
            callback.checkCancelled();
            file2 = new File(file3.getAbsolutePath() + File.separator + "expose");
            try {
                if (file2.exists()) {
                    FileUtils.deleteQuietly((File)file2);
                }
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new AgencyExportException("Can't create local expos\u00e9 directory!");
                }
                FileUtils.touch((File)new File(file2.getAbsolutePath() + File.separator + "index.html"));
            }
            catch (IOException iOException) {
                throw new AgencyExportException("Can't prepare local expos\u00e9 directory!", iOException);
            }
            callback.checkCancelled();
            if (!this.isImageModeDisabled()) {
                this.initWatermarkLogo();
            }
            callback.checkCancelled();
            htmlIndexBuilder = new HtmlIndexBuilder(this);
            htmlExposeBuilder = new HtmlExposeBuilder(this);
            Locale locale = this.getLocale();
            if (locale != null) {
                htmlIndexBuilder.setLocale(locale);
                htmlExposeBuilder.setLocale(locale);
            }
            callback.checkCancelled();
            trovitWriter = null;
            arrayList3 = null;
            if (this.isTrovitFeedExport()) {
                trovitWriter = new TrovitWriter();
                arrayList3 = new ArrayList<Object>();
            }
            callback.checkCancelled();
            immobiliareWriter = null;
            arrayList2 = null;
            if (this.isImmobiliareFeedExport()) {
                immobiliareWriter = new ImmobiliareWriter();
                arrayList2 = new ArrayList<Feed.Properties.Property>();
            }
            callback.checkCancelled();
            kyeroWriter = null;
            arrayList = null;
            if (this.isKyeroFeedExport()) {
                kyeroWriter = new KyeroWriter();
                arrayList = new ArrayList<PropertyType>();
            }
            callback.checkCancelled();
            syndFeedImpl2 = null;
            if (this.isRssFeedExport()) {
                syndFeedImpl2 = new SyndFeedImpl();
                syndFeedImpl2.setAuthor(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl2.setCopyright(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl2.setDescription(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl2.setEncoding(Charset.defaultCharset().name());
                syndFeedImpl2.setFeedType("rss_2.0");
                syndFeedImpl2.setLanguage(this.getLocale().getLanguage());
                syndFeedImpl2.setPublishedDate(new Date());
                syndFeedImpl2.setTitle(this.getCompany());
                if (this.getBaseUrl() != null) {
                    syndFeedImpl2.setUri(this.getBaseUrl());
                    syndFeedImpl2.setLink(this.getBaseUrl() + "rss.xml");
                }
            }
            callback.checkCancelled();
            syndFeedImpl = null;
            if (this.isAtomFeedExport()) {
                syndFeedImpl = new SyndFeedImpl();
                syndFeedImpl.setAuthor(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl.setCopyright(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl.setDescription(agencyAgent.getCompany().getCompanyName());
                syndFeedImpl.setEncoding(Charset.defaultCharset().name());
                syndFeedImpl.setFeedType("atom_1.0");
                syndFeedImpl.setLanguage(this.getLocale().getLanguage());
                syndFeedImpl.setPublishedDate(new Date());
                syndFeedImpl.setTitle(this.getCompany());
                if (this.getBaseUrl() != null) {
                    syndFeedImpl.setUri(this.getBaseUrl());
                    syndFeedImpl.setLink(this.getBaseUrl() + "atom.xml");
                }
            }
            callback.checkCancelled();
            try {
                htmlIndexBuilder.storeDefaultStylesheet(new File(file3.getAbsolutePath() + File.separator + "website.css"));
            }
            catch (IOException iOException) {
                throw new AgencyExportException("Can't create 'website.css'!", iOException);
            }
            callback.checkCancelled();
            if (!this.isImageModeDisabled() && this.isImageExportWithColorbox()) {
                block92: {
                    object5 = null;
                    object42 = null;
                    object5 = new File(file3.getAbsolutePath() + File.separator + "colorbox.zip");
                    WebsiteHtmlExport.saveResource("colorbox.zip", (File)object5);
                    object42 = new ZipFile((File)object5);
                    object3 = ((ZipFile)object42).entries();
                    while (object3.hasMoreElements()) {
                        object2 = (ZipEntry)object3.nextElement();
                        string = object2.getName();
                        file = new File(file3.getAbsolutePath() + File.separator + string);
                        if (object2.isDirectory()) {
                            if (file.exists() || file.mkdirs()) continue;
                            LOGGER.warn((Object)"Can't create directory!");
                            LOGGER.warn((Object)("> " + file.getAbsolutePath()));
                            continue;
                        }
                        object = ((ZipFile)object42).getInputStream((ZipEntry)object2);
                        ImmoToolUtils.writeStreamToFile((InputStream)object, (File)file);
                        ((InputStream)object).close();
                    }
                    if (object42 == null) break block92;
                    try {
                        ((ZipFile)object42).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                FileUtils.deleteQuietly((File)object5);
                break block95;
                catch (IOException iOException) {
                    try {
                        throw new AgencyExportException("Can't save colorbox scripts!", iOException);
                    }
                    catch (Throwable throwable) {
                        if (object42 != null) {
                            try {
                                ((ZipFile)object42).close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        FileUtils.deleteQuietly(object5);
                        throw throwable;
                    }
                }
            }
        }
        if (!agencyExportSummary.getUpdatedEstateIds().isEmpty()) {
            for (Object object42 : agencyExportSummary.getUpdatedEstateIds()) {
                try {
                    Object object6;
                    Object object7;
                    Object object8;
                    callback.checkCancelled();
                    object3 = null;
                    try {
                        object3 = AgencyEstate.loadEstate((Long)object42);
                    }
                    catch (ImmoToolDbException immoToolDbException) {
                        LOGGER.warn((Object)("Can't load estate #" + object42));
                        LOGGER.warn((Object)("> " + immoToolDbException.getLocalizedMessage()), (Throwable)immoToolDbException);
                        continue;
                    }
                    if (object3 == null) {
                        LOGGER.warn((Object)("Can't load estate #" + object42));
                        continue;
                    }
                    callback.checkCancelled();
                    if ("always".equals(this.getAddressPublishing())) {
                        object3.setAdressPublished(true);
                    } else if ("never".equals(this.getAddressPublishing())) {
                        object3.setAdressPublished(false);
                    }
                    callback.checkCancelled();
                    if (this.isImageModeDisabled()) {
                        object3.getAttachments().clear();
                    } else {
                        int n = this.getImageCount() != null ? this.getImageCount() : -1;
                        int n2 = this.getVideoCount() != null ? this.getVideoCount() : -1;
                        int n3 = 0;
                        int n4 = 0;
                        object8 = new ArrayList();
                        for (Object object9 : object3.getAttachments()) {
                            if (!this.canExportAttachment((Long)object42, (EstateAttachmentImpl)object9)) {
                                object8.add(object9);
                            }
                            if ((object7 = object9.getMimeType()) != null && ((String)object7).toLowerCase().startsWith("image/") && n > -1) {
                                if (n3 >= n) {
                                    object8.add(object9);
                                } else {
                                    ++n3;
                                }
                            }
                            if (object7 == null || !((String)object7).toLowerCase().startsWith("video/") || n2 <= -1) continue;
                            if (n4 >= n2) {
                                object8.add(object9);
                                continue;
                            }
                            ++n4;
                        }
                        object3.getAttachments().removeAll((Collection<?>)object8);
                    }
                    callback.checkCancelled();
                    object2 = null;
                    string = object3.getContactId();
                    if (!StringUtils.isBlank((String)string)) {
                        try {
                            String[] stringArray = string.split("\\.");
                            long l = Long.valueOf(stringArray[stringArray.length - 1]);
                            object2 = AgencyContact.loadContact(l);
                        }
                        catch (Exception exception) {
                            object2 = null;
                            LOGGER.warn((Object)"could not load contact!");
                            LOGGER.warn((Object)("> " + string));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    callback.checkCancelled();
                    file = new File(file2.getAbsolutePath() + File.separator + ((AgencyEstate)((Object)object3)).getIdNr());
                    htmlExposeBuilder.storeWebsite((AgencyEstate)((Object)object3), agencyAgent, (AgencyContact)((Object)object2), file, "../../website.css");
                    htmlIndexBuilder.addItem((AgencyEstate)((Object)object3), file2.getName(), !this.isImageModeDisabled(), this.isPdfIncluded());
                    callback.checkCancelled();
                    Object object10 = object = this.getBaseUrl() != null ? this.getBaseUrl().trim() : "";
                    if (!((String)object).endsWith("/")) {
                        object = (String)object + "/";
                    }
                    object = (String)object + "expose/" + ((AgencyEstate)((Object)object3)).getIdNr() + "/";
                    callback.checkCancelled();
                    if (trovitWriter != null && arrayList3 != null) {
                        trovitWriter.setBaseUrl((String)object);
                        object8 = trovitWriter.write((EstateImpl)object3, agencyAgent.getCompany().getCompanyName());
                        if (object8 != null) {
                            object8.setUrl((String)object + "index.html");
                            if (object8.getPictures() != null) {
                                Object object9;
                                int n = 0;
                                object9 = object8.getPictures().getPicture().iterator();
                                while (object9.hasNext()) {
                                    object7 = (Picture)object9.next();
                                    object7.setPictureUrl(new URL((String)object + "img_" + ++n + ".jpg").toString());
                                }
                            }
                            arrayList3.add(object8);
                        }
                    }
                    callback.checkCancelled();
                    if (immobiliareWriter != null && arrayList2 != null && "IT".equalsIgnoreCase(object3.getAdress().getCountry())) {
                        object8 = new ArrayList();
                        immobiliareWriter.setBaseUrl((String)object);
                        Feed.Properties.Property property = immobiliareWriter.convertEstate((EstateImpl)object3, agencyAgent, (AgentContactImpl)object2, (List<String>)object8);
                        if (property != null && object8.isEmpty()) {
                            arrayList2.add(property);
                        }
                    }
                    callback.checkCancelled();
                    if (kyeroWriter != null && arrayList != null) {
                        object8 = new ArrayList();
                        kyeroWriter.setBaseUrl((String)object);
                        PropertyType propertyType = kyeroWriter.convertEstate((EstateImpl)object3, (List)object8);
                        if (propertyType != null && object8.isEmpty()) {
                            propertyType.setUrl(new URL((String)object + "index.html"));
                            if (propertyType.getImages() != null) {
                                int n = 0;
                                object7 = propertyType.getImages().getImage().iterator();
                                while (object7.hasNext()) {
                                    object6 = (ImagesType.Image)object7.next();
                                    object6.setUrl(new URL((String)object + "img_" + ++n + ".jpg"));
                                }
                            }
                            arrayList.add(propertyType);
                        }
                    }
                    callback.checkCancelled();
                    if (syndFeedImpl2 == null && syndFeedImpl == null) continue;
                    object8 = new SyndEntryImpl();
                    object8.setAuthor(agencyAgent.getCompany().getCompanyName());
                    object8.setLink((String)object + "index.html");
                    if (object3.getPublishBegin() != null) {
                        object8.setPublishedDate(object3.getPublishBegin());
                    }
                    object8.setUpdatedDate(new Date());
                    object8.setUri((String)object + "index.html");
                    String string2 = object3.getTitle(this.getLocale());
                    if (string2 == null) {
                        string2 = OpenEstateUtils.translateEstate((String)object3.getType().getName(), (Locale)this.getLocale()) + " / " + OpenEstateUtils.translateAction((String)object3.getAction(), (Locale)this.getLocale());
                    }
                    string2 = !StringUtils.isBlank((String)object3.getPublicId()) ? object3.getPublicId().trim() + " \u00bb " + string2 : "#" + ((AgencyEstate)((Object)object3)).getIdNr() + " \u00bb " + string2;
                    object8.setTitle(string2);
                    SyndContentImpl syndContentImpl = new SyndContentImpl();
                    syndContentImpl.setType("text/plain");
                    object7 = null;
                    object6 = "FREITEXTE.KURZ_BESCHR";
                    if (object3.hasAttribute((String)object6)) {
                        object7 = ((AgencyEstate)((Object)object3)).writeValue(object3.getAttribute((String)object6), this.getLocale());
                    }
                    if (StringUtils.isBlank((String)object7) && object3.hasAttribute((String)(object6 = "FREITEXTE.OBJEKT_BESCHR"))) {
                        object7 = ((AgencyEstate)((Object)object3)).writeValue(object3.getAttribute((String)object6), this.getLocale());
                    }
                    if (StringUtils.isBlank((String)object7)) {
                        object7 = string2;
                    }
                    syndContentImpl.setValue((String)object7);
                    object8.setDescription((SyndContent)syndContentImpl);
                    if (syndFeedImpl2 != null) {
                        syndFeedImpl2.getEntries().add(object8);
                    }
                    if (syndFeedImpl == null) continue;
                    syndFeedImpl.getEntries().add(object8);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't save estate #" + object42 + "!", iOException);
                }
                catch (OpenEstateException openEstateException) {
                    LOGGER.warn((Object)("Estate #" + object42 + " contains problems!"));
                    LOGGER.warn((Object)("> " + openEstateException.getLocalizedMessage()), (Throwable)openEstateException);
                }
            }
        }
        callback.checkCancelled();
        try {
            htmlIndexBuilder.storeWebsites(agencyAgent, 10, file3, "website.css");
        }
        catch (IOException iOException) {
            throw new AgencyExportException("Can't save index files!", iOException);
        }
        if (trovitWriter != null && arrayList3 != null) {
            callback.checkCancelled();
            try {
                object5 = new File(file3.getPath() + File.separator + "trovit.xml");
                object42 = TrovitUtils.getFactory().createTrovit();
                object42.getAd().addAll(arrayList3);
                TrovitUtils.marshallWithCDATA((Marshaller)TrovitUtils.createMarshaller(), (Object)object42, (File)object5);
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't save trovit feed!", exception);
            }
        }
        if (immobiliareWriter != null && arrayList2 != null) {
            callback.checkCancelled();
            try {
                object5 = new File(file3.getPath() + File.separator + "immobiliare.xml");
                object42 = immobiliareWriter.createRoot();
                object42.getMetadata().setPublisher(immobiliareWriter.convertAgent(agencyAgent));
                object42.setProperties(ImmobiliareUtils.getFactory().createFeedProperties());
                object42.getProperties().getProperty().addAll(arrayList2);
                ImmobiliareUtils.createMarshaller().marshal(object42, (File)object5);
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't save immobiliare feed!", exception);
            }
        }
        if (kyeroWriter != null && arrayList != null) {
            callback.checkCancelled();
            try {
                object5 = new File(file3.getPath() + File.separator + "kyero.xml");
                object42 = kyeroWriter.createRoot();
                object42.setAgent(kyeroWriter.convertAgent(agencyAgent));
                object42.getProperty().addAll(arrayList);
                KyeroUtils.createMarshaller().marshal(object42, (File)object5);
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't save kyero feed!", exception);
            }
        }
        if (syndFeedImpl2 != null) {
            callback.checkCancelled();
            try {
                object5 = new File(file3.getPath() + File.separator + "rss.xml");
                object42 = null;
                try {
                    object42 = new FileWriter((File)object5);
                    object3 = new SyndFeedOutput();
                    object3.output((SyndFeed)syndFeedImpl2, (Writer)object42);
                }
                finally {
                    IOUtils.closeQuietly((Writer)object42);
                }
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't save rss feed!", exception);
            }
        }
        if (syndFeedImpl != null) {
            callback.checkCancelled();
            try {
                object5 = new File(file3.getPath() + File.separator + "atom.xml");
                object42 = null;
                try {
                    object42 = new FileWriter((File)object5);
                    object3 = new SyndFeedOutput();
                    object3.output((SyndFeed)syndFeedImpl, (Writer)object42);
                }
                finally {
                    IOUtils.closeQuietly((Writer)object42);
                }
            }
            catch (Exception exception) {
                throw new AgencyExportException("Can't save atom feed!", exception);
            }
        }
        return file3;
    }

    @Override
    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        FileInputStream fileInputStream;
        Object object;
        StringBuilder stringBuilder;
        block21: {
            FileOutputStream fileOutputStream;
            block20: {
                boolean bl;
                if (!file.isDirectory()) {
                    return;
                }
                LOGGER.info((Object)"preparing transport for website_html");
                callback.checkCancelled();
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.currentTimeMillis()).append("\n");
                for (File object2 : file.listFiles()) {
                    this.buildFileList(object2, "", stringBuilder);
                }
                Object object3 = null;
                try {
                    callback.checkCancelled();
                    String[] stringArray = fTPClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    fTPClient.sendNoOp();
                    object3 = Arrays.asList(stringArray);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read existing files from FTP server!", iOException);
                }
                boolean bl2 = bl = !object3.contains(STAMP);
                if (!bl) break block20;
                callback.checkCancelled();
                LOGGER.info((Object)"> first export!");
                for (File i : file.listFiles()) {
                    if (!object3.contains(i.getName())) continue;
                    throw new AgencyExportException("The file '" + i.getName() + "' already exists on the FTP server!");
                }
                break block21;
            }
            LOGGER.info((Object)"> load immotool.stamp");
            object = null;
            OutputStream fileInputStream2 = null;
            String[] stringArray = null;
            try {
                callback.checkCancelled();
                object = File.createTempFile("immotool.", ".stamp");
                fileOutputStream = new FileOutputStream((File)object);
                fTPClient.retrieveFile(STAMP, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                String iOException = ImmoToolUtils.readFile((File)object);
                stringArray = iOException.split("\\n");
            }
            catch (IOException iOException) {
                try {
                    throw new AgencyExportException("Can't read 'immotool.stamp' from FTP server!", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream2);
                    FileUtils.deleteQuietly((File)object);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)object);
            LOGGER.info((Object)"> full update");
            for (int i = 1; i < stringArray.length; ++i) {
                String string2;
                callback.checkCancelled();
                String string3 = string2 = stringArray[i] != null ? stringArray[i].trim() : null;
                if (StringUtils.isBlank((String)string2)) continue;
                try {
                    if (string2.endsWith("/")) {
                        String string4 = string2.substring(0, string2.length() - 1);
                        LOGGER.info((Object)("> remove dir: " + string4));
                        if (fTPClient.removeDirectory(string4)) continue;
                        LOGGER.warn((Object)("Can't remove directory '" + string4 + "'!"));
                        continue;
                    }
                    LOGGER.info((Object)("> remove file: " + string2));
                    if (fTPClient.deleteFile(string2)) continue;
                    LOGGER.warn((Object)("Can't remove file '" + string2 + "'!"));
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)("Can't delete '" + string2 + "' from FTP server!"));
                    LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                }
            }
        }
        LOGGER.info((Object)"save immotool.stamp");
        object = null;
        InputStream inputStream = null;
        File file2 = new File(ImmoToolApp.getApplication().getProject().getTempDirectory().getAbsolutePath() + File.separator + STAMP);
        try {
            object = new FileWriter(file2);
            ((Writer)object).write(stringBuilder.toString());
            ((OutputStreamWriter)object).flush();
            fTPClient.sendNoOp();
            fileInputStream = new FileInputStream(file2);
            if (!fTPClient.setFileType(2)) {
                LOGGER.warn((Object)"Can't change file-type!");
            }
            if (!fTPClient.storeFile(file2.getName(), (InputStream)fileInputStream)) {
                LOGGER.warn((Object)("Can't store file: " + file2.getName()));
            }
            fTPClient.sendNoOp();
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write 'immotool.stamp' to FTP server!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)object);
                IOUtils.closeQuietly(inputStream);
                FileUtils.deleteQuietly((File)file2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)object);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        FileUtils.deleteQuietly((File)file2);
    }

    public String getBaseUrl() {
        if (this.baseUrl == null) {
            return null;
        }
        if (this.baseUrl.trim().length() == 0) {
            return "";
        }
        if (!this.baseUrl.trim().endsWith("/")) {
            return this.baseUrl.trim() + "/";
        }
        return this.baseUrl;
    }

    public String getCompany() {
        return this.company;
    }

    public List<WebsiteExportFilter> getFilters() {
        return this.filters;
    }

    public String getMap() {
        return this.map;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Long getPdfSetupId() {
        return this.exposePdfSetupId;
    }

    public String getStylesheetUrl() {
        return this.stylesheetUrl;
    }

    @Override
    public String getTitle() {
        return "Website: HTML-Export";
    }

    public boolean isAtomFeedExport() {
        return this.exportAtomFeed;
    }

    public boolean isExposeAgentVisible() {
        return this.exposeAgentVisible;
    }

    public boolean isExposeContactVisible() {
        return this.exposeContactVisible;
    }

    public boolean isExposeTermsVisible() {
        return this.exposeTermsVisible;
    }

    public boolean isImageExportWithColorbox() {
        return this.exportImagesWithColorbox;
    }

    public boolean isImmobiliareFeedExport() {
        return this.exportImmobiliareFeed;
    }

    public boolean isKyeroFeedExport() {
        return this.exportKyeroFeed;
    }

    public boolean isPdfIncluded() {
        return this.exposePdfSetupId != null && this.exposePdfSetupId > 0L;
    }

    public boolean isRssFeedExport() {
        return this.exportRssFeed;
    }

    public boolean isTrovitFeedExport() {
        return this.exportTrovitFeed;
    }

    @Override
    public boolean isZipped() {
        return false;
    }

    @Override
    public void load(Properties properties) {
        Boolean bl;
        super.load(properties);
        this.setBaseUrl(properties.getProperty(KEY_BASE_URL, ""));
        this.setCompany(properties.getProperty(KEY_COMPANY, ""));
        this.setAtomFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_ATOM, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setKyeroFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_KYERO, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setImmobiliareFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_IMMOBILIARE, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setRssFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_RSS, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setTrovitFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_TROVIT, (Boolean)ImmoToolUtils.getPropertyAsBoolean((String)KEY_TROVIT, (Boolean)Boolean.FALSE, (Properties)properties), (Properties)properties));
        this.setExposeAgentVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_AGENT, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setExposeContactVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_CONTACT, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setExposeTermsVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_TERMS, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setImageExportWithColorbox(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGES_COLORBOX, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setMap(properties.getProperty(KEY_MAP));
        this.setPdfSetupId(ImmoToolUtils.getPropertyAsLong((String)KEY_EXPOSE_PDF_SETUP, (Long)0L, (Properties)properties));
        this.setStylesheetUrl(properties.getProperty(KEY_STYLE_SRC, ""));
        Boolean bl2 = ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGES, (Boolean)ImmoToolUtils.getPropertyAsBoolean((String)KEY_INCLUDE_IMAGES, (Boolean)Boolean.FALSE, (Properties)properties), (Properties)properties);
        if (Boolean.TRUE.equals(bl2)) {
            if (!this.getMimeTypes().contains("image/jpeg")) {
                this.getMimeTypes().add("image/jpeg");
            }
            if (!this.getMimeTypes().contains("image/png")) {
                this.getMimeTypes().add("image/png");
            }
        }
        if (Boolean.TRUE.equals(bl = ImmoToolUtils.getPropertyAsBoolean((String)KEY_MEDIA, (Boolean)Boolean.FALSE, (Properties)properties)) && !this.getMimeTypes().contains("application/pdf")) {
            this.getMimeTypes().add("application/pdf");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (!string.startsWith("export.filter.")) continue;
            String[] stringArray = properties.get(string).toString().split(",");
            String string2 = !StringUtils.isBlank((String)stringArray[0]) ? stringArray[0].trim() : null;
            String string3 = stringArray.length > 1 && !StringUtils.isBlank((String)stringArray[1]) ? stringArray[1].trim() : null;
            this.getFilters().add(WebsiteHtmlExport.createFilter(string2, string3));
        }
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_BASE_URL, this.getBaseUrl());
        properties.setProperty(KEY_COMPANY, this.getCompany());
        properties.setProperty(KEY_EXPOSE_AGENT, Boolean.valueOf(this.isExposeAgentVisible()).toString());
        properties.setProperty(KEY_EXPOSE_CONTACT, Boolean.valueOf(this.isExposeContactVisible()).toString());
        properties.setProperty(KEY_EXPOSE_PDF_SETUP, this.isPdfIncluded() ? this.getPdfSetupId().toString() : "0");
        properties.setProperty(KEY_EXPOSE_TERMS, Boolean.valueOf(this.isExposeTermsVisible()).toString());
        properties.setProperty(KEY_IMAGES_COLORBOX, Boolean.valueOf(this.isImageExportWithColorbox()).toString());
        properties.setProperty(KEY_STYLE_SRC, this.getStylesheetUrl());
        properties.setProperty(KEY_FEED_IMMOBILIARE, Boolean.valueOf(this.isImmobiliareFeedExport()).toString());
        properties.setProperty(KEY_FEED_RSS, Boolean.valueOf(this.isRssFeedExport()).toString());
        properties.setProperty(KEY_FEED_TROVIT, Boolean.valueOf(this.isTrovitFeedExport()).toString());
        properties.setProperty(KEY_FEED_ATOM, Boolean.valueOf(this.isAtomFeedExport()).toString());
        properties.setProperty(KEY_FEED_KYERO, Boolean.valueOf(this.isKyeroFeedExport()).toString());
        properties.setProperty("export.imagemode", String.valueOf(this.getImageMode()));
        if (this.getMap() != null) {
            properties.setProperty(KEY_MAP, this.getMap());
        }
        int n = 0;
        for (WebsiteExportFilter websiteExportFilter : this.getFilters()) {
            String string = "";
            if (websiteExportFilter.getEstateAction() != null) {
                string = string + websiteExportFilter.getEstateAction().trim();
            }
            string = string + ",";
            if (websiteExportFilter.getEstateType() != null) {
                string = string + websiteExportFilter.getEstateType().trim();
            }
            properties.setProperty("export.filter." + n, string);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveResource(String string, File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(WebsiteHtmlExport.class.getResourceAsStream("/com/openindex/openestate/tool/agency/utils/resources/html/" + string));
            ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setAtomFeedExport(boolean bl) {
        this.exportAtomFeed = bl;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setCompany(String string) {
        this.company = string;
    }

    public void setExposeAgentVisible(boolean bl) {
        this.exposeAgentVisible = bl;
    }

    public void setExposeContactVisible(boolean bl) {
        this.exposeContactVisible = bl;
    }

    public void setExposeTermsVisible(boolean bl) {
        this.exposeTermsVisible = bl;
    }

    public void setImageExportWithColorbox(boolean bl) {
        this.exportImagesWithColorbox = bl;
    }

    public void setImmobiliareFeedExport(boolean bl) {
        this.exportImmobiliareFeed = bl;
    }

    public void setKyeroFeedExport(boolean bl) {
        this.exportKyeroFeed = bl;
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setMap(String string) {
        this.map = MAP_GOOGLE.equalsIgnoreCase(string) ? MAP_GOOGLE : (MAP_OSM.equalsIgnoreCase(string) ? MAP_OSM : null);
    }

    public void setPdfSetupId(Long l) {
        this.exposePdfSetupId = l;
    }

    public void setRssFeedExport(boolean bl) {
        this.exportRssFeed = bl;
    }

    public void setStylesheetUrl(String string) {
        this.stylesheetUrl = string;
    }

    public void setTrovitFeedExport(boolean bl) {
        this.exportTrovitFeed = bl;
    }

    @Override
    public final void setZipped(boolean bl) {
        super.setZipped(false);
    }

    @Override
    public boolean supportsEstateType(String string, String string2) {
        if (this.getFilters().isEmpty()) {
            return true;
        }
        block2: for (WebsiteExportFilter websiteExportFilter : this.getFilters()) {
            String string3 = websiteExportFilter.getEstateAction();
            if (!StringUtils.isBlank((String)string3) && !string3.equalsIgnoreCase(string2)) continue;
            String string4 = websiteExportFilter.getEstateType();
            if (StringUtils.isBlank((String)string4)) {
                return true;
            }
            if (string4.equalsIgnoreCase(string)) {
                return true;
            }
            String string5 = string;
            while (string5 != null) {
                try {
                    OpenEstateType openEstateType = OpenEstateType.newInstance((String)string5);
                    if (openEstateType == null || StringUtils.isBlank((String)openEstateType.getParent())) continue block2;
                    string5 = openEstateType.getParent();
                    if (!string4.equalsIgnoreCase(string5)) continue;
                    return true;
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"internal problem during website-export!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        return false;
    }

    @Override
    public final boolean supportsIncrementalUpdate() {
        return false;
    }
}

