/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.WebsiteExportFilter;
import com.openindex.openestate.tool.agency.export.WebsiteExportFilterDialog;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlExport;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.JSelectButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;

public class WebsiteHtmlExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(WebsiteHtmlExportPanel.class);
    private static final String FEED_TROVIT = "trovit";
    private static final String FEED_IMMOBILIARE = "immobiliare";
    private static final String FEED_RSS = "rss";
    private static final String FEED_ATOM = "atom";
    private static final String FEED_KYERO = "kyero";
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JCheckBox imgColorboxExportBox;
    private JComboBox pdfExportBox;
    private JComboBox mapTypeBox;
    private JSelectButton feedExportButton;
    private JCheckBox exposeShowAgentBox;
    private JCheckBox exposeShowContactBox;
    private JCheckBox exposeShowTermsBox;
    private JTextField companyNameField;
    private JTextField baseUrlField;
    private JTextField styleCssUrl;
    private JList filterField;
    private JButton addFilterButton;
    private JButton editFilterButton;
    private JButton delFilterButton;
    private OpenEstateLocaleComboBox exportLocaleBox;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;

    public WebsiteHtmlExportPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(WebsiteHtmlExportPanel.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(WebsiteHtmlExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.validationHandler.init();
        this.addFilterButton.setAction(this.actionMap.get(this.addFilterButton.getText()));
        this.editFilterButton.setAction(this.actionMap.get(this.editFilterButton.getText()));
        this.delFilterButton.setAction(this.actionMap.get(this.delFilterButton.getText()));
        this.filterField.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                WebsiteHtmlExportPanel.this.editFilterButton.setEnabled(WebsiteHtmlExportPanel.this.filterField.getSelectedIndex() >= 0);
                WebsiteHtmlExportPanel.this.delFilterButton.setEnabled(WebsiteHtmlExportPanel.this.filterField.getSelectedIndex() >= 0);
            }
        });
        this.filterField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WebsiteHtmlExportPanel.this.doFilterEdit();
                }
            }
        });
        this.feedExportButton.addMenuItemListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebsiteHtmlExportPanel.this.baseUrlField.setEnabled(WebsiteHtmlExportPanel.this.feedExportButton.getSelectedKeys().length > 0);
                WebsiteHtmlExportPanel.this.validationHandler.validate((JComponent)WebsiteHtmlExportPanel.this.baseUrlField);
            }
        });
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebsiteHtmlExportPanel.this.imgColorboxExportBox.setEnabled(WebsiteHtmlExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
                WebsiteHtmlExportPanel.this.exportMimeTypesButton.setEnabled(WebsiteHtmlExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
    }

    private void buildForm() {
        this.baseUrlField = new JTextField();
        this.baseUrlField.setName("baseUrlField");
        this.styleCssUrl = new JTextField();
        this.styleCssUrl.setName("styleCssUrl");
        this.imgColorboxExportBox = new JCheckBox();
        this.imgColorboxExportBox.setName("imgColorboxExportBox");
        this.imgColorboxExportBox.setSelected(true);
        this.pdfExportBox = new JComboBox();
        this.pdfExportBox.setName("pdfExportBox");
        this.pdfExportBox.setRenderer(new PdfSetupRenderer());
        this.pdfExportBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.exposeShowAgentBox = new JCheckBox();
        this.exposeShowAgentBox.setName("exposeShowAgentBox");
        this.exposeShowAgentBox.setSelected(true);
        this.exposeShowContactBox = new JCheckBox();
        this.exposeShowContactBox.setName("exposeShowContactBox");
        this.exposeShowContactBox.setSelected(true);
        this.exposeShowTermsBox = new JCheckBox();
        this.exposeShowTermsBox.setName("exposeShowTermsBox");
        this.exposeShowTermsBox.setSelected(true);
        this.exportLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.exportLocaleBox.setName("exportLocaleBox");
        this.companyNameField = new JTextField();
        this.companyNameField.setName("companyNameField");
        this.mapTypeBox = new JComboBox();
        this.mapTypeBox.setName("mapTypeBox");
        this.mapTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.mapTypeBox.addItem(this.resourceMap.getString("label.map.empty", new Object[0]));
        this.mapTypeBox.addItem(this.resourceMap.getString("label.map.select", new Object[]{"openstreetmap.org"}));
        this.mapTypeBox.addItem(this.resourceMap.getString("label.map.select", new Object[]{"maps.google.com"}));
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.feedExportButton = new JSelectButton(1);
        this.feedExportButton.setName("feedExportButton");
        this.feedExportButton.setText("[ " + this.resourceMap.getString("label.feed.empty", new Object[0]) + " ]");
        this.feedExportButton.setEmptyText(this.feedExportButton.getText());
        this.feedExportButton.addOption(FEED_ATOM, this.resourceMap.getString("label.feed.atom", new Object[0]));
        this.feedExportButton.addOption(FEED_IMMOBILIARE, this.resourceMap.getString("label.feed.immobiliare", new Object[0]));
        this.feedExportButton.addOption(FEED_KYERO, this.resourceMap.getString("label.feed.kyero", new Object[0]));
        this.feedExportButton.addOption(FEED_RSS, this.resourceMap.getString("label.feed.rss", new Object[0]));
        this.feedExportButton.addOption(FEED_TROVIT, this.resourceMap.getString("label.feed.trovit", new Object[0]));
        this.filterField = new JList(new DefaultListModel());
        this.filterField.setName("filterField");
        this.filterField.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.filterField);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, 30));
        this.addFilterButton = new JButton();
        this.addFilterButton.setText("doFilterAdd");
        this.addFilterButton.setName("addFilterButton");
        this.delFilterButton = new JButton();
        this.delFilterButton.setText("doFilterDelete");
        this.delFilterButton.setName("delFilterButton");
        this.editFilterButton = new JButton();
        this.editFilterButton.setText("doFilterEdit");
        this.editFilterButton.setName("editFilterButton");
        this.validationHandler.putRule((JComponent)this.companyNameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.baseUrlField, ValidationHandler.URL);
        this.validationHandler.putRule((JComponent)this.exportLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.exportLocaleBox));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 25dlu:grow");
        defaultFormBuilder.append(this.resourceMap.getString("label.companyName", new Object[0]), (Component)this.companyNameField);
        defaultFormBuilder.append(this.resourceMap.getString("label.exportLocale", new Object[0]), (Component)this.exportLocaleBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.feedExport", new Object[0]), (Component)this.feedExportButton);
        defaultFormBuilder.append(this.resourceMap.getString("label.baseUrl", new Object[0]), (Component)this.baseUrlField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.expose.pdf", new Object[0]), (Component)this.pdfExportBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.styleCssUrl", new Object[0]), (Component)this.styleCssUrl);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append("", (Component)this.exportMimeTypesButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.map", new Object[0]), (Component)this.mapTypeBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.exposeShowAgentBox);
        defaultFormBuilder.append("", (Component)this.imgColorboxExportBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.exposeShowContactBox);
        defaultFormBuilder.append("", (Component)this.exposeShowTermsBox);
        defaultFormBuilder.nextLine();
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.addFilterButton);
        jPanel.add(this.editFilterButton);
        jPanel.add(this.delFilterButton);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        jPanel2.add((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.filters", new Object[0])), "Center");
        jPanel2.add((Component)jPanel, "East");
        defaultFormBuilder.append((Component)jPanel2, 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.border(Borders.EMPTY);
        this.setLayout(new BorderLayout());
        this.add((Component)defaultFormBuilder.getPanel(), "North");
        this.add((Component)jScrollPane, "Center");
        this.revalidate();
        this.repaint();
    }

    @Action
    public void doFilterAdd() {
        try {
            WebsiteExportFilterDialog websiteExportFilterDialog = new WebsiteExportFilterDialog(null, true);
            websiteExportFilterDialog.setAlwaysOnTop(true);
            websiteExportFilterDialog.setVisible(true);
            if (websiteExportFilterDialog.getStatus() != 2) {
                return;
            }
            String string = websiteExportFilterDialog.getSelectedEstateAction();
            OpenEstateType openEstateType = websiteExportFilterDialog.getSelectedEstateType();
            ((DefaultListModel)this.filterField.getModel()).addElement(new FilterItem(string, openEstateType != null ? openEstateType.getName() : null));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"add-filter-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantAddFilter", new Object[0]), (Throwable)exception);
        }
    }

    @Action
    public void doFilterDelete() {
        int n = this.filterField.getSelectedIndex();
        if (n < 0) {
            return;
        }
        ((DefaultListModel)this.filterField.getModel()).remove(n);
    }

    @Action
    public void doFilterEdit() {
        try {
            int n = this.filterField.getSelectedIndex();
            if (n < 0) {
                return;
            }
            FilterItem filterItem = (FilterItem)this.filterField.getSelectedValue();
            WebsiteExportFilterDialog websiteExportFilterDialog = new WebsiteExportFilterDialog(null, true);
            websiteExportFilterDialog.load(filterItem.getEstateType(), filterItem.getEstateAction());
            websiteExportFilterDialog.setAlwaysOnTop(true);
            websiteExportFilterDialog.setVisible(true);
            if (websiteExportFilterDialog.getStatus() != 2) {
                return;
            }
            String string = websiteExportFilterDialog.getSelectedEstateAction();
            OpenEstateType openEstateType = websiteExportFilterDialog.getSelectedEstateType();
            ((DefaultListModel)this.filterField.getModel()).setElementAt(new FilterItem(string, openEstateType.getName()), n);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"edit-filter-error!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantEditFilter", new Object[0]), (Throwable)exception);
        }
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractExport abstractExport) {
        this.delFilterButton.setEnabled(false);
        this.editFilterButton.setEnabled(false);
        this.filterField.getSelectionModel().clearSelection();
        ((DefaultListModel)this.filterField.getModel()).clear();
        if (abstractExport == null) {
            this.companyNameField.setText("");
            this.styleCssUrl.setText("");
            this.imgColorboxExportBox.setEnabled(true);
            this.exposeShowAgentBox.setSelected(true);
            this.exposeShowContactBox.setSelected(true);
            this.exposeShowTermsBox.setSelected(true);
            this.exportLocaleBox.setSelectedIndex(-1);
            this.mapTypeBox.setSelectedIndex(0);
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            this.pdfExportBox.setSelectedIndex(0);
            this.baseUrlField.setText("http://");
            this.baseUrlField.setEnabled(false);
            this.feedExportButton.clearSelection();
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
        } else if (abstractExport instanceof WebsiteHtmlExport) {
            WebsiteHtmlExport websiteHtmlExport = (WebsiteHtmlExport)abstractExport;
            this.companyNameField.setText(websiteHtmlExport.getCompany());
            this.styleCssUrl.setText(websiteHtmlExport.getStylesheetUrl());
            this.exposeShowAgentBox.setSelected(websiteHtmlExport.isExposeAgentVisible());
            this.exposeShowContactBox.setSelected(websiteHtmlExport.isExposeContactVisible());
            this.exposeShowTermsBox.setSelected(websiteHtmlExport.isExposeTermsVisible());
            this.exportLocaleBox.setSelectedLocale(abstractExport.getLocale());
            if (websiteHtmlExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item object : this.exportMimeTypesButton.getMimeTypeItems()) {
                    PdfSetup[] pdfSetupArray = object.getMimeType().toString();
                    object.setSelected(abstractExport.getMimeTypes().contains(pdfSetupArray));
                }
            }
            this.imgColorboxExportBox.setEnabled(websiteHtmlExport.isImageModeFile());
            this.imgColorboxExportBox.setSelected(websiteHtmlExport.isImageExportWithColorbox());
            this.feedExportButton.clearSelection();
            this.feedExportButton.setSelected(FEED_ATOM, websiteHtmlExport.isAtomFeedExport());
            this.feedExportButton.setSelected(FEED_IMMOBILIARE, websiteHtmlExport.isImmobiliareFeedExport());
            this.feedExportButton.setSelected(FEED_KYERO, websiteHtmlExport.isKyeroFeedExport());
            this.feedExportButton.setSelected(FEED_RSS, websiteHtmlExport.isRssFeedExport());
            this.feedExportButton.setSelected(FEED_TROVIT, websiteHtmlExport.isTrovitFeedExport());
            this.feedExportButton.updateText();
            this.baseUrlField.setEnabled(this.feedExportButton.getSelectedKeys().length > 0);
            this.baseUrlField.setText(this.baseUrlField.isEnabled() ? websiteHtmlExport.getBaseUrl() : "http://");
            if ("osm".equals(websiteHtmlExport.getMap())) {
                this.mapTypeBox.setSelectedIndex(1);
            } else if ("google".equals(websiteHtmlExport.getMap())) {
                this.mapTypeBox.setSelectedIndex(2);
            } else {
                this.mapTypeBox.setSelectedIndex(0);
            }
            for (WebsiteExportFilter websiteExportFilter : websiteHtmlExport.getFilters()) {
                ((DefaultListModel)this.filterField.getModel()).addElement(new FilterItem(websiteExportFilter));
            }
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            try {
                Long l = websiteHtmlExport.getPdfSetupId();
                TreeMap<String, PdfSetup> treeMap = new TreeMap<String, PdfSetup>();
                for (PdfSetup pdfSetup : PdfSetup.loadSetups()) {
                    treeMap.put(pdfSetup.getName(), pdfSetup);
                }
                for (PdfSetup pdfSetup : treeMap.values()) {
                    this.pdfExportBox.addItem(pdfSetup);
                    if (l == null || !l.equals(pdfSetup.getId())) continue;
                    this.pdfExportBox.setSelectedIndex(this.pdfExportBox.getItemCount() - 1);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load pdf-setups!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            if (this.companyNameField.getText().trim().length() == 0) {
                try {
                    this.companyNameField.setText(AgencyAgent.loadAgent().getCompany().getCompanyName());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not load company-name!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        WebsiteHtmlExport websiteHtmlExport;
        if (abstractExport instanceof WebsiteHtmlExport) {
            websiteHtmlExport = (WebsiteHtmlExport)abstractExport;
            websiteHtmlExport.setBaseUrl(this.baseUrlField.isEnabled() ? this.baseUrlField.getText().trim() : "");
            websiteHtmlExport.setCompany(this.companyNameField.getText().trim());
            websiteHtmlExport.setImageExportWithColorbox(this.imgColorboxExportBox.isSelected());
            websiteHtmlExport.setLanguage(this.exportLocaleBox.getSelectedLocale());
            websiteHtmlExport.setExposeAgentVisible(this.exposeShowAgentBox.isSelected());
            websiteHtmlExport.setExposeContactVisible(this.exposeShowContactBox.isSelected());
            websiteHtmlExport.setExposeTermsVisible(this.exposeShowTermsBox.isSelected());
            websiteHtmlExport.setStylesheetUrl(this.styleCssUrl.getText().trim());
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                websiteHtmlExport.setImageMode("file");
            } else {
                websiteHtmlExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (Object object : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!object.isSelected()) continue;
                    abstractExport.getMimeTypes().add(object.getMimeType().toString());
                }
            }
            websiteHtmlExport.setAtomFeedExport(this.feedExportButton.hasSelection(FEED_ATOM));
            websiteHtmlExport.setImmobiliareFeedExport(this.feedExportButton.hasSelection(FEED_IMMOBILIARE));
            websiteHtmlExport.setKyeroFeedExport(this.feedExportButton.hasSelection(FEED_KYERO));
            websiteHtmlExport.setRssFeedExport(this.feedExportButton.hasSelection(FEED_RSS));
            websiteHtmlExport.setTrovitFeedExport(this.feedExportButton.hasSelection(FEED_TROVIT));
            if (this.mapTypeBox.getSelectedIndex() == 1) {
                websiteHtmlExport.setMap("osm");
            } else if (this.mapTypeBox.getSelectedIndex() == 2) {
                websiteHtmlExport.setMap("google");
            } else {
                websiteHtmlExport.setMap(null);
            }
            websiteHtmlExport.getFilters().clear();
            for (int i = 0; i < this.filterField.getModel().getSize(); ++i) {
                Object object;
                object = (FilterItem)this.filterField.getModel().getElementAt(i);
                websiteHtmlExport.getFilters().add(WebsiteHtmlExport.createFilter(((FilterItem)object).getEstateAction(), ((FilterItem)object).getEstateType()));
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        PdfSetup pdfSetup = (PdfSetup)this.pdfExportBox.getSelectedItem();
        websiteHtmlExport.setPdfSetupId(pdfSetup != null ? pdfSetup.getId() : null);
    }

    private class PdfSetupRenderer
    extends JLabel
    implements ListCellRenderer {
        private PdfSetupRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof PdfSetup) {
                PdfSetup pdfSetup = (PdfSetup)object;
                this.setText(" " + pdfSetup.getName());
            } else {
                this.setText(" [ " + WebsiteHtmlExportPanel.this.resourceMap.getString("label.expose.pdf.dontSend", new Object[0]) + " ]");
            }
            return this;
        }
    }

    private final class FilterItem {
        private WebsiteExportFilter filter;

        private FilterItem(String string, String string2) {
            this(WebsiteHtmlExport.createFilter(string, string2));
        }

        private FilterItem(WebsiteExportFilter websiteExportFilter) {
            this.filter = websiteExportFilter;
        }

        public String getEstateAction() {
            return this.filter.getEstateAction();
        }

        public String getEstateType() {
            return this.filter.getEstateType();
        }

        public String toString() {
            String string = "";
            String string2 = this.getEstateType();
            string = string2 != null && string2.length() > 0 ? string + OpenEstateUtils.translateEstate((String)string2) : string + WebsiteHtmlExportPanel.this.resourceMap.getString("label.allEstateTypes", new Object[0]);
            string = string + ", ";
            String string3 = this.getEstateAction();
            string = string3 != null && string3.length() > 0 ? string + OpenEstateUtils.translateAction((String)string3) : string + WebsiteHtmlExportPanel.this.resourceMap.getString("label.allEstateActions", new Object[0]);
            return " " + string;
        }
    }
}

