/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.WebsitePhpExportPanel;
import com.openindex.openestate.tool.agency.utils.PhpWebsiteBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class WebsitePhpExport
extends AbstractExport {
    private static final Logger LOGGER = Logger.getLogger(WebsitePhpExport.class);
    public static final String KEY_LANGUAGES = "export.languages";
    public static final String KEY_SEND_SCRIPTS = "export.send.scripts";
    public static final String KEY_EXPOSE_CONTACT_FORM = "export.expose.contact.form";
    public static final String KEY_EXPOSE_CONTACT_PERSON = "export.expose.contact.person";
    public static final String KEY_EXPOSE_PDF_SETUP = "export.expose.pdf.setup";
    public static final String KEY_EXPOSE_TERMS = "export.expose.terms";
    public static final String KEY_STYLE_SRC = "export.style.src";
    public static final String KEY_PAGE_TITLE = "export.pageTitle";
    public static final String KEY_FEED_TROVIT = "export.feed.trovit";
    public static final String KEY_FEED_RSS = "export.feed.rss";
    public static final String KEY_FEED_ATOM = "export.feed.atom";
    @Deprecated
    private static final String KEY_MEDIA = "export.media";
    @Deprecated
    private static final String KEY_IMAGES = "export.images";
    @Deprecated
    private static final String KEY_INCLUDE_IMAGES = "export.include.images";
    @Deprecated
    private static final String KEY_TROVIT = "export.trovit";
    public static final String NAME = "website_php";
    private static final String STAMP = "immotool.php.stamp";
    private static final String LOCK = "immotool.php.lock";
    private String pageTitle = "";
    private String stylesheetUrl = "";
    private List<Locale> languages = new ArrayList<Locale>();
    private boolean scriptsSend = true;
    private boolean exposeContactFormVisible = true;
    private boolean exposeContactPersonVisible = true;
    private boolean exposeTermsVisible = true;
    private boolean exportTrovitFeed = false;
    private boolean exportRssFeed = false;
    private boolean exportAtomFeed = false;
    private Long exposePdfSetupId = null;
    private String ftpBasePath = null;

    public WebsitePhpExport() {
        this.setIncremental(false);
        this.setFullTransportWarningShown(false);
        this.setZipped(false);
        this.setLanguage(Locale.getDefault());
    }

    private void buildFileList(File file, String string, StringBuilder stringBuilder) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.buildFileList(file2, string + file.getName() + "/", stringBuilder);
            }
            stringBuilder.append(string).append(file.getName()).append("/\n");
        } else {
            stringBuilder.append(string).append(file.getName()).append("\n");
        }
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new WebsitePhpExportPanel();
    }

    @Override
    public File doExport(AgencyExportSummary agencyExportSummary, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        callback.checkCancelled();
        if (!this.isImageModeDisabled()) {
            this.initWatermarkLogo();
        }
        callback.checkCancelled();
        PhpWebsiteBuilder phpWebsiteBuilder = new PhpWebsiteBuilder(this);
        return phpWebsiteBuilder.build(agencyExportSummary);
    }

    @Override
    public void doFinishFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        String string2 = StringUtils.defaultIfBlank((String)this.ftpBasePath, (String)"").trim();
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        try {
            callback.checkCancelled();
            String string3 = string2 + "sessions";
            if (fTPClient.site("CHMOD 777 " + string3) != 200) {
                LOGGER.warn((Object)"Can't CHMOD the sessions-directory!");
            }
            callback.checkCancelled();
            String string4 = string2 + "cache";
            if (fTPClient.site("CHMOD 777 " + string4) != 200) {
                LOGGER.warn((Object)"Can't CHMOD the cache-directory!");
            }
            callback.checkCancelled();
            for (FTPFile fTPFile : fTPClient.listFiles(string4)) {
                if (fTPFile.getType() != 0 || "index.html".equalsIgnoreCase(fTPFile.getName()) || ".htaccess".equalsIgnoreCase(fTPFile.getName()) || fTPClient.deleteFile(string4 + "/" + fTPFile.getName())) continue;
                LOGGER.warn((Object)("Can't remove file: " + string4 + "/" + fTPFile.getName()));
            }
            callback.checkCancelled();
            LOGGER.info((Object)"Remove lock-file");
            if (!fTPClient.deleteFile(string2 + LOCK)) {
                LOGGER.warn((Object)"Can't remove lock-file!");
            }
        }
        catch (IOException iOException) {
            throw new AgencyExportException("Can't finish the export process!", iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        Object object;
        StringBuilder stringBuilder;
        block61: {
            List<String> list;
            String string2;
            block60: {
                File file2;
                boolean bl;
                if (!file.isDirectory()) {
                    return;
                }
                LOGGER.info((Object)"preparing transport for website_php");
                string2 = this.getIdPrefix();
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.currentTimeMillis()).append("\n");
                try {
                    callback.checkCancelled();
                    this.ftpBasePath = fTPClient.printWorkingDirectory();
                    if (this.ftpBasePath != null && this.ftpBasePath.length() > 1) {
                        if (this.ftpBasePath.startsWith("\"") && this.ftpBasePath.endsWith("\"")) {
                            this.ftpBasePath = this.ftpBasePath.substring(1, this.ftpBasePath.length() - 1).trim();
                        } else if (this.ftpBasePath.startsWith("'") && this.ftpBasePath.endsWith("'")) {
                            this.ftpBasePath = this.ftpBasePath.substring(1, this.ftpBasePath.length() - 1).trim();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't get current working directory from FTP server!", iOException);
                }
                try {
                    callback.checkCancelled();
                    if (!fTPClient.storeFile(LOCK, (InputStream)new ByteArrayInputStream(new byte[0]))) {
                        LOGGER.warn((Object)"Can't store lock-file!");
                    }
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't save lock file!", iOException);
                }
                list = null;
                try {
                    callback.checkCancelled();
                    String[] stringArray = fTPClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    fTPClient.sendNoOp();
                    list = Arrays.asList(stringArray);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read existing files from FTP server!", iOException);
                }
                boolean bl2 = bl = !list.contains(STAMP);
                if (!bl) break block60;
                callback.checkCancelled();
                LOGGER.info((Object)"> first export!");
                for (File file3 : file.listFiles()) {
                    if (!list.contains(file3.getName())) continue;
                    throw new AgencyExportException("The file '" + file3.getName() + "' already exists on the FTP server!");
                }
                callback.checkCancelled();
                for (File iOException : new String[]{"data", "img"}) {
                    file2 = new File(file, (String)((Object)iOException));
                    this.buildFileList(file2, "", stringBuilder);
                }
                for (File i : new String[]{"templates" + File.separator + "default"}) {
                    file2 = new File(file, (String)((Object)i));
                    this.buildFileList(file2, "templates/", stringBuilder);
                }
                break block61;
            }
            if (this.isExportScripts()) {
                callback.checkCancelled();
                try {
                    for (File file9 : fTPClient.listFiles("templates")) {
                        if (!file9.isFile() || file9.getName().equals("index.html")) continue;
                        LOGGER.debug((Object)("DELETE OLD TEMPLATE: " + file9.getName()));
                        fTPClient.deleteFile("templates/" + file9.getName());
                    }
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't remove old template files!", iOException);
                }
            }
            LOGGER.info((Object)"> load immotool.php.stamp");
            object = null;
            FileOutputStream fileOutputStream = null;
            String[] stringArray = null;
            try {
                callback.checkCancelled();
                object = File.createTempFile("immotool.", ".stamp");
                fileOutputStream = new FileOutputStream((File)object);
                fTPClient.retrieveFile(STAMP, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                String file10 = ImmoToolUtils.readFile((File)object);
                stringArray = file10.split("\\n");
            }
            catch (IOException iOException) {
                try {
                    throw new AgencyExportException("Can't read 'immotool.php.stamp' from FTP server!", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    FileUtils.deleteQuietly((File)object);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)object);
            if (!this.isIncremental()) {
                callback.checkCancelled();
                try {
                    ImmoToolUtils.deleteRecursively((FTPClient)fTPClient, (String)"data");
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't remove old data files from FTP server!", iOException);
                }
                callback.checkCancelled();
                for (String string3 : new String[]{"data"}) {
                    File file3 = new File(file, string3);
                    this.buildFileList(file3, "", stringBuilder);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    callback.checkCancelled();
                    for (Object object2 : fTPClient.listFiles("data")) {
                        arrayList.add(object2.getName());
                    }
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read data files from FTP server!", iOException);
                }
                try {
                    for (Long l : agencyExportSummary.getUpdatedEstateIds()) {
                        String string4;
                        String string5 = string4 = !StringUtils.isBlank((String)string2) ? string2.trim() + "-" + l.toString() : l.toString();
                        if (!arrayList.contains(string4)) continue;
                        ImmoToolUtils.deleteRecursively((FTPClient)fTPClient, (String)("data/" + string4));
                        callback.checkCancelled();
                    }
                    for (Long l : agencyExportSummary.getRemovedEstateIds()) {
                        String string6;
                        String string7 = string6 = !StringUtils.isBlank((String)string2) ? string2.trim() + "-" + l.toString() : l.toString();
                        if (!arrayList.contains(string6)) continue;
                        ImmoToolUtils.deleteRecursively((FTPClient)fTPClient, (String)("data/" + string6));
                        callback.checkCancelled();
                    }
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't remove old data files from FTP server!", iOException);
                }
                callback.checkCancelled();
                for (Long l : agencyExportSummary.getUpdatedEstateIds()) {
                    Object object2;
                    String string8 = !StringUtils.isBlank((String)string2) ? string2.trim() + "-" + l.toString() : l.toString();
                    object2 = new File(new File(file, "data"), string8);
                    this.buildFileList((File)object2, "data/", stringBuilder);
                }
                callback.checkCancelled();
                for (int i = 1; i < stringArray.length; ++i) {
                    String string9 = stringArray[i];
                    if (string9 == null || !string9.matches("data/[\\w\\-]*/.*")) continue;
                    stringBuilder.append(string9).append("\n");
                }
                callback.checkCancelled();
                File file4 = new File(file, "data");
                for (File file5 : file4.listFiles()) {
                    if (!file5.isFile()) continue;
                    stringBuilder.append("data/").append(file5.getName()).append("\n");
                }
                stringBuilder.append("data/").append("\n");
            }
            callback.checkCancelled();
            for (String string10 : new String[]{"img"}) {
                File file6 = new File(file, string10);
                this.buildFileList(file6, "", stringBuilder);
            }
            for (String string11 : new String[]{"templates" + File.separator + "default"}) {
                File file7 = new File(file, string11);
                this.buildFileList(file7, "templates/", stringBuilder);
            }
            if (this.isExportScripts()) {
                void var14_40;
                callback.checkCancelled();
                boolean bl = true;
                while (var14_40 < stringArray.length) {
                    String string12;
                    String string13 = string12 = stringArray[var14_40] != null ? stringArray[var14_40].trim() : null;
                    if (!StringUtils.isBlank((String)string12) && !string12.startsWith("data/")) {
                        try {
                            if (string12.endsWith("/")) {
                                String string14 = string12.substring(0, string12.length() - 1);
                                if (!fTPClient.removeDirectory(string14)) {
                                    LOGGER.warn((Object)("Can't remove directory: " + string14));
                                }
                                callback.checkCancelled();
                            } else {
                                if (!fTPClient.deleteFile(string12)) {
                                    LOGGER.warn((Object)("Can't remove file: " + string12));
                                }
                                callback.checkCancelled();
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.warn((Object)"Can't delete existing file from FTP-server!");
                            LOGGER.warn((Object)("> path: " + string12));
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        }
                    }
                    ++var14_40;
                }
            }
            if (list.contains("private.php")) {
                File file8 = new File(file, "private.php");
                if (file8.isFile()) {
                    FileUtils.deleteQuietly((File)file8);
                }
                callback.checkCancelled();
            }
            if (list.contains("myconfig.php")) {
                File file9 = new File(file, "myconfig.php");
                if (file9.isFile()) {
                    FileUtils.deleteQuietly((File)file9);
                }
                callback.checkCancelled();
            }
        }
        LOGGER.info((Object)"save immotool.php.stamp");
        object = null;
        FileInputStream fileInputStream = null;
        File file11 = new File(ImmoToolApp.getApplication().getProject().getTempDirectory(), STAMP);
        try {
            object = new FileWriter(file11);
            ((Writer)object).write(stringBuilder.toString());
            ((OutputStreamWriter)object).flush();
            fTPClient.sendNoOp();
            fileInputStream = new FileInputStream(file11);
            if (!fTPClient.setFileType(2)) {
                LOGGER.warn((Object)"Can't change file-type!");
            }
            if (!fTPClient.storeFile(file11.getName(), (InputStream)fileInputStream)) {
                LOGGER.warn((Object)("Can't store file: " + file11.getName()));
            }
            fTPClient.sendNoOp();
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write 'immotool.php.stamp' to FTP server!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)object);
                IOUtils.closeQuietly(fileInputStream);
                FileUtils.deleteQuietly((File)file11);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)object);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        FileUtils.deleteQuietly((File)file11);
    }

    public List<Locale> getLanguages() {
        return this.languages;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public Long getPdfSetupId() {
        return this.exposePdfSetupId;
    }

    public String getStylesheetUrl() {
        return this.stylesheetUrl;
    }

    @Override
    public String getTitle() {
        return "Website: PHP-Export";
    }

    public boolean hasLanguage(Locale locale) {
        if (locale == null) {
            return false;
        }
        for (Locale locale2 : this.languages) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    public boolean isAtomFeedExport() {
        return this.exportAtomFeed;
    }

    public boolean isExposeContactFormVisible() {
        return this.exposeContactFormVisible;
    }

    public boolean isExposeContactPersonVisible() {
        return this.exposeContactPersonVisible;
    }

    public boolean isExportScripts() {
        return this.scriptsSend;
    }

    public boolean isExposeTermsVisible() {
        return this.exposeTermsVisible;
    }

    public boolean isPdfIncluded() {
        return this.exposePdfSetupId != null && this.exposePdfSetupId > 0L;
    }

    public boolean isRssFeedExport() {
        return this.exportRssFeed;
    }

    public boolean isTrovitFeedExport() {
        return this.exportTrovitFeed;
    }

    @Override
    public final boolean isZipped() {
        return false;
    }

    @Override
    public void load(Properties properties) {
        Boolean bl;
        super.load(properties);
        this.setPageTitle(properties.getProperty(KEY_PAGE_TITLE, ""));
        this.setAtomFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_ATOM, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setRssFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_RSS, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setTrovitFeedExport(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FEED_TROVIT, (Boolean)ImmoToolUtils.getPropertyAsBoolean((String)KEY_TROVIT, (Boolean)Boolean.FALSE, (Properties)properties), (Properties)properties));
        this.setExposeContactFormVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_CONTACT_FORM, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setExposeContactPersonVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_CONTACT_PERSON, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setExposeTermsVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_EXPOSE_TERMS, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setIncremental(ImmoToolUtils.getPropertyAsBoolean((String)"export.incremental", (Boolean)Boolean.FALSE, (Properties)properties));
        this.setPdfSetupId(ImmoToolUtils.getPropertyAsLong((String)KEY_EXPOSE_PDF_SETUP, (Long)0L, (Properties)properties));
        this.setExportScripts(ImmoToolUtils.getPropertyAsBoolean((String)KEY_SEND_SCRIPTS, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setStylesheetUrl(properties.getProperty(KEY_STYLE_SRC, ""));
        Boolean bl2 = ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGES, (Boolean)ImmoToolUtils.getPropertyAsBoolean((String)KEY_INCLUDE_IMAGES, (Boolean)Boolean.FALSE, (Properties)properties), (Properties)properties);
        if (Boolean.TRUE.equals(bl2)) {
            if (!this.getMimeTypes().contains("image/jpeg")) {
                this.getMimeTypes().add("image/jpeg");
            }
            if (!this.getMimeTypes().contains("image/png")) {
                this.getMimeTypes().add("image/png");
            }
        }
        if (Boolean.TRUE.equals(bl = ImmoToolUtils.getPropertyAsBoolean((String)KEY_MEDIA, (Boolean)Boolean.FALSE, (Properties)properties)) && !this.getMimeTypes().contains("application/pdf")) {
            this.getMimeTypes().add("application/pdf");
        }
        String[] stringArray = properties.getProperty(KEY_LANGUAGES, this.getLocale().getLanguage()).split(",");
        this.getLanguages().clear();
        for (String string : stringArray) {
            this.getLanguages().add(OpenEstateUtils.buildLocale((String)string));
        }
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_PAGE_TITLE, this.getPageTitle());
        properties.setProperty(KEY_EXPOSE_CONTACT_FORM, Boolean.valueOf(this.isExposeContactFormVisible()).toString());
        properties.setProperty(KEY_EXPOSE_CONTACT_PERSON, Boolean.valueOf(this.isExposeContactPersonVisible()).toString());
        properties.setProperty(KEY_EXPOSE_PDF_SETUP, this.isPdfIncluded() ? this.getPdfSetupId().toString() : "0");
        properties.setProperty(KEY_EXPOSE_TERMS, Boolean.valueOf(this.isExposeTermsVisible()).toString());
        properties.setProperty("export.incremental", Boolean.valueOf(this.isIncremental()).toString());
        properties.setProperty(KEY_SEND_SCRIPTS, Boolean.valueOf(this.isExportScripts()).toString());
        properties.setProperty(KEY_STYLE_SRC, this.getStylesheetUrl());
        properties.setProperty(KEY_FEED_RSS, Boolean.valueOf(this.isRssFeedExport()).toString());
        properties.setProperty(KEY_FEED_TROVIT, Boolean.valueOf(this.isTrovitFeedExport()).toString());
        properties.setProperty(KEY_FEED_ATOM, Boolean.valueOf(this.isAtomFeedExport()).toString());
        properties.setProperty("export.imagemode", String.valueOf(this.getImageMode()));
        Locale locale = this.getLocale();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale2 : this.getLanguages()) {
            if (locale != null && !bl && locale2.getLanguage().equals(locale.getLanguage())) {
                bl = true;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(locale2.getLanguage());
        }
        if (locale != null && !bl) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(locale.getLanguage());
        }
        properties.setProperty(KEY_LANGUAGES, stringBuilder.toString());
    }

    public void setAtomFeedExport(boolean bl) {
        this.exportAtomFeed = bl;
    }

    public void setExposeContactFormVisible(boolean bl) {
        this.exposeContactFormVisible = bl;
    }

    public void setExposeContactPersonVisible(boolean bl) {
        this.exposeContactPersonVisible = bl;
    }

    public void setExportScripts(boolean bl) {
        this.scriptsSend = bl;
    }

    public void setExposeTermsVisible(boolean bl) {
        this.exposeTermsVisible = bl;
    }

    @Override
    public void setLanguage(Locale locale) {
        super.setLanguage(locale != null ? locale : Locale.GERMAN);
    }

    public void setPageTitle(String string) {
        this.pageTitle = string;
    }

    public void setPdfSetupId(Long l) {
        this.exposePdfSetupId = l;
    }

    public void setRssFeedExport(boolean bl) {
        this.exportRssFeed = bl;
    }

    public void setStylesheetUrl(String string) {
        this.stylesheetUrl = string;
    }

    public void setTrovitFeedExport(boolean bl) {
        this.exportTrovitFeed = bl;
    }

    @Override
    public final void setZipped(boolean bl) {
        super.setZipped(false);
    }

    @Override
    public boolean supportsIncrementalUpdate() {
        return true;
    }
}

