/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.utils.OpenEstateLocaleComboBox;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.WebsitePhpExport;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.JSelectButton;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationPattern;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class WebsitePhpExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(WebsitePhpExportPanel.class);
    private static final String FEED_TROVIT = "trovit";
    private static final String FEED_RSS = "rss";
    private static final String FEED_ATOM = "atom";
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JCheckBox exposeShowContactFormBox;
    private JCheckBox exposeShowContactPersonBox;
    private JCheckBox exposeShowTermsBox;
    private JSelectButton feedExportButton;
    private JCheckBox scriptExportBox;
    private JComboBox pdfExportBox;
    private JComboBox exportModeBox;
    private JTextField pageTitleField;
    private JTextField styleCssUrl;
    private JTextField estateIdPrefixField;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private OpenEstateLocaleComboBox defaultLocaleBox;
    private Map<Locale, JCheckBox> localeBoxes;

    public WebsitePhpExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(WebsitePhpExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.resourceMap.injectComponents((Component)this);
        this.validationHandler.init();
        this.defaultLocaleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebsitePhpExportPanel.this.selectLocale(WebsitePhpExportPanel.this.defaultLocaleBox.getSelectedLocale());
            }
        });
    }

    private void buildForm() {
        this.styleCssUrl = new JTextField();
        this.styleCssUrl.setName("styleCssUrl");
        this.pdfExportBox = new JComboBox();
        this.pdfExportBox.setName("pdfExportBox");
        this.pdfExportBox.setRenderer(new PdfSetupRenderer());
        this.pdfExportBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.exposeShowContactFormBox = new JCheckBox();
        this.exposeShowContactFormBox.setName("exposeShowContactFormBox");
        this.exposeShowContactFormBox.setSelected(true);
        this.exposeShowContactPersonBox = new JCheckBox();
        this.exposeShowContactPersonBox.setName("exposeShowContactPersonBox");
        this.exposeShowContactPersonBox.setSelected(true);
        this.exposeShowTermsBox = new JCheckBox();
        this.exposeShowTermsBox.setName("exposeShowTermsBox");
        this.exposeShowTermsBox.setSelected(true);
        this.scriptExportBox = new JCheckBox();
        this.scriptExportBox.setName("scriptExportBox");
        this.scriptExportBox.setSelected(true);
        this.defaultLocaleBox = new OpenEstateLocaleComboBox(true, AgencyPlugin.getLocales());
        this.defaultLocaleBox.setName("defaultLocaleBox");
        this.pageTitleField = new JTextField();
        this.pageTitleField.setName("pageTitleField");
        this.estateIdPrefixField = new JTextField();
        this.estateIdPrefixField.setName("estateIdPrefixField");
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        this.imageTypeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.feedExportButton = new JSelectButton(1);
        this.feedExportButton.setName("feedExportButton");
        this.feedExportButton.setText("[ " + this.resourceMap.getString("label.feed.empty", new Object[0]) + " ]");
        this.feedExportButton.setEmptyText(this.feedExportButton.getText());
        this.feedExportButton.addOption(FEED_ATOM, this.resourceMap.getString("label.feed.atom", new Object[0]));
        this.feedExportButton.addOption(FEED_RSS, this.resourceMap.getString("label.feed.rss", new Object[0]));
        this.feedExportButton.addOption(FEED_TROVIT, this.resourceMap.getString("label.feed.trovit", new Object[0]));
        this.exportModeBox = new JComboBox(new DefaultComboBoxModel());
        this.exportModeBox.setName("exportModeBox");
        this.exportModeBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.incremental", new Object[0]));
        ((DefaultComboBoxModel)this.exportModeBox.getModel()).addElement(this.resourceMap.getString("label.exportMode.full", new Object[0]));
        this.localeBoxes = new HashMap<Locale, JCheckBox>();
        for (Locale locale : AgencyPlugin.getLocales()) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setText(locale.getDisplayLanguage(locale) + " / " + locale.getDisplayLanguage());
            jCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            jCheckBox.setName("extraLocaleBox");
            this.localeBoxes.put(locale, jCheckBox);
        }
        Locale[] localeArray = this.localeBoxes.keySet().toArray(new Locale[this.localeBoxes.size()]);
        this.validationHandler.putRule((JComponent)this.pageTitleField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.defaultLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.defaultLocaleBox));
        this.validationHandler.putRule((JComponent)this.estateIdPrefixField, (ValidationRule)new ValidationPattern("\\w{0,5}"));
        int n = 0;
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, pref:grow, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, 50dlu", (JPanel)this);
        defaultFormBuilder.append(this.resourceMap.getString("label.pageTitle", new Object[0]), (Component)this.pageTitleField, 3);
        defaultFormBuilder.append(this.resourceMap.getString("label.estateIdPrefix", new Object[0]), (Component)this.estateIdPrefixField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox, 3);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.exportMode", new Object[0]), (Component)this.exportModeBox, 3);
        defaultFormBuilder.append((Component)this.defaultLocaleBox, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.feedExport", new Object[0]), (Component)this.feedExportButton, 3);
        defaultFormBuilder.append((Component)(localeArray.length > n ? (JComponent)this.localeBoxes.get(localeArray[n++]) : new JLabel("")), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.expose.pdf", new Object[0]), (Component)this.pdfExportBox, 3);
        defaultFormBuilder.append((Component)(localeArray.length > n ? (JComponent)this.localeBoxes.get(localeArray[n++]) : new JLabel("")), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.styleCssUrl", new Object[0]), (Component)this.styleCssUrl, 3);
        defaultFormBuilder.append((Component)(localeArray.length > n ? (JComponent)this.localeBoxes.get(localeArray[n++]) : new JLabel("")), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.exposeShowContactFormBox);
        defaultFormBuilder.append((Component)this.exposeShowTermsBox);
        defaultFormBuilder.append((Component)(localeArray.length > n ? (JComponent)this.localeBoxes.get(localeArray[n++]) : new JLabel("")), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(" ", (Component)this.exposeShowContactPersonBox);
        defaultFormBuilder.append((Component)this.scriptExportBox);
        defaultFormBuilder.append((Component)(localeArray.length > n ? (JComponent)this.localeBoxes.get(localeArray[n++]) : new JLabel("")), 3);
        defaultFormBuilder.nextLine();
        if (localeArray.length > n) {
            for (int i = n; i < localeArray.length; ++i) {
                defaultFormBuilder.append("", (Component)new JLabel(""), 3);
                defaultFormBuilder.append((Component)this.localeBoxes.get(localeArray[i]), 3);
                defaultFormBuilder.nextLine();
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    @Override
    public void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.pageTitleField.setText("");
            this.styleCssUrl.setText("");
            this.estateIdPrefixField.setText("");
            this.exposeShowContactFormBox.setSelected(true);
            this.exposeShowContactPersonBox.setSelected(true);
            this.exposeShowTermsBox.setSelected(true);
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            this.pdfExportBox.setSelectedIndex(0);
            this.scriptExportBox.setSelected(false);
            this.exportModeBox.setSelectedIndex(-1);
            this.feedExportButton.clearSelection();
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
            this.defaultLocaleBox.setSelectedIndex(-1);
            for (JCheckBox jCheckBox : this.localeBoxes.values()) {
                jCheckBox.setSelected(false);
            }
            this.selectLocale(null);
        } else if (abstractExport instanceof WebsitePhpExport) {
            WebsitePhpExport websitePhpExport = (WebsitePhpExport)abstractExport;
            this.pageTitleField.setText(websitePhpExport.getPageTitle());
            this.styleCssUrl.setText(websitePhpExport.getStylesheetUrl());
            this.estateIdPrefixField.setText(websitePhpExport.getIdPrefix());
            this.exposeShowContactFormBox.setSelected(websitePhpExport.isExposeContactFormVisible());
            this.exposeShowContactPersonBox.setSelected(websitePhpExport.isExposeContactPersonVisible());
            this.exposeShowTermsBox.setSelected(websitePhpExport.isExposeTermsVisible());
            this.scriptExportBox.setSelected(websitePhpExport.isExportScripts());
            this.exportModeBox.setSelectedIndex(websitePhpExport.isIncremental() ? 0 : 1);
            this.feedExportButton.clearSelection();
            this.feedExportButton.setSelected(FEED_ATOM, websitePhpExport.isAtomFeedExport());
            this.feedExportButton.setSelected(FEED_RSS, websitePhpExport.isRssFeedExport());
            this.feedExportButton.setSelected(FEED_TROVIT, websitePhpExport.isTrovitFeedExport());
            this.feedExportButton.updateText();
            if (websitePhpExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item object : this.exportMimeTypesButton.getMimeTypeItems()) {
                    PdfSetup[] pdfSetupArray = object.getMimeType().toString();
                    object.setSelected(abstractExport.getMimeTypes().contains(pdfSetupArray));
                }
            }
            this.defaultLocaleBox.setSelectedLocale(abstractExport.getLocale());
            for (Locale locale : this.localeBoxes.keySet()) {
                this.localeBoxes.get(locale).setSelected(websitePhpExport.hasLanguage(locale));
            }
            this.selectLocale(abstractExport.getLocale());
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            try {
                Long l = websitePhpExport.getPdfSetupId();
                TreeMap<String, PdfSetup> treeMap = new TreeMap<String, PdfSetup>();
                for (PdfSetup pdfSetup : PdfSetup.loadSetups()) {
                    treeMap.put(pdfSetup.getName(), pdfSetup);
                }
                for (PdfSetup pdfSetup : treeMap.values()) {
                    this.pdfExportBox.addItem(pdfSetup);
                    if (l == null || !l.equals(pdfSetup.getId())) continue;
                    this.pdfExportBox.setSelectedIndex(this.pdfExportBox.getItemCount() - 1);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load pdf-setups!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            if (this.pageTitleField.getText().trim().length() == 0) {
                try {
                    this.pageTitleField.setText(AgencyAgent.loadAgent().getCompany().getCompanyName());
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"could not load company-name!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        WebsitePhpExport websitePhpExport;
        if (abstractExport instanceof WebsitePhpExport) {
            websitePhpExport = (WebsitePhpExport)abstractExport;
            websitePhpExport.setPageTitle(this.pageTitleField.getText().trim());
            websitePhpExport.setIdPrefix(this.estateIdPrefixField.getText());
            websitePhpExport.setLanguage(this.defaultLocaleBox.getSelectedLocale());
            websitePhpExport.setExposeContactFormVisible(this.exposeShowContactFormBox.isSelected());
            websitePhpExport.setExposeContactPersonVisible(this.exposeShowContactPersonBox.isSelected());
            websitePhpExport.setExposeTermsVisible(this.exposeShowTermsBox.isSelected());
            websitePhpExport.setStylesheetUrl(this.styleCssUrl.getText().trim());
            websitePhpExport.setExportScripts(this.scriptExportBox.isSelected());
            websitePhpExport.setIncremental(this.exportModeBox.getSelectedIndex() == 0);
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                websitePhpExport.setImageMode("file");
            } else {
                websitePhpExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item object : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!object.isSelected()) continue;
                    abstractExport.getMimeTypes().add(object.getMimeType().toString());
                }
            }
            websitePhpExport.setAtomFeedExport(this.feedExportButton.hasSelection(FEED_ATOM));
            websitePhpExport.setRssFeedExport(this.feedExportButton.hasSelection(FEED_RSS));
            websitePhpExport.setTrovitFeedExport(this.feedExportButton.hasSelection(FEED_TROVIT));
            websitePhpExport.getLanguages().clear();
            for (Locale locale : this.localeBoxes.keySet()) {
                if (!this.localeBoxes.get(locale).isSelected()) continue;
                websitePhpExport.getLanguages().add(locale);
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        PdfSetup pdfSetup = (PdfSetup)this.pdfExportBox.getSelectedItem();
        websitePhpExport.setPdfSetupId(pdfSetup != null ? pdfSetup.getId() : null);
    }

    private void selectLocale(Locale locale) {
        for (Locale locale2 : this.localeBoxes.keySet()) {
            JCheckBox jCheckBox = this.localeBoxes.get(locale2);
            if (locale != null && locale2.getLanguage().equals(locale.getLanguage())) {
                jCheckBox.setEnabled(false);
                jCheckBox.setSelected(true);
                continue;
            }
            jCheckBox.setEnabled(true);
        }
    }

    private class PdfSetupRenderer
    extends JLabel
    implements ListCellRenderer {
        private PdfSetupRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof PdfSetup) {
                PdfSetup pdfSetup = (PdfSetup)object;
                this.setText(" " + pdfSetup.getName());
            } else {
                this.setText(" [ " + WebsitePhpExportPanel.this.resourceMap.getString("label.expose.pdf.dontSend", new Object[0]) + " ]");
            }
            return this;
        }
    }
}

