/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.xml.WisITUtils;
import com.openindex.openestate.impl.xml.wis_it.WIS;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskCancelledException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlExport;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.WisItXMLExportPanel;
import com.openindex.openestate.tool.agency.utils.WisItWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

public class WisItXMLExport
extends AbstractXmlExport {
    private static final Logger LOGGER = Logger.getLogger(WisItXMLExport.class);
    public static final String KEY_PUBLIC_ID_USED = "export.wis_it.public_id_used";
    public static final String NAME = "wohnen-in-suedtirol.it";
    private static final String STAMP = "wis.stamp";
    public static final String KEY_AGENT_ID = "wis.agent_id";
    private String agentId = "";
    private boolean publicIdUsed;

    public WisItXMLExport() {
        this.setIncremental(false);
        this.setZipped(false);
        this.setPublicIdUsed(false);
    }

    @Override
    public Object doConvert(AgencyExportSummary agencyExportSummary, SerializableXmlElement serializableXmlElement, boolean bl, Map<String, String> map) {
        WisItWriter wisItWriter = new WisItWriter();
        wisItWriter.setXmlLineSeparator("<br/>");
        wisItWriter.setEnergyCertificateAppendedToDescription(this.isEnergyCertificateAppendedToDescription());
        WIS wIS = wisItWriter.write(serializableXmlElement);
        map.putAll(wisItWriter.getErrorMap());
        if (!map.isEmpty() || wIS == null) {
            return null;
        }
        if (wIS.getBENUTZER() == null) {
            wIS.setBENUTZER(WisITUtils.getFactory().createBENUTZER());
        }
        wIS.getBENUTZER().setKDNR(this.agentId);
        return wIS;
    }

    @Override
    public void doPrepareFtpTransport(FtpTransport ftpTransport, AgencyExportSummary agencyExportSummary, File file, FTPClient fTPClient, String string, ImmoToolTask.Callback callback) throws AgencyExportException, ImmoToolTaskCancelledException {
        FileInputStream fileInputStream;
        Object object;
        StringBuilder stringBuilder;
        block21: {
            FileOutputStream fileOutputStream;
            block20: {
                boolean bl;
                if (!file.isDirectory()) {
                    return;
                }
                LOGGER.info((Object)"preparing transport for wohnen-in-suedtirol.it");
                callback.checkCancelled();
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.currentTimeMillis()).append("\n");
                for (File object2 : file.listFiles()) {
                    this.buildFileList(object2, "", stringBuilder);
                }
                Object object3 = null;
                try {
                    callback.checkCancelled();
                    String[] stringArray = fTPClient.listNames();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                    fTPClient.sendNoOp();
                    object3 = Arrays.asList(stringArray);
                }
                catch (IOException iOException) {
                    throw new AgencyExportException("Can't read existing files from FTP server!", iOException);
                }
                boolean bl2 = bl = !object3.contains(STAMP);
                if (!bl) break block20;
                callback.checkCancelled();
                LOGGER.info((Object)"> first export!");
                for (File i : file.listFiles()) {
                    if (!object3.contains(i.getName())) continue;
                    throw new AgencyExportException("The file '" + i.getName() + "' already exists on the FTP server!");
                }
                break block21;
            }
            LOGGER.info((Object)"> load wis.stamp");
            object = null;
            OutputStream fileInputStream2 = null;
            String[] stringArray = null;
            try {
                callback.checkCancelled();
                object = File.createTempFile("wis.", ".stamp");
                fileOutputStream = new FileOutputStream((File)object);
                fTPClient.retrieveFile(STAMP, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                String iOException = ImmoToolUtils.readFile((File)object);
                stringArray = iOException.split("\\n");
            }
            catch (IOException iOException) {
                try {
                    throw new AgencyExportException("Can't read 'wis.stamp' from FTP server!", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream2);
                    FileUtils.deleteQuietly((File)object);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            FileUtils.deleteQuietly((File)object);
            LOGGER.info((Object)"> full update");
            for (int i = 1; i < stringArray.length; ++i) {
                String string2;
                callback.checkCancelled();
                String string3 = string2 = stringArray[i] != null ? stringArray[i].trim() : null;
                if (StringUtils.isBlank((String)string2)) continue;
                try {
                    if (string2.endsWith("/")) {
                        String string4 = string2.substring(0, string2.length() - 1);
                        LOGGER.info((Object)("> remove dir: " + string4));
                        if (fTPClient.removeDirectory(string4)) continue;
                        LOGGER.warn((Object)("Can't remove directory '" + string4 + "'!"));
                        continue;
                    }
                    LOGGER.info((Object)("> remove file: " + string2));
                    if (fTPClient.deleteFile(string2)) continue;
                    LOGGER.warn((Object)("Can't remove file '" + string2 + "'!"));
                    continue;
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)("Can't delete '" + string2 + "' from FTP server!"));
                    LOGGER.warn((Object)("> " + iOException.getLocalizedMessage()), (Throwable)iOException);
                }
            }
        }
        LOGGER.info((Object)"save wis.stamp");
        object = null;
        InputStream inputStream = null;
        File file2 = new File(ImmoToolApp.getApplication().getProject().getTempDirectory().getAbsolutePath() + File.separator + STAMP);
        try {
            object = new FileWriter(file2);
            ((Writer)object).write(stringBuilder.toString());
            ((OutputStreamWriter)object).flush();
            fTPClient.sendNoOp();
            fileInputStream = new FileInputStream(file2);
            if (!fTPClient.setFileType(2)) {
                LOGGER.warn((Object)"Can't change file-type!");
            }
            if (!fTPClient.storeFile(file2.getName(), (InputStream)fileInputStream)) {
                LOGGER.warn((Object)("Can't store file: " + file2.getName()));
            }
            fTPClient.sendNoOp();
        }
        catch (IOException iOException) {
            try {
                throw new AgencyExportException("Can't write 'wis.stamp' to FTP server!", iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)object);
                IOUtils.closeQuietly(inputStream);
                FileUtils.deleteQuietly((File)file2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)object);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        FileUtils.deleteQuietly((File)file2);
    }

    @Override
    protected void doWrite(Object object, Writer writer) throws IOException {
        try {
            WisITUtils.marshallWithCDATA((Marshaller)WisITUtils.createMarshaller(), (Object)object, (Writer)writer);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't write WIS.it-XML!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new IOExceptionWithCause("Can't write WIS.it-XML!", (Throwable)exception);
        }
    }

    @Override
    public AbstractExportPanel createSetupPanel() {
        return new WisItXMLExportPanel();
    }

    public String getAgentId() {
        return this.agentId;
    }

    @Override
    protected boolean getEstateForUpdate(AgencyEstate agencyEstate) {
        if (agencyEstate == null) {
            return false;
        }
        if (!super.getEstateForUpdate(agencyEstate)) {
            return false;
        }
        String[] stringArray = agencyEstate.getGeoDbIds("wis_it");
        if (stringArray == null || stringArray.length < 2) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        ArrayList<EstateAttachmentImpl> arrayList = new ArrayList<EstateAttachmentImpl>();
        for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
            if (!this.canExportAttachment(agencyEstate.getIdNr(), estateAttachmentImpl)) continue;
            if (estateAttachmentImpl.getMimeType().toLowerCase().startsWith("image/")) {
                if (n > 9) {
                    arrayList.add(estateAttachmentImpl);
                    continue;
                }
                ++n;
                continue;
            }
            if (n2 > 2) {
                arrayList.add(estateAttachmentImpl);
                continue;
            }
            ++n2;
        }
        for (EstateAttachmentImpl estateAttachmentImpl : arrayList) {
            agencyEstate.getAttachments().remove(estateAttachmentImpl);
        }
        if (this.isPublicIdUsed()) {
            agencyEstate.setId(agencyEstate.getPublicId());
        }
        return true;
    }

    @Override
    protected String getEstateIdForRemoval(Long l, AgencyExportSummary agencyExportSummary) {
        return this.isPublicIdUsed() && agencyExportSummary.getRemovedEstatePublicIds().containsKey(l) ? agencyExportSummary.getRemovedEstatePublicIds().get(l) : super.getEstateIdForRemoval(l, agencyExportSummary);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return "Portal: Wohnen-in-Suedtirol.it";
    }

    @Override
    public String getXmlFileName() {
        return "WIS_IMPORT.XML";
    }

    public boolean isPublicIdUsed() {
        return this.publicIdUsed;
    }

    @Override
    public boolean isZipped() {
        return false;
    }

    @Override
    public void load(Properties properties) {
        super.load(properties);
        this.setAgentId(properties.getProperty(KEY_AGENT_ID, ""));
        this.setImageMode(properties.getProperty("export.imagemode", "file"));
        this.setPublicIdUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_PUBLIC_ID_USED, (Boolean)false, (Properties)properties));
        this.setIdPrefix(null);
        this.setIncremental(false);
        this.setZipped(false);
    }

    @Override
    public void save(Properties properties) {
        super.save(properties);
        properties.setProperty(KEY_AGENT_ID, this.getAgentId());
        properties.setProperty("export.imagemode", this.getImageMode());
        properties.setProperty(KEY_PUBLIC_ID_USED, Boolean.valueOf(this.isPublicIdUsed()).toString());
    }

    public void setAgentId(String string) {
        this.agentId = string != null ? string.trim() : "";
    }

    public void setPublicIdUsed(boolean bl) {
        this.publicIdUsed = bl;
    }

    @Override
    public boolean supportsIncrementalUpdate() {
        return false;
    }
}

