/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.AbstractExport;
import com.openindex.openestate.tool.agency.export.AbstractExportPanel;
import com.openindex.openestate.tool.agency.export.WisItXMLExport;
import com.openindex.openestate.tool.utils.JMimeTypeButton;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class WisItXMLExportPanel
extends AbstractExportPanel {
    private static final Logger LOGGER = Logger.getLogger(WisItXMLExportPanel.class);
    private ResourceMap resourceMap;
    private ValidationHandler validationHandler;
    private JTextField agentIdField;
    private JComboBox imageTypeBox;
    private JMimeTypeButton exportMimeTypesButton;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;

    public WisItXMLExportPanel() {
        this.build();
    }

    private void build() {
        this.resourceMap = ImmoToolUtils.getResourceMap(WisItXMLExportPanel.class);
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.buildForm();
        this.imageTypeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WisItXMLExportPanel.this.exportMimeTypesButton.setEnabled(WisItXMLExportPanel.this.imageTypeBox.getSelectedIndex() > 0);
            }
        });
        this.resourceMap.injectComponents((Component)this);
        this.load(null);
        this.validationHandler.init();
    }

    private void buildForm() {
        this.agentIdField = new JTextField();
        this.agentIdField.setName("agentIdField");
        this.exportMimeTypesButton = new JMimeTypeButton();
        this.exportMimeTypesButton.setName("exportMimeTypesButton");
        this.exportMimeTypesButton.setHorizontalAlignment(2);
        this.exportMimeTypesButton.addApplicationTypes();
        this.exportMimeTypesButton.addAudioTypes();
        this.exportMimeTypesButton.addImageTypes();
        this.exportMimeTypesButton.addTextTypes();
        this.exportMimeTypesButton.addVideoTypes();
        this.imageTypeBox = new JComboBox(new DefaultComboBoxModel());
        this.imageTypeBox.setName("imageTypeBox");
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.disabled", new Object[0]));
        ((DefaultComboBoxModel)this.imageTypeBox.getModel()).addElement(this.resourceMap.getString("label.imageType.file", new Object[0]));
        this.publicIdBox = new JCheckBox();
        this.publicIdBox.setName("publicIdBox");
        this.energyCertificateBox = new JCheckBox();
        this.energyCertificateBox.setName("energyCertificateBox");
        this.validationHandler.putRule((JComponent)this.agentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu");
        defaultFormBuilder.append(this.resourceMap.getString("label.agentId", new Object[0]), (Component)this.agentIdField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.imageType", new Object[0]), (Component)this.imageTypeBox);
        defaultFormBuilder.append((Component)this.exportMimeTypesButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.options", new Object[0]), (Component)this.publicIdBox, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append("", (Component)this.energyCertificateBox, 5);
        defaultFormBuilder.nextLine();
        JPanel jPanel = new JPanel(new FlowLayout(1));
        String string = ImmoToolApp.getApplication().getApplicationResources().getString("label.supportedBy", new Object[0]);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel.setBorder(titledBorder);
        try {
            this.appendFooterImage(jPanel, "<html><div style=\"padding:3px; text-align:center;\"><b>Immobilien Siller Immobili</b><br>mediatore e consulente immobiliare<br>Sterzing / Vipiteno, S\u00fcdtirol, Italia<br><b style=\"color:blue;\">www.immobili.bz.it</b></div></html>", new URL("http://www.immobili.bz.it/"), ImmoToolApp.class.getResource("/com/openindex/openestate/tool/resources/logos/siller.png"));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load partner-image!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        int n = titledBorder.getMinimumSize((Component)jPanel).width + 10;
        if (n > jPanel.getPreferredSize().width) {
            jPanel.setPreferredSize(new Dimension(n, jPanel.getPreferredSize().height));
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "East");
        defaultFormBuilder.border(Borders.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)defaultFormBuilder.getPanel(), "Center");
        this.add((Component)jPanel2, "South");
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(this.resourceMap.getString("warning.fullTransfer", new Object[0]));
        if (this.publicIdBox.isSelected()) {
            list.add(this.resourceMap.getString("warning.publicIdExport", new Object[0]));
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public final void load(AbstractExport abstractExport) {
        if (abstractExport == null) {
            this.agentIdField.setText("");
            this.imageTypeBox.setSelectedIndex(-1);
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(false);
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
        } else if (abstractExport instanceof WisItXMLExport) {
            WisItXMLExport wisItXMLExport = (WisItXMLExport)abstractExport;
            this.agentIdField.setText(wisItXMLExport.getAgentId());
            this.publicIdBox.setSelected(wisItXMLExport.isPublicIdUsed());
            this.energyCertificateBox.setSelected(wisItXMLExport.isEnergyCertificateAppendedToDescription());
            if (wisItXMLExport.isImageModeFile()) {
                this.imageTypeBox.setSelectedIndex(1);
            } else {
                this.imageTypeBox.setSelectedIndex(0);
            }
            this.exportMimeTypesButton.clearSelection();
            this.exportMimeTypesButton.setEnabled(this.imageTypeBox.getSelectedIndex() > 0);
            if (this.exportMimeTypesButton.isEnabled()) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    String string = item.getMimeType().toString();
                    item.setSelected(abstractExport.getMimeTypes().contains(string));
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(AbstractExport abstractExport) {
        if (abstractExport instanceof WisItXMLExport) {
            WisItXMLExport wisItXMLExport = (WisItXMLExport)abstractExport;
            wisItXMLExport.setAgentId(this.agentIdField.getText().trim());
            wisItXMLExport.setPublicIdUsed(this.publicIdBox.isSelected());
            wisItXMLExport.setEnergyCertificateAppendedToDescription(this.energyCertificateBox.isSelected());
            if (this.imageTypeBox.getSelectedIndex() == 1) {
                wisItXMLExport.setImageMode("file");
            } else {
                wisItXMLExport.setImageMode("disabled");
            }
            abstractExport.getMimeTypes().clear();
            if (this.imageTypeBox.getSelectedIndex() > 0) {
                for (JMimeTypeButton.Item item : this.exportMimeTypesButton.getMimeTypeItems()) {
                    if (!item.isSelected()) continue;
                    abstractExport.getMimeTypes().add(item.getMimeType().toString());
                }
            }
        } else {
            throw new IllegalArgumentException("invalid export-class: " + abstractExport.getClass().getName());
        }
    }
}

