/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class GeoDb {
    private static final Map<String, GeoAreaImpl> areaCache = new HashMap<String, GeoAreaImpl>();
    private static final Map<String, GeoAreaImpl[]> childAreaCache = new HashMap<String, GeoAreaImpl[]>();
    private static final Map<String, GeoCountryImpl[]> countryCache = new HashMap<String, GeoCountryImpl[]>();
    private String name;
    private String provider;
    private Date buildTime;

    private static synchronized void cacheArea(String string, GeoAreaImpl geoAreaImpl) {
        String string2 = string + "." + geoAreaImpl.getId();
        if (!areaCache.containsKey(string2) && areaCache.size() >= 100) {
            String string3 = areaCache.keySet().iterator().next();
            areaCache.remove(string3);
        }
        areaCache.put(string2, geoAreaImpl);
    }

    private static synchronized GeoAreaImpl cacheAreaLookup(String string, String string2) {
        String string3 = string + "." + string2;
        return areaCache.containsKey(string3) ? areaCache.get(string3) : null;
    }

    private static synchronized void cacheAreas(String string, String string2, GeoAreaImpl[] geoAreaImplArray) {
        for (GeoAreaImpl geoAreaImpl : geoAreaImplArray) {
            GeoDb.cacheArea(string, geoAreaImpl);
        }
        String string3 = string + "." + string2;
        if (!childAreaCache.containsKey(string3) && childAreaCache.size() >= 50) {
            String string4 = childAreaCache.keySet().iterator().next();
            childAreaCache.remove(string4);
        }
        childAreaCache.put(string3, geoAreaImplArray);
    }

    private static synchronized GeoAreaImpl[] cacheAreasLookup(String string, String string2) {
        String string3 = string + "." + string2;
        return childAreaCache.containsKey(string3) ? childAreaCache.get(string3) : null;
    }

    private static synchronized void cacheCountries(String string, GeoCountryImpl[] geoCountryImplArray) {
        String string2 = string;
        if (!countryCache.containsKey(string2) && countryCache.size() >= 10) {
            String string3 = countryCache.keySet().iterator().next();
            countryCache.remove(string3);
        }
        countryCache.put(string2, geoCountryImplArray);
    }

    private static synchronized GeoCountryImpl[] cacheCountriesLookup(String string) {
        String string2 = string;
        return countryCache.containsKey(string2) ? countryCache.get(string2) : null;
    }

    public static synchronized void clearCaches() {
        areaCache.clear();
        childAreaCache.clear();
        countryCache.clear();
    }

    public Date getBuildTime() {
        return this.buildTime != null ? (Date)this.buildTime.clone() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoAreaImpl loadArea(String string) throws ImmoToolDbException {
        GeoAreaImpl geoAreaImpl = GeoDb.cacheAreaLookup(this.getName(), string);
        if (geoAreaImpl != null) {
            return geoAreaImpl;
        }
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoAreaImpl geoAreaImpl2 = this.loadArea(string, collection);
            return geoAreaImpl2;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public GeoAreaImpl loadArea(String string, Collection collection) throws ImmoToolDbException {
        GeoAreaImpl geoAreaImpl = GeoDb.cacheAreaLookup(this.getName(), string);
        if (geoAreaImpl != null) {
            return geoAreaImpl;
        }
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Agency/geo/" + this.getName() + ".xml')//openestate:Area\n" + "let $Id := $x/@Id\n" + "let $Name := $x/@Name\n" + "let $ProviderId := $x/@ProviderId\n" + "where ($Id='" + string + "')\n" + "order by $Name\n" + "return <row Id=\"{$Id}\" Name=\"{$Name}\" ProviderId=\"{$ProviderId}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            Node node = xMLResource.getContentAsDOM();
            GeoAreaImpl geoAreaImpl2 = new GeoAreaImpl();
            geoAreaImpl2.setId(node.getAttributes().getNamedItem("Id").getNodeValue());
            geoAreaImpl2.setName(node.getAttributes().getNamedItem("Name").getNodeValue());
            geoAreaImpl2.setProviderId(node.getAttributes().getNamedItem("ProviderId").getNodeValue());
            GeoDb.cacheArea(this.getName(), geoAreaImpl2);
            return geoAreaImpl2;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load geo-databases: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public GeoAreaImpl[] loadAreas(GeoAreaImpl geoAreaImpl) throws ImmoToolDbException {
        return this.loadAreas(geoAreaImpl.getId());
    }

    public GeoAreaImpl[] loadAreas(GeoCountryImpl geoCountryImpl) throws ImmoToolDbException {
        return this.loadAreas(geoCountryImpl.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoAreaImpl[] loadAreas(String string) throws ImmoToolDbException {
        GeoAreaImpl[] geoAreaImplArray = GeoDb.cacheAreasLookup(this.getName(), string);
        if (geoAreaImplArray != null) {
            return geoAreaImplArray;
        }
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoAreaImpl[] geoAreaImplArray2 = this.loadAreas(string, collection);
            return geoAreaImplArray2;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public GeoAreaImpl[] loadAreas(String string, Collection collection) throws ImmoToolDbException {
        GeoAreaImpl[] geoAreaImplArray = GeoDb.cacheAreasLookup(this.getName(), string);
        if (geoAreaImplArray != null) {
            return geoAreaImplArray;
        }
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Agency/geo/" + this.getName() + ".xml')//openestate:Area\n" + "let $Id := $x/@Id\n" + "let $Name := $x/@Name\n" + "let $ProviderId := $x/@ProviderId\n" + "where ($x/../@Id='" + string + "')\n" + "order by $Name\n" + "return <row Id=\"{$Id}\" Name=\"{$Name}\" ProviderId=\"{$ProviderId}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            ArrayList<GeoAreaImpl> arrayList = new ArrayList<GeoAreaImpl>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                Node node = xMLResource.getContentAsDOM();
                GeoAreaImpl geoAreaImpl = new GeoAreaImpl();
                geoAreaImpl.setId(node.getAttributes().getNamedItem("Id").getNodeValue());
                geoAreaImpl.setName(node.getAttributes().getNamedItem("Name").getNodeValue());
                geoAreaImpl.setProviderId(node.getAttributes().getNamedItem("ProviderId").getNodeValue());
                arrayList.add(geoAreaImpl);
            }
            GeoAreaImpl[] geoAreaImplArray2 = arrayList.toArray(new GeoAreaImpl[arrayList.size()]);
            GeoDb.cacheAreas(this.getName(), string, geoAreaImplArray2);
            return geoAreaImplArray2;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load geo-databases: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoCountryImpl[] loadCountries() throws ImmoToolDbException {
        GeoCountryImpl[] geoCountryImplArray = GeoDb.cacheCountriesLookup(this.getName());
        if (geoCountryImplArray != null) {
            return geoCountryImplArray;
        }
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoCountryImpl[] geoCountryImplArray2 = this.loadCountries(collection);
            return geoCountryImplArray2;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public GeoCountryImpl[] loadCountries(Collection collection) throws ImmoToolDbException {
        GeoCountryImpl[] geoCountryImplArray = GeoDb.cacheCountriesLookup(this.getName());
        if (geoCountryImplArray != null) {
            return geoCountryImplArray;
        }
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Agency/geo/" + this.getName() + ".xml')//openestate:Country\n" + "let $Id := $x/@Id\n" + "let $IsoCode := $x/@IsoCode\n" + "let $Name := $x/@Name\n" + "let $ProviderId := $x/@ProviderId\n" + "order by $Name\n" + "return <row Id=\"{$Id}\" Name=\"{$Name}\" ProviderId=\"{$ProviderId}\" IsoCode=\"{$IsoCode}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            ArrayList<GeoCountryImpl> arrayList = new ArrayList<GeoCountryImpl>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                Node node = xMLResource.getContentAsDOM();
                GeoCountryImpl geoCountryImpl = new GeoCountryImpl();
                geoCountryImpl.setId(node.getAttributes().getNamedItem("Id").getNodeValue());
                geoCountryImpl.setName(node.getAttributes().getNamedItem("Name").getNodeValue());
                geoCountryImpl.setProviderId(node.getAttributes().getNamedItem("ProviderId").getNodeValue());
                geoCountryImpl.setIsoCode(node.getAttributes().getNamedItem("IsoCode").getNodeValue());
                arrayList.add(geoCountryImpl);
            }
            GeoCountryImpl[] geoCountryImplArray2 = arrayList.toArray(new GeoCountryImpl[arrayList.size()]);
            GeoDb.cacheCountries(this.getName(), geoCountryImplArray2);
            return geoCountryImplArray2;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load geo-databases: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoDb loadGeoDb(String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoDb geoDb = GeoDb.loadGeoDb(string, collection);
            return geoDb;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static GeoDb loadGeoDb(String string, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = "declare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in document('ImmoTool/OpenEstate-Agency/geo/" + string + ".xml')/openestate:Geo\n" + "let $name := $x/@Name\n" + "let $provider := $x/@Provider\n" + "let $buildTime := $x/@BuildTime\n" + "return <row name=\"{$name}\" provider=\"{$provider}\" buildTime=\"{$buildTime}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            if (resourceSet.getSize() <= 0L) {
                return null;
            }
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            Node node = xMLResource.getContentAsDOM();
            GeoDb geoDb = new GeoDb();
            geoDb.setName(node.getAttributes().getNamedItem("name").getNodeValue());
            geoDb.setProvider(node.getAttributes().getNamedItem("provider").getNodeValue());
            String string3 = node.getAttributes().getNamedItem("buildTime").getNodeValue();
            if (string3 != null) {
                geoDb.setBuildTime(OpenEstateUtils.getXsdDateTimeFormat().parse(string3));
            }
            return geoDb;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load geo-database: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoDb[] loadGeoDbs() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoDb[] geoDbArray = GeoDb.loadGeoDbs(collection);
            return geoDbArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static GeoDb[] loadGeoDbs(Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/geo')/openestate:Geo\nlet $name := $x/@Name\nlet $provider := $x/@Provider\nlet $buildTime := $x/@BuildTime\norder by $name\nreturn <row name=\"{$name}\" provider=\"{$provider}\" buildTime=\"{$buildTime}\" />";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            ArrayList<GeoDb> arrayList = new ArrayList<GeoDb>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                Node node = xMLResource.getContentAsDOM();
                GeoDb geoDb = new GeoDb();
                geoDb.setName(node.getAttributes().getNamedItem("name").getNodeValue());
                geoDb.setProvider(node.getAttributes().getNamedItem("provider").getNodeValue());
                String string2 = node.getAttributes().getNamedItem("buildTime").getNodeValue();
                if (string2 != null) {
                    geoDb.setBuildTime(OpenEstateUtils.getXsdDateTimeFormat().parse(string2));
                }
                arrayList.add(geoDb);
            }
            return arrayList.toArray(new GeoDb[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load geo-databases: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGeoDb(String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoDb.removeGeoDb(string, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void removeGeoDb(String string, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = string + ".xml";
            XMLResource xMLResource = null;
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string2)) {
                return;
            }
            xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string2);
            if (xMLResource == null) {
                throw new Exception("Can't find resource: " + string2 + "!");
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not remove geo-database: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setBuildTime(Date date) {
        this.buildTime = date != null ? (Date)date.clone() : null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeGeoDb(String string, File file) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/geo");
            GeoDb.storeGeoDb(string, file, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void storeGeoDb(String string, File file, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        BufferedReader bufferedReader = null;
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/geo")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string2 = string + ".xml";
            XMLResource xMLResource = null;
            xMLResource = !ImmoToolDbUtils.hasResource((Collection)collection, (String)string2) ? ImmoToolDbUtils.createXmlResource((Collection)collection, (String)string2) : ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string2);
            if (xMLResource == null) {
                throw new Exception("Can't find resource: " + string2 + "!");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuilder.append(string3).append(SystemUtils.LINE_SEPARATOR);
                string3 = bufferedReader.readLine();
            }
            xMLResource.setContent((Object)stringBuilder.toString().trim());
            ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            try {
                throw immoToolDbException;
                catch (Exception exception) {
                    throw new ImmoToolDbException("could not store geo-database: " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }
}

