/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class GeoDbPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(GeoDbPanel.class);
    private ResourceMap resourceMap;
    private GeoDb geoDb;
    private JComboBox geoCountryBox;
    private List<JComboBox> geoAreaBoxes;
    private DefaultFormBuilder geoFormBuilder;
    private JPanel busyPanel;
    private JXBusyLabel busyLabel;
    private boolean isLoading = false;

    public GeoDbPanel(GeoDb geoDb) {
        this(geoDb, 50);
    }

    public GeoDbPanel(GeoDb geoDb, int n) {
        this.geoDb = geoDb;
        this.resourceMap = ImmoToolUtils.getResourceMap(GeoDbPanel.class);
        this.geoAreaBoxes = new ArrayList<JComboBox>();
        int n2 = n > 0 ? n : 50;
        this.geoCountryBox = new JComboBox();
        this.geoCountryBox.setName("geoCountryBox");
        this.geoCountryBox.setRenderer(new CountryRenderer());
        this.geoCountryBox.addItem("");
        try {
            for (GeoCountryImpl geoCountryImpl : geoDb.loadCountries()) {
                this.geoCountryBox.addItem(geoCountryImpl);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't load countries from GeoDb!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.geoCountryBox.addActionListener(new GeoSelectAction(this.geoCountryBox, 0));
        AutoCompleteDecorator.decorate((JComboBox)this.geoCountryBox, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof GeoCountryImpl) {
                    return ((GeoCountryImpl)object).getName();
                }
                return "-";
            }
        });
        this.geoFormBuilder = ImmoToolUtils.createFormBuilder((String)("right:[" + n2 + "dlu,pref], 3dlu, 30dlu:grow"));
        this.geoFormBuilder.append(this.resourceMap.getString("label.country", new Object[0]) + ":", (Component)this.geoCountryBox);
        this.geoFormBuilder.nextLine();
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setName("busyLabel");
        this.busyLabel.setVisible(false);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)("right:[" + n2 + "dlu,pref], 3dlu, 30dlu:grow"));
        defaultFormBuilder.append("", (Component)this.busyLabel);
        defaultFormBuilder.nextLine();
        this.busyPanel = defaultFormBuilder.getPanel();
        this.busyPanel.setVisible(false);
        this.busyPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.geoFormBuilder.getPanel(), "Center");
        this.add((Component)this.busyPanel, "South");
        this.revalidate();
        this.repaint();
        this.resourceMap.injectComponents((Component)this);
    }

    private JComboBox appendBox(int n) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setRenderer(new AreaRenderer());
        jComboBox.addActionListener(new GeoSelectAction(jComboBox, n));
        AutoCompleteDecorator.decorate(jComboBox, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof GeoAreaImpl) {
                    return ((GeoAreaImpl)object).getName();
                }
                return "-";
            }
        });
        this.geoFormBuilder.append(this.resourceMap.getString("label.area", new Object[]{n}) + ":", jComboBox);
        this.geoFormBuilder.nextLine();
        this.geoFormBuilder.getPanel().revalidate();
        this.geoFormBuilder.getPanel().repaint();
        return jComboBox;
    }

    public GeoDb getGeoDb() {
        return this.geoDb;
    }

    public void load(AgencyEstate agencyEstate) throws ImmoToolDbException {
        int n;
        boolean bl;
        String string = agencyEstate.getId();
        boolean bl2 = bl = string == null || string.trim().length() == 0;
        if (bl) {
            return;
        }
        this.isLoading = true;
        String[] stringArray = agencyEstate.getGeoDbIds(this.geoDb.getName());
        block0: for (n = 0; n < stringArray.length; ++n) {
            String string2;
            JComboBox jComboBox = null;
            if (n == 0) {
                jComboBox = this.geoCountryBox;
                string2 = stringArray[n];
                for (int i = 0; i < this.geoCountryBox.getItemCount(); ++i) {
                    GeoCountryImpl geoCountryImpl;
                    Object e = this.geoCountryBox.getItemAt(i);
                    if (!(e instanceof GeoCountryImpl) || (geoCountryImpl = (GeoCountryImpl)e).getId() == null || !geoCountryImpl.getId().equals(string2)) continue;
                    jComboBox.setSelectedIndex(i);
                    continue block0;
                }
                continue;
            }
            if (this.geoAreaBoxes.size() >= n) {
                jComboBox = this.geoAreaBoxes.get(n - 1);
            } else {
                jComboBox = this.appendBox(n);
                this.geoAreaBoxes.add(jComboBox);
            }
            string2 = stringArray[n];
            String string3 = stringArray[n - 1];
            jComboBox.setEnabled(true);
            jComboBox.removeAllItems();
            jComboBox.addItem(null);
            for (GeoAreaImpl geoAreaImpl : this.geoDb.loadAreas(string3)) {
                jComboBox.addItem(geoAreaImpl);
                if (geoAreaImpl.getId() == null || !geoAreaImpl.getId().equals(string2)) continue;
                jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
            }
        }
        for (n = stringArray.length; n < this.geoAreaBoxes.size(); ++n) {
            this.geoAreaBoxes.get(n).removeAllItems();
            this.geoAreaBoxes.get(n).addItem(null);
            this.geoAreaBoxes.get(n).setEnabled(false);
        }
        this.isLoading = false;
        if (stringArray.length == 1) {
            new GeoSelectAction(this.geoCountryBox, 0).actionPerformed(null);
        } else if (stringArray.length > 1) {
            n = stringArray.length - 2;
            if (this.geoAreaBoxes.size() > n) {
                new GeoSelectAction(this.geoAreaBoxes.get(n), stringArray.length - 1).actionPerformed(null);
            }
        }
    }

    private Task reloadBox(final JComboBox jComboBox, final String string) {
        jComboBox.removeAllItems();
        jComboBox.addItem("");
        jComboBox.setEnabled(false);
        if (string == null) {
            return null;
        }
        this.busyLabel.setBusy(true);
        this.busyLabel.setText(this.resourceMap.getString("label.reload", new Object[0]));
        this.busyLabel.setVisible(true);
        this.busyPanel.setVisible(true);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                for (GeoAreaImpl geoAreaImpl : GeoDbPanel.this.geoDb.loadAreas(string)) {
                    jComboBox.addItem(geoAreaImpl);
                }
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                GeoDbPanel.this.busyLabel.setText(GeoDbPanel.this.resourceMap.getString("label.reload.error", new Object[0]));
            }

            protected void finished() {
                super.finished();
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoDbPanel.this.busyLabel.setBusy(false);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                jComboBox.setEnabled(jComboBox.getItemCount() > 1);
                GeoDbPanel.this.busyLabel.setVisible(false);
            }
        };
    }

    public void save(AgencyEstate agencyEstate) {
        GeoCountryImpl geoCountryImpl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.geoCountryBox.getSelectedItem() instanceof GeoCountryImpl && (geoCountryImpl = (GeoCountryImpl)this.geoCountryBox.getSelectedItem()) != null) {
            arrayList.add(geoCountryImpl.getId());
            for (JComboBox jComboBox : this.geoAreaBoxes) {
                if (!(jComboBox.getSelectedItem() instanceof GeoAreaImpl)) continue;
                GeoAreaImpl geoAreaImpl = (GeoAreaImpl)jComboBox.getSelectedItem();
                if (geoAreaImpl == null) break;
                arrayList.add(geoAreaImpl.getId());
            }
        }
        agencyEstate.setGeoDbIds(this.geoDb.getName(), arrayList.toArray(new String[arrayList.size()]));
    }

    private class GeoSelectAction
    implements ActionListener {
        private JComboBox box;
        private int level;

        public GeoSelectAction(JComboBox jComboBox, int n) {
            this.box = jComboBox;
            this.level = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (GeoDbPanel.this.isLoading) {
                return;
            }
            if (this.box.isPopupVisible() && (actionEvent == null || (actionEvent.getModifiers() & 0x10) == 0)) {
                return;
            }
            Object object = this.box.getSelectedItem();
            if ("".equals(object)) {
                object = null;
            }
            JComboBox jComboBox = null;
            if (GeoDbPanel.this.geoAreaBoxes.size() > this.level) {
                jComboBox = (JComboBox)GeoDbPanel.this.geoAreaBoxes.get(this.level);
            } else {
                if (object == null) {
                    return;
                }
                jComboBox = GeoDbPanel.this.appendBox(this.level + 1);
                GeoDbPanel.this.geoAreaBoxes.add(jComboBox);
            }
            String string = null;
            if (object instanceof GeoCountryImpl) {
                string = ((GeoCountryImpl)object).getId();
            } else if (object instanceof GeoAreaImpl) {
                string = ((GeoAreaImpl)object).getId();
            }
            ImmoToolUtils.executeTask((Task)GeoDbPanel.this.reloadBox(jComboBox, string));
        }
    }

    private class CountryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CountryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof GeoCountryImpl) {
                GeoCountryImpl geoCountryImpl = (GeoCountryImpl)object;
                this.setText(" " + geoCountryImpl.getName());
            } else {
                this.setText(" [ " + GeoDbPanel.this.resourceMap.getString("label.noSelection", new Object[]{GeoDbPanel.this.geoDb.getName()}) + " ]");
            }
            return this;
        }
    }

    private class AreaRenderer
    extends JLabel
    implements ListCellRenderer {
        public AreaRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof GeoAreaImpl) {
                GeoAreaImpl geoAreaImpl = (GeoAreaImpl)object;
                this.setText(" " + geoAreaImpl.getName());
            } else {
                this.setText(" [ " + GeoDbPanel.this.resourceMap.getString("label.noSelection", new Object[]{GeoDbPanel.this.geoDb.getName()}) + " ]");
            }
            return this;
        }
    }
}

