/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlExport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class HtmlBuilder {
    public static final String HTML_RES_PATH = "/com/openindex/openestate/tool/agency/utils/resources/html/";
    public static final String BASE_STYLESHEET = "website.css";
    private final WebsiteHtmlExport export;
    private String encoding = Charset.defaultCharset().name();
    private Locale locale = Locale.getDefault();

    public HtmlBuilder(WebsiteHtmlExport websiteHtmlExport) {
        this.export = websiteHtmlExport;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public WebsiteHtmlExport getExport() {
        return this.export;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static String prepareString(String string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml((String)string).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&nbsp;").replaceAll("'", "&apos;");
    }

    protected void saveFile(InputStream inputStream, File file) throws IOException {
        ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveHtml(String string, File file) throws IOException {
        StringReader stringReader = null;
        FileWriter fileWriter = null;
        try {
            stringReader = new StringReader(string);
            fileWriter = new FileWriter(file);
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = stringReader.read(cArray, 0, cArray.length)) > 0) {
                fileWriter.write(cArray, 0, n);
            }
            fileWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stringReader);
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)stringReader);
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDefaultStylesheet(File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(this.getClass().getResourceAsStream("/com/openindex/openestate/tool/agency/utils/resources/html/website.css"));
            ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String writeText(String string) {
        String string2 = "https?://(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,4})?((/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)?";
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = string.substring(matcher.start(), matcher.end());
            matcher.appendReplacement(stringBuffer, "<a href=\"" + string3 + "\" target=\"_blank\">" + string3 + "</a>");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replaceAll("\\n", "<br/>");
    }
}

