/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlExport;
import com.openindex.openestate.tool.agency.utils.HtmlBuilder;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class HtmlExposeBuilder
extends HtmlBuilder {
    private static final Logger LOGGER = Logger.getLogger(HtmlExposeBuilder.class);
    private static final String LS = SystemUtils.LINE_SEPARATOR;
    private Properties resources;
    private Date now;

    public HtmlExposeBuilder(WebsiteHtmlExport websiteHtmlExport) {
        super(websiteHtmlExport);
        this.loadResources();
        this.now = new Date();
    }

    /*
     * WARNING - void declaration
     */
    protected String buildWebsite(AgencyEstate agencyEstate, AgencyAgent agencyAgent, AgencyContact agencyContact, String string, String string2) throws OpenEstateException {
        Object object;
        String string32;
        EstateAttachmentImpl estateAttachmentImpl;
        Object object2;
        Object object3;
        CharSequence charSequence;
        if (agencyEstate == null) {
            throw new IllegalArgumentException("unknown estate!");
        }
        if (agencyEstate.getIdNr() < 1L) {
            throw new IllegalArgumentException("unknown estate-id!");
        }
        if (agencyAgent == null) {
            throw new IllegalArgumentException("unknown agent!");
        }
        String string4 = agencyEstate.getPublicId();
        if (string4 == null || string4.trim().length() <= 0) {
            string4 = "#" + agencyEstate.getIdNr();
        }
        String string5 = agencyEstate.getType() != null ? OpenEstateUtils.translateEstate((String)agencyEstate.getType().getName(), (Locale)this.getLocale()) : this.resources.getProperty("label.undefinedEstateType", "???");
        String string6 = agencyEstate.getAction() != null ? OpenEstateUtils.translateAction((String)agencyEstate.getAction(), (Locale)this.getLocale()) : this.resources.getProperty("label.undefinedEstateAction", "???");
        String string7 = agencyEstate.getTitle(this.getLocale());
        if (string7 == null || string7.trim().length() <= 0) {
            string7 = string5 + ", " + string6 + ", " + agencyEstate.getAdress().getPostalCode() + " " + agencyEstate.getAdress().getCity() + ", " + agencyEstate.getAdress().writeCountry(this.getLocale());
        }
        String string8 = null;
        String[] stringArray = new String[]{"FREITEXTE.KURZ_BESCHR", "FREITEXTE.OBJEKT_BESCHR"};
        for (String object52 : stringArray) {
            if (!agencyEstate.hasAttribute(object52) || (charSequence = (String)agencyEstate.getAttribute(object52).getValueObject(this.getLocale())) == null || ((String)charSequence).trim().length() <= 0) continue;
            string8 = charSequence;
            break;
        }
        if (string8 == null || string8.trim().length() <= 0) {
            string8 = string7;
        }
        if (string8.length() > 150) {
            string8 = string8.substring(0, 150) + "...";
        }
        string8 = string8.replaceAll("\\n", " ").replaceAll("\\r", " ").replaceAll("\\s\\s", " ");
        StringBuilder stringBuilder = new StringBuilder();
        String string9 = "FREITEXTE.KEYWORDS";
        if (agencyEstate.hasAttribute(string9)) {
            stringBuilder.append(agencyEstate.getAttribute(string9).getValueObject(this.getLocale()));
        }
        if (stringBuilder.length() <= 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(OpenEstateUtils.getEstateTypePath((OpenEstateType)agencyEstate.getType())));
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string6);
            stringBuilder.append(',').append(agencyEstate.getAdress().getPostalCode());
            stringBuilder.append(',').append(agencyEstate.getAdress().getCity());
            if (agencyEstate.getAdress().getCityPart() != null && agencyEstate.getAdress().getCityPart().trim().length() > 0) {
                stringBuilder.append(',').append(agencyEstate.getAdress().getCityPart());
            }
            stringBuilder.append(',').append(agencyEstate.getAdress().writeCountry(this.getLocale()));
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        if (!this.getExport().isImageModeDisabled()) {
            void var15_20;
            boolean i = false;
            while (var15_20 < agencyEstate.getAttachments().size()) {
                charSequence = (EstateAttachmentImpl)agencyEstate.getAttachments().get((int)var15_20);
                if (charSequence.isName() && (this.getExport().isAllImagesExported() || charSequence.isPublished()) && charSequence.getMimeType().startsWith("image/") && this.getExport().getMimeTypes().contains(charSequence.getMimeType())) {
                    arrayList.add(charSequence);
                }
                ++var15_20;
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (!this.getExport().isImageModeDisabled()) {
            for (int i = 0; i < agencyEstate.getAttachments().size(); ++i) {
                object3 = (EstateAttachmentImpl)agencyEstate.getAttachments().get(i);
                if (!object3.isName() || !object3.isPublished() || object3.getMimeType().startsWith("image/") || !this.getExport().getMimeTypes().contains(object3.getMimeType())) continue;
                arrayList2.add(object3);
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("<div class=\"expose-nav\">");
        ((StringBuilder)charSequence).append("[ <a href=\"../../index.html\" title=\"").append(this.resources.getProperty("label.backToSummary", "???")).append("\">").append(this.resources.getProperty("label.backToSummary", "???")).append("</a> ]");
        object3 = this.getExport().getPdfSetupId();
        if (object3 != null && (Long)object3 > 0L) {
            ((StringBuilder)charSequence).append("[ <a href=\"index.pdf\" target=\"_blank\" title=\"").append(this.resources.getProperty("label.downloadPdf", "???")).append("\">").append(this.resources.getProperty("label.downloadPdf", "???")).append("</a> ]");
        }
        ((StringBuilder)charSequence).append("[ <a href=\"#\" onclick=\"window.print();return false;\" title=\"").append(this.resources.getProperty("label.printExpose", "???")).append("\">").append(this.resources.getProperty("label.printExpose", "???")).append("</a> ]");
        ((StringBuilder)charSequence).append("</div>");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">").append(LS);
        stringBuilder2.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">").append(LS);
        stringBuilder2.append("<head>").append(LS);
        stringBuilder2.append("<title>").append(HtmlExposeBuilder.prepareString(string7)).append(" | ").append(this.resources.getProperty("label.expose", "???")).append(" ").append(string4).append("</title>").append(LS);
        stringBuilder2.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=").append(HtmlExposeBuilder.prepareString(this.getEncoding())).append("\"/>").append(LS);
        stringBuilder2.append("<meta name=\"description\" content=\"").append(HtmlExposeBuilder.prepareString(string8)).append("\"/>").append(LS);
        stringBuilder2.append("<meta name=\"keywords\" content=\"").append(HtmlExposeBuilder.prepareString(stringBuilder.toString())).append("\"/>").append(LS);
        stringBuilder2.append("<meta name=\"author\" content=\"").append(HtmlExposeBuilder.prepareString(this.getExport().getCompany())).append("\"/>").append(LS);
        stringBuilder2.append("<meta name=\"generator\" content=\"").append(HtmlExposeBuilder.prepareString(ImmoToolApp.getApplicationTitle() + " " + ImmoToolApp.getApplicationVersion())).append("\"/>").append(LS);
        stringBuilder2.append("<meta name=\"robots\" content=\"index,follow\"/>").append(LS);
        if (string != null) {
            stringBuilder2.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(string).append("\"/>").append(LS);
        }
        if (string2 != null) {
            stringBuilder2.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(string2).append("\"/>").append(LS);
        }
        if (this.getExport().isRssFeedExport()) {
            stringBuilder2.append("<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS-Feed\" href=\"../../rss.xml\" />").append(LS);
        }
        if (this.getExport().isAtomFeedExport()) {
            stringBuilder2.append("<link rel=\"alternate\" type=\"application/atom+xml\" title=\"Atom-Feed\" href=\"../../atom.xml\" />").append(LS);
        }
        if (!arrayList.isEmpty() && this.getExport().isImageExportWithColorbox()) {
            stringBuilder2.append("<link type=\"text/css\" media=\"screen\" rel=\"stylesheet\" href=\"../../colorbox/colorbox.css\" />").append(LS);
            stringBuilder2.append("<script type=\"text/javascript\" src=\"../../colorbox/jquery.min.js\"></script>").append(LS);
            stringBuilder2.append("<script type=\"text/javascript\" src=\"../../colorbox/jquery.colorbox-min.js\"></script>").append(LS);
            stringBuilder2.append("<script type=\"text/javascript\">").append(LS);
            stringBuilder2.append("$(document).ready(function(){").append(LS);
            stringBuilder2.append("  $(\"a[rel='gallery']\").colorbox({transition:\"none\", width:\"75%\", height:\"75%\"});").append(LS);
            stringBuilder2.append("});").append(LS);
            stringBuilder2.append("</script>").append(LS);
        }
        stringBuilder2.append("</head>").append(LS);
        stringBuilder2.append("<body>").append("<div id=\"page\" class=\"expose\">").append(LS);
        stringBuilder2.append(((StringBuilder)charSequence).toString()).append(LS);
        String string10 = agencyEstate.getTitle(this.getLocale());
        if (string10 == null || string10.trim().length() == 0) {
            string10 = agencyEstate.getFallbackTitle(this.getLocale());
        }
        stringBuilder2.append("<div id=\"expose-header\">");
        stringBuilder2.append("<h1>").append(this.resources.getProperty("label.expose", "???")).append(" ").append(string4).append(" &bull; ").append(string10).append("</h1>");
        stringBuilder2.append("<h2>").append(string5).append(" / ").append(string6).append("</h2>");
        stringBuilder2.append("</div>").append(LS);
        stringBuilder2.append("<div id=\"expose-estate\"").append(this.getExport().isExposeAgentVisible() || this.getExport().isExposeContactVisible() ? " class=\"col_left\"" : "").append(">").append(LS);
        stringBuilder2.append("<div id=\"expose-estate-adress\">");
        stringBuilder2.append("<h3>").append(this.resources.getProperty("label.adress", "???")).append("</h3>");
        stringBuilder2.append("<p>").append(agencyEstate.getAdress().writeFullAdress("<br/>", this.getLocale())).append("</p>");
        stringBuilder2.append("</div>").append(LS);
        Collection collection = agencyEstate.getAttributes();
        if (!collection.isEmpty()) {
            String string11;
            stringBuilder2.append("<div id=\"expose-estate-attribs\">");
            object2 = null;
            estateAttachmentImpl = new TreeSet(agencyEstate.getAttributeKeys());
            for (String string32 : estateAttachmentImpl) {
                object = agencyEstate.getAttribute(string32);
                if (object.getGroupName() == null || object.getAttribName() == null || object.getGroupName().equalsIgnoreCase("FREITEXTE") || object.getGroupName().equalsIgnoreCase("PREISE") && object.getAttribName().equalsIgnoreCase("SONDERANGEBOT") || StringUtils.isBlank((String)(string11 = agencyEstate.writeValue((ValueImpl)object, this.getLocale())))) continue;
                if (object2 == null || !((String)object2).equals(object.getGroupName())) {
                    if (object2 != null) {
                        stringBuilder2.append("</ul>");
                    }
                    object2 = object.getGroupName();
                    stringBuilder2.append("<h3>").append(OpenEstateUtils.translateAttributeByCountry((String)object2, (Locale)this.getLocale(), (String)agencyEstate.getAdress().getCountry())).append("</h3>");
                    stringBuilder2.append("<ul>");
                }
                stringBuilder2.append("<li>").append(OpenEstateUtils.translateAttributeByCountry((String)object2, (String)object.getAttribName(), (Locale)this.getLocale(), (String)agencyEstate.getAdress().getCountry())).append(": ").append("<b>").append(HtmlExposeBuilder.prepareString(string11)).append("</b>").append("</li>");
            }
            if (object2 != null) {
                stringBuilder2.append("</ul>");
            }
            stringBuilder2.append("</div>").append(LS);
            for (String string32 : estateAttachmentImpl) {
                object = agencyEstate.getAttribute(string32);
                if (object.getGroupName() == null || object.getAttribName() == null || !object.getGroupName().equalsIgnoreCase("FREITEXTE") || agencyEstate.isHiddenPrices() && object.getAttribName().equalsIgnoreCase("PREIS_BESCHR")) continue;
                string11 = OpenEstateUtils.translateAttributeByCountry((String)object.getGroupName(), (String)object.getAttribName(), (Locale)this.getLocale(), (String)agencyEstate.getAdress().getCountry());
                String string12 = agencyEstate.writeValue((ValueImpl)object, this.getLocale());
                if (string12 == null || string12.trim().length() == 0) continue;
                stringBuilder2.append("<div class=\"expose-estate-text\">");
                stringBuilder2.append("<h3>").append(string11 != null ? string11 : object.getAttribName()).append("</h3>");
                stringBuilder2.append("<p>").append(HtmlExposeBuilder.writeText(HtmlExposeBuilder.prepareString(string12.trim()))).append("</p>");
                stringBuilder2.append("</div>").append(LS);
            }
        }
        if (!arrayList.isEmpty()) {
            stringBuilder2.append("<div id=\"expose-estate-gallery\">");
            stringBuilder2.append("<h3>").append(this.resources.getProperty("label.gallery", "???")).append("</h3>");
            int n = 0;
            for (EstateAttachmentImpl estateAttachmentImpl2 : arrayList) {
                stringBuilder2.append("<div class=\"image\">");
                string32 = estateAttachmentImpl2.getTitle(this.getLocale());
                string32 = string32 == null ? "" : string32.trim();
                if (string32.length() > 0) {
                    stringBuilder2.append("<h4>").append(string32).append("</h4>");
                }
                object = "img_" + ++n + ".jpg";
                if (this.getExport().isImageExportWithColorbox()) {
                    stringBuilder2.append("<script type=\"text/javascript\">").append(LS);
                    stringBuilder2.append("document.write( '<a href=\"").append((String)object).append("\" rel=\"gallery\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\"><img src=\"").append((String)object).append("\" alt=\"\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\" border=\"0\" width=\"50%\" height=\"50%\" /></a>' );").append(LS);
                    stringBuilder2.append("</script>").append(LS);
                    stringBuilder2.append("<noscript><a href=\"").append((String)object).append("\" target=\"_blank\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\"><img src=\"").append((String)object).append("\" alt=\"\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\" border=\"0\" width=\"50%\" height=\"50%\" /></a></noscript>").append(LS);
                } else {
                    stringBuilder2.append("<a href=\"").append((String)object).append("\" target=\"_blank\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\"><img src=\"").append((String)object).append("\" alt=\"\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32)).append("\" border=\"0\" width=\"50%\" height=\"50%\" /></a>");
                }
                stringBuilder2.append("</div>");
            }
            stringBuilder2.append("</div>").append(LS);
        }
        if (!arrayList2.isEmpty()) {
            stringBuilder2.append("<div id=\"expose-estate-media\">");
            stringBuilder2.append("<h3>").append(this.resources.getProperty("label.media", "???")).append("</h3>");
            stringBuilder2.append("<ul>");
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                estateAttachmentImpl = (EstateAttachmentImpl)object2.next();
                String string13 = estateAttachmentImpl.getFileAsName();
                string32 = estateAttachmentImpl.getTitle(this.getLocale());
                if (string32 != null && string32.trim().length() > 0) {
                    string32 = string13;
                }
                stringBuilder2.append("<li><a href=\"").append(string13).append("\" target=\"_blank\" title=\"").append(StringEscapeUtils.escapeHtml((String)string32.trim())).append("\">").append(StringEscapeUtils.escapeHtml((String)string32.trim())).append("</a></li>");
            }
            stringBuilder2.append("</ul>");
            stringBuilder2.append("</div>").append(LS);
        }
        if ("google".equals(object2 = this.getExport().getMap()) || "osm".equals(object2)) {
            estateAttachmentImpl = agencyEstate.getAdress().getLatitude();
            Double d = agencyEstate.getAdress().getLongitude();
            if (estateAttachmentImpl != null && d != null) {
                string32 = null;
                object = null;
                if ("google".equals(object2)) {
                    object = "http://maps.google.com/?ie=UTF8&amp;t=m&amp;ll=" + estateAttachmentImpl + "," + d + "&amp;z=12";
                    string32 = "http://maps.google.com/?ie=UTF8&amp;t=m&amp;ll=" + estateAttachmentImpl + "," + d + "&amp;z=12&amp;output=embed";
                } else if ("osm".equals(object2)) {
                    object = "http://www.openstreetmap.org/?lat=" + estateAttachmentImpl + "&amp;lon=" + d + "&amp;zoom=12&amp;layers=M";
                    double d2 = 0.05;
                    double d3 = (double)Math.round(estateAttachmentImpl.doubleValue() * 100.0) / 100.0;
                    double d4 = (double)Math.round(d * 100.0) / 100.0;
                    String string14 = d4 - d2 + "," + (d3 - d2) + "," + (d4 + d2) + "," + (d3 + d2);
                    string32 = "http://www.openstreetmap.org/export/embed.html?bbox=" + string14 + "&amp;layer=mapnik";
                }
                stringBuilder2.append("<div id=\"expose-estate-map\">");
                stringBuilder2.append("<h3>").append(this.resources.getProperty("label.map", "???")).append("</h3>");
                if (string32 != null) {
                    stringBuilder2.append("<iframe src=\"").append(string32).append("\" width=\"640\" height=\"480\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>");
                    if (object != null) {
                        stringBuilder2.append("<br/>");
                    }
                }
                if (object != null) {
                    stringBuilder2.append("<small><a href=\"").append((String)object).append("\" target=\"_blank\">");
                    stringBuilder2.append(this.resources.getProperty("label.map.link", "???"));
                    stringBuilder2.append("</a></small>");
                }
                stringBuilder2.append("</div>").append(LS);
            }
        }
        estateAttachmentImpl = agencyAgent.getTerms(this.getLocale());
        if (this.getExport().isExposeTermsVisible() && estateAttachmentImpl != null && estateAttachmentImpl.trim().length() > 0) {
            String string15 = HtmlExposeBuilder.prepareString(estateAttachmentImpl).trim().replaceAll(Pattern.quote(LS), "<br/>");
            stringBuilder2.append("<div id=\"expose-estate-terms\">");
            stringBuilder2.append("<h3>").append(this.resources.getProperty("label.terms", "???")).append("</h3>");
            stringBuilder2.append("<p>").append(HtmlExposeBuilder.writeText(string15)).append("</p>");
            stringBuilder2.append("</div>").append(LS);
        }
        stringBuilder2.append("</div>").append(LS);
        if (this.getExport().isExposeAgentVisible() || this.getExport().isExposeContactVisible()) {
            stringBuilder2.append("<div id=\"expose-agent\" class=\"col_right\">").append(LS);
            if (this.getExport().isExposeContactVisible() && agencyContact != null) {
                String string16;
                String string17;
                String string18;
                stringBuilder2.append("<div id=\"expose-agent-contact\">");
                stringBuilder2.append("<h3>").append(this.resources.getProperty("label.contact", "???")).append("</h3><ul>");
                stringBuilder2.append("<li>").append(agencyContact.writePersonFullName()).append("<br/>").append(agencyContact.writeFullAdress("<br/>", this.getLocale())).append("</li>");
                String string19 = agencyContact.getPersonPhone();
                if (string19 != null && string19.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.contact.phone", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string19).trim()).append("</li>");
                }
                if ((string18 = agencyContact.getPersonMobilePhone()) != null && string18.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.contact.cellphone", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string18).trim()).append("</li>");
                }
                if ((string17 = agencyContact.getPersonFax()) != null && string17.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.contact.fax", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string17).trim()).append("</li>");
                }
                if ((string16 = agencyContact.getPersonMail()) != null && string16.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.contact.email", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string16).replace("@", " [a] ").replaceAll("\\.", " [.] ").trim()).append("</li>");
                }
                stringBuilder2.append("</ul></div>").append(LS);
            }
            if (this.getExport().isExposeAgentVisible()) {
                CompanyAdressImpl companyAdressImpl = agencyAgent.getCompany();
                stringBuilder2.append("<div id=\"expose-agent-company\">");
                stringBuilder2.append("<h3>").append(this.resources.getProperty("label.agent", "???")).append("</h3><ul>");
                stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.company", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(companyAdressImpl.getCompanyName()).trim()).append("</li>");
                stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.adress", "???")).append("</b><br/>").append(companyAdressImpl.writeFullAdress("<br/>", this.getLocale()).trim()).append("</li>");
                if (companyAdressImpl.getCompanyWebsite() != null && companyAdressImpl.getCompanyWebsite().getHost().trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.website", "???")).append("</b><br/><a href=\"").append(companyAdressImpl.getCompanyWebsite().toString()).append("\" target=\"_blank\">").append(companyAdressImpl.getCompanyWebsite().toString()).append("</a></li>");
                }
                if ((string32 = companyAdressImpl.getCompanyPhone()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.phone", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                if ((string32 = companyAdressImpl.getCompanyFax()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.fax", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                if ((string32 = companyAdressImpl.getCompanyMail()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.email", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).replace("@", " [a] ").replaceAll("\\.", " [.] ").trim()).append("</li>");
                }
                if ((string32 = agencyAgent.getAufsichtsBehoerde()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.aufsicht", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                if ((string32 = agencyAgent.getGewerbeErlaubnis()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.gewerbe", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).replaceAll(Pattern.quote(SystemUtils.LINE_SEPARATOR), "<br/>").trim()).append("</li>");
                }
                if ((string32 = agencyAgent.getHandelsRegister()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.handelsregister", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                if ((string32 = agencyAgent.getUstId()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.ustId", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                if ((string32 = agencyAgent.getVertretung()) != null && string32.trim().length() > 0) {
                    stringBuilder2.append("<li><b>").append(this.resources.getProperty("label.agent.vertretung", "???")).append("</b><br/>").append(HtmlExposeBuilder.prepareString(string32).trim()).append("</li>");
                }
                stringBuilder2.append("</ul></div>").append(LS);
            }
            stringBuilder2.append("</div>").append(LS);
        }
        stringBuilder2.append("<div class=\"clear\"></div>").append(LS);
        stringBuilder2.append(((StringBuilder)charSequence).toString()).append(LS);
        stringBuilder2.append("<div id=\"index-footer\">");
        stringBuilder2.append("<div style=\"float:right;\">").append(DateFormat.getDateTimeInstance(2, 3, this.getLocale()).format(this.now)).append("</div>").append(LS);
        stringBuilder2.append("<div style=\"float:left;\">powered by <a href=\"").append("http://openestate.org/").append("\" target=\"_blank\" title=\"powered by OpenEstate.org\">OpenEstate</a></div>").append(LS);
        stringBuilder2.append("<div class=\"clear\"></div>").append(LS);
        stringBuilder2.append("</div>").append(LS);
        stringBuilder2.append("</div>").append("</body>").append(LS);
        stringBuilder2.append("</html>");
        return stringBuilder2.toString();
    }

    private void loadResources() {
        this.resources = new Properties();
        try {
            String string = ImmoToolUtils.getResourcePath(HtmlExposeBuilder.class, (Locale)this.getLocale());
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                this.resources.load(uRL.openStream());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read ressources!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.loadResources();
    }

    public void storeWebsite(AgencyEstate agencyEstate, AgencyAgent agencyAgent, AgencyContact agencyContact, File file) throws IOException, OpenEstateException {
        this.storeWebsite(agencyEstate, agencyAgent, agencyContact, file, "website.css");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWebsite(AgencyEstate agencyEstate, AgencyAgent agencyAgent, AgencyContact agencyContact, File file, String string) throws IOException, OpenEstateException {
        Object object;
        Object object2;
        Object object3;
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("could not create expose-directory!");
        }
        String string2 = this.getExport().getStylesheetUrl();
        String string3 = string2 == null || string2.trim().length() == 0 ? null : string2;
        File file2 = new File(file.getAbsolutePath() + File.separator + "index.html");
        String string4 = this.buildWebsite(agencyEstate, agencyAgent, agencyContact, string, string3);
        this.saveHtml(string4, file2);
        int n = 0;
        for (Object object4 : agencyEstate.getAttachments()) {
            block37: {
                Object object5;
                block38: {
                    block39: {
                        block35: {
                            block36: {
                                object3 = null;
                                object2 = null;
                                object = null;
                                object3 = AgencyEstate.loadAttachmentAsTempFile(agencyEstate.getIdNr(), object4.getFileAsName());
                                if (object3 != null) break block35;
                                if (object3 == null) break block36;
                                FileUtils.deleteQuietly((File)object3);
                            }
                            if (object2 != null) {
                                IOUtils.closeQuietly(object2);
                            }
                            if (object == null) continue;
                            IOUtils.closeQuietly(object);
                            continue;
                        }
                        if (!object4.getMimeType().startsWith("image/")) {
                            object5 = new File(file.getAbsolutePath() + File.separator + object4.getFileAsName());
                            FileUtils.copyFile((File)object3, (File)object5);
                            break block37;
                        }
                        object2 = new FileInputStream((File)object3);
                        object5 = this.getExport().convertImage((InputStream)object2);
                        if (object5 != null) break block38;
                        LOGGER.warn((Object)"could not convert image properly!");
                        LOGGER.warn((Object)("> estate #" + agencyEstate.getIdNr()));
                        LOGGER.warn((Object)("> " + object4.getFileAsName()));
                        if (object3 == null) break block39;
                        FileUtils.deleteQuietly((File)object3);
                    }
                    if (object2 != null) {
                        IOUtils.closeQuietly((InputStream)object2);
                    }
                    if (object == null) continue;
                    IOUtils.closeQuietly((OutputStream)object);
                    continue;
                }
                try {
                    ((FileInputStream)object2).close();
                    File file3 = new File(file.getAbsolutePath() + File.separator + "img_" + (n + 1) + ".jpg");
                    object = new FileOutputStream(file3);
                    ImageIO.write((RenderedImage)object5, "jpg", (OutputStream)object);
                    ((FileOutputStream)object).close();
                    if (n == 0) {
                        BufferedImage bufferedImage = ImmoToolUtils.cropImageToRatio((BufferedImage)object5, (int)100, (int)75);
                        BufferedImage bufferedImage2 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage, (int)100, (int)75, (int)1);
                        file3 = new File(file.getAbsolutePath() + File.separator + "preview.jpg");
                        object = new FileOutputStream(file3);
                        ImageIO.write((RenderedImage)bufferedImage2, "jpg", (OutputStream)object);
                        ((FileOutputStream)object).close();
                        bufferedImage.flush();
                        bufferedImage2.flush();
                    }
                    ((Image)object5).flush();
                    ++n;
                }
                catch (Exception exception) {
                    block40: {
                        try {
                            LOGGER.warn((Object)"could not store attachment!");
                            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            if (object3 == null) break block40;
                        }
                        catch (Throwable throwable) {
                            if (object3 != null) {
                                FileUtils.deleteQuietly((File)object3);
                            }
                            if (object2 != null) {
                                IOUtils.closeQuietly(object2);
                            }
                            if (object != null) {
                                IOUtils.closeQuietly(object);
                            }
                            throw throwable;
                        }
                        FileUtils.deleteQuietly((File)object3);
                    }
                    if (object2 != null) {
                        IOUtils.closeQuietly((InputStream)object2);
                    }
                    if (object == null) continue;
                    IOUtils.closeQuietly(object);
                    continue;
                }
            }
            if (object3 != null) {
                FileUtils.deleteQuietly((File)object3);
            }
            if (object2 != null) {
                IOUtils.closeQuietly((InputStream)object2);
            }
            if (object == null) continue;
            IOUtils.closeQuietly((OutputStream)object);
        }
        if (this.getExport().getPdfSetupId() != null && this.getExport().getPdfSetupId() > 0L) {
            Object object6 = null;
            try {
                Object object4;
                object4 = PdfSetup.loadSetup(this.getExport().getPdfSetupId());
                object3 = this.getExport().getAddressPublishing();
                if ("always".equals(object3)) {
                    ((PdfSetup)object4).setAddressPublishing(2);
                } else if ("never".equals(object3)) {
                    ((PdfSetup)object4).setAddressPublishing(1);
                } else {
                    ((PdfSetup)object4).setAddressPublishing(0);
                }
                object2 = ((PdfSetup)object4).createBuilder();
                object = new File(file.getAbsolutePath() + File.separator + "index.pdf");
                object6 = new FileOutputStream((File)object);
                ((PdfBuilder)object2).generatePdf(agencyEstate, (OutputStream)object6);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"could not store pdf!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                try {
                    if (object6 != null) {
                        ((FileOutputStream)object6).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

