/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.export.WebsiteHtmlExport;
import com.openindex.openestate.tool.agency.utils.HtmlBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class HtmlIndexBuilder
extends HtmlBuilder {
    private static final Logger LOGGER = Logger.getLogger(HtmlIndexBuilder.class);
    private static final String LS = SystemUtils.LINE_SEPARATOR;
    private Map<Long, String> items = new TreeMap<Long, String>();
    private Properties resources;
    private Date now;

    public HtmlIndexBuilder(WebsiteHtmlExport websiteHtmlExport) {
        super(websiteHtmlExport);
        this.loadResources();
        this.now = new Date();
    }

    public void addItem(AgencyEstate agencyEstate, String string, boolean bl, boolean bl2) {
        this.items.put(agencyEstate.getIdNr(), this.buildWebsiteItem(agencyEstate, string, bl, bl2));
    }

    protected String buildWebsite(AgencyAgent agencyAgent, int n, int n2, int n3, String string, String string2) {
        CharSequence charSequence;
        if (n < 0) {
            throw new IllegalArgumentException("invalid page #" + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid page-count!");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("invalid element-count!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0 && n > 0) {
            stringBuilder.append("<div class=\"index-nav\">");
            if (n > 1) {
                charSequence = n > 2 ? "index_" + (n - 1) + ".html" : "index.html";
                stringBuilder.append("[ <a href=\"").append((String)charSequence).append("\" title=\"").append(this.resources.getProperty("label.prevPage", "???")).append("\">").append(this.resources.getProperty("label.prevPage", "???")).append("</a> ]");
            }
            if (n < n2) {
                charSequence = "index_" + (n + 1) + ".html";
                stringBuilder.append("[ <a href=\"").append((String)charSequence).append("\" title=\"").append(this.resources.getProperty("label.nextPage", "???")).append("\">").append(this.resources.getProperty("label.nextPage", "???")).append("</a> ]");
            }
            stringBuilder.append("</div>");
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">").append(LS);
        ((StringBuilder)charSequence).append("<html xmlns=\"http://www.w3.org/1999/xhtml\">").append(LS);
        ((StringBuilder)charSequence).append("<head>").append(LS);
        ((StringBuilder)charSequence).append("<title>").append(this.resources.getProperty("label.title", "???")).append(" | ").append(HtmlIndexBuilder.prepareString(this.getExport().getCompany())).append("</title>").append(LS);
        ((StringBuilder)charSequence).append("<meta http-equiv=\"content-type\" content=\"text/html; charset=").append(this.getEncoding()).append("\"/>").append(LS);
        ((StringBuilder)charSequence).append("<meta name=\"author\" content=\"").append(HtmlIndexBuilder.prepareString(this.getExport().getCompany())).append("\"/>").append(LS);
        ((StringBuilder)charSequence).append("<meta name=\"description\" content=\"\"/>").append(LS);
        ((StringBuilder)charSequence).append("<meta name=\"generator\" content=\"").append(HtmlIndexBuilder.prepareString(ImmoToolApp.getApplicationTitle() + " " + ImmoToolApp.getApplicationVersion())).append("\"/>").append(LS);
        ((StringBuilder)charSequence).append("<meta name=\"keywords\" content=\"\"/>").append(LS);
        ((StringBuilder)charSequence).append("<meta name=\"robots\" content=\"noindex,follow\"/>").append(LS);
        if (string != null) {
            ((StringBuilder)charSequence).append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(string).append("\"/>").append(LS);
        }
        if (string2 != null) {
            ((StringBuilder)charSequence).append("<link rel=\"stylesheet\" type=\"text/css\" href=\"").append(string2).append("\"/>").append(LS);
        }
        if (this.getExport().isRssFeedExport()) {
            ((StringBuilder)charSequence).append("<link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS-Feed\" href=\"rss.xml\" />").append(LS);
        }
        if (this.getExport().isAtomFeedExport()) {
            ((StringBuilder)charSequence).append("<link rel=\"alternate\" type=\"application/atom+xml\" title=\"Atom-Feed\" href=\"atom.xml\" />").append(LS);
        }
        ((StringBuilder)charSequence).append("</head>").append(LS);
        ((StringBuilder)charSequence).append("<body>").append("<div id=\"page\" class=\"index\">").append(LS);
        if (n2 > 0 && n > 0) {
            ((StringBuilder)charSequence).append(stringBuilder.toString()).append(LS);
        }
        ((StringBuilder)charSequence).append("<div id=\"index-header\">");
        ((StringBuilder)charSequence).append("<h1>").append(this.resources.getProperty("label.title", "???")).append("</h1>");
        ((StringBuilder)charSequence).append("<h2>").append(HtmlIndexBuilder.prepareString(this.getExport().getCompany())).append("</h2>");
        if (n2 > 0 && n > 0) {
            ((StringBuilder)charSequence).append(new Formatter().format(this.resources.getProperty("label.pageCount", "???"), n, n2).toString());
        } else {
            ((StringBuilder)charSequence).append("<i>").append(this.resources.getProperty("label.empty", "???")).append("</i>");
        }
        ((StringBuilder)charSequence).append("</div>").append(LS);
        if (n2 > 0 && n > 0) {
            ((StringBuilder)charSequence).append("<div id=\"index-result\">").append(LS);
            int n4 = (n - 1) * n3;
            int n5 = n4 + n3;
            Long[] longArray = this.items.keySet().toArray(new Long[this.items.size()]);
            for (int i = n4; i < n5 && longArray.length > i; ++i) {
                Long l = longArray[i];
                ((StringBuilder)charSequence).append(this.items.get(l)).append(LS);
            }
            ((StringBuilder)charSequence).append("</div>").append(LS);
            ((StringBuilder)charSequence).append("<div class=\"clear\"></div>").append(LS);
            ((StringBuilder)charSequence).append(stringBuilder.toString()).append(LS);
        }
        ((StringBuilder)charSequence).append("<div id=\"index-footer\">");
        ((StringBuilder)charSequence).append("<div style=\"float:right;\">").append(DateFormat.getDateTimeInstance(2, 3, this.getLocale()).format(this.now)).append("</div>").append(LS);
        ((StringBuilder)charSequence).append("<div style=\"float:left;\">powered by <a href=\"").append("http://openestate.org/").append("\" target=\"_blank\" title=\"powered by OpenEstate.org\">OpenEstate</a></div>").append(LS);
        ((StringBuilder)charSequence).append("<div class=\"clear\"></div>").append(LS);
        ((StringBuilder)charSequence).append("</div>").append(LS);
        ((StringBuilder)charSequence).append("</div>").append("</body>").append(LS);
        ((StringBuilder)charSequence).append("</html>");
        return ((StringBuilder)charSequence).toString();
    }

    protected String buildWebsiteItem(AgencyEstate agencyEstate, String string, boolean bl, boolean bl2) {
        String string2;
        if (agencyEstate == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string.trim();
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        string3 = string3 + agencyEstate.getIdNr();
        OpenEstateType openEstateType = agencyEstate.getType();
        if (openEstateType == null) {
            return "";
        }
        String string4 = OpenEstateUtils.translateEstate((String)openEstateType.getName(), (Locale)this.getLocale());
        String string5 = !StringUtils.isEmpty((String)agencyEstate.getAction()) ? OpenEstateUtils.translateAction((String)agencyEstate.getAction(), (Locale)this.getLocale()) : "";
        String string6 = agencyEstate.getPublicId();
        if (string6 == null || string6.trim().length() == 0) {
            string6 = "#" + agencyEstate.getIdNr();
        }
        if ((string2 = agencyEstate.getTitle(this.getLocale())) == null || string2.trim().length() == 0) {
            string2 = agencyEstate.getFallbackTitle(this.getLocale());
        }
        stringBuilder.append("<div class=\"item\">").append(LS);
        stringBuilder.append("<h3><a href=\"").append(string3).append("/index.html\" title=\"").append(this.resources.getProperty("label.details", "???")).append("\">").append(string6).append(" | ").append(HtmlIndexBuilder.prepareString(string2)).append("</a></h3>").append(LS);
        if (bl) {
            for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
                if (estateAttachmentImpl == null || !estateAttachmentImpl.isName() || !this.getExport().isAllImagesExported() && !estateAttachmentImpl.isPublished() || !estateAttachmentImpl.getMimeType().startsWith("image/") || !this.getExport().getMimeTypes().contains(estateAttachmentImpl.getMimeType())) continue;
                stringBuilder.append("<div class=\"img\">");
                stringBuilder.append("<a href=\"").append(string3).append("/index.html\" title=\"").append(this.resources.getProperty("label.details", "???")).append("\">").append("<img src=\"").append(string3).append("/preview.jpg\" alt=\"0\" border=\"0\"/></a>");
                stringBuilder.append("</div>").append(LS);
                break;
            }
        }
        stringBuilder.append("<div class=\"block\"><ul>");
        stringBuilder.append("<li>").append(HtmlIndexBuilder.prepareString(string4)).append("</li>");
        stringBuilder.append("<li>").append(HtmlIndexBuilder.prepareString(string5)).append("</li>");
        stringBuilder.append("<li>").append(HtmlIndexBuilder.prepareString(agencyEstate.getAdress().writePostal())).append("</li>");
        stringBuilder.append("<li>").append(HtmlIndexBuilder.prepareString(agencyEstate.getAdress().writeCountry(this.getLocale()))).append("</li>");
        stringBuilder.append("</ul></div>").append(LS);
        stringBuilder.append("<div class=\"block\"><ul>");
        for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(agencyEstate.getAction())) {
            Object object;
            if (!agencyEstate.getType().isAttribRequired(openEstateAttrib, agencyEstate.getAction())) continue;
            String string7 = openEstateAttrib.getKey();
            if ("it".equalsIgnoreCase(agencyEstate.getAdress().getCountry()) && "FLAECHEN".equals(openEstateAttrib.getGroup()) && "WOHNFLAECHE".equals(openEstateAttrib.getName()) && agencyEstate.hasAttribute((String)(object = "FLAECHEN.BRUTTOFLAECHE"))) {
                string7 = object;
            }
            ValueImpl valueImpl = object = agencyEstate.hasAttribute(string7) ? agencyEstate.getAttribute(string7) : null;
            if (object == null) continue;
            String string8 = OpenEstateUtils.translateAttributeByCountry((String)object.getGroupName(), (String)object.getAttribName(), (Locale)this.getLocale(), (String)agencyEstate.getAdress().getCountry());
            String string9 = agencyEstate.writeValue((ValueImpl)object, this.getLocale());
            if (string9 == null || string9.trim().length() == 0) continue;
            stringBuilder.append("<li>").append(HtmlIndexBuilder.prepareString(string8 != null ? string8 : object.getAttribName())).append(": <b>").append(HtmlIndexBuilder.prepareString(string9)).append("</b></li>");
        }
        stringBuilder.append("</ul></div>").append(LS);
        stringBuilder.append("<div class=\"nav\">");
        stringBuilder.append("&raquo; <a href=\"").append(string3).append("/index.html\" title=\"").append(this.resources.getProperty("label.details", "???")).append("\">").append(this.resources.getProperty("label.detailsLink", "???")).append("</a>");
        if (bl2) {
            stringBuilder.append("<br/>&raquo; <a href=\"").append(string3).append("/index.pdf\" target=\"_blank\" title=\"").append(this.resources.getProperty("label.pdf", "???")).append("\">").append(this.resources.getProperty("label.pdfLink", "???")).append("</a>");
        }
        stringBuilder.append("</div>").append(LS);
        stringBuilder.append("<div class=\"clear\"></div>").append(LS);
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private void loadResources() {
        this.resources = new Properties();
        try {
            String string = ImmoToolUtils.getResourcePath(HtmlIndexBuilder.class, (Locale)this.getLocale());
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                this.resources.load(uRL.openStream());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read ressources!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.loadResources();
    }

    public void storeWebsites(AgencyAgent agencyAgent, int n, File file) throws IOException {
        this.storeWebsites(agencyAgent, n, file, "website.css");
    }

    public void storeWebsites(AgencyAgent agencyAgent, int n, File file, String string) throws IOException {
        String string2;
        int n2 = this.items.size();
        String string3 = this.getExport().getStylesheetUrl();
        String string4 = string2 = string3 == null || string3.trim().length() == 0 ? null : string3;
        if (n2 <= 0) {
            String string5 = this.buildWebsite(agencyAgent, 0, 0, n, string, string2);
            this.saveHtml(string5, new File(file.getAbsolutePath() + File.separator + "index.html"));
        } else {
            int n3 = (int)Math.ceil((double)n2 / (double)n);
            for (int i = 0; i < n3; ++i) {
                String string6 = this.buildWebsite(agencyAgent, i + 1, n3, n, string, string2);
                String string7 = i == 0 ? "index.html" : "index_" + (i + 1) + ".html";
                this.saveHtml(string6, new File(file.getAbsolutePath() + File.separator + string7));
            }
        }
    }
}

