/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.idx.IDXCSVReader;
import com.openindex.openestate.impl.csv.idx.IDXCSVSchema;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.utils.HashGenerator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IDXCsvReader
extends IDXCSVReader {
    private static final Logger LOGGER = Logger.getLogger(IDXCsvReader.class);
    private boolean hashComparisonEnabled = false;

    public IDXCsvReader() {
    }

    public IDXCsvReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
        this.hashComparisonEnabled = false;
    }

    public IDXCsvReader(AgencyImportDialog agencyImportDialog) {
        this();
        this.setOpenEstateLanguage(agencyImportDialog.getSelectedLocale());
        this.hashComparisonEnabled = agencyImportDialog.isCsvHashingSelected();
    }

    public static String calculateHash(String[] stringArray) throws NoSuchAlgorithmException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("#");
            }
            stringBuilder.append(string);
        }
        return HashGenerator.messageDigestAsString((String)stringBuilder.toString(), (String)"SHA");
    }

    public EstateImpl createEmptyEstate() {
        return new AgencyEstate();
    }

    public boolean isHashComparisonEnabled() {
        return this.hashComparisonEnabled;
    }

    protected boolean readEstate(IDXCSVSchema iDXCSVSchema, String[] stringArray, EstateImpl estateImpl) {
        if (!super.readEstate(iDXCSVSchema, stringArray, estateImpl)) {
            return false;
        }
        if (this.isHashComparisonEnabled()) {
            try {
                String string = IDXCsvReader.calculateHash(stringArray);
                estateImpl.getCustomValues().putCustomValue("import.hash", (Object)string, 5);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Hash generation failed!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return true;
    }

    public void setHashComparisonEnabled(boolean bl) {
        this.hashComparisonEnabled = bl;
    }
}

