/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVReader;
import com.openindex.openestate.impl.csv.is24.IS24CSVSchema;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyImportDialog;
import com.openindex.openestate.tool.utils.HashGenerator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IS24CsvReader
extends IS24CSVReader {
    private static final Logger LOGGER = Logger.getLogger(IS24CsvReader.class);
    private boolean hashComparisonEnabled = false;

    public IS24CsvReader() {
    }

    public IS24CsvReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
        this.hashComparisonEnabled = false;
    }

    public IS24CsvReader(AgencyImportDialog agencyImportDialog) {
        this();
        this.setOpenEstateLanguage(agencyImportDialog.getSelectedLocale());
        this.hashComparisonEnabled = agencyImportDialog.isCsvHashingSelected();
    }

    public static String calculateHash(String[] stringArray) throws NoSuchAlgorithmException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string);
        }
        return HashGenerator.messageDigestAsString((String)stringBuilder.toString(), (String)"SHA");
    }

    public EstateImpl createEmptyEstate() {
        return new AgencyEstate();
    }

    public boolean isHashComparisonEnabled() {
        return this.hashComparisonEnabled;
    }

    protected boolean readEstate(IS24CSVSchema iS24CSVSchema, String[] stringArray, EstateImpl estateImpl) {
        if (!super.readEstate(iS24CSVSchema, stringArray, estateImpl)) {
            return false;
        }
        if (this.isHashComparisonEnabled()) {
            try {
                String string = IS24CsvReader.calculateHash(stringArray);
                estateImpl.getCustomValues().putCustomValue("import.hash", (Object)string, 5);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Hash generation failed!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return true;
    }

    public void setHashComparisonEnabled(boolean bl) {
        this.hashComparisonEnabled = bl;
    }
}

