/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.csv.is24.IS24CSVWriter;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.util.Locale;
import org.apache.log4j.Logger;

public class IS24CsvWriter
extends IS24CSVWriter {
    private static final Logger LOGGER = Logger.getLogger(IS24CsvWriter.class);
    public static final String GEODB = "is24";
    private GeoDb geoDb;

    public IS24CsvWriter() {
        this.init();
    }

    public IS24CsvWriter(Locale locale) {
        super(locale);
        this.init();
    }

    protected void handleValues(String[] stringArray, EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl) {
        if (estateImpl instanceof AgencyEstate) {
            String[] stringArray2;
            AgencyEstate agencyEstate = (AgencyEstate)estateImpl;
            Long l = agencyEstate.getGroupNr();
            if (l != null && l > 0L) {
                stringArray[8] = l.toString();
            }
            if (this.geoDb != null && !Locale.GERMANY.getCountry().equalsIgnoreCase(estateImpl.getAdress().getCountry()) && (stringArray2 = agencyEstate.getGeoDbIds(GEODB)).length >= 2) {
                try {
                    GeoAreaImpl geoAreaImpl = this.geoDb.loadArea(stringArray2[1]);
                    stringArray[55] = geoAreaImpl.getName().trim();
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't load international area from geo-db (is24)!");
                    LOGGER.error((Object)("> " + stringArray2[1]));
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
    }

    private void init() {
        this.geoDb = null;
        try {
            this.geoDb = GeoDb.loadGeoDb(GEODB);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load GeoDb!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }
}

