/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.xml.IS24XmlUtils;
import com.openindex.openestate.impl.xml.is24.ISOLaenderCodeTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilieBaseTyp;
import com.openindex.openestate.impl.xml.is24.ImmobilienTransferTyp;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;

public class IS24XmlWriter
extends com.openindex.openestate.impl.xml.IS24XmlWriter {
    private static final Logger LOGGER = Logger.getLogger(IS24XmlWriter.class);
    public static final String GEODB = "is24";
    private GeoDb geoDb;

    public IS24XmlWriter() {
        this.init();
    }

    public IS24XmlWriter(Locale locale) {
        super(locale);
        this.init();
    }

    protected ImmobilienTransferTyp.Anbieter convertAgent(AgentImpl agentImpl) {
        return super.convertAgent(agentImpl);
    }

    protected JAXBElement convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws OpenEstateException {
        JAXBElement jAXBElement = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
        if (jAXBElement == null || !list.isEmpty()) {
            return null;
        }
        Object object = jAXBElement.getValue();
        if (object instanceof ImmobilieBaseTyp) {
            ImmobilieBaseTyp immobilieBaseTyp = (ImmobilieBaseTyp)object;
            if (estateImpl instanceof AgencyEstate) {
                String[] stringArray;
                AgencyEstate agencyEstate = (AgencyEstate)estateImpl;
                if (agencyEstate.getGroupNr() != null && agencyEstate.getGroupNr() > 0L) {
                    immobilieBaseTyp.setGruppierungsID(agencyEstate.getGroupNr());
                }
                if (immobilieBaseTyp.getAdresse() == null) {
                    immobilieBaseTyp.setAdresse(IS24XmlUtils.getFactory().createImmobilienAdresseTyp());
                }
                if (this.geoDb != null && !ISOLaenderCodeTyp.DEU.equals((Object)immobilieBaseTyp.getAdresse().getLaenderkennzeichen()) && (stringArray = agencyEstate.getGeoDbIds(GEODB)).length >= 2) {
                    try {
                        GeoAreaImpl geoAreaImpl = this.geoDb.loadArea(stringArray[1]);
                        immobilieBaseTyp.getAdresse().setInternationaleRegion(geoAreaImpl.getName());
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)"Can't load international area from geo-db (is24)!");
                        LOGGER.error((Object)("> " + stringArray[1]));
                        LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
        }
        return jAXBElement;
    }

    protected ImmobilienTransferTyp createRoot() {
        ImmobilienTransferTyp immobilienTransferTyp = super.createRoot();
        immobilienTransferTyp.setErstellerSoftware(ImmoToolApp.getApplicationTitle());
        immobilienTransferTyp.setErstellerSoftwareVersion(ImmoToolApp.getApplicationVersion());
        return immobilienTransferTyp;
    }

    private void init() {
        this.geoDb = null;
        try {
            this.geoDb = GeoDb.loadGeoDb(GEODB);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load GeoDb!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }
}

