/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.impl.xml.immobiliare.LocationStructure;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImmobiliareWriter
extends com.openindex.openestate.impl.xml.ImmobiliareWriter {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareWriter.class);
    public static final String GEODB = "immobiliare";
    private GeoDb geoDb;

    public ImmobiliareWriter() {
        this.init();
    }

    public ImmobiliareWriter(Locale locale) {
        super(locale);
        this.init();
    }

    public Feed.Properties.Property convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        String[] stringArray;
        Feed.Properties.Property property = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
        if (!list.isEmpty()) {
            return property;
        }
        if (this.geoDb == null) {
            return property;
        }
        String[] stringArray2 = stringArray = estateImpl instanceof AgencyEstate ? ((AgencyEstate)estateImpl).getGeoDbIds(GEODB) : new String[]{};
        if (stringArray.length < 4) {
            list.add("No city was provided for immobiliare!");
            return property;
        }
        if (property.getLocation() == null) {
            property.setLocation(ImmobiliareUtils.getFactory().createLocationStructure());
        }
        if (property.getLocation().getCity() == null) {
            property.getLocation().setCity(ImmobiliareUtils.getFactory().createLocationStructureCity());
        }
        try {
            GeoAreaImpl geoAreaImpl;
            if (stringArray.length > 1 && (geoAreaImpl = this.geoDb.loadArea(stringArray[1])) != null) {
                property.getLocation().setAdministrativeArea(StringUtils.trimToEmpty((String)geoAreaImpl.getName()));
            }
            if (stringArray.length > 2 && (geoAreaImpl = this.geoDb.loadArea(stringArray[2])) != null) {
                property.getLocation().setSubAdministrativeArea(ImmobiliareUtils.getFactory().createLocationStructureSubAdministrativeArea());
                property.getLocation().getSubAdministrativeArea().setValue(StringUtils.trimToEmpty((String)geoAreaImpl.getName()));
                property.getLocation().getSubAdministrativeArea().setCode(StringUtils.trimToNull((String)geoAreaImpl.getProviderId()));
            }
            if (stringArray.length > 3 && (geoAreaImpl = this.geoDb.loadArea(stringArray[3])) != null) {
                property.getLocation().setCity(ImmobiliareUtils.getFactory().createLocationStructureCity());
                property.getLocation().getCity().setValue(StringUtils.trimToEmpty((String)geoAreaImpl.getName()));
                try {
                    property.getLocation().getCity().setCode(BigInteger.valueOf(Long.valueOf(geoAreaImpl.getProviderId())));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't write geo-code for city!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    property.getLocation().getCity().setCode(null);
                }
            }
            if (stringArray.length > 4 && (geoAreaImpl = this.geoDb.loadArea(stringArray[4])) != null) {
                if (property.getLocation().getLocality() == null) {
                    property.getLocation().setLocality(ImmobiliareUtils.getFactory().createLocationStructureLocality());
                }
                property.getLocation().getLocality().setNeighbourhood(ImmobiliareUtils.getFactory().createLocationStructureLocalityNeighbourhood());
                property.getLocation().getLocality().getNeighbourhood().setType(LocationStructure.Locality.Neighbourhood.LocationNeighbourhoodType.AREA);
                property.getLocation().getLocality().getNeighbourhood().setValue(StringUtils.trimToEmpty((String)geoAreaImpl.getName()));
                try {
                    property.getLocation().getLocality().getNeighbourhood().setId(BigInteger.valueOf(Long.valueOf(geoAreaImpl.getProviderId())));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't write geo-code for locality!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    property.getLocation().getLocality().getNeighbourhood().setValue(null);
                }
            }
        }
        catch (Exception exception) {
            list.add("GeoDb-Error: " + exception.getLocalizedMessage());
            LOGGER.error((Object)"Can't load international area from geo-db (immobiliare)!");
            for (int i = 0; i < stringArray.length; ++i) {
                LOGGER.error((Object)("> " + stringArray[i]));
            }
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        return property;
    }

    private void init() {
        this.geoDb = null;
        try {
            this.geoDb = GeoDb.loadGeoDb(GEODB);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load GeoDb!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }
}

