/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.utils.Service;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class PdfBuilder {
    private static final Logger LOGGER = Logger.getLogger(PdfBuilder.class);
    protected static final float MARGIN_TOP = 110.0f;
    protected static final float MARGIN_BOTTOM = 90.0f;
    protected static final float MARGIN_LEFT = 60.0f;
    protected static final float MARGIN_RIGHT = 60.0f;
    private static File pdfFontFile = null;
    protected AgencyAgent agent = null;
    protected Date now = null;
    protected PdfSetup pdfSetup;
    protected Font bodyFontH1;
    protected Font bodyFontH2;
    protected Font bodyFontH3;
    protected Font bodyFontBold;
    protected Font bodyFontNormal;
    protected Font bodyFontSmall;
    protected List<Integer> pageBreakBeforeRow;
    protected List<Integer> pageBreakIfNextRowNotFits;
    protected Color borderColor;
    protected Color bodyHeadBgColor;
    protected Color bodyHeadFgColor;
    protected Color bodyTextBgColor;
    protected Color bodyTextFgColor;
    protected Color headerTextFgColor;
    protected Color footerTextFgColor;
    protected boolean encryptionEnabled = false;
    protected String encryptionPassword = null;
    protected boolean encryptionAccessibilityAllowed = false;
    protected boolean encryptionCopyingAllowed = false;
    protected boolean encryptionPrintingAllowed = false;
    private ResourceBundle resourceBundle;
    private Locale openestateLocale;

    protected PdfBuilder() {
    }

    protected void buildTemplate(PdfTemplate pdfTemplate, float f, float f2, int n) throws ImmoToolDbException, IOException, DocumentException {
        float f3;
        float f4;
        BaseFont baseFont = this.registeredFont().getBaseFont();
        pdfTemplate.setBoundingBox(new Rectangle(60.0f, f2 - 25.0f, f - 60.0f, 0.0f));
        if (this.pdfSetup.isHeaderVisible()) {
            Object object;
            f4 = f2 - 110.0f + 10.0f;
            pdfTemplate.setColorStroke(this.borderColor);
            pdfTemplate.setColorFill(this.borderColor);
            pdfTemplate.moveTo(60.0f, f4);
            pdfTemplate.lineTo(f - 60.0f, f4);
            pdfTemplate.stroke();
            float f5 = 60.0f;
            float f6 = f2 - 36.666668f;
            if (this.pdfSetup.isHeaderLogoVisible() && (object = AgencyAgent.loadLogo()) != null) {
                f3 = f - 60.0f - 60.0f;
                float f7 = 70.0f;
                float f8 = 60.0f;
                float f9 = f2 - 110.0f + 15.0f;
                Image image = Image.getInstance((java.awt.Image)object, null);
                image.scaleToFit(f3, f7);
                image.setAbsolutePosition(f8, f9);
                pdfTemplate.addImage(image);
                f5 = f8 + image.getScaledWidth() + 10.0f;
            }
            pdfTemplate.beginText();
            pdfTemplate.setColorStroke(this.headerTextFgColor);
            pdfTemplate.setColorFill(this.headerTextFgColor);
            pdfTemplate.setFontAndSize(baseFont, 12.0f);
            object = this.pdfSetup.isHeaderTextCustom() && this.pdfSetup.getHeaderTextCustomLine1() != null ? this.pdfSetup.getHeaderTextCustomLine1() : (this.agent != null ? this.agent.getCompany().getCompanyName() : "");
            pdfTemplate.showTextAligned(0, object != null ? ((String)object).trim() : "", f5, f6, 0.0f);
            pdfTemplate.setFontAndSize(baseFont, 10.0f);
            object = this.pdfSetup.isHeaderTextCustom() && this.pdfSetup.getHeaderTextCustomLine2() != null ? this.pdfSetup.getHeaderTextCustomLine2() : (this.agent != null ? this.agent.getCompany().writePersonFullName() : "");
            pdfTemplate.showTextAligned(0, (String)(object != null ? object : ""), f5, f6 - 12.0f, 0.0f);
            pdfTemplate.setFontAndSize(baseFont, 10.0f);
            object = this.pdfSetup.isHeaderTextCustom() && this.pdfSetup.getHeaderTextCustomLine3() != null ? this.pdfSetup.getHeaderTextCustomLine3() : (this.agent != null ? this.agent.getCompany().writeFullAdress(", ", this.getOpenEstateLocale()) : "");
            pdfTemplate.showTextAligned(0, (String)(object != null ? object : ""), f5, f6 - 24.0f, 0.0f);
            pdfTemplate.endText();
        }
        if (this.pdfSetup.isFooterVisible()) {
            String string;
            f4 = 80.0f;
            pdfTemplate.setColorStroke(this.borderColor);
            pdfTemplate.setColorFill(this.borderColor);
            pdfTemplate.moveTo(60.0f, f4);
            pdfTemplate.lineTo(f - 60.0f, f4);
            pdfTemplate.stroke();
            pdfTemplate.beginText();
            pdfTemplate.setColorStroke(this.footerTextFgColor);
            pdfTemplate.setColorFill(this.footerTextFgColor);
            pdfTemplate.setFontAndSize(baseFont, 10.0f);
            Integer n2 = this.pdfSetup.getFooterAlignment();
            int n3 = n2 == null ? 0 : (0 == n2 ? 0 : (1 == n2 ? 1 : (2 == n2 ? 2 : 0)));
            float f10 = 60.0f;
            f3 = 60.0f;
            if (n3 == 2) {
                f3 = f - 60.0f;
            } else if (n3 == 1) {
                f3 = f / 2.0f;
            }
            if (this.isFooterTimestampPrinted()) {
                pdfTemplate.showTextAligned(n3, new Formatter().format(this.resourceBundle.getString("label.stamp"), PdfBuilder.getDateFormat().format(this.now)).toString(), f3, f10, 0.0f);
                f10 -= 12.0f;
            }
            if (this.isFooterWebsitePrinted() && this.agent != null && this.agent.getCompany().getCompanyWebsite() != null && (string = this.agent.getCompany().getCompanyWebsite().getHost()) != null && string.trim().length() > 0) {
                pdfTemplate.showTextAligned(n3, this.agent.getCompany().getCompanyWebsite().toString(), f3, f10, 0.0f);
                f10 -= 12.0f;
            }
            if (this.isFooterPageNumberPrinted()) {
                pdfTemplate.showTextAligned(n3, new Formatter().format(this.resourceBundle.getString("label.page"), n).toString(), f3, f10, 0.0f);
                f10 -= 12.0f;
            }
            pdfTemplate.endText();
        }
    }

    protected void buildTableHead(PdfPTable pdfPTable, int n, String string) {
        PdfPCell pdfPCell = null;
        PdfPTable pdfPTable2 = new PdfPTable(1);
        pdfPTable2.setWidthPercentage(100.0f);
        pdfPCell = new PdfPCell();
        pdfPCell.setPaddingTop(10.0f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell();
        pdfPCell.setPaddingBottom(5.0f);
        pdfPCell.setPaddingLeft(5.0f);
        pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setBorderWidthBottom(1.0f);
        pdfPCell.setBorderColorBottom(this.borderColor);
        if (this.pdfSetup.isNumberedHeadlines()) {
            pdfPCell.addElement((Element)new Paragraph(String.valueOf(n) + ". " + string, this.bodyFontH2));
        } else {
            pdfPCell.addElement((Element)new Paragraph(string, this.bodyFontH2));
        }
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell(pdfPTable2);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableHead2(PdfPTable pdfPTable, int n, int n2, String string) {
        PdfPCell pdfPCell = null;
        Font font = new Font(this.bodyFontH3);
        font.setColor(this.bodyTextFgColor);
        PdfPTable pdfPTable2 = new PdfPTable(1);
        pdfPTable2.setWidthPercentage(100.0f);
        pdfPCell = new PdfPCell();
        pdfPCell.setPaddingTop(10.0f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = this.pdfSetup.isNumberedHeadlines() ? new PdfPCell((Phrase)new Paragraph(String.valueOf(n) + "." + String.valueOf(n2) + ". " + string, font)) : new PdfPCell((Phrase)new Paragraph(string, font));
        pdfPCell.setPaddingTop(3.0f);
        pdfPCell.setPaddingBottom(3.0f);
        pdfPCell.setPaddingLeft(5.0f);
        pdfPCell.setPaddingRight(5.0f);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable2.addCell(pdfPCell);
        pdfPCell = new PdfPCell(pdfPTable2);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string) {
        this.buildTableRow(pdfPTable, string, 0);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n) {
        this.buildTableRow(pdfPTable, string, n, this.bodyFontNormal.getSize(), 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, int n2) {
        this.buildTableRow(pdfPTable, string, n, this.bodyFontNormal.getSize(), n2);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, float f) {
        this.buildTableRow(pdfPTable, string, 0, f, 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, float f, int n) {
        this.buildTableRow(pdfPTable, string, 0, f, n);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, float f) {
        this.buildTableRow(pdfPTable, string, 0, f, 3);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, int n, float f, int n2) {
        String string2 = string != null ? ImmoToolUtils.replaceTags((String)string).trim() : "";
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string2));
        try {
            String string3;
            while (lineNumberReader.ready() && (string3 = lineNumberReader.readLine()) != null) {
                Font font = new Font(this.bodyFontNormal);
                font.setStyle(n);
                font.setSize(f);
                Paragraph paragraph = new Paragraph(string3, font);
                paragraph.setAlignment(n2);
                this.buildTableRow(pdfPTable, paragraph, f / 2.0f);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not write text!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    protected void buildTableRow(PdfPTable pdfPTable, Paragraph paragraph) {
        this.buildTableRow(pdfPTable, paragraph, 10.0f);
    }

    protected void buildTableRow(PdfPTable pdfPTable, Paragraph paragraph, float f) {
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPaddingTop(0.0f);
        pdfPCell.setPaddingBottom(f);
        pdfPCell.setPaddingLeft(20.0f);
        pdfPCell.setPaddingRight(20.0f);
        pdfPCell.addElement((Element)paragraph);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        pdfPTable.addCell(pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, String string2) {
        Paragraph paragraph = new Paragraph(StringEscapeUtils.unescapeHtml((String)string2), this.bodyFontNormal);
        paragraph.setAlignment(0);
        this.buildTableRow(pdfPTable, string, paragraph);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, Paragraph paragraph) {
        PdfPCell pdfPCell = new PdfPCell((Phrase)paragraph);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingTop(1.5f);
        pdfPCell.setPaddingBottom(3.5f);
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setBackgroundColor(this.bodyTextBgColor);
        this.buildTableRow(pdfPTable, string, pdfPCell);
    }

    protected void buildTableRow(PdfPTable pdfPTable, String string, PdfPCell pdfPCell) {
        Paragraph paragraph = new Paragraph(string + ":", this.bodyFontBold);
        paragraph.setAlignment(0);
        PdfPCell pdfPCell2 = new PdfPCell((Phrase)paragraph);
        pdfPCell2.setBorderWidth(0.0f);
        pdfPCell2.setPadding(0.0f);
        pdfPCell2.setPaddingLeft(30.0f);
        pdfPCell2.setPaddingTop(1.5f);
        pdfPCell2.setPaddingBottom(3.5f);
        pdfPCell2.setBackgroundColor(this.bodyTextBgColor);
        pdfPCell2.setVerticalAlignment(4);
        pdfPTable.addCell(pdfPCell2);
        pdfPTable.addCell(pdfPCell);
    }

    public abstract AgencySetupPdfFormPanel createSetupPanel();

    public ImmoToolTask<File> createTask(AgencyEstate agencyEstate) {
        return this.createTask(agencyEstate, null);
    }

    public ImmoToolTask<File> createTask(AgencyEstate agencyEstate, File file) {
        return this.createTask(agencyEstate, file, false);
    }

    public abstract ImmoToolTask<File> createTask(AgencyEstate var1, File var2, boolean var3);

    public abstract void generatePdf(AgencyEstate var1, OutputStream var2) throws ImmoToolException;

    protected void generateTable(Document document, PdfPTable pdfPTable, PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws ImmoToolException {
        PdfWriter pdfWriter = null;
        try {
            float f = rectangle.getWidth();
            float f2 = rectangle.getHeight();
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            if (this.encryptionEnabled) {
                int n = 0;
                if (this.encryptionAccessibilityAllowed) {
                    n |= 0x200;
                }
                if (this.encryptionCopyingAllowed) {
                    n |= 0x10;
                }
                if (this.encryptionPrintingAllowed) {
                    n |= 0x804;
                }
                pdfWriter.setEncryption(Charset.defaultCharset().encode(this.encryptionPassword).array(), null, n, 1);
                pdfWriter.createXmpMetadata();
            }
            if (!document.isOpen()) {
                document.open();
            }
            float f3 = 0.0f;
            int n = 0;
            for (int i = 0; i <= pdfPTable.getRows().size(); ++i) {
                boolean bl = this.pageBreakBeforeRow.contains(i);
                float f4 = pdfPTable.getRowHeight(i);
                if (!bl) {
                    boolean bl2 = bl = f3 - f4 <= 90.0f;
                }
                if (!bl && this.pageBreakIfNextRowNotFits.contains(i) && i < pdfPTable.getRows().size()) {
                    float f5 = pdfPTable.getRowHeight(i + 1);
                    boolean bl3 = bl = f3 - f4 - f5 <= 90.0f;
                }
                if (bl) {
                    document.newPage();
                    PdfTemplate pdfTemplate = null;
                    pdfTemplate = pdfWriter.getDirectContent().createTemplate(f, f2);
                    if (pdfReader != null) {
                        int n2 = n + 1;
                        if (n2 > pdfReader.getNumberOfPages()) {
                            n2 = pdfReader.getNumberOfPages();
                        }
                        pdfWriter.getDirectContentUnder().addTemplate((PdfTemplate)pdfWriter.getImportedPage(pdfReader, n2), 0.0f, 0.0f);
                    }
                    this.buildTemplate(pdfTemplate, f, f2, ++n);
                    pdfWriter.getDirectContent().addTemplate(pdfTemplate, 0.0f, 0.0f);
                    f3 = f2 - 110.0f;
                }
                f3 = pdfPTable.writeSelectedRows(i, i + 1, 60.0f, f3, pdfWriter.getDirectContent());
            }
            pdfWriter.flush();
        }
        catch (Exception exception) {
            throw new ImmoToolException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(2, 2);
    }

    public static Font getMatchingFont(String string, float f, Font font) {
        Font font2 = new Font(font);
        while (true) {
            Chunk chunk = new Chunk(string, font2);
            if (!(chunk.getWidthPoint() > f)) break;
            font2.setSize(font2.getSize() - 0.2f);
        }
        return font2;
    }

    public static Font getMatchingFont(String string, float f, float f2, Font font, float f3) {
        return PdfBuilder.getMatchingFont(string, f, f2, font, f3, new char[]{'-'});
    }

    public static Font getMatchingFont(String string, float f, float f2, Font font, float f3, char[] cArray) {
        if (f2 < font.getSize()) {
            return null;
        }
        int n = (int)Math.floor(f2 / font.getCalculatedLeading(f3));
        float f4 = f * (float)n;
        float f5 = new Chunk(" ", font).getWidthPoint();
        String[] stringArray = StringUtils.split((String)string, (String)" ");
        int n2 = 1;
        float f6 = 0.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            float f7;
            String string2 = stringArray[i];
            float f8 = 0.0f;
            boolean bl = false;
            if (cArray != null && cArray.length > 0) {
                for (char c : cArray) {
                    if (!StringUtils.contains((String)string2, (char)c) || StringUtils.containsOnly((String)string2, (char[])new char[]{c})) continue;
                    String[] stringArray2 = StringUtils.split((String)string2, (char)c);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string3 = j + 1 < stringArray2.length ? stringArray2[j] + c : stringArray2[j];
                        f8 += new Chunk(string3, font).getWidthPoint();
                    }
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                f8 += new Chunk(string2, font).getWidthPoint();
            }
            if ((f7 = f6 + f8) > f * (float)n2) {
                float f9 = f * (float)n2 - f6;
                f7 += f9;
                ++n2;
            } else if (i + 1 < stringArray.length) {
                f7 += f5;
            }
            f6 = f7;
        }
        if (f6 <= f4) {
            return font;
        }
        Font font2 = new Font(font);
        font2.setSize(font2.getSize() - 0.1f);
        return PdfBuilder.getMatchingFont(string, f, f2, font2, f3, cArray);
    }

    public abstract String getName();

    public Locale getOpenEstateLocale() {
        return this.openestateLocale;
    }

    public abstract String getTitle();

    protected boolean isFooterPageNumberPrinted() {
        return true;
    }

    protected boolean isFooterTimestampPrinted() {
        return true;
    }

    protected boolean isFooterWebsitePrinted() {
        return true;
    }

    public static Map<String, PdfBuilder> listAvailableBuilders() {
        TreeMap<String, PdfBuilder> treeMap = new TreeMap<String, PdfBuilder>();
        Iterator iterator = Service.providers(PdfBuilder.class);
        while (iterator.hasNext()) {
            PdfBuilder pdfBuilder = (PdfBuilder)iterator.next();
            treeMap.put(pdfBuilder.getName(), pdfBuilder);
        }
        return treeMap;
    }

    public void load(PdfSetup pdfSetup) {
        this.openestateLocale = null;
        for (Locale locale : OpenEstateUtils.getAvailableLocales()) {
            if (!locale.getLanguage().equals(pdfSetup.getLocale())) continue;
            this.openestateLocale = locale;
            break;
        }
        if (this.openestateLocale == null) {
            throw new IllegalArgumentException("could not load openestate-translation for '" + pdfSetup.getLocale() + "'");
        }
        this.resourceBundle = ResourceBundle.getBundle("com/openindex/openestate/tool/agency/utils/resources/PdfBuilder", this.openestateLocale);
        try {
            this.agent = AgencyAgent.loadAgent();
        }
        catch (Exception exception) {
            this.agent = null;
            LOGGER.warn((Object)"could not load agent!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.now = new Date();
        this.pdfSetup = pdfSetup;
        this.pageBreakBeforeRow = new ArrayList<Integer>();
        this.pageBreakIfNextRowNotFits = new ArrayList<Integer>();
        this.borderColor = this.pdfSetup.getBorderColor();
        this.bodyHeadBgColor = this.pdfSetup.getBodyHeadBackground();
        this.bodyHeadFgColor = this.pdfSetup.getBodyHeadForeground();
        this.bodyTextBgColor = this.pdfSetup.getBodyTextBackground();
        this.bodyTextFgColor = this.pdfSetup.getBodyTextForeground();
        this.headerTextFgColor = this.pdfSetup.getHeaderTextForeground();
        this.footerTextFgColor = this.pdfSetup.getFooterTextForeground();
        if (this.borderColor == null) {
            this.borderColor = Color.GRAY;
        }
        if (this.bodyHeadBgColor == null) {
            this.bodyHeadBgColor = Color.WHITE;
        }
        if (this.bodyHeadFgColor == null) {
            this.bodyHeadFgColor = Color.BLACK;
        }
        if (this.bodyTextBgColor == null) {
            this.bodyTextBgColor = Color.WHITE;
        }
        if (this.bodyTextFgColor == null) {
            this.bodyTextFgColor = Color.BLACK;
        }
        if (this.footerTextFgColor == null) {
            this.footerTextFgColor = Color.BLACK;
        }
        if (this.headerTextFgColor == null) {
            this.headerTextFgColor = Color.BLACK;
        }
        this.registerFonts();
        Font font = this.registeredFont();
        this.bodyFontH1 = new Font(font);
        this.bodyFontH1.setSize(16.0f);
        this.bodyFontH1.setStyle(1);
        this.bodyFontH1.setColor(this.bodyHeadFgColor);
        this.bodyFontH2 = new Font(font);
        this.bodyFontH2.setSize(14.0f);
        this.bodyFontH2.setStyle(1);
        this.bodyFontH2.setColor(this.bodyHeadFgColor);
        this.bodyFontH3 = new Font(font);
        this.bodyFontH3.setSize(12.0f);
        this.bodyFontH3.setStyle(1);
        this.bodyFontH3.setColor(this.bodyHeadFgColor);
        this.bodyFontBold = new Font(font);
        this.bodyFontBold.setSize(11.0f);
        this.bodyFontBold.setStyle(1);
        this.bodyFontBold.setColor(this.bodyTextFgColor);
        this.bodyFontNormal = new Font(font);
        this.bodyFontNormal.setSize(11.0f);
        this.bodyFontNormal.setStyle(0);
        this.bodyFontNormal.setColor(this.bodyTextFgColor);
        this.bodyFontSmall = new Font(font);
        this.bodyFontSmall.setSize(9.0f);
        this.bodyFontSmall.setStyle(0);
        this.bodyFontSmall.setColor(this.bodyTextFgColor);
        this.encryptionEnabled = pdfSetup.isEncryptionEnabled();
        this.encryptionPassword = pdfSetup.getEncryptionPassword();
        this.encryptionAccessibilityAllowed = pdfSetup.isEncryptionAccessibilityAllowed();
        this.encryptionCopyingAllowed = pdfSetup.isEncryptionCopyingAllowed();
        this.encryptionPrintingAllowed = pdfSetup.isEncryptionPrintingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerFonts() {
        if (pdfFontFile == null || !pdfFontFile.exists()) {
            String string = "/com/openindex/openestate/tool/resources/DejaVuSans.ttf";
            InputStream inputStream = null;
            try {
                pdfFontFile = File.createTempFile("font_", ".ttf");
                pdfFontFile.deleteOnExit();
                inputStream = PdfBuilder.class.getResourceAsStream(string);
                ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)pdfFontFile);
            }
            catch (Exception exception) {
                pdfFontFile = null;
                LOGGER.warn((Object)"Can't save font-file!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't close stream to font-file!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        if (pdfFontFile != null) {
            if (!pdfFontFile.isFile()) {
                LOGGER.warn((Object)("Can't find font file: " + pdfFontFile.getAbsolutePath()));
            } else {
                FontFactory.register((String)pdfFontFile.getAbsolutePath(), (String)"BaseFont");
            }
        }
    }

    protected Font registeredFont() {
        return FontFactory.getFont((String)"BaseFont", (String)"Identity-H", (boolean)true);
    }

    protected Font registeredFont(float f, int n, Color color) {
        return FontFactory.getFont((String)"BaseFont", (String)"Identity-H", (boolean)true, (float)f, (int)n, (Color)color);
    }
}

