/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroups;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormDetailedPanel;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class PdfExposeDetailedBuilder
extends PdfBuilder {
    private static final Logger LOGGER = Logger.getLogger(PdfExposeDetailedBuilder.class);
    public static final String NAME = "expose.detailed";
    public static final int GALLERY_DEFAULT = 0;
    public static final int GALLERY_1_IMAGE_PER_ROW = 1;
    public static final int GALLERY_2_IMAGES_PER_ROW = 2;
    public static final int GALLERY_3_IMAGES_PER_ROW = 3;
    public static final int GALLERY_4_IMAGES_PER_ROW = 4;
    public static final int GALLERY_1_IMAGE_PER_SITE = 5;
    public static final int GALLERY_2_IMAGES_PER_SITE = 6;
    public static final int GALLERY_WITHOUT_IMAGES = -1;
    private ResourceMap resourceMap;
    private Properties resources;

    protected PdfPTable buildTable(AgencyEstate agencyEstate, Rectangle rectangle) throws ImmoToolException {
        float f = rectangle.getWidth();
        int n = 3;
        switch (this.pdfSetup.getBodyTextAlignment()) {
            case 1: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 0: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        int n2 = 0;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setTotalWidth(f - 60.0f - 60.0f);
        String string = agencyEstate.getTitle(this.getOpenEstateLocale().getLanguage());
        OpenEstateType openEstateType = agencyEstate.getType();
        String string2 = openEstateType != null ? OpenEstateUtils.translateEstate((String)openEstateType.getName(), (Locale)this.getOpenEstateLocale()) : "";
        String string3 = agencyEstate.getAction() != null && agencyEstate.getAction().trim().length() > 0 ? OpenEstateUtils.translateAction((String)agencyEstate.getAction(), (Locale)this.getOpenEstateLocale()) : "";
        Font font = new Font(this.bodyFontH1);
        font.setColor(this.bodyTextFgColor);
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPaddingTop(0.0f);
        pdfPCell.setPaddingBottom(0.0f);
        if (string != null && string.trim().length() > 0) {
            pdfPCell.addElement((Element)new Paragraph(string.trim(), font));
            pdfPCell.addElement((Element)new Paragraph(string2 + " / " + string3, this.bodyFontNormal));
        } else {
            pdfPCell.addElement((Element)new Paragraph(string2 + " / " + string3, font));
        }
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPTable.addCell(pdfPCell);
        ArrayList<Area> arrayList = new ArrayList<Area>();
        if (this.pdfSetup.getAreas() == null) {
            arrayList.addAll(Arrays.asList(Area.values()));
        } else {
            for (String string4 : this.pdfSetup.getAreas()) {
                try {
                    arrayList.add(Area.valueOf(string4));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Unknown pdf area!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        for (Area area : arrayList) {
            if (Area.GENERAL == area) {
                n2 += this.writeGeneralArea(pdfPTable, n2, agencyEstate, n);
                continue;
            }
            if (Area.IMAGES == area) {
                n2 += this.writeImageArea(pdfPTable, n2, agencyEstate, rectangle);
                continue;
            }
            if (Area.AGENCY == area) {
                n2 += this.writeAgencyArea(pdfPTable, n2, agencyEstate);
                continue;
            }
            if (Area.TERMS == area) {
                n2 += this.writeTermsArea(pdfPTable, n2, n);
                continue;
            }
            LOGGER.warn((Object)("Unprintable area: " + (Object)((Object)area)));
        }
        return pdfPTable;
    }

    @Override
    public AgencySetupPdfFormPanel createSetupPanel() {
        return new AgencySetupPdfFormDetailedPanel();
    }

    @Override
    public ImmoToolTask<File> createTask(final AgencyEstate agencyEstate, final File file, final boolean bl) {
        return new ImmoToolTask<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected File executeTask() throws Exception {
                File file5 = AgencyPlugin.getLastExportLocation();
                File file2 = file;
                FileOutputStream fileOutputStream = null;
                try {
                    Serializable serializable;
                    if (file2 == null) {
                        if (bl) {
                            throw new Exception("no output-file provided!");
                        }
                        serializable = new JFileChooser();
                        ((JFileChooser)serializable).setDialogTitle(PdfExposeDetailedBuilder.this.resourceMap.getString("message.saveExpose", new Object[0]));
                        String string = agencyEstate.getPublicId();
                        if (string == null || string.trim().length() == 0) {
                            string = String.valueOf(agencyEstate.getIdNr());
                        }
                        string = string.replaceAll("[^\\w\\-\\.]", "_");
                        while (string.contains("__")) {
                            string = string.replace("__", "_");
                        }
                        String string2 = new Formatter().format(PdfExposeDetailedBuilder.this.resources.getProperty("message.saveExpose.defaultFile", "???"), string).toString();
                        if (file5 != null) {
                            ((JFileChooser)serializable).setSelectedFile(new File(file5.getAbsolutePath() + File.separator + string2));
                        } else {
                            ((JFileChooser)serializable).setSelectedFile(new File(string2));
                        }
                        ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                            }

                            @Override
                            public String getDescription() {
                                return PdfExposeDetailedBuilder.this.resourceMap.getString("message.saveExpose.files", new Object[]{"*.pdf"});
                            }
                        });
                        int n = ((JFileChooser)serializable).showSaveDialog(null);
                        if (n != 0) {
                            File file3 = null;
                            return file3;
                        }
                        file2 = ((JFileChooser)serializable).getSelectedFile();
                        AgencyPlugin.setLastExportLocation(file2.getParentFile());
                        if (file2.exists() && !ImmoToolUtils.showQuestionDialog((String)PdfExposeDetailedBuilder.this.resourceMap.getString("question.overwriteExistingFile", new Object[0]))) {
                            File file4 = null;
                            return file4;
                        }
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    PdfExposeDetailedBuilder.this.generatePdf(agencyEstate, fileOutputStream);
                    fileOutputStream.flush();
                    serializable = file2;
                    return serializable;
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)PdfExposeDetailedBuilder.this.resourceMap.getString("error.cantSavePdf", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(File file2) {
                super.succeeded((Object)file2);
                if (file2 != null && !bl) {
                    ImmoToolUtils.showMessageInfoDialog((String)PdfExposeDetailedBuilder.this.resourceMap.getString("message.saveExpose.success", new Object[]{file2.getAbsolutePath()}));
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void generatePdf(AgencyEstate agencyEstate, OutputStream outputStream) throws ImmoToolException {
        Boolean bl = agencyEstate.getAdress().isAdressPublished();
        int n = this.pdfSetup.getAddressPublishing();
        if (2 == n) {
            agencyEstate.getAdress().setAdressPublished(true);
        } else if (1 == n) {
            agencyEstate.getAdress().setAdressPublished(false);
        }
        if (this.pdfSetup.isTemplateUsed()) {
            InputStream inputStream;
            block10: {
                inputStream = null;
                try {
                    File file = this.pdfSetup.getTemporaryTemplate();
                    if (file != null && !file.isFile()) {
                        LOGGER.warn((Object)"Can't find temporary pdf-template!");
                        LOGGER.warn((Object)("> " + file.getAbsolutePath()));
                        file = null;
                    }
                    InputStream inputStream2 = inputStream = file != null ? new FileInputStream(file) : PdfSetup.loadTemplateAsStream(this.pdfSetup.getId());
                    if (inputStream == null) {
                        LOGGER.warn((Object)"Can't read expose-template!");
                        break block10;
                    }
                    this.generatePdf(agencyEstate, inputStream, outputStream);
                }
                catch (Exception exception) {
                    try {
                        LOGGER.warn((Object)"Can't open expose-template!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        this.generatePdf(agencyEstate, this.pdfSetup.isLandscapeFormat() ? PageSize.A4.rotate() : PageSize.A4, outputStream);
        agencyEstate.getAdress().setAdressPublished(Boolean.TRUE.equals(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generatePdf(AgencyEstate agencyEstate, InputStream inputStream, OutputStream outputStream) throws IOException, ImmoToolException {
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(inputStream);
            this.generatePdf(agencyEstate, pdfReader, pdfReader.getPageSize(1), outputStream);
        }
        finally {
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    public final void generatePdf(AgencyEstate agencyEstate, Rectangle rectangle, OutputStream outputStream) throws ImmoToolException {
        this.generatePdf(agencyEstate, null, rectangle, outputStream);
    }

    protected void generatePdf(AgencyEstate agencyEstate, PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws ImmoToolException {
        String string = agencyEstate.getTitle(this.getOpenEstateLocale().getLanguage());
        if (string == null) {
            string = "";
        }
        try {
            String string2;
            float f = rectangle.getWidth();
            float f2 = rectangle.getHeight();
            Document document = new Document(new Rectangle(f, f2));
            PdfPTable pdfPTable = this.buildTable(agencyEstate, rectangle);
            pdfPTable.setWidths(new float[]{pdfPTable.getTotalWidth() * 0.5f, pdfPTable.getTotalWidth() * 0.5f});
            this.generateTable(document, pdfPTable, pdfReader, rectangle, outputStream);
            document.addAuthor(this.agent != null ? this.agent.getCompany().getCompanyName() : "");
            document.addCreationDate();
            document.addCreator(ImmoToolApp.getApplicationTitle() + " v" + ImmoToolApp.getApplicationVersion());
            document.addProducer();
            document.addTitle(string);
            document.addSubject(new Formatter().format(this.resources.getProperty("subject", "???"), agencyEstate.getIdNr()).toString());
            String string3 = "FREITEXTE.KEYWORDS";
            if (agencyEstate.hasAttribute(string3) && (string2 = (String)agencyEstate.getAttribute(string3).getValueObject(this.getOpenEstateLocale())) != null) {
                document.addKeywords(string2.trim());
            }
            document.close();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not generate pdf-expose!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new ImmoToolException("could not generate pdf-expose: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private static int getGalleryColumnCount(Integer n) {
        if (n == null) {
            return 0;
        }
        switch (n) {
            case 1: 
            case 5: 
            case 6: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    private static Float getGalleryImageWidth(Integer n, float f) {
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: 
            case 5: 
            case 6: {
                return Float.valueOf(f);
            }
            case 2: {
                return Float.valueOf(f / 2.0f - 10.0f);
            }
            case 3: {
                return Float.valueOf(f / 3.0f - 10.0f);
            }
            case 4: {
                return Float.valueOf(f / 4.0f - 10.0f);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return ImmoToolUtils.getResourceMap(PdfExposeDetailedBuilder.class).getString("title", new Object[0]);
    }

    @Override
    public void load(PdfSetup pdfSetup) {
        super.load(pdfSetup);
        if (!NAME.equals(pdfSetup.getBuilder())) {
            throw new IllegalArgumentException("invalid pdf-setup!");
        }
        this.resourceMap = ImmoToolUtils.getResourceMap(PdfExposeDetailedBuilder.class);
        this.resources = new Properties();
        try {
            String string = ImmoToolUtils.getResourcePath(PdfExposeDetailedBuilder.class, (Locale)this.getOpenEstateLocale());
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                this.resources.load(uRL.openStream());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read ressources!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private int writeAgencyArea(PdfPTable pdfPTable, int n, AgencyEstate agencyEstate) {
        String string;
        URL uRL;
        if (this.agent == null) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n2 = n;
        int n3 = 0;
        this.buildTableHead(pdfPTable, ++n2, this.resources.getProperty("label.agent", "???"));
        this.buildTableHead2(pdfPTable, n2, ++n3, this.resources.getProperty("label.agent.providedBy", "???"));
        this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.company", "???"), this.agent.getCompany().getCompanyName());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.agent.getCompany().writeFullAdress(SystemUtils.LINE_SEPARATOR));
        if (this.agent.getCompany().getRegion() != null && this.agent.getCompany().getRegion().trim().length() > 0) {
            stringBuilder.append(" / ").append(this.agent.getCompany().getRegion());
        }
        this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.adress", "???"), stringBuilder.toString());
        String string2 = this.agent.getAufsichtsBehoerde();
        if (string2 != null && string2.trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.aufsicht", "???"), string2.trim());
        }
        if ((string2 = this.agent.getGewerbeErlaubnis()) != null && string2.trim().length() > 0) {
            if (this.agent.getCompany() != null && "de".equalsIgnoreCase(this.agent.getCompany().getCountry())) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.gewerbeerlaubnis34c", "???"), string2.trim());
            } else {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.gewerbeerlaubnis", "???"), string2.trim());
            }
        }
        if ((string2 = this.agent.getHandelsRegister()) != null && string2.trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.handelsregister", "???"), string2.trim());
        }
        if ((string2 = this.agent.getUstId()) != null && string2.trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.ustId", "???"), string2.trim());
        }
        if ((string2 = this.agent.getVertretung()) != null && string2.trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.vertretung", "???"), string2.trim());
        }
        if ((uRL = this.agent.getCompany().getCompanyWebsite()) != null && uRL.getHost() != null && uRL.getHost().trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.agent.website", "???"), uRL.toString());
        }
        if ((string = agencyEstate.getContactId()) != null && string.trim().length() == 0) {
            string = null;
        }
        try {
            this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
            this.buildTableHead2(pdfPTable, n2, ++n3, this.resources.getProperty("label.contact", "???"));
            AgencyContact agencyContact = null;
            if (string != null) {
                String[] stringArray = string.split("\\.");
                long l = Long.valueOf(stringArray[stringArray.length - 1]);
                agencyContact = AgencyContact.loadContact(l);
            }
            if (agencyContact != null) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.person", "???"), agencyContact.writePersonFullName());
            } else {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.person", "???"), this.agent.getCompany().writePersonFullName());
            }
            if (agencyContact != null && agencyContact.getPersonPhone() != null && agencyContact.getPersonPhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.phone", "???"), agencyContact.getPersonPhone().trim());
            } else if (this.agent.getCompany().getPersonPhone() != null && this.agent.getCompany().getPersonPhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.phone", "???"), this.agent.getCompany().getPersonPhone().trim());
            } else if (this.agent.getCompany().getCompanyPhone() != null && this.agent.getCompany().getCompanyPhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.phone", "???"), this.agent.getCompany().getCompanyPhone().trim());
            }
            if (agencyContact != null && agencyContact.getPersonMobilePhone() != null && agencyContact.getPersonMobilePhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.cellphone", "???"), agencyContact.getPersonMobilePhone().trim());
            } else if (this.agent.getCompany().getPersonMobilePhone() != null && this.agent.getCompany().getPersonMobilePhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.cellphone", "???"), this.agent.getCompany().getPersonMobilePhone().trim());
            } else if (this.agent.getCompany().getCompanyMobilePhone() != null && this.agent.getCompany().getCompanyMobilePhone().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.cellphone", "???"), this.agent.getCompany().getCompanyMobilePhone().trim());
            }
            if (agencyContact != null && agencyContact.getPersonFax() != null && agencyContact.getPersonFax().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.fax", "???"), agencyContact.getPersonFax().trim());
            } else if (this.agent.getCompany().getPersonFax() != null && this.agent.getCompany().getPersonFax().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.fax", "???"), this.agent.getCompany().getPersonFax().trim());
            } else if (this.agent.getCompany().getCompanyFax() != null && this.agent.getCompany().getCompanyFax().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.fax", "???"), this.agent.getCompany().getCompanyFax().trim());
            }
            if (agencyContact != null && agencyContact.getPersonMail() != null && agencyContact.getPersonMail().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.mail", "???"), agencyContact.getPersonMail().trim());
            } else if (this.agent.getCompany().getPersonMail() != null && this.agent.getCompany().getPersonMail().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.mail", "???"), this.agent.getCompany().getPersonMail().trim());
            } else if (this.agent.getCompany().getCompanyMail() != null && this.agent.getCompany().getCompanyMail().trim().length() > 0) {
                this.buildTableRow(pdfPTable, this.resources.getProperty("label.contact.mail", "???"), this.agent.getCompany().getCompanyMail().trim());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load contact!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        return n2 - n;
    }

    private int writeGeneralArea(PdfPTable pdfPTable, int n, AgencyEstate agencyEstate, int n2) {
        Object object;
        String string2;
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n3 = n;
        int n4 = 0;
        this.buildTableHead(pdfPTable, ++n3, this.resources.getProperty("label.estate", "???"));
        this.buildTableHead2(pdfPTable, n3, ++n4, this.resources.getProperty("label.estate.general", "???"));
        if (agencyEstate.getPublicId() != null && agencyEstate.getPublicId().trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.estate.nr", "???"), agencyEstate.getPublicId());
        } else {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.estate.id", "???"), String.valueOf(agencyEstate.getIdNr()));
        }
        this.buildTableRow(pdfPTable, this.resources.getProperty("label.estate.adress", "???"), agencyEstate.getAdress().writeFullAdress(SystemUtils.LINE_SEPARATOR, this.getOpenEstateLocale()));
        if (agencyEstate.getAdress().getRegion() != null && agencyEstate.getAdress().getRegion().trim().length() > 0) {
            this.buildTableRow(pdfPTable, this.resources.getProperty("label.estate.area", "???"), agencyEstate.getAdress().getRegion());
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : OpenEstateAttribGroups.getValues()) {
            if (!agencyEstate.getType().hasAttribGroup(string2)) continue;
            object = agencyEstate.getType().getAttribsByGroup(string2);
            int n5 = ((OpenEstateAttrib[])object).length;
            for (int i = 0; i < n5; ++i) {
                OpenEstateAttrib openEstateAttrib = object[i];
                if (!agencyEstate.hasAttribute(string2, openEstateAttrib.getName())) continue;
                linkedHashSet.add(openEstateAttrib.getKey());
            }
        }
        Object object2 = null;
        for (String string3 : linkedHashSet) {
            Object object3;
            string2 = agencyEstate.getAttribute(string3);
            if (string2.getGroupName() == null || string2.getAttribName() == null || string2.getGroupName().equalsIgnoreCase("FREITEXTE") || string2.getGroupName().equalsIgnoreCase("PREISE") && string2.getAttribName().equalsIgnoreCase("SONDERANGEBOT") || StringUtils.isBlank((String)(object = agencyEstate.writeValue((ValueImpl)string2, this.getOpenEstateLocale())))) continue;
            if (object2 == null || !((String)object2).equals(string2.getGroupName())) {
                object2 = string2.getGroupName();
                object3 = OpenEstateUtils.translateAttributeByCountry((String)object2, (Locale)this.getOpenEstateLocale(), (String)agencyEstate.getAdress().getCountry());
                this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
                this.buildTableHead2(pdfPTable, n3, ++n4, (String)(object3 != null ? object3 : object2));
            }
            this.buildTableRow(pdfPTable, (String)((object3 = OpenEstateUtils.translateAttributeByCountry((String)string2.getGroupName(), (String)string2.getAttribName(), (Locale)this.getOpenEstateLocale(), (String)agencyEstate.getAdress().getCountry())) != null ? object3 : string2.getAttribName()), object != null ? ((String)object).trim() : "");
        }
        for (String string4 : linkedHashSet) {
            string2 = agencyEstate.getAttribute(string4);
            if (string2.getGroupName() == null || string2.getAttribName() == null || !string2.getGroupName().equalsIgnoreCase("FREITEXTE") || string2.getAttribName().equalsIgnoreCase("KEYWORDS") || agencyEstate.isHiddenPrices() && string2.getAttribName().equalsIgnoreCase("PREIS_BESCHR") || string2.getAttribName().equalsIgnoreCase("KURZ_BESCHR") && linkedHashSet.contains("FREITEXTE.OBJEKT_BESCHR") || StringUtils.isBlank((String)(object = string2.writeValue(this.getOpenEstateLocale(), agencyEstate.getCurrency())))) continue;
            String string5 = OpenEstateUtils.translateAttributeByCountry((String)string2.getGroupName(), (String)string2.getAttribName(), (Locale)this.getOpenEstateLocale(), (String)agencyEstate.getAdress().getCountry());
            this.pageBreakIfNextRowNotFits.add(pdfPTable.getRows().size());
            this.buildTableHead2(pdfPTable, n3, ++n4, string5 != null ? string5 : string2.getAttribName());
            this.buildTableRow(pdfPTable, object != null ? ((String)object).trim() : "", 0, n2);
        }
        return n3 - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImageArea(PdfPTable pdfPTable, int n, AgencyEstate agencyEstate, Rectangle rectangle) {
        Object object;
        Object object2;
        Object object3;
        Float f;
        Image image;
        File file;
        PdfPCell pdfPCell;
        ArrayList<EstateAttachmentImpl> arrayList;
        int n2;
        int n3 = n2 = this.pdfSetup.getImageGallery() != null ? this.pdfSetup.getImageGallery() : 0;
        if (n2 <= -1 || agencyEstate.getAttachments().isEmpty()) {
            return 0;
        }
        int n4 = n2 > 0 ? n2 : 2;
        int n5 = PdfExposeDetailedBuilder.getGalleryColumnCount(n4);
        if (n5 < 1) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n6 = n;
        int n7 = 0;
        Integer n8 = this.pdfSetup.getImageResolution();
        boolean bl = Boolean.TRUE.equals(this.pdfSetup.getImageSeparatedPlans());
        boolean bl2 = Boolean.TRUE.equals(this.pdfSetup.getImageSeparatedPanoramas());
        ArrayList<EstateAttachmentImpl> arrayList2 = bl ? new ArrayList<EstateAttachmentImpl>() : null;
        ArrayList<EstateAttachmentImpl> arrayList3 = arrayList = bl2 ? new ArrayList<EstateAttachmentImpl>() : null;
        if (5 != n4) {
            this.buildTableHead(pdfPTable, ++n6, this.resources.getProperty("label.gallery", "???"));
            pdfPCell = new PdfPCell((Phrase)new Paragraph("", this.bodyFontSmall));
            pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(10.0f);
            pdfPTable.addCell(pdfPCell);
        }
        pdfPCell = null;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        n7 = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : agencyEstate.getAttachments()) {
            if (!estateAttachmentImpl.isName() || !estateAttachmentImpl.isPublished() || !"image/bmp".equalsIgnoreCase(estateAttachmentImpl.getMimeType()) && !"image/jpeg".equalsIgnoreCase(estateAttachmentImpl.getMimeType()) && !"image/png".equalsIgnoreCase(estateAttachmentImpl.getMimeType())) continue;
            if (bl && ("IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType()) || "IMAGE_MAP".equals(estateAttachmentImpl.getType()))) {
                arrayList2.add(estateAttachmentImpl);
                continue;
            }
            if (bl2 && "IMAGE_PANORAMA".equals(estateAttachmentImpl.getType())) {
                arrayList.add(estateAttachmentImpl);
                continue;
            }
            if (n7 % n5 == 0) {
                if (pdfPCell != null) {
                    this.writeImageRow(pdfPTable, (PdfPTable)pdfPCell, arrayList4);
                }
                pdfPCell = new PdfPTable(n5);
                pdfPCell.setWidthPercentage(100.0f);
                arrayList4.clear();
            }
            ++n7;
            try {
                file = AgencyEstate.loadAttachmentAsTempFile(agencyEstate.getIdNr(), estateAttachmentImpl.getFileAsName());
                if (file == null) continue;
                image = null;
                boolean bl3 = this.pdfSetup.isLandscapeFormat() && (5 == n4 || 6 == n4 || 1 == n4);
                f = PdfExposeDetailedBuilder.getGalleryImageWidth(n4, pdfPTable.getTotalWidth());
                Object object4 = f == null ? null : (object3 = Float.valueOf(bl3 ? f.floatValue() * 0.4f : f.floatValue()));
                if (6 == n4) {
                    object3 = Float.valueOf((rectangle.getHeight() - 110.0f - 90.0f) / 2.0f - 30.0f);
                    if (n7 < 3) {
                        object3 = Float.valueOf(((Float)object3).floatValue() - 30.0f);
                    }
                }
                if (f == null || object3 == null) continue;
                if (n8 != null && n8 >= 72) {
                    object2 = ImageIO.read(file);
                    object = f == null || object3 == null ? object2 : ImmoToolUtils.scaleImageToResolution((BufferedImage)object2, (int)f.intValue(), (int)((Float)object3).intValue(), (int)n8);
                    image = Image.getInstance((java.awt.Image)object, null);
                    ((java.awt.Image)object2).flush();
                    ((java.awt.Image)object).flush();
                } else {
                    object2 = ImageIO.read(file);
                    image = Image.getInstance((java.awt.Image)object2, null);
                    ((java.awt.Image)object2).flush();
                }
                if (file.isFile()) {
                    FileUtils.deleteQuietly((File)file);
                }
                if (image == null) continue;
                image.setBorderWidth(0.0f);
                if (image.getWidth() > f.floatValue() || image.getHeight() > ((Float)object3).floatValue()) {
                    image.scaleToFit(f.floatValue(), ((Float)object3).floatValue());
                }
                if (5 == n4) {
                    object2 = this.resources.getProperty("label.view", "???");
                    object = estateAttachmentImpl.getTitle(this.getOpenEstateLocale());
                    if (object != null && ((String)object).trim().length() > 0) {
                        object2 = (String)object2 + " '" + (String)object + "'";
                    }
                    if (n7 > 0) {
                        this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    }
                    this.buildTableHead(pdfPTable, ++n6, (String)object2);
                    PdfPCell pdfPCell2 = new PdfPCell((Phrase)new Paragraph("", this.bodyFontSmall));
                    pdfPCell2.setColspan(pdfPTable.getNumberOfColumns());
                    pdfPCell2.setBorderWidth(0.0f);
                    pdfPCell2.setPadding(0.0f);
                    pdfPCell2.setPaddingTop(10.0f);
                    pdfPTable.addCell(pdfPCell2);
                } else {
                    object2 = estateAttachmentImpl.getTitle(this.getOpenEstateLocale());
                    arrayList4.add(object2 != null ? ((String)object2).trim() : null);
                }
                object2 = new PdfPCell(image, false);
                object2.setBorderWidth(0.0f);
                object2.setPadding(0.0f);
                object2.setBackgroundColor(this.bodyTextBgColor);
                object2.setHorizontalAlignment(1);
                pdfPCell.addCell((PdfPCell)object2);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write image into pdf!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        while (n7 % n5 != 0) {
            PdfPCell pdfPCell3 = new PdfPCell();
            pdfPCell3.setBorderWidth(0.0f);
            pdfPCell.addCell(pdfPCell3);
            arrayList4.add(null);
            ++n7;
        }
        this.writeImageRow(pdfPTable, (PdfPTable)pdfPCell, arrayList4);
        if (bl && arrayList2 != null && !arrayList2.isEmpty()) {
            for (EstateAttachmentImpl estateAttachmentImpl : arrayList2) {
                file = null;
                try {
                    file = AgencyEstate.loadAttachmentAsTempFile(agencyEstate.getIdNr(), estateAttachmentImpl.getFileAsName());
                    if (file == null) continue;
                    image = null;
                    Float f2 = Float.valueOf(pdfPTable.getTotalWidth());
                    Float f3 = f2 == null ? null : (f = Float.valueOf(this.pdfSetup.isLandscapeFormat() ? f2.floatValue() * 0.45f : f2.floatValue() * 1.2f));
                    if (f2 == null || f == null) continue;
                    if (n8 != null && n8 >= 72) {
                        object3 = ImageIO.read(file);
                        object2 = ImmoToolUtils.scaleImageToResolution((BufferedImage)object3, (int)f2.intValue(), (int)f.intValue(), (int)n8);
                        image = Image.getInstance((java.awt.Image)object2, null);
                        ((java.awt.Image)object3).flush();
                        ((java.awt.Image)object2).flush();
                    } else {
                        object3 = ImageIO.read(file);
                        image = Image.getInstance((java.awt.Image)object3, null);
                        ((java.awt.Image)object3).flush();
                    }
                    if (image == null) continue;
                    image.setBorderWidth(0.0f);
                    if (image.getWidth() > f2.floatValue() || image.getHeight() > f.floatValue()) {
                        image.scaleToFit(f2.floatValue(), f.floatValue());
                    }
                    object3 = !StringUtils.isBlank((String)(object2 = estateAttachmentImpl.getTitle(this.getOpenEstateLocale()))) ? ((String)object2).trim() : ("IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType()) ? this.resources.getProperty("label.plan", "???") : ("IMAGE_MAP".equals(estateAttachmentImpl.getType()) ? this.resources.getProperty("label.map", "???") : this.resources.getProperty("label.view", "???")));
                    this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    this.buildTableHead(pdfPTable, ++n6, (String)object3);
                    object = new PdfPCell(image, false);
                    object.setBorderWidth(0.0f);
                    object.setPaddingTop(10.0f);
                    object.setHorizontalAlignment(1);
                    object.setVerticalAlignment(4);
                    object.setColspan(pdfPTable.getNumberOfColumns());
                    object.setBackgroundColor(this.bodyTextBgColor);
                    pdfPTable.addCell((PdfPCell)object);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't write image into pdf!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                finally {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
        if (bl2 && arrayList != null && !arrayList.isEmpty()) {
            for (EstateAttachmentImpl estateAttachmentImpl : arrayList) {
                file = null;
                try {
                    file = AgencyEstate.loadAttachmentAsTempFile(agencyEstate.getIdNr(), estateAttachmentImpl.getFileAsName());
                    if (file == null) continue;
                    image = null;
                    Float f4 = Float.valueOf(pdfPTable.getTotalWidth());
                    Float f5 = f4 == null ? null : (f = Float.valueOf(this.pdfSetup.isLandscapeFormat() ? f4.floatValue() * 0.45f : f4.floatValue() * 1.2f));
                    if (f4 == null || f == null) continue;
                    if (n8 != null && n8 >= 72) {
                        object3 = ImageIO.read(file);
                        if (!this.pdfSetup.isLandscapeFormat()) {
                            object2 = ImmoToolUtils.rotateImageToLeft((BufferedImage)object3, (int)1);
                            ((java.awt.Image)object3).flush();
                            object3 = object2;
                        }
                        object2 = ImmoToolUtils.scaleImageToResolution((BufferedImage)object3, (int)f4.intValue(), (int)f.intValue(), (int)n8);
                        ((java.awt.Image)object3).flush();
                        image = Image.getInstance((java.awt.Image)object2, null);
                        ((java.awt.Image)object2).flush();
                    } else {
                        object3 = ImageIO.read(file);
                        if (!this.pdfSetup.isLandscapeFormat()) {
                            object2 = ImmoToolUtils.rotateImageToLeft((BufferedImage)object3, (int)1);
                            ((java.awt.Image)object3).flush();
                            object3 = object2;
                        }
                        image = Image.getInstance((java.awt.Image)object3, null);
                        ((java.awt.Image)object3).flush();
                    }
                    if (image == null) continue;
                    image.setBorderWidth(0.0f);
                    if (image.getWidth() > f4.floatValue() || image.getHeight() > f.floatValue()) {
                        image.scaleToFit(f4.floatValue(), f.floatValue());
                    }
                    object3 = !StringUtils.isBlank((String)(object2 = estateAttachmentImpl.getTitle(this.getOpenEstateLocale()))) ? ((String)object2).trim() : ("IMAGE_PANORAMA".equals(estateAttachmentImpl.getType()) ? this.resources.getProperty("label.panorama", "???") : this.resources.getProperty("label.view", "???"));
                    this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
                    this.buildTableHead(pdfPTable, ++n6, (String)object3);
                    object = new PdfPCell(image, false);
                    object.setBorderWidth(0.0f);
                    object.setPaddingTop(10.0f);
                    object.setHorizontalAlignment(1);
                    object.setVerticalAlignment(4);
                    object.setColspan(pdfPTable.getNumberOfColumns());
                    object.setBackgroundColor(this.bodyTextBgColor);
                    pdfPTable.addCell((PdfPCell)object);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't write image into pdf!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                finally {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
        return n6 - n;
    }

    private void writeImageRow(PdfPTable pdfPTable, PdfPTable pdfPTable2, List<String> list) {
        for (String string : list) {
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingBottom(10.0f);
            if (string != null && string.trim().length() > 0) {
                Paragraph paragraph = new Paragraph(string, this.bodyFontSmall);
                paragraph.setAlignment(1);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable2.addCell(pdfPCell);
        }
        PdfPCell pdfPCell = new PdfPCell();
        pdfPCell.setColspan(pdfPTable.getNumberOfColumns());
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.addElement((Element)pdfPTable2);
        pdfPTable.addCell(pdfPCell);
    }

    private int writeTermsArea(PdfPTable pdfPTable, int n, int n2) {
        if (this.agent == null || !this.pdfSetup.isTermsVisible()) {
            return 0;
        }
        String string = this.agent.getTerms(this.getOpenEstateLocale().getLanguage());
        if (string == null || string.trim().length() == 0) {
            return 0;
        }
        if (n > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        int n3 = n;
        Integer n4 = this.pdfSetup.getTermsTextSize();
        if (n3 > 0) {
            this.pageBreakBeforeRow.add(pdfPTable.getRows().size());
        }
        this.buildTableHead(pdfPTable, ++n3, this.resources.getProperty("label.terms", "???"));
        if (n4 == null) {
            this.buildTableRow(pdfPTable, string.trim(), 0, n2);
        } else {
            this.buildTableRow(pdfPTable, string.trim(), n4.floatValue(), n2);
        }
        return n3 - n;
    }

    public static enum Area {
        GENERAL,
        IMAGES,
        AGENCY,
        TERMS;

    }
}

