/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.DefaultSplitCharacter;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfReader;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormPanel;
import com.openindex.openestate.tool.agency.AgencySetupPdfFormShortPanel;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import com.openindex.openestate.tool.agency.utils.PdfExposeDetailedBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class PdfExposeShortBuilder
extends PdfBuilder {
    private static final Logger LOGGER = Logger.getLogger(PdfExposeShortBuilder.class);
    public static final String NAME = "expose.short";
    public static final int GALLERY_DEFAULT = 0;
    public static final int GALLERY_1x1_IMAGE = 1;
    public static final int GALLERY_1x1_PLAN = 2;
    public static final int GALLERY_2x1_IMAGE_PLAN = 3;
    public static final int GALLERY_2x1_PLAN_IMAGE = 4;
    public static final int GALLERY_2x1_IMAGES = 5;
    public static final int GALLERY_3x1_IMAGES = 6;
    public static final int GALLERY_2x2_IMAGES = 7;
    public static final int GALLERY_3x2_IMAGES = 8;
    public static final int GALLERY_WITHOUT_IMAGES = -1;
    public static final int CONTACT_NAME = 0;
    public static final int CONTACT_PHONE = 1;
    public static final int CONTACT_FAX = 2;
    public static final int CONTACT_MAIL = 3;
    private static final float LANDSCAPE_HEIGHT_DESCRIPTION = 275.0f;
    private static final float LANDSCAPE_HEIGHT_ATTRIBS_TOP = 35.0f;
    private static final float LANDSCAPE_HEIGHT_ATTRIBS_BOTTOM = 35.0f;
    private static final float LANDSCAPE_HEIGHT_HEAD = 35.0f;
    private static final float LANDSCAPE_HEIGHT_SUBHEAD = 20.0f;
    private static final float LANDSCAPE_HEIGHT_IMAGE = 330.0f;
    private static final float LANDSCAPE_HEIGHT_TYPE = 35.0f;
    private static final float LANDSCAPE_HEIGHT_PRICES = 35.0f;
    private static final float LANDSCAPE_HEIGHT_CONTACT = 35.0f;
    private static final float PORTRAIT_HEIGHT_DESCRIPTION = 350.0f;
    private static final float PORTRAIT_HEIGHT_ATTRIBS_TOP = 35.0f;
    private static final float PORTRAIT_HEIGHT_ATTRIBS_BOTTOM = 35.0f;
    private static final float PORTRAIT_HEIGHT_HEAD = 35.0f;
    private static final float PORTRAIT_HEIGHT_SUBHEAD = 20.0f;
    private static final float PORTRAIT_HEIGHT_IMAGE = 180.0f;
    private static final float PORTRAIT_HEIGHT_TYPE = 35.0f;
    private static final float PORTRAIT_HEIGHT_PRICES = 35.0f;
    private static final float PORTRAIT_HEIGHT_CONTACT = 35.0f;
    private ResourceMap resourceMap;
    private Properties resources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PdfPTable buildTable(AgencyEstate agencyEstate, Rectangle rectangle) throws ImmoToolException, DocumentException, OpenEstateException {
        EstateAttachmentImpl[] estateAttachmentImplArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(OpenEstateUtils.getEstateTypePath((OpenEstateType)agencyEstate.getType())));
        float f = rectangle.getWidth();
        float f2 = f - 60.0f - 60.0f;
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setTotalWidth(f2);
        PdfPCell pdfPCell = null;
        int n = this.pdfSetup.getImageGallery() != null ? this.pdfSetup.getImageGallery() : 5;
        EstateAttachmentImpl[] estateAttachmentImplArray2 = estateAttachmentImplArray = n != -1 ? PdfExposeShortBuilder.getGalleryImages(agencyEstate, n) : new EstateAttachmentImpl[]{};
        if (this.pdfSetup.isLandscapeFormat()) {
            int n2;
            Float f3;
            PdfPTable pdfPTable2 = new PdfPTable(estateAttachmentImplArray.length > 0 ? 2 : 1);
            float f4 = f2;
            PdfPTable pdfPTable3 = null;
            if (estateAttachmentImplArray.length > 0) {
                int n3 = estateAttachmentImplArray.length == 1 ? 1 : PdfExposeShortBuilder.getGalleryColumnCount(n);
                int n4 = estateAttachmentImplArray.length == 1 ? 1 : PdfExposeShortBuilder.getGalleryRowCount(n);
                float f5 = f2 / 3.0f / (float)n4;
                float f6 = 330.0f / (float)n3 - 5.0f;
                pdfPTable3 = new PdfPTable(n4);
                f3 = null;
                n2 = 0;
                for (EstateAttachmentImpl estateAttachmentImpl : estateAttachmentImplArray) {
                    pdfPCell = null;
                    try {
                        Image image = this.writeEstateImage(agencyEstate.getIdNr(), estateAttachmentImpl, f5, f6, this.pdfSetup.getImageResolution());
                        Float f7 = Float.valueOf(image.getScaledWidth());
                        pdfPCell = this.writeEstateImageToCell(image, 1, 5);
                        pdfPCell.setFixedHeight(f6 + 5.0f);
                        if (f3 == null || f7.floatValue() > f3.floatValue()) {
                            f3 = f7;
                        }
                    }
                    finally {
                        if (pdfPCell == null) {
                            pdfPCell = new PdfPCell();
                            pdfPCell.setBorderWidth(0.0f);
                        }
                        pdfPTable3.addCell(pdfPCell);
                    }
                    ++n2;
                }
                while (n2 % n4 != 0) {
                    ++n2;
                    pdfPCell = new PdfPCell();
                    pdfPCell.setBorderWidth(0.0f);
                    pdfPTable3.addCell(pdfPCell);
                }
                if (f3 != null) {
                    float f8 = f3.floatValue() * (float)n4 + 10.0f;
                    pdfPTable2.setTotalWidth(new float[]{f2 - f8, f8});
                    f4 = f2 - f8;
                }
            }
            PdfPTable pdfPTable4 = this.createExpsoseHeadCityTable(agencyEstate, this.bodyHeadFgColor);
            PdfPTable pdfPTable5 = this.createExpsoseProvisionTable(agencyEstate, this.bodyTextFgColor, f4, 35.0f);
            PdfPTable pdfPTable6 = this.createExposeAttribsTopTable(agencyEstate, arrayList, this.bodyTextFgColor, f4, 35.0f);
            PdfPTable pdfPTable7 = this.createExposeAttribsBottomTable(agencyEstate, arrayList, this.bodyTextFgColor, f4, 35.0f);
            f3 = null;
            if (!this.pdfSetup.getContactPublishings().isEmpty()) {
                AgencyContact agencyContact = null;
                try {
                    String[] stringArray;
                    Long l;
                    String string = agencyEstate.getContactId();
                    if (string != null && string.trim().length() > 0 && (agencyContact = AgencyContact.loadContact(l = Long.valueOf((stringArray = string.split("\\."))[stringArray.length - 1]))) == null) {
                        LOGGER.warn((Object)("Can't load contact #" + l));
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't load contact!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                f3 = this.createExposeContactTable(agencyContact, this.agent, this.bodyTextFgColor, f4, 35.0f);
            }
            pdfPCell = new PdfPCell(this.createExpsoseHeadTable(agencyEstate, this.bodyHeadFgColor, f4, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(pdfPTable4 == null ? 1.0f : 0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(2.0f);
            pdfPCell.setColspan(pdfPTable2.getNumberOfColumns());
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable4 != null) {
                pdfPCell = new PdfPCell(pdfPTable4);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(1.0f);
                pdfPCell.setFixedHeight(20.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPCell.setColspan(pdfPTable2.getNumberOfColumns());
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseTypeTable(agencyEstate, this.bodyTextFgColor));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable3 != null) {
                pdfPTable3.setWidthPercentage(100.0f);
                pdfPCell = new PdfPCell();
                pdfPCell.setPadding(0.0f);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setFixedHeight(330.0f);
                pdfPCell.setHorizontalAlignment(2);
                pdfPCell.setVerticalAlignment(5);
                pdfPCell.addElement((Element)pdfPTable3);
                n2 = 3;
                if (pdfPTable5 != null) {
                    ++n2;
                }
                if (pdfPTable6 != null) {
                    ++n2;
                }
                if (pdfPTable7 != null) {
                    ++n2;
                }
                if (f3 != null) {
                    ++n2;
                }
                pdfPCell.setRowspan(n2);
                pdfPTable2.addCell(pdfPCell);
            }
            if (pdfPTable6 != null) {
                pdfPCell = new PdfPCell(pdfPTable6);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            float f9 = 275.0f;
            if (pdfPTable4 != null) {
                f9 -= 20.0f;
            }
            if (pdfPTable5 != null) {
                f9 -= 35.0f;
            }
            if (pdfPTable6 != null) {
                f9 -= 35.0f;
            }
            if (pdfPTable7 != null) {
                f9 -= 35.0f;
            }
            if (f3 != null) {
                f9 -= 35.0f;
            }
            pdfPCell = new PdfPCell(this.createExpsoseDescriptionTable(agencyEstate, this.bodyTextFgColor, f4, f9));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(2.0f);
            pdfPCell.setPaddingRight(2.0f);
            pdfPCell.setFixedHeight(f9);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable7 != null) {
                pdfPCell = new PdfPCell(pdfPTable7);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthTop(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseAttribsPriceTable(agencyEstate, this.bodyHeadFgColor, f4, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthTop(0.5f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable2.addCell(pdfPCell);
            if (pdfPTable5 != null) {
                pdfPCell = new PdfPCell(pdfPTable5);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            if (f3 != null) {
                pdfPCell = new PdfPCell((PdfPTable)f3);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable2.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(pdfPTable2);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPTable.addCell(pdfPCell);
        } else {
            AgencyContact agencyContact;
            PdfPTable pdfPTable8 = this.createExpsoseHeadCityTable(agencyEstate, this.bodyHeadFgColor);
            PdfPTable pdfPTable9 = this.createExpsoseProvisionTable(agencyEstate, this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable10 = this.createExposeAttribsTopTable(agencyEstate, arrayList, this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable11 = this.createExposeAttribsBottomTable(agencyEstate, arrayList, this.bodyTextFgColor, f2, 35.0f);
            PdfPTable pdfPTable12 = null;
            if (!this.pdfSetup.getContactPublishings().isEmpty()) {
                agencyContact = null;
                try {
                    String[] stringArray;
                    Long l;
                    String string = agencyEstate.getContactId();
                    if (string != null && string.trim().length() > 0 && (agencyContact = AgencyContact.loadContact(l = Long.valueOf((stringArray = string.split("\\."))[stringArray.length - 1]))) == null) {
                        LOGGER.warn((Object)("Can't load contact #" + l));
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't load contact!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                pdfPTable12 = this.createExposeContactTable(agencyContact, this.agent, this.bodyTextFgColor, f2, 35.0f);
            }
            pdfPCell = new PdfPCell(this.createExpsoseHeadTable(agencyEstate, this.bodyHeadFgColor, f2, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(pdfPTable8 == null ? 1.0f : 0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingTop(2.0f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable8 != null) {
                pdfPCell = new PdfPCell(pdfPTable8);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(1.0f);
                pdfPCell.setFixedHeight(20.0f);
                pdfPCell.setPadding(0.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            agencyContact = null;
            float f10 = 0.0f;
            float f11 = 0.0f;
            if (estateAttachmentImplArray.length > 0) {
                int n5 = estateAttachmentImplArray.length == 1 ? 1 : PdfExposeShortBuilder.getGalleryRowCount(n);
                int n6 = estateAttachmentImplArray.length == 1 ? 1 : PdfExposeShortBuilder.getGalleryColumnCount(n);
                float f12 = f2 / (float)n6 - 10.0f;
                float f13 = 180.0f / (float)n5 - 10.0f;
                agencyContact = new PdfPTable(n6);
                int n7 = 0;
                for (EstateAttachmentImpl estateAttachmentImpl : estateAttachmentImplArray) {
                    pdfPCell = null;
                    try {
                        Image image = this.writeEstateImage(agencyEstate.getIdNr(), estateAttachmentImpl, f12, f13, this.pdfSetup.getImageResolution());
                        Float f14 = Float.valueOf(image.getScaledWidth());
                        pdfPCell = this.writeEstateImageToCell(image, 1, 5);
                        pdfPCell.setFixedHeight(f13 + 5.0f);
                    }
                    finally {
                        if (pdfPCell == null) {
                            pdfPCell = new PdfPCell();
                        }
                        agencyContact.addCell(pdfPCell);
                    }
                    ++n7;
                }
                while (n7 % n6 != 0) {
                    ++n7;
                    pdfPCell = new PdfPCell();
                    pdfPCell.setBorderWidth(0.0f);
                    agencyContact.addCell(pdfPCell);
                }
            }
            if (agencyContact != null) {
                agencyContact.setWidthPercentage(100.0f);
                pdfPCell = new PdfPCell();
                pdfPCell.setPadding(0.0f);
                pdfPCell.setPaddingLeft(f10);
                pdfPCell.setPaddingRight(f11);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setFixedHeight(180.0f);
                pdfPCell.setHorizontalAlignment(1);
                pdfPCell.setVerticalAlignment(5);
                pdfPCell.addElement((Element)agencyContact);
                pdfPTable.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseTypeTable(agencyEstate, this.bodyTextFgColor));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable10 != null) {
                pdfPCell = new PdfPCell(pdfPTable10);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            float f15 = 350.0f;
            if (agencyContact == null) {
                f15 += 180.0f;
            }
            if (pdfPTable8 != null) {
                f15 -= 20.0f;
            }
            if (pdfPTable9 != null) {
                f15 -= 35.0f;
            }
            if (pdfPTable10 != null) {
                f15 -= 35.0f;
            }
            if (pdfPTable11 != null) {
                f15 -= 35.0f;
            }
            if (pdfPTable12 != null) {
                f15 -= 35.0f;
            }
            pdfPCell = new PdfPCell(this.createExpsoseDescriptionTable(agencyEstate, this.bodyTextFgColor, f2, f15));
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(0.0f);
            pdfPCell.setPaddingLeft(2.0f);
            pdfPCell.setPaddingRight(2.0f);
            pdfPCell.setFixedHeight(f15);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable11 != null) {
                pdfPCell = new PdfPCell(pdfPTable11);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthTop(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            pdfPCell = new PdfPCell(this.createExpsoseAttribsPriceTable(agencyEstate, this.bodyHeadFgColor, f2, 35.0f));
            pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
            pdfPCell.setBorderColor(this.borderColor);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBorderWidthTop(0.5f);
            pdfPCell.setBorderWidthBottom(0.5f);
            pdfPCell.setFixedHeight(35.0f);
            pdfPCell.setPaddingBottom(1.5f);
            pdfPTable.addCell(pdfPCell);
            if (pdfPTable9 != null) {
                pdfPCell = new PdfPCell(pdfPTable9);
                pdfPCell.setBackgroundColor(this.bodyTextBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
            if (pdfPTable12 != null) {
                pdfPCell = new PdfPCell(pdfPTable12);
                pdfPCell.setBackgroundColor(this.bodyHeadBgColor);
                pdfPCell.setBorderColor(this.borderColor);
                pdfPCell.setBorderWidth(0.0f);
                pdfPCell.setBorderWidthBottom(0.5f);
                pdfPCell.setFixedHeight(35.0f);
                pdfPCell.setPaddingBottom(1.5f);
                pdfPTable.addCell(pdfPCell);
            }
        }
        return pdfPTable;
    }

    protected PdfPTable createExposeAttribsBottomTable(AgencyEstate agencyEstate, List<String> list, Color color, float f, float f2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        String string;
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH3);
        font2.setColor(color);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.contains("MAIN_GEWERBE")) {
            arrayList.add("AUSSTATTUNG.HEIZUNGSART");
            arrayList.add("AUSSTATTUNG.BODENBELAG");
            arrayList.add("VERWALTUNG.RAEUME_VERAENDERBAR");
            arrayList.add("AUSSTATTUNG.KELLER");
            arrayList.add("UMFELD.LAGE_GEBIET");
        } else if (list.contains("MAIN_GRUND")) {
            arrayList.add("VERWALTUNG.ZUGANG_AB");
            arrayList.add("VERWALTUNG.BEBAUBAR_KURZ");
            arrayList.add("VERWALTUNG.BEBAUBAR_MIT");
            arrayList.add("VERWALTUNG.GEWERBLICHE_NUTZUNG");
            arrayList.add("VERWALTUNG.ABRISS");
            arrayList.add("AUSSTATTUNG.BAUMBESTAND");
            arrayList.add("UMFELD.LAGE_GEBIET");
        } else if (list.contains("MAIN_LANDWIRTSCHAFT")) {
            arrayList.add("VERWALTUNG.ABRISS");
            arrayList.add("UMFELD.UMFELD_VON");
            arrayList.add("UMFELD.DISTANZ_BUS");
            arrayList.add("UMFELD.DISTANZ_NAHBHF");
            arrayList.add("UMFELD.DISTANZ_BHF");
            arrayList.add("UMFELD.DISTANZ_AUTOBAHN");
            arrayList.add("UMFELD.DISTANZ_FLUG");
        } else if (list.contains("MAIN_STELLPLATZ")) {
            arrayList.add("AUSSTATTUNG.BELEUCHTET");
            arrayList.add("AUSSTATTUNG.EIGNUNG");
            arrayList.add("AUSSTATTUNG.SICHERHEITSTECHNIK");
            arrayList.add("VERWALTUNG.ZUGANG_AB");
        } else if (list.contains("MAIN_WOHNEN")) {
            arrayList.add("PREISE.HAUSGELD");
            arrayList.add("AUSSTATTUNG.HEIZUNGSART");
            arrayList.add("FLAECHEN.STELLPLATZART");
            arrayList.add("AUSSTATTUNG.MOEBLIERT");
            arrayList.add("VERWALTUNG.HAUSTIERE");
            arrayList.add("AUSSTATTUNG.GARTENNUTZUNG");
            arrayList.add("VERWALTUNG.ALS_FERIEN");
            arrayList.add("AUSSTATTUNG.BALKON_TERRASSE");
            arrayList.add("AUSSTATTUNG.AUSSTATTUNG_ART");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (linkedHashMap.size() < 3 && (string = PdfExposeShortBuilder.pickAttribute(agencyEstate, arrayList, stringBuilder2 = new StringBuilder(), stringBuilder = new StringBuilder(), this.getOpenEstateLocale())) != null) {
            arrayList.remove(string);
            linkedHashMap.put(stringBuilder2.toString().trim(), stringBuilder.toString().trim());
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        stringBuilder2 = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = StringUtils.abbreviate((String)((String)entry.getValue()), (int)(linkedHashMap.size() * 150));
            Font font3 = PdfExposeShortBuilder.getMatchingFont(string3, f3, f4, font2, 1.0f);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string2, font));
            Paragraph paragraph = new Paragraph(string3, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            stringBuilder2.addCell(pdfPCell);
        }
        return stringBuilder2;
    }

    protected PdfPTable createExpsoseAttribsPriceTable(AgencyEstate agencyEstate, Color color, float f, float f2) throws ImmoToolException {
        Font font;
        String string;
        Font font2 = new Font(this.bodyFontSmall);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontH3);
        font3.setColor(color);
        Font font4 = new Font(this.bodyFontNormal);
        font4.setColor(color);
        Paragraph paragraph = null;
        PdfPCell pdfPCell = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if ("ERBPACHT".equals(agencyEstate.getAction()) || "PACHT".equals(agencyEstate.getAction())) {
            arrayList.add("PREISE.PACHT");
            arrayList2.add("PREISE.PACHT_QM");
        } else if ("KAUF".equals(agencyEstate.getAction())) {
            arrayList.add("PREISE.KAUFPREIS");
            arrayList2.add("PREISE.KAUFPREIS_QM");
            arrayList2.add("PREISE.MIETEINNAHMEN_PRO_MONAT");
            arrayList3.add("PREISE.STELLPLATZ_PREIS");
        } else if ("MIETE".equals(agencyEstate.getAction())) {
            arrayList.add("PREISE.KALTMIETE");
            arrayList.add("PREISE.WARMMIETE");
            arrayList2.add("PREISE.NEBENKOSTEN");
            arrayList2.add("PREISE.KALTMIETE_QM");
            arrayList2.add("PREISE.WARMMIETE_QM");
            arrayList3.add("PREISE.STELLPLATZ_MIETE");
        } else if ("WAZ".equals(agencyEstate.getAction())) {
            arrayList.add("PREISE.PAUSCHALMIETE");
            arrayList.add("PREISE.KALTMIETE");
            arrayList.add("PREISE.WARMMIETE");
            arrayList2.add("PREISE.MIETE_PRO");
            arrayList2.add("PREISE.KALTMIETE_QM");
            arrayList2.add("PREISE.WARMMIETE_QM");
            arrayList3.add("PREISE.STELLPLATZ_MIETE");
        } else {
            throw new ImmoToolException("unsupported estate-action: " + agencyEstate.getAction() + "!");
        }
        arrayList3.add("PREISE.KAUTION");
        arrayList3.add("PREISE.KAUTION_BETRAG");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = PdfExposeShortBuilder.pickAttribute(agencyEstate, arrayList.toArray(new String[arrayList.size()]), stringBuilder, stringBuilder2, this.getOpenEstateLocale());
        StringBuilder stringBuilder3 = new StringBuilder();
        StringBuilder stringBuilder4 = new StringBuilder();
        String string3 = PdfExposeShortBuilder.pickAttribute(agencyEstate, arrayList2.toArray(new String[arrayList2.size()]), stringBuilder3, stringBuilder4, this.getOpenEstateLocale());
        StringBuilder stringBuilder5 = new StringBuilder();
        StringBuilder stringBuilder6 = new StringBuilder();
        String string4 = PdfExposeShortBuilder.pickAttribute(agencyEstate, arrayList3.toArray(new String[arrayList3.size()]), stringBuilder5, stringBuilder6, this.getOpenEstateLocale());
        PdfPTable pdfPTable = new PdfPTable(string4 != null ? 3 : (string3 != null ? 2 : 1));
        float f3 = f / (float)pdfPTable.getNumberOfColumns() - 4.0f;
        float f4 = f2 - font2.getSize() - 5.0f;
        if (pdfPTable.getNumberOfColumns() >= 1) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (string2 != null) {
                string = stringBuilder2.toString().trim();
                font = PdfExposeShortBuilder.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        if (pdfPTable.getNumberOfColumns() >= 2) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (string3 != null) {
                string = stringBuilder4.toString().trim();
                font = PdfExposeShortBuilder.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder3.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        if (pdfPTable.getNumberOfColumns() >= 3) {
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            if (string4 != null) {
                string = stringBuilder6.toString().trim();
                font = PdfExposeShortBuilder.getMatchingFont(string, f3, f4, font3, 1.0f);
                pdfPCell.addElement((Element)new Paragraph(font2.getSize(), stringBuilder5.toString(), font2));
                paragraph = new Paragraph(string, font);
                paragraph.setAlignment(0);
                paragraph.setMultipliedLeading(1.0f);
                pdfPCell.addElement((Element)paragraph);
            }
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    protected PdfPTable createExposeAttribsTopTable(AgencyEstate agencyEstate, List<String> list, Color color, float f, float f2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        String string;
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH3);
        font2.setColor(color);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list.contains("MAIN_GEWERBE")) {
            arrayList.add("FLAECHEN.GEWERBEFLAECHE");
            arrayList.add("ZUSTAND.BAUJAHR");
            arrayList.add("ZUSTAND.ZUSTAND");
            arrayList.add("UMFELD.LAGE_GEBIET");
            arrayList.add("VERWALTUNG.NUTZUNGSART");
        } else if (list.contains("MAIN_GRUND")) {
            arrayList.add("FLAECHEN.GRUNDSTUECKSFLAECHE");
            arrayList.add("ZUSTAND.ERSCHLIESSUNG");
            arrayList.add("VERWALTUNG.BAUGENEHMIGUNG");
            arrayList.add("VERWALTUNG.NUTZUNGSART");
        } else if (list.contains("MAIN_LANDWIRTSCHAFT")) {
            arrayList.add("FLAECHEN.GESAMTFLAECHE");
            arrayList.add("VERWALTUNG.NUTZUNGSART");
            arrayList.add("VERWALTUNG.ZUGANG_AB");
        } else if (list.contains("MAIN_STELLPLATZ")) {
            arrayList.add("FLAECHEN.STELLPLATZFLAECHE");
            arrayList.add("FLAECHEN.BREITE");
            arrayList.add("FLAECHEN.LAENGE");
            arrayList.add("FLAECHEN.HOEHE");
        } else if (list.contains("MAIN_WOHNEN")) {
            if ("it".equalsIgnoreCase(agencyEstate.getAdress().getCountry()) && agencyEstate.hasAttribute("FLAECHEN", "BRUTTOFLAECHE")) {
                arrayList.add("FLAECHEN.BRUTTOFLAECHE");
            } else {
                arrayList.add("FLAECHEN.WOHNFLAECHE");
            }
            arrayList.add("FLAECHEN.ANZ_ZIMMER");
            arrayList.add("AUSSTATTUNG.ETAGE");
            arrayList.add("AUSSTATTUNG.ETAGE_GESAMT");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (linkedHashMap.size() < 3 && (string = PdfExposeShortBuilder.pickAttribute(agencyEstate, arrayList, stringBuilder2 = new StringBuilder(), stringBuilder = new StringBuilder(), this.getOpenEstateLocale())) != null) {
            arrayList.remove(string);
            linkedHashMap.put(stringBuilder2.toString().trim(), stringBuilder.toString().trim());
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        stringBuilder2 = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = StringUtils.abbreviate((String)((String)entry.getValue()), (int)(linkedHashMap.size() * 150));
            Font font3 = PdfExposeShortBuilder.getMatchingFont(string3, f3, f4, font2, 1.0f);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string2, font));
            Paragraph paragraph = new Paragraph(string3, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            stringBuilder2.addCell(pdfPCell);
        }
        return stringBuilder2;
    }

    protected PdfPTable createExposeContactTable(AgencyContact agencyContact, AgencyAgent agencyAgent, Color color, float f, float f2) {
        String string;
        AgencyContact agencyContact2;
        AgencyContact agencyContact3 = agencyContact2 = agencyContact != null ? agencyContact : agencyAgent.getCompany();
        if (agencyContact2 == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontNormal);
        font2.setColor(color);
        if (agencyContact != null && this.pdfSetup.isContactPublished(0) && !StringUtils.isBlank((String)(string = agencyContact.getPersonLastName()))) {
            String string2 = this.resources.getProperty("label.contact.name");
            if ("FEMALE".equals(agencyContact.getPersonGender())) {
                string2 = string2 + " " + this.resources.getProperty("label.contact.name.female");
            } else if ("MALE".equals(agencyContact.getPersonGender())) {
                string2 = string2 + " " + this.resources.getProperty("label.contact.name.male");
            }
            linkedHashMap.put(string2.trim(), string.trim());
        }
        if (this.pdfSetup.isContactPublished(1)) {
            string = agencyContact2.getPersonPhone();
            if (StringUtils.isBlank((String)string)) {
                string = agencyContact2.getPersonMobilePhone();
            }
            if (StringUtils.isBlank((String)string)) {
                string = agencyAgent.getCompany().getCompanyPhone();
            }
            if (!StringUtils.isBlank((String)string)) {
                linkedHashMap.put(this.resources.getProperty("label.contact.phone"), string.trim());
            }
        }
        if (this.pdfSetup.isContactPublished(2)) {
            string = agencyContact2.getPersonFax();
            if (StringUtils.isBlank((String)string)) {
                string = agencyAgent.getCompany().getCompanyFax();
            }
            if (!StringUtils.isBlank((String)string)) {
                linkedHashMap.put(this.resources.getProperty("label.contact.fax"), string.trim());
            }
        }
        if (this.pdfSetup.isContactPublished(3)) {
            string = agencyContact2.getPersonMail();
            if (StringUtils.isBlank((String)string)) {
                string = agencyAgent.getCompany().getCompanyMail();
            }
            if (!StringUtils.isBlank((String)string)) {
                linkedHashMap.put(this.resources.getProperty("label.contact.mail"), string.trim());
            }
        }
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        string = new PdfPTable(linkedHashMap.size());
        float f3 = f / (float)linkedHashMap.size() - 4.0f;
        float f4 = f2 - font.getSize() - 5.0f;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            char[] cArray;
            String string3 = (String)entry.getKey();
            String string4 = (String)entry.getValue();
            if (string4.contains("@")) {
                char[] cArray2 = new char[2];
                cArray2[0] = 45;
                cArray = cArray2;
                cArray2[1] = 64;
            } else {
                char[] cArray3 = new char[1];
                cArray = cArray3;
                cArray3[0] = 45;
            }
            char[] cArray4 = cArray;
            Font font3 = PdfExposeShortBuilder.getMatchingFont(string4, f3, f4, font2, 1.0f, cArray4);
            PdfPCell pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            pdfPCell.addElement((Element)new Paragraph(font.getSize(), string3, font));
            Paragraph paragraph = new Paragraph(string4, font3);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            if (string4.contains("@")) {
                DefaultSplitCharacter defaultSplitCharacter = new DefaultSplitCharacter(){

                    public boolean isSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
                        char c = this.getCurrentCharacter(n2, cArray, pdfChunkArray);
                        if (c == '@') {
                            return true;
                        }
                        return super.isSplitCharacter(n, n2, n3, cArray, pdfChunkArray);
                    }
                };
                ((Chunk)paragraph.getChunks().get(0)).setSplitCharacter((SplitCharacter)defaultSplitCharacter);
            }
            pdfPCell.addElement((Element)paragraph);
            string.addCell(pdfPCell);
        }
        return string;
    }

    protected PdfPTable createExpsoseDescriptionTable(AgencyEstate agencyEstate, Color color, float f, float f2) {
        String string3;
        Font font = new Font(this.bodyFontNormal);
        font.setColor(color);
        Paragraph paragraph = new Paragraph[]{"FREITEXTE.KURZ_BESCHR", "FREITEXTE.OBJEKT_BESCHR", "FREITEXTE.AUSSTATT_BESCHR"};
        String string2 = "";
        for (String string3 : paragraph) {
            String string4;
            if (!agencyEstate.hasAttribute(string3) || StringUtils.isBlank((String)(string4 = agencyEstate.getAttribute(string3).writeValue(this.getOpenEstateLocale())))) continue;
            string2 = StringUtils.abbreviate((String)string4.trim(), (int)1500);
            break;
        }
        Paragraph paragraph2 = null;
        PdfPCell pdfPCell = null;
        PdfPTable pdfPTable = new PdfPTable(1);
        string3 = PdfExposeShortBuilder.getMatchingFont(string2, f, f2 - 10.0f, font, 1.2f);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        paragraph2 = new Paragraph(string2, (Font)string3);
        paragraph2.setMultipliedLeading(1.2f);
        switch (this.pdfSetup.getBodyTextAlignment()) {
            case 1: {
                paragraph2.setAlignment(1);
                break;
            }
            case 3: {
                paragraph2.setAlignment(3);
                break;
            }
            case 0: {
                paragraph2.setAlignment(0);
                break;
            }
            case 2: {
                paragraph2.setAlignment(2);
                break;
            }
            default: {
                paragraph2.setAlignment(3);
            }
        }
        pdfPCell.addElement((Element)paragraph2);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseHeadTable(AgencyEstate agencyEstate, Color color, float f, float f2) throws DocumentException {
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH2);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontNormal);
        font3.setColor(color);
        String string = StringUtils.trimToNull((String)agencyEstate.getTitle(this.getOpenEstateLocale().getLanguage()));
        if (string == null) {
            string = StringUtils.trimToEmpty((String)agencyEstate.getFallbackTitle(this.getOpenEstateLocale()));
        }
        String string2 = agencyEstate.getPublicId() != null && agencyEstate.getPublicId().trim().length() > 0 ? agencyEstate.getPublicId() : "#" + agencyEstate.getIdNr();
        Paragraph paragraph = null;
        PdfPCell pdfPCell = null;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setWidths(new int[]{70, 30});
        float f3 = f * 0.7f - 4.0f;
        Font font4 = PdfExposeShortBuilder.getMatchingFont(string, f3, f2 - 3.0f, font2, 1.2f);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingLeft(2.0f);
        pdfPCell.setPaddingRight(2.0f);
        pdfPCell.setVerticalAlignment(5);
        paragraph = new Paragraph(string, font4);
        paragraph.setAlignment(0);
        paragraph.setMultipliedLeading(1.2f);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setPadding(0.0f);
        pdfPCell.setPaddingLeft(2.0f);
        pdfPCell.setPaddingRight(2.0f);
        pdfPCell.setVerticalAlignment(5);
        paragraph = new Paragraph(this.resources.getProperty("label.estateNr", "???"), font);
        paragraph.setAlignment(2);
        pdfPCell.addElement((Element)paragraph);
        paragraph = new Paragraph(string2, font3);
        paragraph.setAlignment(2);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseHeadCityTable(AgencyEstate agencyEstate, Color color) throws DocumentException {
        String string;
        String string2;
        int n;
        String string3;
        String string4 = StringUtils.trimToNull((String)agencyEstate.getAdress().getCity());
        if (string4 == null) {
            return null;
        }
        String string5 = StringUtils.trimToNull((String)agencyEstate.getAdress().getPostalCode());
        if (string5 != null) {
            string4 = string5 + " " + string4;
        }
        if ((string3 = StringUtils.trimToNull((String)agencyEstate.getAdress().getCityPart())) != null) {
            string4 = string4 + " / " + string3;
        }
        if (((n = this.pdfSetup.getAddressPublishing()) == 2 || n == 0 && agencyEstate.isAdressPublished()) && (string2 = StringUtils.trimToNull((String)agencyEstate.getAdress().getStreet())) != null) {
            string = StringUtils.trimToNull((String)agencyEstate.getAdress().getStreetNr());
            if (string != null) {
                string2 = string2 + " " + string;
            }
            string4 = string2 + " / " + string4;
        }
        string2 = null;
        string = null;
        PdfPTable pdfPTable = new PdfPTable(1);
        Font font = new Font(this.bodyFontNormal);
        font.setColor(color);
        string = new PdfPCell();
        string.setBorderWidth(0.0f);
        string.setPadding(0.0f);
        string.setVerticalAlignment(5);
        string2 = new Paragraph(string4, font);
        string2.setAlignment(0);
        string.addElement((Element)string2);
        pdfPTable.addCell((PdfPCell)string);
        return pdfPTable;
    }

    protected PdfPTable createExpsoseProvisionTable(AgencyEstate agencyEstate, Color color, float f, float f2) throws DocumentException {
        PdfPCell pdfPCell;
        Paragraph paragraph;
        Font font;
        String string;
        String string2;
        ValueImpl valueImpl;
        float f3;
        Font font2 = new Font(this.bodyFontNormal);
        font2.setColor(color);
        Font font3 = new Font(this.bodyFontSmall);
        font3.setColor(color);
        boolean bl = agencyEstate.hasAttribute("PREISE.COURTAGE_AUSSEN");
        boolean bl2 = agencyEstate.hasAttribute("PREISE.COURTAGE_AUSSEN_TAX");
        if (!bl) {
            return null;
        }
        PdfPTable pdfPTable = new PdfPTable(!bl2 ? 1 : 2);
        if (pdfPTable.getNumberOfColumns() == 2) {
            pdfPTable.setWidths(new int[]{67, 33});
        }
        float f4 = f2 - font3.getSize() - 5.0f;
        if (bl) {
            f3 = pdfPTable.getNumberOfColumns() == 2 ? f * 0.67f - 4.0f : f - 4.0f;
            valueImpl = agencyEstate.getAttribute("PREISE.COURTAGE_AUSSEN");
            string2 = OpenEstateUtils.translateAttribute((String)valueImpl.getGroupName(), (String)valueImpl.getAttribName(), (Locale)this.getOpenEstateLocale());
            string = agencyEstate.writeValue(valueImpl, this.getOpenEstateLocale());
            font = PdfExposeShortBuilder.getMatchingFont(string, f3, f4, font2, 1.0f);
            paragraph = null;
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            paragraph = new Paragraph(font3.getSize(), string2, font3);
            paragraph.setAlignment(0);
            pdfPCell.addElement((Element)paragraph);
            paragraph = new Paragraph(string, font);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            pdfPTable.addCell(pdfPCell);
        }
        if (bl2) {
            f3 = pdfPTable.getNumberOfColumns() == 2 ? f * 0.33f - 4.0f : f - 4.0f;
            valueImpl = agencyEstate.getAttribute("PREISE.COURTAGE_AUSSEN_TAX");
            string2 = OpenEstateUtils.translateAttribute((String)valueImpl.getGroupName(), (String)valueImpl.getAttribName(), (Locale)this.getOpenEstateLocale());
            string = agencyEstate.writeValue(valueImpl, this.getOpenEstateLocale());
            font = PdfExposeShortBuilder.getMatchingFont(string, f3, f4, font2, 1.0f);
            paragraph = null;
            pdfPCell = new PdfPCell();
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setPadding(2.0f);
            pdfPCell.setVerticalAlignment(5);
            paragraph = new Paragraph(font3.getSize(), string2, font3);
            paragraph.setAlignment(0);
            pdfPCell.addElement((Element)paragraph);
            paragraph = new Paragraph(string, font);
            paragraph.setAlignment(0);
            paragraph.setMultipliedLeading(1.0f);
            pdfPCell.addElement((Element)paragraph);
            pdfPTable.addCell(pdfPCell);
        }
        return pdfPTable;
    }

    protected PdfPTable createExpsoseTypeTable(AgencyEstate agencyEstate, Color color) throws DocumentException {
        Font font = new Font(this.bodyFontSmall);
        font.setColor(color);
        Font font2 = new Font(this.bodyFontH2);
        font2.setColor(color);
        OpenEstateType openEstateType = agencyEstate.getType();
        String string = openEstateType != null ? OpenEstateUtils.translateEstate((String)openEstateType.getName(), (Locale)this.getOpenEstateLocale()) : this.resources.getProperty("label.undefined", "???");
        String string2 = agencyEstate.getAction() != null && agencyEstate.getAction().trim().length() > 0 ? OpenEstateUtils.translateAction((String)agencyEstate.getAction(), (Locale)this.getOpenEstateLocale()) : this.resources.getProperty("label.undefined", "???");
        Paragraph paragraph = null;
        PdfPCell pdfPCell = null;
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPCell = new PdfPCell();
        pdfPCell.setBorderWidth(0.0f);
        pdfPCell.setVerticalAlignment(6);
        pdfPCell.addElement((Element)new Paragraph(font.getSize() + 4.0f, this.resources.getProperty("label.estateType", "???") + " / " + this.resources.getProperty("label.estateAction", "???"), font));
        paragraph = new Paragraph(string + " / " + string2, font2);
        paragraph.setMultipliedLeading(1.0f);
        pdfPCell.addElement((Element)paragraph);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    @Override
    public AgencySetupPdfFormPanel createSetupPanel() {
        return new AgencySetupPdfFormShortPanel();
    }

    @Override
    public ImmoToolTask<File> createTask(final AgencyEstate agencyEstate, final File file, final boolean bl) {
        return new ImmoToolTask<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected File executeTask() throws Exception {
                File file5 = AgencyPlugin.getLastExportLocation();
                File file2 = file;
                FileOutputStream fileOutputStream = null;
                try {
                    Serializable serializable;
                    if (file2 == null) {
                        if (bl) {
                            throw new Exception("no output-file provided!");
                        }
                        serializable = new JFileChooser();
                        ((JFileChooser)serializable).setDialogTitle(PdfExposeShortBuilder.this.resourceMap.getString("message.saveExpose", new Object[0]));
                        String string = agencyEstate.getPublicId();
                        if (string == null || string.trim().length() == 0) {
                            string = String.valueOf(agencyEstate.getIdNr());
                        }
                        string = string.replaceAll("[^\\w\\-\\.]", "_");
                        while (string.contains("__")) {
                            string = string.replace("__", "_");
                        }
                        String string2 = new Formatter().format(PdfExposeShortBuilder.this.resources.getProperty("message.saveExpose.defaultFile", "???"), string).toString();
                        if (file5 != null) {
                            ((JFileChooser)serializable).setSelectedFile(new File(file5.getAbsolutePath() + File.separator + string2));
                        } else {
                            ((JFileChooser)serializable).setSelectedFile(new File(string2));
                        }
                        ((JFileChooser)serializable).setFileFilter(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.isDirectory() || file.getName().toLowerCase().endsWith(".pdf");
                            }

                            @Override
                            public String getDescription() {
                                return PdfExposeShortBuilder.this.resourceMap.getString("message.saveExpose.files", new Object[]{"*.pdf"});
                            }
                        });
                        int n = ((JFileChooser)serializable).showSaveDialog(null);
                        if (n != 0) {
                            File file3 = null;
                            return file3;
                        }
                        file2 = ((JFileChooser)serializable).getSelectedFile();
                        AgencyPlugin.setLastExportLocation(file2.getParentFile());
                        if (file2.exists() && !ImmoToolUtils.showQuestionDialog((String)PdfExposeShortBuilder.this.resourceMap.getString("question.overwriteExistingFile", new Object[0]))) {
                            File file4 = null;
                            return file4;
                        }
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    PdfExposeShortBuilder.this.generatePdf(agencyEstate, fileOutputStream);
                    fileOutputStream.flush();
                    serializable = file2;
                    return serializable;
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)PdfExposeShortBuilder.this.resourceMap.getString("error.cantSavePdf", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(File file2) {
                super.succeeded((Object)file2);
                if (file2 != null && !bl) {
                    ImmoToolUtils.showMessageInfoDialog((String)PdfExposeShortBuilder.this.resourceMap.getString("message.saveExpose.success", new Object[]{file2.getAbsolutePath()}));
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void generatePdf(AgencyEstate agencyEstate, OutputStream outputStream) throws ImmoToolException {
        if (this.pdfSetup.isTemplateUsed()) {
            InputStream inputStream;
            block7: {
                inputStream = null;
                try {
                    File file = this.pdfSetup.getTemporaryTemplate();
                    if (file != null && !file.isFile()) {
                        LOGGER.warn((Object)"Can't find temporary pdf-template!");
                        LOGGER.warn((Object)("> " + file.getAbsolutePath()));
                        file = null;
                    }
                    InputStream inputStream2 = inputStream = file != null ? new FileInputStream(file) : PdfSetup.loadTemplateAsStream(this.pdfSetup.getId());
                    if (inputStream == null) {
                        LOGGER.warn((Object)"Can't read expose-template!");
                        break block7;
                    }
                    this.generatePdf(agencyEstate, inputStream, outputStream);
                }
                catch (Exception exception) {
                    try {
                        LOGGER.warn((Object)"Can't open expose-template!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        this.generatePdf(agencyEstate, this.pdfSetup.isLandscapeFormat() ? PageSize.A4.rotate() : PageSize.A4, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generatePdf(AgencyEstate agencyEstate, InputStream inputStream, OutputStream outputStream) throws IOException, ImmoToolException {
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(inputStream);
            this.generatePdf(agencyEstate, pdfReader, pdfReader.getPageSize(1), outputStream);
        }
        finally {
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    public final void generatePdf(AgencyEstate agencyEstate, Rectangle rectangle, OutputStream outputStream) throws ImmoToolException {
        this.generatePdf(agencyEstate, null, rectangle, outputStream);
    }

    protected void generatePdf(AgencyEstate agencyEstate, PdfReader pdfReader, Rectangle rectangle, OutputStream outputStream) throws ImmoToolException {
        String string = agencyEstate.getTitle(this.getOpenEstateLocale().getLanguage());
        if (string == null || string.trim().length() == 0) {
            string = agencyEstate.getFallbackTitle(this.getOpenEstateLocale());
        }
        try {
            String string2;
            float f = rectangle.getWidth();
            float f2 = rectangle.getHeight();
            Document document = new Document(new Rectangle(f, f2));
            PdfPTable pdfPTable = this.buildTable(agencyEstate, rectangle);
            if (pdfPTable.getNumberOfColumns() == 2) {
                pdfPTable.setWidths(new float[]{pdfPTable.getTotalWidth() * 0.65f, pdfPTable.getTotalWidth() * 0.35f});
            }
            this.generateTable(document, pdfPTable, pdfReader, rectangle, outputStream);
            document.addAuthor(this.agent != null ? this.agent.getCompany().getCompanyName() : "");
            document.addCreationDate();
            document.addCreator(ImmoToolApp.getApplicationTitle() + " v" + ImmoToolApp.getApplicationVersion());
            document.addProducer();
            document.addSubject(new Formatter().format(this.resources.getProperty("subject", "???"), agencyEstate.getIdNr()).toString());
            document.addTitle(string);
            String string3 = "FREITEXTE.KEYWORDS";
            if (agencyEstate.hasAttribute(string3) && (string2 = (String)agencyEstate.getAttribute(string3).getValueObject(this.getOpenEstateLocale())) != null) {
                document.addKeywords(string2.trim());
            }
            document.close();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not generate pdf-expose!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new ImmoToolException("could not generate pdf-expose: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private static int getGalleryColumnCount(Integer n) {
        if (n == null) {
            return 0;
        }
        switch (n) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                return 2;
            }
            case 6: 
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    private static EstateAttachmentImpl[] getGalleryImages(AgencyEstate agencyEstate, Integer n) {
        int n2;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object2 : agencyEstate.getAttachments()) {
            if (!object2.isName() || !object2.isPublished() || !"image/bmp".equalsIgnoreCase(object2.getMimeType()) && !"image/jpeg".equalsIgnoreCase(object2.getMimeType()) && !"image/png".equalsIgnoreCase(object2.getMimeType())) continue;
            int n3 = n2 = "IMAGE_GROUNDPLAN".equals(object2.getType()) || "IMAGE_MAP".equals(object2.getType()) ? 1 : 0;
            if (n2 != 0) {
                arrayList2.add(object2);
                continue;
            }
            arrayList.add(object2);
        }
        int n4 = 0;
        object2 = new ArrayList();
        switch (n) {
            case 1: {
                n4 = 1;
                if (arrayList.size() <= 0) break;
                object2.add(arrayList.get(0));
                break;
            }
            case 2: {
                n4 = 1;
                if (arrayList2.size() <= 0) break;
                object2.add(arrayList2.get(0));
                break;
            }
            case 5: {
                n4 = 2;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (arrayList.size() <= n2) continue;
                    object2.add(arrayList.get(n2));
                }
                break;
            }
            case 3: {
                n4 = 2;
                if (arrayList.size() > 0) {
                    object2.add(arrayList.get(0));
                }
                if (arrayList2.size() <= 0) break;
                object2.add(arrayList2.get(0));
                break;
            }
            case 4: {
                n4 = 2;
                if (arrayList2.size() > 0) {
                    object2.add(arrayList2.get(0));
                }
                if (arrayList.size() <= 0) break;
                object2.add(arrayList.get(0));
                break;
            }
            case 6: {
                n4 = 3;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (arrayList.size() <= n2) continue;
                    object2.add(arrayList.get(n2));
                }
                break;
            }
            case 7: {
                n4 = 4;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (arrayList.size() <= n2) continue;
                    object2.add(arrayList.get(n2));
                }
                break;
            }
            case 8: {
                n4 = 6;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (arrayList.size() <= n2) continue;
                    object2.add(arrayList.get(n2));
                }
                break;
            }
        }
        if (n4 <= 0) {
            return new EstateAttachmentImpl[0];
        }
        return object2.toArray(new EstateAttachmentImpl[object2.size()]);
    }

    private static int getGalleryRowCount(Integer n) {
        if (n == null) {
            return 0;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getTitle() {
        return ImmoToolUtils.getResourceMap(PdfExposeShortBuilder.class).getString("title", new Object[0]);
    }

    @Override
    protected boolean isFooterPageNumberPrinted() {
        return false;
    }

    @Override
    public void load(PdfSetup pdfSetup) {
        super.load(pdfSetup);
        if (!NAME.equals(pdfSetup.getBuilder())) {
            throw new IllegalArgumentException("invalid pdf-setup!");
        }
        this.resourceMap = ImmoToolUtils.getResourceMap(PdfExposeDetailedBuilder.class);
        this.resources = new Properties();
        try {
            String string = ImmoToolUtils.getResourcePath(PdfExposeShortBuilder.class, (Locale)this.getOpenEstateLocale());
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                this.resources.load(uRL.openStream());
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read ressources!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private static String pickAttribute(AgencyEstate agencyEstate, String[] stringArray, StringBuilder stringBuilder, StringBuilder stringBuilder2, Locale locale) {
        return PdfExposeShortBuilder.pickAttribute(agencyEstate, Arrays.asList(stringArray), stringBuilder, stringBuilder2, locale);
    }

    private static String pickAttribute(AgencyEstate agencyEstate, List<String> list, StringBuilder stringBuilder, StringBuilder stringBuilder2, Locale locale) {
        for (String string : list) {
            if (!agencyEstate.hasAttribute(string)) continue;
            String[] stringArray = string.split("\\.");
            String string2 = agencyEstate.writeValue(agencyEstate.getAttribute(string), locale);
            if (string2 == null) continue;
            stringBuilder.append(OpenEstateUtils.translateAttributeByCountry((String)stringArray[0], (String)stringArray[1], (Locale)locale, (String)agencyEstate.getAdress().getCountry()));
            stringBuilder2.append(string2);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image writeEstateImage(long l, EstateAttachmentImpl estateAttachmentImpl, float f, float f2, Integer n) {
        BufferedImage bufferedImage;
        Image image;
        File file;
        block8: {
            file = null;
            file = AgencyEstate.loadAttachmentAsTempFile(l, estateAttachmentImpl.getFileAsName());
            BufferedImage bufferedImage2 = ImageIO.read(file);
            image = null;
            if (n != null && n >= 72) {
                bufferedImage = ImmoToolUtils.scaleImageToResolution((BufferedImage)bufferedImage2, (int)((int)f), (int)((int)f2), (int)n);
                image = Image.getInstance((java.awt.Image)bufferedImage, null);
                bufferedImage2.flush();
                bufferedImage.flush();
            } else {
                image = Image.getInstance((java.awt.Image)bufferedImage2, null);
                bufferedImage2.flush();
            }
            if (image != null) break block8;
            bufferedImage = null;
            FileUtils.deleteQuietly((File)file);
            return bufferedImage;
        }
        try {
            image.setBorderWidth(0.0f);
            image.setBackgroundColor(this.bodyTextBgColor);
            if (image.getWidth() > f || image.getHeight() > f2) {
                image.scaleToFit(f, f2);
            }
            bufferedImage = image;
        }
        catch (Exception exception) {
            try {
                LOGGER.warn((Object)"Can't load image!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                image = null;
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(file);
                throw throwable;
            }
            FileUtils.deleteQuietly((File)file);
            return image;
        }
        FileUtils.deleteQuietly((File)file);
        return bufferedImage;
    }

    private PdfPCell writeEstateImageToCell(Image image, int n, int n2) {
        try {
            PdfPCell pdfPCell = new PdfPCell(image, false);
            pdfPCell.setBorderWidth(0.0f);
            pdfPCell.setBackgroundColor(this.bodyTextBgColor);
            pdfPCell.setHorizontalAlignment(n);
            pdfPCell.setVerticalAlignment(n2);
            return pdfPCell;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't create image-cell!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }
}

