/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;

public class PdfSetup {
    private static final Logger LOGGER = Logger.getLogger(PdfSetup.class);
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFY = 3;
    public static final int PUBLISH_DEFAULT = 0;
    public static final int PUBLISH_NEVER = 1;
    public static final int PUBLISH_ALWAYS = 2;
    public static final String KEY_BODY_HEAD_FG = "Body.Head.FgColor";
    public static final String KEY_BODY_HEAD_BG = "Body.Head.BgColor";
    public static final String KEY_BODY_TEXT_BG = "Body.Text.BgColor";
    public static final String KEY_BODY_TEXT_FG = "Body.Text.FgColor";
    public static final String KEY_BODY_TEXT_ALIGN = "Body.Text.Align";
    public static final String KEY_BORDER_COLOR = "Border.Color";
    public static final String KEY_BUILDER = "Builder";
    public static final String KEY_FOOTER_ALIGNMENT = "Footer.Alignment";
    public static final String KEY_FOOTER_TEXT_FG = "Footer.Text.FgColor";
    public static final String KEY_FOOTER_VISIBLE = "Footer.Visible";
    public static final String KEY_HEADER_LOGO_VISIBLE = "Header.Logo.Visible";
    public static final String KEY_HEADER_TEXT_CUSTOM = "Header.Text.Custom";
    public static final String KEY_HEADER_TEXT_FG = "Header.Text.FgColor";
    public static final String KEY_HEADER_TEXT_LINE1 = "Header.Text.Line1";
    public static final String KEY_HEADER_TEXT_LINE2 = "Header.Text.Line2";
    public static final String KEY_HEADER_TEXT_LINE3 = "Header.Text.Line3";
    public static final String KEY_HEADER_VISIBLE = "Header.Visible";
    public static final String KEY_IMAGE_GALLERY = "Image.Gallery";
    public static final String KEY_IMAGE_RESOLUTION = "Image.Resolution";
    public static final String KEY_IMAGE_SEPARATED_PLANS = "Image.SeparatedPlans";
    public static final String KEY_IMAGE_SEPARATED_PANORAMAS = "Image.SeparatedPanoramas";
    public static final String KEY_ID = "Id";
    public static final String KEY_LANDSCAPE = "Landscape";
    public static final String KEY_LOCALE = "Locale";
    public static final String KEY_NAME = "Name";
    public static final String KEY_TEMPLATE = "Template";
    public static final String KEY_TERMS_TEXT_SIZE = "Terms.Text.Size";
    public static final String KEY_TERMS_VISIBLE = "Terms.Visible";
    public static final String KEY_NUMBERED_HEADLINES = "NumberedHeadlines";
    public static final String KEY_PUBLISH_ADRESS = "PublishAdress";
    public static final String KEY_PUBLISH_CONTACT = "PublishContact";
    public static final String KEY_AREAS = "Areas";
    public static final String KEY_ENCRYPTION_ENABLED = "Encryption.Enabled";
    public static final String KEY_ENCRYPTION_PASSWORD = "Encryption.Password";
    public static final String KEY_ENCRYPTION_ALLOW_COPYING = "Encryption.Allow.Copying";
    public static final String KEY_ENCRYPTION_ALLOW_PRINTING = "Encryption.Allow.Printing";
    public static final String KEY_ENCRYPTION_ALLOW_ACCESSIBILITY = "Encryption.Allow.Accessibility";
    @Deprecated
    private static final String KEY_RESOLUTION = "Resolution";
    private Long id = null;
    private String builder = null;
    private String name = null;
    private String locale = null;
    private Integer imageGallery = null;
    private Integer imageResolution = null;
    private Boolean imageSeparatedPlans = null;
    private Boolean imageSeparatedPanoramas = null;
    private Color bodyHeadBackground = null;
    private Color bodyHeadForeground = null;
    private Color bodyTextBackground = null;
    private Color bodyTextForeground = null;
    private Integer bodyTextAlignment = null;
    private Color borderColor = null;
    private Integer footerAlignment = null;
    private Integer addressPublishing = null;
    private List<Integer> contactPublishings = new ArrayList<Integer>();
    private Color footerTextForeground = null;
    private boolean footerVisible = true;
    private boolean headerLogoVisible = true;
    private boolean headerTextCustom = false;
    private String headerTextCustomLine1 = null;
    private String headerTextCustomLine2 = null;
    private String headerTextCustomLine3 = null;
    private Color headerTextForeground = null;
    private boolean headerVisible = true;
    private boolean landscapeFormat = false;
    private boolean templateUsed = false;
    private boolean termsVisible = true;
    private Integer termsTextSize = null;
    private boolean numberedHeadlines = false;
    private Properties properties = null;
    private String[] areas = null;
    private File temporaryTemplate = null;
    private boolean encryptionEnabled = false;
    private String encryptionPassword = null;
    private boolean encryptionAccessibilityAllowed = false;
    private boolean encryptionCopyingAllowed = false;
    private boolean encryptionPrintingAllowed = false;

    public PdfSetup(String string) {
        this.builder = string;
        this.properties = new Properties();
        this.setLocale(Locale.getDefault().getLanguage());
        if ("expose.detailed".equals(string)) {
            this.setName("Langexpos\u00e9");
        } else if ("expose.short".equals(string)) {
            this.setName("Kurzexpos\u00e9");
        }
    }

    public PdfSetup(Properties properties) {
        this.load(properties);
    }

    public PdfBuilder createBuilder() {
        Map<String, PdfBuilder> map = PdfBuilder.listAvailableBuilders();
        if (map == null || !map.containsKey(this.getBuilder())) {
            return null;
        }
        PdfBuilder pdfBuilder = map.get(this.getBuilder());
        pdfBuilder.load(this);
        return pdfBuilder;
    }

    public int getAddressPublishing() {
        return this.addressPublishing != null ? this.addressPublishing : 0;
    }

    public String[] getAreas() {
        return (String[])ArrayUtils.clone((Object[])this.areas);
    }

    public Color getBodyHeadBackground() {
        return this.bodyHeadBackground != null ? this.bodyHeadBackground : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR;
    }

    public Color getBodyHeadForeground() {
        return this.bodyHeadForeground != null ? this.bodyHeadForeground : Color.BLACK;
    }

    public int getBodyTextAlignment() {
        return this.bodyTextAlignment != null ? this.bodyTextAlignment : 3;
    }

    public Color getBodyTextBackground() {
        return this.bodyTextBackground != null ? this.bodyTextBackground : Color.WHITE;
    }

    public Color getBodyTextForeground() {
        return this.bodyTextForeground != null ? this.bodyTextForeground : Color.BLACK;
    }

    public Color getBorderColor() {
        return this.borderColor != null ? this.borderColor : Color.GRAY;
    }

    public String getBuilder() {
        return this.builder;
    }

    public List<Integer> getContactPublishings() {
        return this.contactPublishings;
    }

    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    public int getFooterAlignment() {
        return this.footerAlignment != null ? this.footerAlignment : 0;
    }

    public Color getFooterTextForeground() {
        return this.footerTextForeground != null ? this.footerTextForeground : Color.GRAY;
    }

    public String getHeaderTextCustomLine1() {
        return this.headerTextCustomLine1 != null ? this.headerTextCustomLine1.trim() : "";
    }

    public String getHeaderTextCustomLine2() {
        return this.headerTextCustomLine2 != null ? this.headerTextCustomLine2.trim() : "";
    }

    public String getHeaderTextCustomLine3() {
        return this.headerTextCustomLine3 != null ? this.headerTextCustomLine3.trim() : "";
    }

    public Color getHeaderTextForeground() {
        return this.headerTextForeground != null ? this.headerTextForeground : Color.BLACK;
    }

    public Long getId() {
        return this.id;
    }

    public Integer getImageGallery() {
        return this.imageGallery;
    }

    public Integer getImageResolution() {
        return this.imageResolution;
    }

    public Boolean getImageSeparatedPanoramas() {
        return this.imageSeparatedPanoramas;
    }

    public Boolean getImageSeparatedPlans() {
        return this.imageSeparatedPlans;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Deprecated
    public Integer getResolution() {
        return this.getImageResolution();
    }

    public File getTemporaryTemplate() {
        return this.temporaryTemplate;
    }

    public Integer getTermsTextSize() {
        return this.termsTextSize;
    }

    public boolean isContactPublished(int n) {
        return this.contactPublishings.contains(n);
    }

    public boolean isEncryptionAccessibilityAllowed() {
        return this.encryptionAccessibilityAllowed;
    }

    public boolean isEncryptionCopyingAllowed() {
        return this.encryptionCopyingAllowed;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionEnabled;
    }

    public boolean isEncryptionPrintingAllowed() {
        return this.encryptionPrintingAllowed;
    }

    public boolean isFooterVisible() {
        return this.footerVisible;
    }

    public boolean isHeaderLogoVisible() {
        return this.headerLogoVisible;
    }

    public boolean isHeaderTextCustom() {
        return this.headerTextCustom;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public boolean isLandscapeFormat() {
        return this.landscapeFormat;
    }

    public boolean isNumberedHeadlines() {
        return this.numberedHeadlines;
    }

    public boolean isTemplateUsed() {
        return this.templateUsed;
    }

    public boolean isTermsVisible() {
        return this.termsVisible;
    }

    public final void load(Properties properties) {
        this.properties = properties;
        this.setAddressPublishing(ImmoToolUtils.getPropertyAsInteger((String)KEY_PUBLISH_ADRESS, (Integer)0, (Properties)properties));
        this.setBodyHeadBackground(ImmoToolUtils.getPropertyAsColor((String)KEY_BODY_HEAD_BG, (Color)ImmoToolUtils.TABLE_HIGHLIGHT_COLOR, (Properties)properties));
        this.setBodyHeadForeground(ImmoToolUtils.getPropertyAsColor((String)KEY_BODY_HEAD_FG, (Color)Color.BLACK, (Properties)properties));
        this.setBodyTextAlignment(ImmoToolUtils.getPropertyAsInteger((String)KEY_BODY_TEXT_ALIGN, (Integer)3, (Properties)properties));
        this.setBodyTextBackground(ImmoToolUtils.getPropertyAsColor((String)KEY_BODY_TEXT_BG, (Color)Color.WHITE, (Properties)properties));
        this.setBodyTextForeground(ImmoToolUtils.getPropertyAsColor((String)KEY_BODY_TEXT_FG, (Color)Color.BLACK, (Properties)properties));
        this.setBorderColor(ImmoToolUtils.getPropertyAsColor((String)KEY_BORDER_COLOR, (Color)Color.BLACK, (Properties)properties));
        this.setBuilder(properties.getProperty(KEY_BUILDER, ""));
        this.setFooterAlignment(ImmoToolUtils.getPropertyAsInteger((String)KEY_FOOTER_ALIGNMENT, (Integer)0, (Properties)properties));
        this.setFooterTextForeground(ImmoToolUtils.getPropertyAsColor((String)KEY_FOOTER_TEXT_FG, (Color)Color.BLACK, (Properties)properties));
        this.setFooterVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_FOOTER_VISIBLE, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setHeaderLogoVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_HEADER_LOGO_VISIBLE, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setHeaderTextCustom(ImmoToolUtils.getPropertyAsBoolean((String)KEY_HEADER_TEXT_CUSTOM, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setHeaderTextCustomLine1(properties.getProperty(KEY_HEADER_TEXT_LINE1, ""));
        this.setHeaderTextCustomLine2(properties.getProperty(KEY_HEADER_TEXT_LINE2, ""));
        this.setHeaderTextCustomLine3(properties.getProperty(KEY_HEADER_TEXT_LINE3, ""));
        this.setHeaderTextForeground(ImmoToolUtils.getPropertyAsColor((String)KEY_HEADER_TEXT_FG, (Color)Color.BLACK, (Properties)properties));
        this.setHeaderVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_HEADER_VISIBLE, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setId(ImmoToolUtils.getPropertyAsLong((String)KEY_ID, (Long)0L, (Properties)properties));
        this.setImageGallery(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_GALLERY, (Integer)0, (Properties)properties));
        this.setImageSeparatedPanoramas(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGE_SEPARATED_PANORAMAS, null, (Properties)properties));
        this.setImageSeparatedPlans(ImmoToolUtils.getPropertyAsBoolean((String)KEY_IMAGE_SEPARATED_PLANS, null, (Properties)properties));
        this.setLandscapeFormat(ImmoToolUtils.getPropertyAsBoolean((String)KEY_LANDSCAPE, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setLocale(properties.getProperty(KEY_LOCALE, Locale.getDefault().getLanguage()));
        this.setName(properties.getProperty(KEY_NAME, ""));
        this.setTemplateUsed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_TEMPLATE, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setTermsTextSize(ImmoToolUtils.getPropertyAsInteger((String)KEY_TERMS_TEXT_SIZE, (Integer)10, (Properties)properties));
        this.setTermsVisible(ImmoToolUtils.getPropertyAsBoolean((String)KEY_TERMS_VISIBLE, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setNumberedHeadlines(ImmoToolUtils.getPropertyAsBoolean((String)KEY_NUMBERED_HEADLINES, (Boolean)Boolean.TRUE, (Properties)properties));
        Integer n = ImmoToolUtils.getPropertyAsInteger((String)KEY_RESOLUTION, (Integer)0, (Properties)properties);
        this.setImageResolution(ImmoToolUtils.getPropertyAsInteger((String)KEY_IMAGE_RESOLUTION, (Integer)n, (Properties)properties));
        this.setEncryptionEnabled(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ENCRYPTION_ENABLED, (Boolean)Boolean.FALSE, (Properties)properties));
        this.setEncryptionAccessibilityAllowed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ENCRYPTION_ALLOW_ACCESSIBILITY, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setEncryptionCopyingAllowed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ENCRYPTION_ALLOW_COPYING, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setEncryptionPrintingAllowed(ImmoToolUtils.getPropertyAsBoolean((String)KEY_ENCRYPTION_ALLOW_PRINTING, (Boolean)Boolean.TRUE, (Properties)properties));
        this.setEncryptionPassword(this.isEncryptionEnabled() ? properties.getProperty(KEY_ENCRYPTION_PASSWORD) : null);
        String string = properties.getProperty(KEY_AREAS, null);
        if (string == null) {
            this.setAreas(null);
        } else {
            this.setAreas(string.split(","));
        }
        this.getContactPublishings().clear();
        for (String string2 : properties.getProperty(KEY_PUBLISH_CONTACT, "").split(",")) {
            if (string2 == null || string2.trim().length() == 0) continue;
            this.getContactPublishings().add(Integer.valueOf(string2));
        }
        if (this.getName().trim().length() == 0) {
            if ("expose.detailed".equals(this.getBuilder())) {
                this.setName("Langexpos\u00e9");
            } else if ("expose.short".equals(this.getBuilder())) {
                this.setName("Kurzexpos\u00e9");
            } else {
                this.setName("Expos\u00e9");
            }
        } else if (this.getName().equalsIgnoreCase("Expos\u00e9")) {
            if ("expose.detailed".equals(this.getBuilder())) {
                this.setName("Langexpos\u00e9");
            } else if ("expose.short".equals(this.getBuilder())) {
                this.setName("Kurzexpos\u00e9");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long[] loadIds() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            Long[] longArray = PdfSetup.loadIds(collection);
            return longArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long[] loadIds(Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                try {
                    Long l = Long.valueOf(stringArray[1]);
                    arrayList.add(l);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read expose-setup-id!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            return arrayList.toArray(new Long[arrayList.size()]);
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Can't load expose-ids!", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdfSetup loadSetup(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            PdfSetup pdfSetup = PdfSetup.loadSetup(l, collection);
            return pdfSetup;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static PdfSetup loadSetup(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Pdf." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            Properties properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string);
            if (properties == null) {
                throw new Exception("pdf-setup #" + l + " not found!");
            }
            PdfSetup pdfSetup = new PdfSetup(properties);
            return pdfSetup;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load pdf-setup: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PdfSetup[] loadSetups() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            PdfSetup[] pdfSetupArray = PdfSetup.loadSetups(collection);
            return pdfSetupArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static PdfSetup[] loadSetups(Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Agency/pdf')/properties\nlet $name := $x/entry[@key='Name']/text()\norder by $name\nreturn $x";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            ArrayList<PdfSetup> arrayList = new ArrayList<PdfSetup>();
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                Properties properties = ImmoToolDbUtils.loadProperties((XMLResource)((XMLResource)resourceSet.getResource(i)));
                PdfSetup pdfSetup = new PdfSetup(properties);
                arrayList.add(pdfSetup);
            }
            return arrayList.toArray(new PdfSetup[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load pdf-setups: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryResource loadTemplate(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            BinaryResource binaryResource = PdfSetup.loadTemplate(l, collection);
            return binaryResource;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static BinaryResource loadTemplate(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        if (l <= 0L) {
            throw new ImmoToolDbException("invalid pdf-setup-id!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Pdf." + l + ".pdf";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            return ImmoToolDbUtils.loadBinaryResource((Collection)collection, (String)string);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static InputStream loadTemplateAsStream(long l) throws ImmoToolDbException, XMLDBException {
        BinaryResource binaryResource = PdfSetup.loadTemplate(l);
        return binaryResource != null ? new ByteArrayInputStream((byte[])binaryResource.getContent()) : null;
    }

    public static InputStream loadTemplateAsStream(long l, Collection collection) throws ImmoToolDbException, XMLDBException {
        BinaryResource binaryResource = PdfSetup.loadTemplate(l, collection);
        return binaryResource != null ? new ByteArrayInputStream((byte[])binaryResource.getContent()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSetup(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            PdfSetup.removeSetup(l, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void removeSetup(long l, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            BinaryResource binaryResource;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Pdf." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new Exception(string + " not found!");
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
            String string2 = "Pdf." + l + ".pdf";
            if (ImmoToolDbUtils.hasResource((Collection)collection, (String)string2)) {
                binaryResource = ImmoToolDbUtils.loadBinaryResource((Collection)collection, (String)string2);
                ImmoToolDbUtils.removeResource((Collection)collection, (Resource)binaryResource);
            }
            if ((binaryResource = AgencyPluginUtils.openPluginCollection("/pdf/" + l)) != null) {
                binaryResource.close();
                LOGGER.debug((Object)("Remove collection: " + binaryResource.getName()));
                ImmoToolApp.getApplication().getDatabase().removeCollection(binaryResource.getName());
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("PdfSetup-Error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(Properties properties) {
        StringBuilder stringBuilder;
        String[] stringArray;
        properties.setProperty(KEY_BODY_HEAD_BG, ImmoToolUtils.writeHexColor((Color)this.getBodyHeadBackground()));
        properties.setProperty(KEY_BODY_HEAD_FG, ImmoToolUtils.writeHexColor((Color)this.getBodyHeadForeground()));
        properties.setProperty(KEY_BODY_TEXT_ALIGN, String.valueOf(this.getBodyTextAlignment()));
        properties.setProperty(KEY_BODY_TEXT_BG, ImmoToolUtils.writeHexColor((Color)this.getBodyTextBackground()));
        properties.setProperty(KEY_BODY_TEXT_FG, ImmoToolUtils.writeHexColor((Color)this.getBodyTextForeground()));
        properties.setProperty(KEY_BORDER_COLOR, ImmoToolUtils.writeHexColor((Color)this.getBorderColor()));
        properties.setProperty(KEY_BUILDER, this.getBuilder());
        properties.setProperty(KEY_FOOTER_ALIGNMENT, String.valueOf(this.getFooterAlignment()));
        properties.setProperty(KEY_FOOTER_TEXT_FG, ImmoToolUtils.writeHexColor((Color)this.getFooterTextForeground()));
        properties.setProperty(KEY_FOOTER_VISIBLE, Boolean.valueOf(this.isFooterVisible()).toString());
        properties.setProperty(KEY_HEADER_LOGO_VISIBLE, Boolean.valueOf(this.isHeaderLogoVisible()).toString());
        properties.setProperty(KEY_HEADER_TEXT_CUSTOM, Boolean.valueOf(this.isHeaderTextCustom()).toString());
        properties.setProperty(KEY_HEADER_TEXT_FG, ImmoToolUtils.writeHexColor((Color)this.getHeaderTextForeground()));
        properties.setProperty(KEY_HEADER_TEXT_LINE1, this.getHeaderTextCustomLine1());
        properties.setProperty(KEY_HEADER_TEXT_LINE2, this.getHeaderTextCustomLine2());
        properties.setProperty(KEY_HEADER_TEXT_LINE3, this.getHeaderTextCustomLine3());
        properties.setProperty(KEY_HEADER_VISIBLE, Boolean.valueOf(this.isHeaderVisible()).toString());
        properties.setProperty(KEY_ID, String.valueOf(this.getId()));
        properties.setProperty(KEY_LANDSCAPE, Boolean.valueOf(this.isLandscapeFormat()).toString());
        properties.setProperty(KEY_LOCALE, this.getLocale());
        properties.setProperty(KEY_NAME, this.getName());
        properties.setProperty(KEY_TEMPLATE, Boolean.valueOf(this.isTemplateUsed()).toString());
        properties.setProperty(KEY_TERMS_TEXT_SIZE, this.isTermsVisible() && this.getTermsTextSize() != null ? this.getTermsTextSize().toString() : "10");
        properties.setProperty(KEY_TERMS_VISIBLE, Boolean.valueOf(this.isTermsVisible()).toString());
        properties.setProperty(KEY_NUMBERED_HEADLINES, Boolean.valueOf(this.isNumberedHeadlines()).toString());
        properties.setProperty(KEY_PUBLISH_ADRESS, String.valueOf(this.getAddressPublishing()));
        properties.setProperty(KEY_ENCRYPTION_ENABLED, String.valueOf(this.isEncryptionEnabled()));
        if (this.isEncryptionEnabled()) {
            properties.setProperty(KEY_ENCRYPTION_ALLOW_ACCESSIBILITY, String.valueOf(this.isEncryptionAccessibilityAllowed()));
            properties.setProperty(KEY_ENCRYPTION_ALLOW_COPYING, String.valueOf(this.isEncryptionCopyingAllowed()));
            properties.setProperty(KEY_ENCRYPTION_ALLOW_PRINTING, String.valueOf(this.isEncryptionPrintingAllowed()));
            properties.setProperty(KEY_ENCRYPTION_PASSWORD, this.getEncryptionPassword());
        }
        if ((stringArray = this.getAreas()) == null) {
            if (properties.containsKey(KEY_AREAS)) {
                properties.remove(KEY_AREAS);
            }
        } else {
            stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            properties.setProperty(KEY_AREAS, stringBuilder.toString());
        }
        stringBuilder = new StringBuilder();
        for (Integer n : this.getContactPublishings()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(n);
        }
        properties.setProperty(KEY_PUBLISH_CONTACT, stringBuilder.toString());
        if (this.getImageGallery() != null) {
            properties.setProperty(KEY_IMAGE_GALLERY, this.getImageGallery().toString());
        } else if (properties.containsKey(KEY_IMAGE_GALLERY)) {
            properties.remove(KEY_IMAGE_GALLERY);
        }
        if (this.getImageResolution() != null) {
            properties.setProperty(KEY_IMAGE_RESOLUTION, this.getImageResolution().toString());
        } else if (properties.containsKey(KEY_IMAGE_RESOLUTION)) {
            properties.remove(KEY_IMAGE_RESOLUTION);
        }
        if (this.getImageSeparatedPlans() != null) {
            properties.setProperty(KEY_IMAGE_SEPARATED_PLANS, this.getImageSeparatedPlans().toString());
        } else if (properties.containsKey(KEY_IMAGE_SEPARATED_PLANS)) {
            properties.remove(KEY_IMAGE_SEPARATED_PLANS);
        }
        if (this.getImageSeparatedPanoramas() != null) {
            properties.setProperty(KEY_IMAGE_SEPARATED_PANORAMAS, this.getImageSeparatedPanoramas().toString());
        } else if (properties.containsKey(KEY_IMAGE_SEPARATED_PANORAMAS)) {
            properties.remove(KEY_IMAGE_SEPARATED_PANORAMAS);
        }
        this.properties = properties;
    }

    public void setAddressPublishing(Integer n) {
        this.addressPublishing = n;
    }

    public void setAreas(String[] stringArray) {
        this.areas = (String[])ArrayUtils.clone((Object[])stringArray);
    }

    public void setBodyHeadBackground(Color color) {
        this.bodyHeadBackground = color;
    }

    public void setBodyHeadForeground(Color color) {
        this.bodyHeadForeground = color;
    }

    public void setBodyTextAlignment(Integer n) {
        this.bodyTextAlignment = n;
    }

    public void setBodyTextBackground(Color color) {
        this.bodyTextBackground = color;
    }

    public void setBodyTextForeground(Color color) {
        this.bodyTextForeground = color;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBuilder(String string) {
        this.builder = string;
    }

    public void setEncryptionAccessibilityAllowed(boolean bl) {
        this.encryptionAccessibilityAllowed = bl;
    }

    public void setEncryptionCopyingAllowed(boolean bl) {
        this.encryptionCopyingAllowed = bl;
    }

    public void setEncryptionEnabled(boolean bl) {
        this.encryptionEnabled = bl;
    }

    public void setEncryptionPassword(String string) {
        this.encryptionPassword = string;
    }

    public void setEncryptionPrintingAllowed(boolean bl) {
        this.encryptionPrintingAllowed = bl;
    }

    public void setFooterAlignment(Integer n) {
        this.footerAlignment = n;
    }

    public void setFooterTextForeground(Color color) {
        this.footerTextForeground = color;
    }

    public void setFooterVisible(boolean bl) {
        this.footerVisible = bl;
    }

    public void setHeaderLogoVisible(boolean bl) {
        this.headerLogoVisible = bl;
    }

    public void setHeaderTextCustom(boolean bl) {
        this.headerTextCustom = bl;
    }

    public void setHeaderTextCustomLine1(String string) {
        this.headerTextCustomLine1 = string;
    }

    public void setHeaderTextCustomLine2(String string) {
        this.headerTextCustomLine2 = string;
    }

    public void setHeaderTextCustomLine3(String string) {
        this.headerTextCustomLine3 = string;
    }

    public void setHeaderTextForeground(Color color) {
        this.headerTextForeground = color;
    }

    public void setHeaderVisible(boolean bl) {
        this.headerVisible = bl;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public void setImageGallery(Integer n) {
        this.imageGallery = n;
    }

    public void setImageResolution(Integer n) {
        this.imageResolution = n;
    }

    public void setImageSeparatedPanoramas(Boolean bl) {
        this.imageSeparatedPanoramas = bl;
    }

    public void setImageSeparatedPlans(Boolean bl) {
        this.imageSeparatedPlans = bl;
    }

    public void setLandscapeFormat(boolean bl) {
        this.landscapeFormat = bl;
    }

    public final void setLocale(String string) {
        this.locale = string;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public void setNumberedHeadlines(boolean bl) {
        this.numberedHeadlines = bl;
    }

    public void setTemplateUsed(boolean bl) {
        this.templateUsed = bl;
    }

    public void setTemporaryTemplate(File file) {
        this.temporaryTemplate = file;
    }

    public void setTermsTextSize(Integer n) {
        this.termsTextSize = n;
    }

    public void setTermsVisible(boolean bl) {
        this.termsVisible = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long storeSetup(PdfSetup pdfSetup) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            Long l = PdfSetup.storeSetup(pdfSetup, collection);
            return l;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Long storeSetup(PdfSetup pdfSetup, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        ImmoToolApp immoToolApp = ImmoToolApp.getApplication();
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            if (pdfSetup.getId() == null || pdfSetup.getId() <= 0L) {
                pdfSetup.setId(immoToolApp.getDatabase().getNextSequence("OpenEstate-Agency.PdfSetup"));
            }
            Properties properties = pdfSetup.getProperties();
            pdfSetup.save(properties);
            String string = "Pdf." + pdfSetup.getId() + ".xml";
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)string);
            return pdfSetup.getId();
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeTemplate(long l, File file) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = AgencyPluginUtils.openPluginCollection("/pdf");
            PdfSetup.storeTemplate(l, file, collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void storeTemplate(long l, File file, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        if (l <= 0L) {
            throw new ImmoToolDbException("invalid pdf-setup-id!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Agency/pdf")) {
                throw new ImmoToolDbException("wrong collection provided!");
            }
            String string = "Pdf." + l + ".pdf";
            BinaryResource binaryResource = PdfSetup.loadTemplate(l, collection);
            if (binaryResource == null) {
                binaryResource = ImmoToolDbUtils.createBinaryResource((Collection)collection, (String)string);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImmoToolUtils.writeFileToStream((File)file, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            binaryResource.setContent((Object)byteArrayOutputStream.toByteArray());
            ImmoToolDbUtils.storeResource((Collection)collection, (Resource)binaryResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

