/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class PhpBuilder {
    public static final String PHP_RES_PATH = "/com/openindex/openestate/tool/agency/utils/resources/php/";

    public static String prepareString(String string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.unescapeHtml((String)string).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&nbsp;").replaceAll("'", "&apos;");
    }

    public static String readResource(String string) throws IOException {
        return OpenEstateUtils.readResource((String)(PHP_RES_PATH.substring(1) + string));
    }

    public static String replaceVariable(String string, String string2, Object object) {
        int n = StringUtils.indexOf((String)string, (String)string2);
        if (n < 0) {
            return string;
        }
        int n2 = StringUtils.indexOf((String)string, (String)"=", (int)n);
        if (n2 < 0) {
            return string;
        }
        int n3 = StringUtils.indexOf((String)string, (String)";", (int)n2);
        if (n3 < 0) {
            return string;
        }
        String string3 = object instanceof String ? "'" + StringUtils.replace((String)((String)object), (String)"'", (String)"\\'") + "'" : (object instanceof Boolean ? ((Boolean)object).toString() : (object instanceof Number ? ((Number)object).toString() : "null"));
        String string4 = StringUtils.substring((String)string, (int)n, (int)n3);
        String string5 = string2 + " = " + string3;
        return StringUtils.replaceOnce((String)string, (String)string4, (String)string5);
    }

    public static void saveFile(InputStream inputStream, File file) throws IOException {
        ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file);
    }

    public static void saveHtAccess(File file) throws IOException {
        File file2 = new File(file, ".htaccess");
        if (!file2.exists()) {
            PhpBuilder.saveResource("htaccess.txt", file2);
        }
    }

    public static void saveIndexHtml(File file) throws IOException {
        File file2 = new File(file, "index.html");
        if (!file2.exists()) {
            FileUtils.touch((File)file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveResource(String string, File file) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(PhpBuilder.class.getResourceAsStream(PHP_RES_PATH + string));
            ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)file);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveText(String string, File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public static String writeText(String string) {
        String string2 = "https?://(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,4})?((/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)?";
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string3 = string.substring(matcher.start(), matcher.end());
            matcher.appendReplacement(stringBuffer, "<a href=\"" + string3 + "\" target=\"_blank\">" + string3 + "</a>");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replaceAll("\\n", "<br/>");
    }
}

