/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.EstateAdressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.OpenEstateActions;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroups;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateTypes;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyAgent;
import com.openindex.openestate.tool.agency.AgencyContact;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.AgencyExportException;
import com.openindex.openestate.tool.agency.AgencyExportSummary;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.WebsitePhpExport;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import com.openindex.openestate.tool.agency.utils.PdfBuilder;
import com.openindex.openestate.tool.agency.utils.PdfSetup;
import com.openindex.openestate.tool.agency.utils.PhpBuilder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;

public class PhpWebsiteBuilder
extends PhpBuilder {
    private static final Logger LOGGER = Logger.getLogger(PhpWebsiteBuilder.class);
    private final Map<String, GeoDb> geoDbs = new HashMap<String, GeoDb>();
    private final WebsitePhpExport export;

    public PhpWebsiteBuilder(WebsitePhpExport websitePhpExport) {
        this.export = websitePhpExport;
        try {
            GeoDb geoDb = GeoDb.loadGeoDb("immobiliare");
            if (geoDb != null) {
                this.geoDbs.put("immobiliare", geoDb);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load geo-db 'immobiliare'");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File build(AgencyExportSummary agencyExportSummary) throws AgencyExportException {
        Object object;
        File file = this.export.getExportDirectory();
        Collection collection = null;
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            File file2 = new File(file, "cache");
            if (!file2.exists() && !file2.mkdir()) {
                throw new Exception("Can't create cache-directory!");
            }
            PhpWebsiteBuilder.saveIndexHtml(file2);
            PhpWebsiteBuilder.saveHtAccess(file2);
            File file3 = new File(file, "sessions");
            if (!file3.exists() && !file3.mkdir()) {
                throw new Exception("Can't create session-directory!");
            }
            PhpWebsiteBuilder.saveIndexHtml(file3);
            PhpWebsiteBuilder.saveHtAccess(file3);
            File file4 = new File(file, "data");
            if (!file4.exists() && !file4.mkdir()) {
                throw new Exception("Can't create data-directory!");
            }
            PhpWebsiteBuilder.saveIndexHtml(file4);
            File file5 = new File(file, "img");
            if (!file5.exists() && !file5.mkdir()) {
                throw new Exception("Can't create img-directory!");
            }
            PhpWebsiteBuilder.saveIndexHtml(file5);
            if (this.export.isExportScripts()) {
                object7 = new File(file, "scripts.zip");
                PhpWebsiteBuilder.saveResource("scripts.zip", (File)object7);
                object6 = new ZipFile((File)object7);
                object5 = ((ZipFile)object6).entries();
                while (object5.hasMoreElements()) {
                    ZipEntry zipEntry = object5.nextElement();
                    object4 = zipEntry.getName();
                    object3 = new File(file, (String)object4);
                    if (zipEntry.isDirectory()) {
                        if (((File)object3).exists() || ((File)object3).mkdirs()) continue;
                        LOGGER.warn((Object)"Can't create directory!");
                        LOGGER.warn((Object)("> " + ((File)object3).getAbsolutePath()));
                        continue;
                    }
                    InputStream inputStream = ((ZipFile)object6).getInputStream(zipEntry);
                    ImmoToolUtils.writeStreamToFile((InputStream)inputStream, (File)object3);
                    inputStream.close();
                }
                ((ZipFile)object6).close();
                if (!((File)object7).delete()) {
                    LOGGER.warn((Object)("Can't delete " + ((File)object7).getAbsolutePath()));
                }
            }
            Object object8 = object7 = this.export.getPdfSetupId() != null && this.export.getPdfSetupId() > 0L ? (object7 = PdfSetup.loadSetup(this.export.getPdfSetupId())) : null;
            if (object7 != null) {
                object6 = this.export.getAddressPublishing();
                if ("always".equals(object6)) {
                    ((PdfSetup)object7).setAddressPublishing(2);
                } else if ("never".equals(object6)) {
                    ((PdfSetup)object7).setAddressPublishing(1);
                } else {
                    ((PdfSetup)object7).setAddressPublishing(0);
                }
            }
            object6 = AgencyAgent.loadAgent();
            if (this.export.isExportScripts()) {
                File file6;
                FileUtils.moveFile((File)new File(file, "config.php"), (File)new File(file, "config_default.php"));
                FileUtils.copyFile((File)new File(file, "myconfig.php"), (File)new File(file, "myconfig_default.php"));
                PhpWebsiteBuilder.saveText(this.build_config_php((AgencyAgent)((Object)object6), new File(file, "config_default.php")), new File(file, "config.php"));
                object5 = new File(file, "include");
                if (((File)object5).isDirectory()) {
                    PhpWebsiteBuilder.saveIndexHtml((File)object5);
                }
                if ((file6 = new File(file, "templates")).isDirectory()) {
                    PhpWebsiteBuilder.saveIndexHtml(file6);
                    PhpWebsiteBuilder.saveHtAccess(file6);
                }
            }
            PhpWebsiteBuilder.saveText(this.build_private_php(), new File(file, "private.php"));
            PhpWebsiteBuilder.saveText(this.build_terms_php((AgencyAgent)((Object)object6)), new File(file4, "terms.php"));
            PhpWebsiteBuilder.saveText(this.build_language_php(), new File(file4, "language.php"));
            for (Locale locale : this.export.getLanguages()) {
                object4 = OpenEstateUtils.getFlagIcon((Locale)locale);
                object3 = new BufferedImage(((ImageIcon)object4).getIconWidth(), ((ImageIcon)object4).getIconHeight(), 1);
                Graphics2D graphics2D = ((BufferedImage)object3).createGraphics();
                graphics2D.drawImage(((ImageIcon)object4).getImage(), 0, 0, null);
                ImageIO.write((RenderedImage)object3, "png", new File(file5, locale.getLanguage() + ".png"));
            }
            object5 = StringUtils.trimToNull((String)this.export.getIdPrefix());
            String string = object5 != null ? (String)object5 + "-" : "";
            collection = AgencyPluginUtils.openPluginCollection("/estates");
            object4 = null;
            for (Long l : agencyExportSummary.getUpdatedEstateIds()) {
                object2 = AgencyEstate.loadEstate(l, collection);
                if (object2 == null) {
                    LOGGER.warn((Object)("Can't load estate #" + l));
                    continue;
                }
                object = new File(file4, string + object2.getIdNr());
                if (!((File)object).exists() && !((File)object).mkdir()) {
                    throw new Exception("Can't create directory for estate #" + object2.getIdNr() + "!");
                }
                PhpWebsiteBuilder.saveIndexHtml((File)object);
                if ("always".equals(this.export.getAddressPublishing())) {
                    object2.setAdressPublished(true);
                } else if ("never".equals(this.export.getAddressPublishing())) {
                    object2.setAdressPublished(false);
                }
                if (object2.getContactId() != null && object2.getContactId().contains(".")) {
                    try {
                        Long l2 = Long.valueOf(object2.getContactId().split("\\.")[1]);
                        if (object4 == null || !((AgencyContact)((Object)object4)).getIdNr().equals(l2)) {
                            object4 = AgencyContact.loadContact(l2);
                        }
                    }
                    catch (Exception exception) {
                        object4 = null;
                        LOGGER.warn((Object)("Could not load contact #" + object2.getContactId() + "!"), (Throwable)exception);
                    }
                }
                PhpWebsiteBuilder.saveText(this.build_object_php((AgencyEstate)((Object)object2), string, (AgencyAgent)((Object)object6), (AgencyContact)((Object)object4), (File)object), new File((File)object, "object.php"));
                PhpWebsiteBuilder.saveText(this.build_object_texts_php((AgencyEstate)((Object)object2), string), new File((File)object, "texts.php"));
                if (object7 == null) continue;
                this.build_object_pdf((PdfSetup)object7, (AgencyEstate)((Object)object2), string, file4);
            }
            object3 = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            object2 = new HashMap();
            object3.addAll(Arrays.asList(OpenEstateActions.getValues()));
            arrayList.addAll(Arrays.asList(OpenEstateTypes.getValues()));
            for (String string2 : arrayList) {
                OpenEstateType openEstateType = OpenEstateType.newInstance((String)string2);
                for (String string3 : openEstateType.getActions()) {
                    for (OpenEstateAttrib openEstateAttrib : openEstateType.getAttribs(string3)) {
                        String string4 = openEstateAttrib.getKey();
                        if (object2.containsKey(string4)) continue;
                        object2.put(string4, openEstateAttrib);
                    }
                }
            }
            for (Locale locale : this.export.getLanguages()) {
                PhpWebsiteBuilder.saveText(this.build_translation_php(locale, (List<String>)object3, arrayList, (Map<String, OpenEstateAttrib>)object2), new File(file4, "i18n_" + locale.getLanguage() + ".php"));
            }
            PhpWebsiteBuilder.saveResource("LICENSE.txt", new File(file, "LICENSE.txt"));
            PhpWebsiteBuilder.saveResource("LICENSE.txt", new File(file, "gpl-3.0.txt"));
            object = file;
        }
        catch (AgencyExportException agencyExportException) {
            try {
                throw agencyExportException;
                catch (Exception exception) {
                    throw new AgencyExportException(exception);
                }
            }
            catch (Throwable throwable) {
                ImmoToolDbUtils.close(collection);
                throw throwable;
            }
        }
        ImmoToolDbUtils.close((Collection)collection);
        return object;
    }

    protected String build_config_php(AgencyAgent agencyAgent, File file) throws IOException {
        String string = StringUtils.trimToEmpty((String)this.export.getStylesheetUrl());
        Locale locale = this.export.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string2 = FileUtils.readFileToString((File)file, (String)"UTF-8");
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$DefaultLanguage", locale.getLanguage());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$AdditionalStylesheet", StringUtils.trimToEmpty((String)string));
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$Timezone", TimeZone.getDefault().getID());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$MailFrom", agencyAgent.getCompany().getCompanyMail());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$MailFromName", agencyAgent.getCompany().getCompanyName());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$ShowTerms", this.export.isExposeTermsVisible());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$ShowContactPerson", this.export.isExposeContactPersonVisible());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$ShowContactForm", this.export.isExposeContactFormVisible());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$PublishAtomFeed", this.export.isAtomFeedExport());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$PublishRssFeed", this.export.isRssFeedExport());
        string2 = PhpWebsiteBuilder.replaceVariable(string2, "$PublishTrovitFeed", this.export.isTrovitFeedExport());
        return string2;
    }

    protected String build_language_php() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : this.export.getLanguages()) {
            String string = "'" + locale.getLanguage() + "' => '" + locale.getDisplayLanguage(locale) + "',";
            stringBuilder.append("  ").append(string).append(SystemUtils.LINE_SEPARATOR);
        }
        return PhpWebsiteBuilder.readResource("data_language.php.txt").replace("{LANGUAGES}", stringBuilder.toString());
    }

    protected final void build_object_pdf(PdfSetup pdfSetup, AgencyEstate agencyEstate, String string, File file) throws IOException, ImmoToolException {
        for (Locale locale : this.export.getLanguages()) {
            this.build_object_pdf(pdfSetup, agencyEstate, string, file, locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void build_object_pdf(PdfSetup pdfSetup, AgencyEstate agencyEstate, String string, File file, Locale locale) throws IOException, ImmoToolException {
        pdfSetup.setLocale(locale.getLanguage());
        File file2 = new File(new File(file, string + agencyEstate.getIdNr()), string + agencyEstate.getIdNr() + "_" + locale.getLanguage() + ".pdf");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            PdfBuilder pdfBuilder = pdfSetup.createBuilder();
            pdfBuilder.generatePdf(agencyEstate, fileOutputStream);
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String build_object_php(AgencyEstate agencyEstate, String string, AgencyAgent agencyAgent, AgencyContact agencyContact, File file) throws IOException, OpenEstateException {
        Object object;
        Object object2;
        CharSequence charSequence;
        Object object3;
        StringBuilder stringBuilder;
        int n = this.export.getImageCount() != null ? this.export.getImageCount() : -1;
        int n2 = this.export.getVideoCount() != null ? this.export.getVideoCount() : -1;
        int n3 = 0;
        ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
        if (!this.export.isImageModeDisabled()) {
            for (int i = 0; i < agencyEstate.getAttachments().size(); ++i) {
                stringBuilder = (EstateAttachmentImpl)agencyEstate.getAttachments().get(i);
                if (!stringBuilder.isName() || !this.export.isAllImagesExported() && !stringBuilder.isPublished() || !stringBuilder.getMimeType().startsWith("image/") || !this.export.getMimeTypes().contains(stringBuilder.getMimeType())) continue;
                if (n > -1 && arrayList.size() >= n) break;
                arrayList.add(stringBuilder);
            }
        }
        ArrayList<EstateAttachmentImpl> arrayList2 = new ArrayList<EstateAttachmentImpl>();
        if (!this.export.isImageModeDisabled()) {
            for (int i = 0; i < agencyEstate.getAttachments().size(); ++i) {
                object3 = (EstateAttachmentImpl)agencyEstate.getAttachments().get(i);
                if (!object3.isName() || !object3.isPublished() || object3.getMimeType().startsWith("image/") || !this.export.getMimeTypes().contains(object3.getMimeType())) continue;
                if (object3.getMimeType().startsWith("video/")) {
                    if (n2 > -1 && n3 >= n) continue;
                    ++n3;
                }
                arrayList2.add((EstateAttachmentImpl)object3);
            }
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("action", agencyEstate.getAction() != null ? agencyEstate.getAction().toLowerCase() : "", 2));
        stringBuilder.append(this.writeArrayLine("type", agencyEstate.getType() != null ? agencyEstate.getType().getName().toLowerCase() : "", 2));
        stringBuilder.append(this.writeArrayLine("type_path", OpenEstateUtils.getEstateTypePath((OpenEstateType)agencyEstate.getType()), 2));
        stringBuilder.append(this.writeArrayLine("currency", agencyEstate.getCurrency() != null ? agencyEstate.getCurrency().getCurrencyCode() : null, 2));
        stringBuilder.append(this.writeArrayLine("nr", !StringUtils.isBlank((String)agencyEstate.getPublicId()) ? string + agencyEstate.getPublicId() : null, 2));
        stringBuilder.append(this.writeArrayLine("hidden_price", agencyEstate.isHiddenPrices(), 2));
        stringBuilder.append(this.writeArrayLine("group_nr", agencyEstate.getGroupNr(), 2));
        if (agencyContact != null && !StringUtils.isBlank((String)agencyContact.getPersonMail())) {
            stringBuilder.append(this.writeArrayLine("mail", agencyContact.getPersonMail().trim(), 2));
        } else if (agencyAgent != null && agencyAgent.getCompany() != null && !StringUtils.isBlank((String)agencyAgent.getCompany().getCompanyMail())) {
            stringBuilder.append(this.writeArrayLine("mail", agencyAgent.getCompany().getCompanyMail().trim(), 2));
        } else if (agencyAgent != null && agencyAgent.getCompany() != null && !StringUtils.isBlank((String)agencyAgent.getCompany().getPersonMail())) {
            stringBuilder.append(this.writeArrayLine("mail", agencyAgent.getCompany().getPersonMail().trim(), 2));
        } else {
            stringBuilder.append(this.writeArrayLine("mail", (String)null, 2));
        }
        object3 = new StringBuilder();
        for (Locale locale : this.export.getLanguages()) {
            charSequence = agencyEstate.getTitle(locale);
            if (StringUtils.isBlank((String)charSequence)) {
                charSequence = agencyEstate.getFallbackTitle(locale);
            }
            ((StringBuilder)object3).append(this.writeArrayLine(locale.getLanguage(), (String)charSequence, 4));
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (agencyEstate.getAdress() != null) {
            stringBuilder2.append(this.writeArrayAdress((SimpleAdressImpl)agencyEstate.getAdress(), 4));
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        if (agencyContact != null) {
            stringBuilder3.append(this.writeArrayAdress((SimpleAdressImpl)agencyContact, 4));
        } else if (agencyAgent != null && agencyAgent.getCompany() != null) {
            stringBuilder3.append(this.writeArrayAdress((SimpleAdressImpl)agencyAgent.getCompany(), 4));
        }
        charSequence = new StringBuilder();
        for (String string2 : OpenEstateAttribGroups.getValues()) {
            if ("FREITEXTE".equals(string2) || !agencyEstate.getType().hasAttribGroup(string2)) continue;
            StringBuilder stringBuilder4 = new StringBuilder();
            for (OpenEstateAttrib openEstateAttrib : agencyEstate.getType().getAttribsByGroup(string2)) {
                ValueImpl valueImpl;
                if (!agencyEstate.hasAttribute(openEstateAttrib.getGroup(), openEstateAttrib.getName()) || (valueImpl = agencyEstate.getAttribute(openEstateAttrib.getKey())) == null) continue;
                object2 = new StringBuilder();
                if (openEstateAttrib instanceof SimpleNumericAttrib) {
                    ((StringBuilder)object2).append(this.writeArrayLine("value", (Number)valueImpl.getValueObject(), 8));
                } else if (openEstateAttrib instanceof SimpleBooleanAttrib) {
                    ((StringBuilder)object2).append(this.writeArrayLine("value", (Boolean)valueImpl.getValueObject(), 8));
                } else if (openEstateAttrib instanceof SimpleTimeAttrib) {
                    ((StringBuilder)object2).append(this.writeArrayLine("value", (Date)valueImpl.getValueObject(), 8));
                } else if (openEstateAttrib instanceof SimpleEnumAttrib) {
                    ((StringBuilder)object2).append(this.writeArrayLine("value", (String)valueImpl.getValueObject(), 8));
                } else if (openEstateAttrib instanceof ComplexEnumAttrib) {
                    ((StringBuilder)object2).append(this.writeArrayLine("value", (String[])valueImpl.getValueObject(), 8));
                }
                for (Locale locale : this.export.getLanguages()) {
                    String string3 = agencyEstate.writeValue(valueImpl, locale);
                    ((StringBuilder)object2).append(this.writeArrayLine(locale.getLanguage(), string3, 8));
                }
                stringBuilder4.append(this.writeArrayNode(openEstateAttrib.getName().toLowerCase(), ((StringBuilder)object2).toString(), 6));
            }
            ((StringBuilder)charSequence).append(this.writeArrayNode(string2.toLowerCase(), stringBuilder4.toString(), 4));
        }
        StringBuilder stringBuilder5 = new StringBuilder();
        int n4 = 0;
        if (!arrayList.isEmpty()) {
            for (EstateAttachmentImpl estateAttachmentImpl : arrayList) {
                File file2;
                FileOutputStream fileOutputStream;
                block53: {
                    block52: {
                        block51: {
                            Object var20_32 = null;
                            object = null;
                            fileOutputStream = null;
                            try {
                                Object object4;
                                file2 = AgencyEstate.loadAttachmentAsTempFile(agencyEstate.getIdNr(), estateAttachmentImpl.getFileAsName());
                                if (file2 == null) {
                                    IOUtils.closeQuietly((InputStream)object);
                                    break block51;
                                }
                                object = new FileInputStream(file2);
                                BufferedImage bufferedImage = this.export.convertImage((InputStream)object);
                                if (bufferedImage == null) {
                                    LOGGER.warn((Object)"could not convert image properly!");
                                    LOGGER.warn((Object)("> estate #" + agencyEstate.getIdNr()));
                                    LOGGER.warn((Object)("> " + estateAttachmentImpl.getFileAsName()));
                                    IOUtils.closeQuietly((InputStream)object);
                                    break block52;
                                }
                                ((InputStream)object).close();
                                File file3 = new File(file, "img_" + n4 + ".jpg");
                                fileOutputStream = new FileOutputStream(file3);
                                ImageIO.write((RenderedImage)bufferedImage, "jpg", fileOutputStream);
                                fileOutputStream.close();
                                BufferedImage bufferedImage2 = ImmoToolUtils.cropImageToRatio((BufferedImage)bufferedImage, (int)100, (int)75);
                                object2 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage2, (int)100, (int)75, (int)1);
                                File file4 = new File(file, "img_" + n4 + ".thumb.jpg");
                                fileOutputStream = new FileOutputStream(file4);
                                ImageIO.write((RenderedImage)object2, "jpg", fileOutputStream);
                                fileOutputStream.close();
                                ((Image)object2).flush();
                                if (n4 == 0) {
                                    object4 = ImmoToolUtils.scaleImageAndKeepRatio((BufferedImage)bufferedImage2, (int)200, (int)150, (int)1);
                                    File file5 = new File(file, "title.jpg");
                                    fileOutputStream = new FileOutputStream(file5);
                                    ImageIO.write((RenderedImage)object4, "jpg", fileOutputStream);
                                    fileOutputStream.close();
                                    ((Image)object4).flush();
                                }
                                bufferedImage2.flush();
                                bufferedImage.flush();
                                object4 = new StringBuilder();
                                ((StringBuilder)object4).append(this.writeArrayLine("name", "img_" + n4 + ".jpg", 6));
                                ((StringBuilder)object4).append(this.writeArrayLine("thumb", "img_" + n4 + ".thumb.jpg", 6));
                                ((StringBuilder)object4).append(this.writeArrayLine("type", estateAttachmentImpl.getType() != null ? estateAttachmentImpl.getType().toLowerCase() : null, 6));
                                ((StringBuilder)object4).append(this.writeArrayLine("mimetype", estateAttachmentImpl.getMimeType(), 6));
                                StringBuilder stringBuilder6 = new StringBuilder();
                                for (Locale locale : this.export.getLanguages()) {
                                    stringBuilder6.append(this.writeArrayLine(locale.getLanguage(), estateAttachmentImpl.getTitle(locale), 8));
                                }
                                ((StringBuilder)object4).append(this.writeArrayNode("title", stringBuilder6.toString(), 6));
                                stringBuilder5.append(this.writeArrayNode(((StringBuilder)object4).toString(), 4));
                                ++n4;
                                IOUtils.closeQuietly((InputStream)object);
                                break block53;
                            }
                            catch (Exception exception) {
                                LOGGER.warn((Object)"could not store attachment!");
                                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                                continue;
                            }
                        }
                        IOUtils.closeQuietly(fileOutputStream);
                        FileUtils.deleteQuietly((File)file2);
                        continue;
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    FileUtils.deleteQuietly((File)file2);
                    continue;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                FileUtils.deleteQuietly((File)file2);
                continue;
                finally {
                    void var20_34;
                    IOUtils.closeQuietly((InputStream)object);
                    IOUtils.closeQuietly(fileOutputStream);
                    FileUtils.deleteQuietly((File)var20_34);
                }
            }
        }
        StringBuilder stringBuilder7 = new StringBuilder();
        if (!arrayList2.isEmpty()) {
            for (EstateAttachmentImpl estateAttachmentImpl : arrayList2) {
                try {
                    object = new File(file, estateAttachmentImpl.getFileAsName());
                    AgencyEstate.loadAttachmentIntoFile((File)object, agencyEstate.getIdNr(), estateAttachmentImpl.getFileAsName());
                    StringBuilder stringBuilder8 = new StringBuilder();
                    stringBuilder8.append(this.writeArrayLine("name", ((File)object).getName(), 6));
                    stringBuilder8.append(this.writeArrayLine("type", estateAttachmentImpl.getType() != null ? estateAttachmentImpl.getType().toLowerCase() : null, 6));
                    stringBuilder8.append(this.writeArrayLine("mimetype", estateAttachmentImpl.getMimeType(), 6));
                    StringBuilder stringBuilder9 = new StringBuilder();
                    for (Locale locale : this.export.getLanguages()) {
                        stringBuilder9.append(this.writeArrayLine(locale.getLanguage(), estateAttachmentImpl.getTitle(locale), 8));
                    }
                    stringBuilder8.append(this.writeArrayNode("title", stringBuilder9.toString(), 6));
                    stringBuilder7.append(this.writeArrayNode(stringBuilder8.toString(), 4));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not store attachment!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        StringBuilder stringBuilder10 = new StringBuilder();
        if (!Locale.ITALY.getCountry().equalsIgnoreCase(agencyEstate.getAdress().getCountry())) return PhpWebsiteBuilder.readResource("data_object.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{OBJECT_DETAILS}", stringBuilder.toString()).replace("{OBJECT_TITLES}", ((StringBuilder)object3).toString()).replace("{ADRESS_DETAILS}", stringBuilder2.toString()).replace("{CONTACT_DETAILS}", stringBuilder3.toString()).replace("{ATTRIBUTES_DETAILS}", ((StringBuilder)charSequence).toString()).replace("{IMAGES_DETAILS}", stringBuilder5.toString()).replace("{MEDIA_DETAILS}", stringBuilder7.toString()).replace("{IMMOBILIARE_DETAILS}", stringBuilder10.toString());
        if (!this.geoDbs.containsKey("immobiliare")) return PhpWebsiteBuilder.readResource("data_object.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{OBJECT_DETAILS}", stringBuilder.toString()).replace("{OBJECT_TITLES}", ((StringBuilder)object3).toString()).replace("{ADRESS_DETAILS}", stringBuilder2.toString()).replace("{CONTACT_DETAILS}", stringBuilder3.toString()).replace("{ATTRIBUTES_DETAILS}", ((StringBuilder)charSequence).toString()).replace("{IMAGES_DETAILS}", stringBuilder5.toString()).replace("{MEDIA_DETAILS}", stringBuilder7.toString()).replace("{IMMOBILIARE_DETAILS}", stringBuilder10.toString());
        GeoDb geoDb = this.geoDbs.get("immobiliare");
        object = agencyEstate.getGeoDbIds("immobiliare");
        try {
            if (((OpenEstateAttrib[])object).length >= 2) {
                GeoAreaImpl geoAreaImpl = geoDb.loadArea((String)object[1]);
                stringBuilder10.append(this.writeArrayLine("areaName", geoAreaImpl.getName(), 6));
            }
            if (((Object)object).length >= 3) {
                GeoAreaImpl geoAreaImpl = geoDb.loadArea((String)object[2]);
                stringBuilder10.append(this.writeArrayLine("subAreaName", geoAreaImpl.getName(), 6));
            }
            if (((Object)object).length < 4) return PhpWebsiteBuilder.readResource("data_object.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{OBJECT_DETAILS}", stringBuilder.toString()).replace("{OBJECT_TITLES}", ((StringBuilder)object3).toString()).replace("{ADRESS_DETAILS}", stringBuilder2.toString()).replace("{CONTACT_DETAILS}", stringBuilder3.toString()).replace("{ATTRIBUTES_DETAILS}", ((StringBuilder)charSequence).toString()).replace("{IMAGES_DETAILS}", stringBuilder5.toString()).replace("{MEDIA_DETAILS}", stringBuilder7.toString()).replace("{IMMOBILIARE_DETAILS}", stringBuilder10.toString());
            GeoAreaImpl geoAreaImpl = geoDb.loadArea((String)object[3]);
            stringBuilder10.append(this.writeArrayLine("cityName", geoAreaImpl.getName(), 6));
            stringBuilder10.append(this.writeArrayLine("cityCode", geoAreaImpl.getProviderId(), 6));
            return PhpWebsiteBuilder.readResource("data_object.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{OBJECT_DETAILS}", stringBuilder.toString()).replace("{OBJECT_TITLES}", ((StringBuilder)object3).toString()).replace("{ADRESS_DETAILS}", stringBuilder2.toString()).replace("{CONTACT_DETAILS}", stringBuilder3.toString()).replace("{ATTRIBUTES_DETAILS}", ((StringBuilder)charSequence).toString()).replace("{IMAGES_DETAILS}", stringBuilder5.toString()).replace("{MEDIA_DETAILS}", stringBuilder7.toString()).replace("{IMMOBILIARE_DETAILS}", stringBuilder10.toString());
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't load international area from geo-db (immobiliare)!");
            LOGGER.error((Object)("> " + (String)object[1]));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        return PhpWebsiteBuilder.readResource("data_object.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{OBJECT_DETAILS}", stringBuilder.toString()).replace("{OBJECT_TITLES}", ((StringBuilder)object3).toString()).replace("{ADRESS_DETAILS}", stringBuilder2.toString()).replace("{CONTACT_DETAILS}", stringBuilder3.toString()).replace("{ATTRIBUTES_DETAILS}", ((StringBuilder)charSequence).toString()).replace("{IMAGES_DETAILS}", stringBuilder5.toString()).replace("{MEDIA_DETAILS}", stringBuilder7.toString()).replace("{IMMOBILIARE_DETAILS}", stringBuilder10.toString());
    }

    protected String build_object_texts_php(AgencyEstate agencyEstate, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : OpenEstateAttribGroups.getValues()) {
            if (!"FREITEXTE".equals(string2) || !agencyEstate.getType().hasAttribGroup(string2)) continue;
            for (OpenEstateAttrib openEstateAttrib : agencyEstate.getType().getAttribsByGroup(string2)) {
                ValueImpl valueImpl;
                if (!agencyEstate.hasAttribute(openEstateAttrib.getGroup(), openEstateAttrib.getName()) || agencyEstate.isHiddenPrices() && "PREIS_BESCHR".equals(openEstateAttrib.getName()) || (valueImpl = agencyEstate.getAttribute(openEstateAttrib.getKey())) == null) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                for (Locale locale : this.export.getLanguages()) {
                    String string3 = OpenEstateUtils.serializeString((String)agencyEstate.writeValue(valueImpl, locale), (String)"<br/>");
                    stringBuilder2.append(this.writeArrayLine(locale.getLanguage(), string3, 4));
                }
                stringBuilder.append(this.writeArrayNode(openEstateAttrib.getName().toLowerCase(), stringBuilder2.toString(), 2));
            }
        }
        return PhpWebsiteBuilder.readResource("data_texts.php.txt").replaceAll("\\{OBJECT_ID\\}", string + String.valueOf(agencyEstate.getIdNr())).replace("{TEXT_DETAILS}", stringBuilder.toString());
    }

    protected String build_private_php() throws IOException {
        String string = RandomStringUtils.randomAlphanumeric((int)100);
        return PhpWebsiteBuilder.readResource("private.php.txt").replace("//define('IMMOTOOL_CRYPT_KEY', '');", "define('IMMOTOOL_CRYPT_KEY', '" + string + "');");
    }

    protected String build_terms_php(AgencyAgent agencyAgent) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : this.export.getLanguages()) {
            String string = agencyAgent.getTerms(locale);
            String string2 = !StringUtils.isBlank((String)string) ? OpenEstateUtils.serializeString((String)string.trim(), (String)"<br/>") : null;
            stringBuilder.append(this.writeArrayLine(locale.getLanguage(), string2, 2));
        }
        return PhpWebsiteBuilder.readResource("data_terms.php.txt").replace("{TERMS}", stringBuilder.toString());
    }

    protected String build_translation_php(Locale locale, List<String> list, List<String> list2, Map<String, OpenEstateAttrib> map) throws IOException {
        CharSequence charSequence;
        Properties properties = new Properties();
        String string = ImmoToolUtils.getResourcePath(this.getClass(), null);
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            properties.load(uRL.openStream());
        }
        Properties properties2 = new Properties();
        string = ImmoToolUtils.getResourcePath(this.getClass(), (Locale)locale);
        uRL = this.getClass().getResource(string);
        if (uRL != null) {
            properties2.load(uRL.openStream());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("title", this.export.getPageTitle(), 4));
        Object object3 = properties.propertyNames();
        while (object3.hasMoreElements()) {
            charSequence = (String)object3.nextElement();
            if (((String)charSequence).startsWith("label.")) {
                stringBuilder.append(this.writeArrayLine(((String)charSequence).substring("label.".length()), properties2.getProperty((String)charSequence, "???"), 4));
                continue;
            }
            if (!((String)charSequence).startsWith("error.")) continue;
            stringBuilder2.append(this.writeArrayLine(((String)charSequence).substring("error.".length()), properties2.getProperty((String)charSequence, "???"), 4));
        }
        object3 = null;
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"AUSSTATTUNG_ART", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.ausstattung", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"AUSSTATTUNG_ART", (String)"EINFACH", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.ausstattung.einfach", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"AUSSTATTUNG_ART", (String)"GEHOBEN", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.ausstattung.gehoben", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"AUSSTATTUNG_ART", (String)"LUXUS", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.ausstattung.luxus", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"AUSSTATTUNG_ART", (String)"NORMAL", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.ausstattung.normal", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"AUSSTATTUNG", (String)"MOEBLIERT", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.moebliert", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"FLAECHEN", (String)"ANZ_ZIMMER", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.zimmer", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"ZUSTAND", (String)"ALTER", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.alter", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"ZUSTAND", (String)"ALTER", (String)"NEUBAU", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.alter.neubau", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"ZUSTAND", (String)"ALTER", (String)"ALTBAU", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.alter.altbau", (String)object3, 4));
        object3 = OpenEstateUtils.translateAttribute((String)"PREISE", (String)"SONDERANGEBOT", (Locale)locale);
        stringBuilder.append(this.writeArrayLine("openestate.sonderangebot", (String)object3, 4));
        charSequence = new StringBuilder();
        for (String object22 : list) {
            String string2 = OpenEstateUtils.translateAction((String)object22, (Locale)locale);
            ((StringBuilder)charSequence).append(this.writeArrayLine(object22.toLowerCase(), string2, 6));
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        for (String string3 : list2) {
            String string4 = OpenEstateUtils.translateEstate((String)string3, (Locale)locale);
            stringBuilder3.append(this.writeArrayLine(string3.toLowerCase(), string4, 6));
        }
        StringBuilder stringBuilder4 = new StringBuilder();
        for (String string5 : EstateAttachmentImpl.getTypes()) {
            String string6 = OpenEstateUtils.translateAttachment((String)string5, (Locale)locale);
            stringBuilder4.append(this.writeArrayLine(string5.toLowerCase(), string6, 6));
        }
        StringBuilder stringBuilder5 = new StringBuilder();
        StringBuilder stringBuilder6 = new StringBuilder();
        for (String string7 : OpenEstateAttribGroups.getValues()) {
            stringBuilder6.append(this.writeArrayLine(string7.toLowerCase(), OpenEstateUtils.translateAttribute((String)string7, (Locale)locale), 6));
            StringBuilder stringBuilder7 = new StringBuilder();
            for (OpenEstateAttrib openEstateAttrib : map.values()) {
                if (!openEstateAttrib.getGroup().equals(string7)) continue;
                String string8 = OpenEstateUtils.translateAttribute((String)string7, (String)openEstateAttrib.getName(), (Locale)locale);
                stringBuilder7.append(this.writeArrayLine(openEstateAttrib.getName().toLowerCase(), string8, 8));
            }
            stringBuilder5.append(this.writeArrayNode(string7.toLowerCase(), stringBuilder7.toString(), 6));
        }
        return PhpWebsiteBuilder.readResource("data_i18n.php.txt").replace("{LANGUAGE_NAME}", locale.getDisplayLanguage(locale) + " / " + locale.getDisplayLanguage(Locale.GERMAN)).replace("{LANGUAGE_CODE}", locale.getLanguage()).replace("{I18N_LABELS}", stringBuilder.toString()).replace("{I18N_ERRORS}", stringBuilder2.toString()).replace("{I18N_OPENESTATE_ACTIONS}", ((StringBuilder)charSequence).toString()).replace("{I18N_OPENESTATE_ATTACHMENTS}", stringBuilder4.toString()).replace("{I18N_OPENESTATE_ATTRIBUTES}", stringBuilder5.toString()).replace("{I18N_OPENESTATE_GROUPS}", stringBuilder6.toString()).replace("{I18N_OPENESTATE_TYPES}", stringBuilder3.toString());
    }

    protected String writeArrayAdress(SimpleAdressImpl simpleAdressImpl, int n) {
        EstateAdressImpl estateAdressImpl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("country", simpleAdressImpl.getCountry(), n));
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Locale locale : this.export.getLanguages()) {
            stringBuilder2.append(this.writeArrayLine(locale.getLanguage(), simpleAdressImpl.writeCountry(locale), n + 2));
        }
        stringBuilder.append(this.writeArrayNode("country_name", stringBuilder2.toString(), n));
        stringBuilder.append(this.writeArrayLine("postal", simpleAdressImpl.getPostalCode(), n));
        stringBuilder.append(this.writeArrayLine("city", simpleAdressImpl.getCity(), n));
        stringBuilder.append(this.writeArrayLine("city_part", simpleAdressImpl.getCityPart(), n));
        if (simpleAdressImpl instanceof EstateAdressImpl) {
            estateAdressImpl = (EstateAdressImpl)simpleAdressImpl;
            stringBuilder.append(this.writeArrayLine("street", estateAdressImpl.isAdressPublished() != false ? simpleAdressImpl.getStreet() : null, n));
            stringBuilder.append(this.writeArrayLine("street_nr", estateAdressImpl.isAdressPublished() != false ? simpleAdressImpl.getStreetNr() : null, n));
        } else {
            stringBuilder.append(this.writeArrayLine("street", simpleAdressImpl.getStreet(), n));
            stringBuilder.append(this.writeArrayLine("street_nr", simpleAdressImpl.getStreetNr(), n));
        }
        stringBuilder.append(this.writeArrayLine("region", simpleAdressImpl.getRegion(), n));
        stringBuilder.append(this.writeArrayLine("latitude", simpleAdressImpl.getLatitude() != null ? simpleAdressImpl.getLatitude() : null, n));
        stringBuilder.append(this.writeArrayLine("longitude", simpleAdressImpl.getLongitude() != null ? simpleAdressImpl.getLongitude() : null, n));
        if (simpleAdressImpl instanceof PersonAdressImpl) {
            estateAdressImpl = (PersonAdressImpl)simpleAdressImpl;
            stringBuilder.append(this.writeArrayLine("person_title", estateAdressImpl.getPersonTitle(), n));
            stringBuilder.append(this.writeArrayLine("person_firstname", estateAdressImpl.getPersonFirstName(), n));
            stringBuilder.append(this.writeArrayLine("person_middlename", estateAdressImpl.getPersonMiddleName(), n));
            stringBuilder.append(this.writeArrayLine("person_lastname", estateAdressImpl.getPersonLastName(), n));
            stringBuilder.append(this.writeArrayLine("person_fullname", estateAdressImpl.writePersonFullName(), n));
            stringBuilder.append(this.writeArrayLine("person_gender", estateAdressImpl.getPersonGender(), n));
            stringBuilder.append(this.writeArrayLine("person_mail", estateAdressImpl.getPersonMail(), n));
            stringBuilder.append(this.writeArrayLine("person_phone", estateAdressImpl.getPersonPhone(), n));
            stringBuilder.append(this.writeArrayLine("person_mobile", estateAdressImpl.getPersonMobilePhone(), n));
            stringBuilder.append(this.writeArrayLine("person_fax", estateAdressImpl.getPersonFax(), n));
        }
        if (simpleAdressImpl instanceof CompanyAdressImpl) {
            estateAdressImpl = (CompanyAdressImpl)simpleAdressImpl;
            stringBuilder.append(this.writeArrayLine("company_name", estateAdressImpl.getCompanyName(), n));
            stringBuilder.append(this.writeArrayLine("company_name_addition", estateAdressImpl.getCompanyNameAddition(), n));
            stringBuilder.append(this.writeArrayLine("company_type", estateAdressImpl.getCompanyType(), n));
            stringBuilder.append(this.writeArrayLine("company_business", estateAdressImpl.getCompanyBusiness(), n));
            stringBuilder.append(this.writeArrayLine("company_department", estateAdressImpl.getCompanyDepartment(), n));
            stringBuilder.append(this.writeArrayLine("company_position", estateAdressImpl.getCompanyPosition(), n));
            stringBuilder.append(this.writeArrayLine("company_mail", estateAdressImpl.getCompanyMail(), n));
            stringBuilder.append(this.writeArrayLine("company_phone", estateAdressImpl.getCompanyPhone(), n));
            stringBuilder.append(this.writeArrayLine("company_mobile", estateAdressImpl.getCompanyMobilePhone(), n));
            stringBuilder.append(this.writeArrayLine("company_fax", estateAdressImpl.getCompanyFax(), n));
            stringBuilder.append(this.writeArrayLine("company_website", estateAdressImpl.getCompanyWebsite() != null ? estateAdressImpl.getCompanyWebsite().toString() : "", n));
        }
        return stringBuilder.toString();
    }

    protected String writeArrayLine(String string, String string2, int n) {
        String string3 = StringUtils.repeat((String)" ", (int)n);
        String string4 = !StringUtils.isBlank((String)string2) ? "'" + string2.replaceAll(Pattern.quote("'"), "\\\\'") + "'" : "null";
        return string3 + "'" + string + "' => " + string4 + "," + SystemUtils.LINE_SEPARATOR;
    }

    protected String writeArrayLine(String string, String[] stringArray, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = "";
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(string4.toLowerCase().replaceAll(Pattern.quote("'"), "\\\\'")).append("'");
            }
            string3 = "array(" + stringBuilder.toString() + ")";
        } else {
            string3 = "null";
        }
        return string2 + "'" + string + "' => " + string3 + "," + SystemUtils.LINE_SEPARATOR;
    }

    protected String writeArrayLine(String string, Date date, int n) {
        return this.writeArrayLine(string, date != null ? (Number)(date.getTime() / 1000L) : (Number)null, n);
    }

    protected String writeArrayLine(String string, Number number, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = number != null ? number.toString() : "null";
        return string2 + "'" + string + "' => " + string3 + "," + SystemUtils.LINE_SEPARATOR;
    }

    protected String writeArrayLine(String string, Boolean bl, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = bl != null ? bl.toString().toLowerCase() : "null";
        return string2 + "'" + string + "' => " + string3 + "," + SystemUtils.LINE_SEPARATOR;
    }

    protected String writeArrayNode(String string, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = StringUtils.repeat((String)" ", (int)(n + 2));
        String string4 = !StringUtils.isBlank((String)string) ? string3 + string.trim() + SystemUtils.LINE_SEPARATOR : "";
        return string2 + "array(" + SystemUtils.LINE_SEPARATOR + string4 + string2 + ")," + SystemUtils.LINE_SEPARATOR;
    }

    protected String writeArrayNode(String string, String string2, int n) {
        String string3 = StringUtils.repeat((String)" ", (int)n);
        String string4 = StringUtils.repeat((String)" ", (int)(n + 2));
        String string5 = !StringUtils.isBlank((String)string2) ? string4 + string2.trim() + SystemUtils.LINE_SEPARATOR : "";
        return string3 + "'" + string + "' => array(" + SystemUtils.LINE_SEPARATOR + string5 + string3 + ")," + SystemUtils.LINE_SEPARATOR;
    }
}

