/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.utils;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.xml.WisITWriter;
import com.openindex.openestate.impl.xml.wis_it.OBJEKT;
import com.openindex.openestate.tool.agency.AgencyEstate;
import com.openindex.openestate.tool.agency.utils.GeoDb;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WisItWriter
extends WisITWriter {
    private static final Logger LOGGER = Logger.getLogger(WisItWriter.class);
    public static final String GEODB = "wis_it";
    private GeoDb geoDb;

    public WisItWriter() {
        this.init();
    }

    public WisItWriter(Locale locale) {
        super(locale);
        this.init();
    }

    public OBJEKT convertEstate(EstateImpl estateImpl, List<String> list) {
        String[] stringArray;
        OBJEKT oBJEKT = super.convertEstate(estateImpl, list);
        if (!list.isEmpty()) {
            return oBJEKT;
        }
        if (this.geoDb == null) {
            list.add("GeoDb not found!");
            return oBJEKT;
        }
        String[] stringArray2 = stringArray = estateImpl instanceof AgencyEstate ? ((AgencyEstate)estateImpl).getGeoDbIds(GEODB) : new String[]{};
        if (stringArray.length < 2) {
            list.add("No region was provided for wis_it!");
            return oBJEKT;
        }
        try {
            GeoAreaImpl geoAreaImpl = this.geoDb.loadArea(stringArray[1]);
            oBJEKT.setORT(geoAreaImpl.getName());
        }
        catch (Exception exception) {
            list.add("GeoDb-Error: " + exception.getLocalizedMessage());
            LOGGER.error((Object)"Can't load international area from geo-db (wis_it)!");
            LOGGER.error((Object)("> " + stringArray[1]));
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        return oBJEKT;
    }

    private void init() {
        this.geoDb = null;
        try {
            this.geoDb = GeoDb.loadGeoDb(GEODB);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load GeoDb!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }
}

