/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.http;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.atom.Atom;
import org.exist.atom.modules.AtomProtocol;
import org.exist.atom.util.DOM;
import org.exist.atom.util.DOMDB;
import org.exist.atom.util.DateFormatter;
import org.exist.atom.util.NodeHandler;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.http.webdav.WebDAV;
import org.exist.http.webdav.WebDAVMethod;
import org.exist.http.webdav.WebDAVMethodFactory;
import org.exist.http.webdav.methods.Copy;
import org.exist.http.webdav.methods.Delete;
import org.exist.http.webdav.methods.Mkcol;
import org.exist.http.webdav.methods.Move;
import org.exist.http.webdav.methods.Put;
import org.exist.security.PermissionDeniedException;
import org.exist.security.UUIDGenerator;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebDAVServlet
extends HttpServlet {
    protected static final Logger LOG = Logger.getLogger((Class)WebDAVServlet.class);
    private WebDAV webdav;
    protected String databaseid = "exist";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String id = config.getInitParameter("database-id");
        if (id != null && !"".equals(id)) {
            this.databaseid = id;
        }
        int authMethod = 1;
        String param = config.getInitParameter("authentication");
        if (param != null && "basic".equalsIgnoreCase(param)) {
            authMethod = 0;
        }
        this.webdav = new WebDAV(authMethod, this.databaseid, new AtomWebDAVMethodFactory());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.dumpHeaders(request);
        this.webdav.process(request, response);
    }

    private void dumpHeaders(HttpServletRequest request) {
        System.out.println("-------------------------------------------------------");
        System.out.println(request.getMethod() + " " + request.getPathInfo());
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            System.out.println(header + " = " + request.getHeader(header));
        }
    }

    class AtomCopy
    extends Copy {
        AtomCopy(BrokerPool pool) {
            super(pool);
        }
    }

    class AtomMove
    extends Move {
        AtomMove(BrokerPool pool) {
            super(pool);
        }
    }

    class AtomMkcol
    extends Mkcol {
        AtomMkcol(BrokerPool pool) {
            super(pool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
            DBBroker broker = null;
            Collection collection = null;
            try {
                try {
                    broker = this.pool.get(user);
                    collection = broker.openCollection(path, 0);
                    if (collection != null) {
                        response.sendError(405, "collection " + request.getPathInfo() + " already exists");
                        return;
                    }
                }
                finally {
                    if (collection != null) {
                        collection.release(0);
                    }
                }
            }
            catch (EXistException ex) {
                throw new ServletException("Exception while getting a broker from the pool.", (Throwable)ex);
            }
            super.process(user, request, response, path);
            collection = broker.openCollection(path, 0);
            if (collection == null) {
                this.pool.release(broker);
                return;
            }
            Object feedDoc = null;
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            Txn transaction = transact.beginTransaction();
            try {
                String id = UUIDGenerator.getUUID();
                String currentDateTime = DateFormatter.toXSDDateTime(new Date());
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setNamespaceAware(true);
                Document doc = docFactory.newDocumentBuilder().getDOMImplementation().createDocument(Atom.NAMESPACE_STRING, "feed", null);
                Element root = doc.getDocumentElement();
                DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "id", "urn:uuid:" + id, false);
                DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "updated", currentDateTime, false);
                DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "title", path.lastSegment().getCollectionPath(), false);
                Element editLink = doc.createElementNS(Atom.NAMESPACE_STRING, "link");
                editLink.setAttribute("rel", "edit");
                editLink.setAttribute("type", "application/atom+xml");
                editLink.setAttribute("href", "#");
                root.appendChild(editLink);
                IndexInfo info = collection.validateXMLResource(transaction, broker, AtomProtocol.FEED_DOCUMENT_URI, doc);
                collection.store(transaction, broker, info, doc, false);
                transact.commit(transaction);
            }
            catch (ParserConfigurationException ex) {
                transact.abort(transaction);
                throw new ServletException("SAX error: " + ex.getMessage(), (Throwable)ex);
            }
            catch (SAXException ex) {
                transact.abort(transaction);
                throw new ServletException("SAX error: " + ex.getMessage(), (Throwable)ex);
            }
            catch (TriggerException ex) {
                transact.abort(transaction);
                throw new ServletException("Trigger failed: " + ex.getMessage(), (Throwable)ex);
            }
            catch (LockException ex) {
                transact.abort(transaction);
                throw new ServletException("Cannot acquire write lock.", (Throwable)ex);
            }
            catch (PermissionDeniedException ex) {
                transact.abort(transaction);
                throw new ServletException("Permission denied.", (Throwable)ex);
            }
            catch (EXistException ex) {
                transact.abort(transaction);
                throw new ServletException("Database exception", (Throwable)ex);
            }
            finally {
                collection.release(0);
                this.pool.release(broker);
            }
        }
    }

    class AtomDelete
    extends Delete {
        AtomDelete(BrokerPool pool) {
            super(pool);
        }

        public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
            super.process(user, request, response, path);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            DocumentImpl feedDoc = null;
            DBBroker broker = null;
            Collection collection = null;
            try {
                broker = this.pool.get(user);
                XmldbURI filename = path.lastSegment();
                XmldbURI collUri = path.removeLastSegment();
                LOG.debug((Object)("Atom DELETE collUri='" + collUri + "';  path=" + filename + "';"));
                collection = broker.openCollection(collUri, 0);
                if (collection == null || collection.hasChildCollection(filename)) {
                    transact.abort(transaction);
                    return;
                }
                feedDoc = collection.getDocument(broker, AtomProtocol.FEED_DOCUMENT_URI);
                feedDoc.getUpdateLock().acquire(1);
                FindEntryByResource finder = new FindEntryByResource(filename.toString());
                DOM.findChildren(feedDoc.getDocumentElement(), Atom.NAMESPACE_STRING, "entry", finder);
                Element entry = finder.getEntry();
                if (entry != null) {
                    ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
                    feedRoot.removeChild(transaction, entry);
                    String currentDateTime = DateFormatter.toXSDDateTime(new Date());
                    DOMDB.replaceTextElement(transaction, feedRoot, Atom.NAMESPACE_STRING, "updated", currentDateTime, true);
                    LOG.debug((Object)"Storing change...");
                    broker.storeXMLResource(transaction, feedDoc);
                    transact.commit(transaction);
                } else {
                    transact.abort(transaction);
                }
            }
            catch (TransactionException ex) {
                transact.abort(transaction);
                throw new ServletException("Cannot commit transaction.", (Throwable)ex);
            }
            catch (EXistException ex) {
                transact.abort(transaction);
                throw new ServletException("Exception while getting a broker from the pool.", (Throwable)ex);
            }
            catch (LockException ex) {
                transact.abort(transaction);
                throw new ServletException("Cannot acquire write lock.", (Throwable)ex);
            }
            finally {
                if (feedDoc != null) {
                    feedDoc.getUpdateLock().release(1);
                }
                if (collection != null) {
                    collection.release(0);
                }
                this.pool.release(broker);
            }
        }
    }

    class AtomPut
    extends Put {
        AtomPut(BrokerPool pool) {
            super(pool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
            XmldbURI filename = path.lastSegment();
            XmldbURI collUri = path.removeLastSegment();
            DBBroker broker = null;
            Collection collection = null;
            boolean updateToExisting = false;
            try {
                try {
                    broker = this.pool.get(user);
                    collection = broker.openCollection(collUri, 0);
                    updateToExisting = collection.getDocument(broker, filename) != null;
                }
                catch (EXistException ex) {
                    throw new ServletException("Exception while getting a broker from the pool.", (Throwable)ex);
                }
                super.process(user, request, response, path);
                if (updateToExisting) {
                    LOG.debug((Object)"Update to existing resource, skipping feed update.");
                    return;
                }
            }
            finally {
                if (collection != null) {
                    collection.release(0);
                }
            }
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            DocumentImpl feedDoc = null;
            try {
                MimeType mime;
                LOG.debug((Object)("Atom PUT collUri='" + collUri + "';  path=" + filename + "';"));
                if (collection == null || collection.hasChildCollection(filename)) {
                    LOG.debug((Object)"No collection or subcollection already exists.");
                    transact.abort(transaction);
                    return;
                }
                String contentType = request.getContentType();
                if (contentType == null) {
                    mime = MimeTable.getInstance().getContentTypeFor(filename);
                    if (mime != null) {
                        contentType = mime.getName();
                    }
                } else {
                    int p = contentType.indexOf(59);
                    if (p > -1) {
                        contentType = StringValue.trimWhitespace(contentType.substring(0, p));
                    }
                    mime = MimeTable.getInstance().getContentType(contentType);
                }
                if (mime == null) {
                    mime = MimeType.BINARY_TYPE;
                }
                LOG.debug((Object)"Acquiring lock on feed document...");
                feedDoc = collection.getDocument(broker, AtomProtocol.FEED_DOCUMENT_URI);
                feedDoc.getUpdateLock().acquire(1);
                String title = request.getHeader("Title");
                if (title == null) {
                    title = filename.toString();
                }
                String created = DateFormatter.toXSDDateTime(new Date());
                ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
                DOMDB.replaceTextElement(transaction, feedRoot, Atom.NAMESPACE_STRING, "updated", created, true);
                String id = "urn:uuid:" + UUIDGenerator.getUUID();
                Element mediaEntry = AtomProtocol.generateMediaEntry(id, created, title, filename.toString(), mime.getName());
                DOMDB.appendChild(transaction, feedRoot, mediaEntry);
                broker.storeXMLResource(transaction, feedDoc);
                transact.commit(transaction);
            }
            catch (TransactionException ex) {
                transact.abort(transaction);
                throw new ServletException("Cannot commit transaction.", (Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                transact.abort(transaction);
                throw new ServletException("DOM implementation is misconfigured.", (Throwable)ex);
            }
            catch (LockException ex) {
                transact.abort(transaction);
                throw new ServletException("Cannot acquire write lock.", (Throwable)ex);
            }
            finally {
                if (feedDoc != null) {
                    feedDoc.getUpdateLock().release(1);
                }
                if (collection != null) {
                    collection.release(0);
                }
                this.pool.release(broker);
            }
        }
    }

    class AtomWebDAVMethodFactory
    extends WebDAVMethodFactory {
        AtomWebDAVMethodFactory() {
        }

        public WebDAVMethod create(String method, BrokerPool pool) {
            if (method.equals("PUT")) {
                return new AtomPut(pool);
            }
            if (method.equals("DELETE")) {
                return new AtomDelete(pool);
            }
            if (method.equals("MKCOL")) {
                return new AtomMkcol(pool);
            }
            if (method.equals("MOVE")) {
                return new AtomMove(pool);
            }
            if (method.equals("COPY")) {
                return new AtomCopy(pool);
            }
            return super.create(method, pool);
        }
    }

    class FindEntryByResource
    implements NodeHandler {
        String path;
        Element matching;

        FindEntryByResource(String path) {
            this.path = path;
            this.matching = null;
        }

        public void process(Node parent, Node child) {
            Element entry = (Element)child;
            NodeList nl = entry.getElementsByTagNameNS(Atom.NAMESPACE_STRING, "content");
            if (nl.getLength() != 0 && this.path.equals(((Element)nl.item(0)).getAttribute("src"))) {
                this.matching = entry;
            }
        }

        public Element getEntry() {
            return this.matching;
        }
    }
}

