/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.exist.backup.ErrorReport;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.security.User;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.DOMTransaction;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;

public class ConsistencyCheck {
    private Stack elementStack = new Stack();
    private DBBroker broker;
    private int defaultIndexDepth;
    private boolean directAccess = false;

    public ConsistencyCheck(DBBroker broker, boolean directAccess) {
        this.broker = broker;
        this.defaultIndexDepth = ((NativeBroker)broker).getDefaultIndexDepth();
        this.directAccess = directAccess;
    }

    public List checkAll(ProgressCallback callback) {
        List errors = this.checkCollectionTree(callback);
        this.checkDocuments(callback, errors);
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List checkCollectionTree(ProgressCallback callback) {
        User.enablePasswordChecks(false);
        try {
            ArrayList errors = new ArrayList();
            Collection root = this.broker.getCollection(XmldbURI.ROOT_COLLECTION_URI);
            this.checkCollection(root, errors, callback);
            ArrayList arrayList = errors;
            return arrayList;
        }
        finally {
            User.enablePasswordChecks(true);
        }
    }

    private void checkCollection(Collection collection, List errors, ProgressCallback callback) {
        XmldbURI uri = collection.getURI();
        callback.startCollection(uri.toString());
        Iterator i = collection.collectionIterator();
        while (i.hasNext()) {
            ErrorReport.CollectionError error;
            XmldbURI childUri = (XmldbURI)i.next();
            try {
                Collection child = this.broker.getCollection(uri.append(childUri));
                if (child == null) {
                    error = new ErrorReport.CollectionError(4, "Child collection not found: " + childUri + ", parent is " + uri);
                    error.setCollectionId(collection.getId());
                    error.setCollectionURI(childUri);
                    errors.add(error);
                    callback.error(error);
                    continue;
                }
                this.checkCollection(child, errors, callback);
            }
            catch (Exception e) {
                error = new ErrorReport.CollectionError(4, "Error while loading child collection: " + childUri + ", parent is " + uri);
                error.setCollectionId(collection.getId());
                error.setCollectionURI(childUri);
                errors.add(error);
                callback.error(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDocumentCount() {
        User.enablePasswordChecks(false);
        try {
            DocumentCallback cb = new DocumentCallback(null, null, false);
            this.broker.getResourcesFailsafe(cb, this.directAccess);
            int n = cb.docCount;
            return n;
        }
        finally {
            User.enablePasswordChecks(true);
        }
    }

    public List checkDocuments(ProgressCallback progress) {
        ArrayList errors = new ArrayList();
        this.checkDocuments(progress, errors);
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDocuments(ProgressCallback progress, List errorList) {
        User.enablePasswordChecks(false);
        try {
            DocumentCallback cb = new DocumentCallback(errorList, progress, true);
            this.broker.getResourcesFailsafe(cb, this.directAccess);
        }
        finally {
            User.enablePasswordChecks(true);
        }
    }

    public ErrorReport checkXMLTree(final DocumentImpl doc) {
        final DOMFile domDb = ((NativeBroker)this.broker).getDOMFile();
        return (ErrorReport)new DOMTransaction(this, domDb, 1, doc){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object start() {
                ErrorReport.ResourceError resourceError;
                try {
                    ElementImpl root = (ElementImpl)doc.getDocumentElement();
                    EmbeddedXMLStreamReader reader = ConsistencyCheck.this.broker.getXMLStreamReader(root, true);
                    boolean attribsAllowed = false;
                    int expectedAttribs = 0;
                    int attributeCount = 0;
                    block23: while (reader.hasNext()) {
                        ErrorReport.ResourceError resourceError2;
                        int status = reader.next();
                        NodeId nodeId = (NodeId)reader.getProperty("node-id");
                        ElementNode parent = null;
                        if (status != 2 && !ConsistencyCheck.this.elementStack.isEmpty()) {
                            parent = (ElementNode)ConsistencyCheck.this.elementStack.peek();
                            ++parent.childCount;
                            if (!nodeId.isChildOf(parent.elem.getNodeId())) {
                                resourceError2 = new ErrorReport.ResourceError(2, "Node " + nodeId + " is not a child of " + parent.elem.getNodeId());
                                return resourceError2;
                            }
                            if (!(parent.prevSibling == null || nodeId.isSiblingOf(parent.prevSibling) && nodeId.compareTo(parent.prevSibling) > 0)) {
                                resourceError2 = new ErrorReport.ResourceError(0, "Node " + nodeId + " is not a sibling of " + parent.prevSibling);
                                return resourceError2;
                            }
                            parent.prevSibling = nodeId;
                        }
                        switch (status) {
                            case 10: {
                                ++attributeCount;
                                continue block23;
                            }
                            case 2: {
                                if (ConsistencyCheck.this.elementStack.isEmpty()) {
                                    resourceError2 = new ErrorReport.ResourceError(2, "Error in node hierarchy: received END_ELEMENT event but stack was empty!");
                                    return resourceError2;
                                }
                                ElementNode lastElem = (ElementNode)ConsistencyCheck.this.elementStack.pop();
                                if (lastElem.childCount == lastElem.elem.getChildCount()) continue block23;
                                ErrorReport.ResourceError resourceError3 = new ErrorReport.ResourceError(2, "Element reports incorrect child count: expected " + lastElem.elem.getChildCount() + " but found " + lastElem.childCount);
                                return resourceError3;
                            }
                            case 1: {
                                StoredNode node;
                                if (nodeId.getTreeLevel() <= ConsistencyCheck.this.defaultIndexDepth) {
                                    NativeBroker.NodeRef nodeRef = new NativeBroker.NodeRef(doc.getDocId(), nodeId);
                                    try {
                                        Value v;
                                        long p = domDb.findValue(nodeRef);
                                        if (p != reader.getCurrentPosition() && (v = domDb.get(p)) == null) {
                                            ErrorReport.IndexError indexError = new ErrorReport.IndexError(6, "Failed to access node " + nodeId + " through dom.dbx index. Wrong storage address. Expected: " + p + "; got: " + reader.getCurrentPosition() + " - ", doc.getDocId());
                                            return indexError;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        ErrorReport.IndexError indexError = new ErrorReport.IndexError(6, "Failed to access node " + nodeId + " through dom.dbx index.", e, doc.getDocId());
                                        return indexError;
                                    }
                                }
                                if ((node = reader.getNode()).getNodeType() != 1) {
                                    ErrorReport.ResourceError resourceError4 = new ErrorReport.ResourceError(1, "Expected an element node, received node of type " + node.getNodeType());
                                    return resourceError4;
                                }
                                ConsistencyCheck.this.elementStack.push(new ElementNode((ElementImpl)node));
                                attribsAllowed = true;
                                attributeCount = 0;
                                expectedAttribs = reader.getAttributeCount();
                                continue block23;
                            }
                        }
                        if (attribsAllowed && attributeCount != expectedAttribs) {
                            ErrorReport.ResourceError resourceError5 = new ErrorReport.ResourceError(1, "Wrong number of attributes. Expected: " + expectedAttribs + "; found: " + attributeCount);
                            return resourceError5;
                        }
                        attribsAllowed = false;
                    }
                    if (!ConsistencyCheck.this.elementStack.isEmpty()) {
                        ErrorReport.ResourceError resourceError6 = new ErrorReport.ResourceError(2, "Error in node hierarchy: reached end of tree but stack was not empty!");
                        return resourceError6;
                    }
                    Object var7_11 = null;
                    return var7_11;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    resourceError = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    return resourceError;
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                    resourceError = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    return resourceError;
                }
                finally {
                    ConsistencyCheck.this.elementStack.clear();
                }
            }
        }.run();
    }

    public static interface ProgressCallback {
        public void startDocument(String var1);

        public void startCollection(String var1);

        public void error(ErrorReport var1);
    }

    private class DocumentCallback
    implements BTreeCallback {
        private List errors;
        private ProgressCallback progress;
        private int docCount = 0;
        private boolean checkDocs;

        private DocumentCallback(List errors, ProgressCallback progress, boolean checkDocs) {
            this.errors = errors;
            this.progress = progress;
            this.checkDocs = checkDocs;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            block9: {
                CollectionStore store = (CollectionStore)((NativeBroker)ConsistencyCheck.this.broker).getStorage((byte)0);
                int collectionId = CollectionStore.DocumentKey.getCollectionId(key);
                int docId = CollectionStore.DocumentKey.getDocumentId(key);
                try {
                    byte type = key.data()[key.start() + Collection.LENGTH_COLLECTION_ID + DocumentImpl.LENGTH_DOCUMENT_TYPE];
                    VariableByteInput istream = store.getAsStream(pointer);
                    DocumentImpl doc = null;
                    doc = type == 1 ? new BinaryDocument(ConsistencyCheck.this.broker.getBrokerPool()) : new DocumentImpl(ConsistencyCheck.this.broker.getBrokerPool());
                    doc.read(istream);
                    ++this.docCount;
                    if (this.checkDocs) {
                        ErrorReport report;
                        if (this.progress != null) {
                            this.progress.startDocument(doc.getFileURI().toString());
                        }
                        if (type == 0 && !ConsistencyCheck.this.directAccess && (report = ConsistencyCheck.this.checkXMLTree(doc)) != null) {
                            if (report instanceof ErrorReport.ResourceError) {
                                ((ErrorReport.ResourceError)report).setDocumentId(docId);
                            }
                            if (this.errors != null) {
                                this.errors.add(report);
                            }
                            if (this.progress != null) {
                                this.progress.error(report);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ErrorReport.ResourceError error = new ErrorReport.ResourceError(5, e.getMessage(), e);
                    error.setDocumentId(docId);
                    if (this.errors != null) {
                        this.errors.add(error);
                    }
                    if (this.progress == null) break block9;
                    this.progress.error(error);
                }
            }
            return true;
        }
    }

    private static class ElementNode {
        ElementImpl elem;
        int childCount = 0;
        NodeId prevSibling = null;

        ElementNode(ElementImpl element) {
            this.elem = element;
        }
    }
}

