/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.security.SecurityManager;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;

public class ExportGUI
extends JFrame {
    private BrokerPool pool = null;
    private int documentCount = 0;
    private PrintWriter logWriter = null;
    private JButton btnChangeDir;
    private JButton btnConfSelect;
    private JLabel currentTask;
    private JTextField dbConfig;
    private JButton exportBtn;
    private JCheckBox incrementalBtn;
    private JCheckBox directAccessBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JMenuItem menuQuit;
    private JTextArea messages;
    private JTextField outputDir;
    private JProgressBar progress;
    private JButton startBtn;

    public ExportGUI() {
        super("Consistency Check and Repair");
        this.initComponents();
        String existHome = System.getProperty("exist.home", "./");
        File home = new File(existHome);
        this.dbConfig.setText(new File(home, "conf.xml").getAbsolutePath());
        this.outputDir.setText(new File(home, "export").getAbsolutePath());
    }

    protected boolean checkOutputDir() {
        File dir = new File(this.outputDir.getText());
        if (!dir.exists()) {
            if (JOptionPane.showConfirmDialog(this, "The output directory " + dir.getAbsolutePath() + " does not exist. Create it?", "Confirm", 0) == 0) {
                dir.mkdirs();
            } else {
                return false;
            }
        }
        return true;
    }

    protected boolean startDB() {
        if (this.pool != null) {
            return true;
        }
        File confFile = new File(this.dbConfig.getText());
        if (!confFile.exists() || !confFile.canRead()) {
            JOptionPane.showMessageDialog(this, "The selected database configuration file " + confFile.getAbsolutePath() + " does not exist or is not readable.", "Configuration Error", 0);
            return false;
        }
        try {
            Configuration config = new Configuration(confFile.getAbsolutePath(), null);
            BrokerPool.configure(1, 5, config);
            this.pool = BrokerPool.getInstance();
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not start the database instance. Please remember\nthat this tool tries to launch an embedded db instance. No other db instance should\nbe running on the same data.", "DB Error", 0);
            e.printStackTrace();
            System.err.println("ERROR: Failed to open database: " + e.getMessage());
            return false;
        }
    }

    private void initComponents() {
        this.currentTask = new JLabel();
        this.progress = new JProgressBar();
        this.jScrollPane2 = new JScrollPane();
        this.messages = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.startBtn = new JButton();
        this.exportBtn = new JButton();
        this.incrementalBtn = new JCheckBox("Incremental backup");
        this.directAccessBtn = new JCheckBox("Direct access");
        this.outputDir = new JTextField();
        this.jLabel1 = new JLabel();
        this.btnChangeDir = new JButton();
        this.dbConfig = new JTextField();
        this.jLabel2 = new JLabel();
        this.btnConfSelect = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.menuQuit = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                ExportGUI.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.currentTask.setText(" ");
        this.currentTask.setMinimumSize(new Dimension(0, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.currentTask, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.progress, gridBagConstraints);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.jScrollPane2.setPreferredSize(new Dimension(400, 200));
        this.messages.setColumns(20);
        this.messages.setLineWrap(true);
        this.messages.setRows(5);
        this.messages.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane2.setViewportView(this.messages);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jToolBar1.setRollover(true);
        this.startBtn.setText("Check");
        this.startBtn.setFocusable(false);
        this.startBtn.setHorizontalTextPosition(0);
        this.startBtn.setVerticalTextPosition(3);
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportGUI.this.startBtncheck(evt);
            }
        });
        this.jToolBar1.add(this.startBtn);
        this.exportBtn.setText("Check & Export");
        this.exportBtn.setFocusable(false);
        this.exportBtn.setHorizontalTextPosition(0);
        this.exportBtn.setVerticalTextPosition(3);
        this.exportBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportGUI.this.exportBtnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.exportBtn);
        this.jToolBar1.add(this.incrementalBtn);
        this.jToolBar1.add(this.directAccessBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.outputDir, gridBagConstraints);
        this.jLabel1.setText("Output Directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.btnChangeDir.setText("Change");
        this.btnChangeDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportGUI.this.btnChangeDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnChangeDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.dbConfig, gridBagConstraints);
        this.jLabel2.setText("DB Configuration:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.btnConfSelect.setText("Select");
        this.btnConfSelect.setMaximumSize(new Dimension(75, 24));
        this.btnConfSelect.setMinimumSize(new Dimension(75, 24));
        this.btnConfSelect.setPreferredSize(new Dimension(75, 24));
        this.btnConfSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportGUI.this.btnConfSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.btnConfSelect, gridBagConstraints);
        this.jMenu1.setText("File");
        this.menuQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.menuQuit.setText("Quit");
        this.menuQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportGUI.this.menuQuitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.menuQuit);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        BrokerPool.stopAll(false);
    }

    private void startBtncheck(ActionEvent evt) {
        if (!this.checkOutputDir()) {
            return;
        }
        Runnable checkRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ExportGUI.this.openLog(ExportGUI.this.outputDir.getText());
                try {
                    ExportGUI.this.checkDB();
                }
                finally {
                    ExportGUI.this.closeLog();
                }
            }
        };
        new Thread(checkRun).start();
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        if (!this.checkOutputDir()) {
            return;
        }
        Runnable th = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ExportGUI.this.openLog(ExportGUI.this.outputDir.getText());
                try {
                    ExportGUI.this.currentTask.setText("Checking database consistency ...");
                    List errors = ExportGUI.this.checkDB();
                    ExportGUI.this.currentTask.setText("Exporting data ...");
                    ExportGUI.this.exportDB(ExportGUI.this.outputDir.getText(), errors);
                }
                finally {
                    ExportGUI.this.closeLog();
                }
            }
        };
        new Thread(th).start();
    }

    private void btnChangeDirActionPerformed(ActionEvent evt) {
        File dir = new File(this.outputDir.getText());
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(new File(dir, "export"));
        chooser.setCurrentDirectory(dir);
        if (chooser.showDialog(this, "Export") == 0) {
            this.outputDir.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void menuQuitActionPerformed(ActionEvent evt) {
        BrokerPool.stopAll(false);
        System.exit(0);
    }

    private void btnConfSelectActionPerformed(ActionEvent evt) {
        File dir = new File(this.dbConfig.getText()).getParentFile();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(new File(dir, "conf.xml"));
        chooser.setCurrentDirectory(dir);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                MimeType mime = MimeTable.getInstance().getContentTypeFor(f.getName());
                if (mime == null) {
                    return false;
                }
                return mime.isXMLType();
            }

            public String getDescription() {
                return "Database XML configuration file";
            }
        });
        if (chooser.showDialog(this, "Select") == 0) {
            this.dbConfig.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDB(String exportTarget, List errorList) {
        if (!this.startDB()) {
            return;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            SystemExport.StatusCallback callback = new SystemExport.StatusCallback(){

                public void startCollection(String path) {
                    ExportGUI.this.progress.setString(path);
                }

                public void startDocument(String name, int current, int count) {
                    ExportGUI.this.progress.setString(name);
                    ExportGUI.this.progress.setValue(ExportGUI.this.progress.getValue() + 1);
                }

                public void error(String message, Throwable exception) {
                    ExportGUI.this.displayMessage(message);
                    if (exception != null) {
                        ExportGUI.this.displayMessage(exception.toString());
                    }
                    ExportGUI.this.displayMessage("---------------------------------------------------");
                }
            };
            this.progress.setIndeterminate(false);
            this.progress.setValue(0);
            this.progress.setStringPainted(true);
            this.progress.setMinimum(0);
            this.progress.setMaximum(this.documentCount);
            Object[] selected = this.directAccessBtn.getSelectedObjects();
            boolean directAccess = selected != null && selected[0] != null;
            this.displayMessage("Starting export ...");
            selected = this.incrementalBtn.getSelectedObjects();
            boolean incremental = selected != null && selected[0] != null;
            SystemExport sysexport = new SystemExport(broker, callback, directAccess);
            File file = sysexport.export(exportTarget, incremental, true, errorList);
            this.displayMessage("Export to " + file.getAbsolutePath() + " completed successfully.");
            this.progress.setString("");
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
        }
        finally {
            this.pool.release(broker);
            this.progress.setValue(0);
            this.currentTask.setText(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List checkDB() {
        if (!this.startDB()) {
            return null;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(SecurityManager.SYSTEM_USER);
            Object[] selected = this.directAccessBtn.getSelectedObjects();
            boolean directAccess = selected != null && selected[0] != null;
            ConsistencyCheck checker = new ConsistencyCheck(broker, directAccess);
            ConsistencyCheck.ProgressCallback cb = new ConsistencyCheck.ProgressCallback(){

                public void startDocument(String path) {
                    ExportGUI.this.progress.setString(path);
                    ExportGUI.this.progress.setValue(ExportGUI.this.progress.getValue() + 1);
                }

                public void error(ErrorReport error) {
                    ExportGUI.this.displayMessage(error.toString());
                    ExportGUI.this.displayMessage("---------------------------------------------------");
                }

                public void startCollection(String path) {
                    ExportGUI.this.progress.setString(path);
                }
            };
            this.progress.setIndeterminate(true);
            this.messages.setText("");
            this.displayMessage("Checking collections ...");
            List errors = checker.checkCollectionTree(cb);
            if (errors.size() == 0) {
                this.displayMessage("No errors found.");
            } else {
                this.displayMessage("Errors found.");
            }
            this.progress.setStringPainted(true);
            this.progress.setString("Counting documents ...");
            this.documentCount = checker.getDocumentCount();
            this.progress.setIndeterminate(false);
            this.progress.setValue(0);
            this.progress.setMinimum(0);
            this.progress.setMaximum(this.documentCount);
            this.displayMessage("Checking documents ...");
            checker.checkDocuments(cb, errors);
            if (errors.size() == 0) {
                this.displayMessage("No errors found.");
            } else {
                this.displayMessage("Errors found.");
            }
            this.progress.setString("");
            List list = errors;
            return list;
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
        }
        finally {
            this.pool.release(broker);
            this.progress.setValue(0);
            this.currentTask.setText(" ");
        }
        return null;
    }

    public void displayMessage(String message) {
        this.messages.append(message + '\n');
        this.messages.setCaretPosition(this.messages.getDocument().getLength());
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    private void openLog(String dir) {
        try {
            File file = SystemExport.getUniqueFile("report", ".log", dir);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            this.logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: failed to create log file");
        }
    }

    private void closeLog() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ExportGUI().setVisible(true);
            }
        });
    }
}

