/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import org.jedit.syntax.DefaultInputHandler;
import org.jedit.syntax.InputHandler;
import org.jedit.syntax.JEditTextArea;

public class ClientInputHandler
extends DefaultInputHandler {
    private boolean runningOnMac = System.getProperty("mrj.version") != null;
    public static final ActionListener SELECT_ALL = new select_all();
    public static final ActionListener CLIP_COPY = new clip_copy();
    public static final ActionListener CLIP_PASTE = new clip_paste();
    public static final ActionListener CLIP_CUT = new clip_cut();

    public void addDefaultKeyBindings() {
        if (this.runningOnMac) {
            this.addKeyBinding("BACK_SPACE", BACKSPACE);
            this.addKeyBinding("M+BACK_SPACE", BACKSPACE_WORD);
            this.addKeyBinding("DELETE", DELETE);
            this.addKeyBinding("M+DELETE", DELETE_WORD);
            this.addKeyBinding("ENTER", INSERT_BREAK);
            this.addKeyBinding("TAB", INSERT_TAB);
            this.addKeyBinding("HOME", DOCUMENT_HOME);
            this.addKeyBinding("END", DOCUMENT_END);
            this.addKeyBinding("S+HOME", SELECT_DOC_HOME);
            this.addKeyBinding("S+END", SELECT_DOC_END);
            this.addKeyBinding("M+A", SELECT_ALL);
            this.addKeyBinding("S+HOME", SELECT_HOME);
            this.addKeyBinding("S+END", SELECT_END);
            this.addKeyBinding("PAGE_UP", PREV_PAGE);
            this.addKeyBinding("PAGE_DOWN", NEXT_PAGE);
            this.addKeyBinding("S+PAGE_UP", SELECT_PREV_PAGE);
            this.addKeyBinding("S+PAGE_DOWN", SELECT_NEXT_PAGE);
            this.addKeyBinding("LEFT", PREV_CHAR);
            this.addKeyBinding("S+LEFT", SELECT_PREV_CHAR);
            this.addKeyBinding("A+LEFT", PREV_WORD);
            this.addKeyBinding("AS+LEFT", SELECT_PREV_WORD);
            this.addKeyBinding("RIGHT", NEXT_CHAR);
            this.addKeyBinding("S+RIGHT", SELECT_NEXT_CHAR);
            this.addKeyBinding("A+RIGHT", NEXT_WORD);
            this.addKeyBinding("AS+RIGHT", SELECT_NEXT_WORD);
            this.addKeyBinding("UP", PREV_LINE);
            this.addKeyBinding("S+UP", SELECT_PREV_LINE);
            this.addKeyBinding("DOWN", NEXT_LINE);
            this.addKeyBinding("S+DOWN", SELECT_NEXT_LINE);
            this.addKeyBinding("A+ENTER", REPEAT);
            this.addKeyBinding("M+C", CLIP_COPY);
            this.addKeyBinding("M+V", CLIP_PASTE);
            this.addKeyBinding("M+X", CLIP_CUT);
        } else {
            super.addDefaultKeyBindings();
            this.addKeyBinding("C+A", SELECT_ALL);
            this.addKeyBinding("C+C", CLIP_COPY);
            this.addKeyBinding("C+V", CLIP_PASTE);
            this.addKeyBinding("C+X", CLIP_CUT);
        }
    }

    public void keyTyped(KeyEvent evt) {
        if (this.runningOnMac) {
            int modifiers = evt.getModifiers();
            char c = evt.getKeyChar();
            if (c != '\uffff' && (modifiers & 8) != 0) {
                this.executeAction(INSERT_CHAR, evt.getSource(), String.valueOf(c));
            } else if ((modifiers & 4) == 0) {
                super.keyTyped(evt);
            }
        } else {
            super.keyTyped(evt);
        }
    }

    public static class clip_cut
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea((EventObject)evt);
            textArea.cut();
        }
    }

    public static class clip_paste
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea((EventObject)evt);
            textArea.paste();
        }
    }

    public static class clip_copy
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea((EventObject)evt);
            textArea.copy();
        }
    }

    public static class select_all
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            JEditTextArea textArea = InputHandler.getTextArea((EventObject)evt);
            textArea.selectAll();
        }
    }
}

