/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.exist.client.ClientFrame;
import org.exist.client.ClientTextArea;
import org.exist.client.InteractiveClient;
import org.exist.client.Messages;
import org.exist.security.User;
import org.exist.storage.ElementIndex;
import org.exist.storage.TextSearchEngine;
import org.exist.util.ProgressIndicator;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

class DocumentView
extends JFrame {
    protected InteractiveClient client;
    private XmldbURI resourceName;
    protected Resource resource;
    protected Collection collection;
    protected boolean readOnly = false;
    protected ClientTextArea text;
    protected JButton saveButton;
    protected JButton saveAsButton;
    protected JTextField statusMessage;
    protected JProgressBar progress;
    protected JPopupMenu popup;
    protected Properties properties;

    public DocumentView(InteractiveClient client, XmldbURI resourceName, Properties properties) throws XMLDBException {
        super(URIUtils.urlDecodeUtf8(resourceName.lastSegment()));
        this.resourceName = resourceName;
        this.resource = client.retrieve(resourceName, properties.getProperty("indent", "yes"));
        this.client = client;
        this.collection = client.getCollection();
        this.properties = properties;
        this.getContentPane().setLayout(new BorderLayout());
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                DocumentView.this.close();
            }
        });
        this.pack();
    }

    public void viewDocument() {
        try {
            if (this.resource.getResourceType().equals("XMLResource")) {
                this.setText((String)this.resource.getContent());
            } else {
                this.setText(new String((byte[])this.resource.getContent()));
            }
            UserManagementService service = (UserManagementService)this.client.current.getService("UserManagementService", "1.0");
            User user = service.getUser(this.properties.getProperty("user"));
            String lockOwner = service.hasUserLock(this.resource);
            if (lockOwner != null && JOptionPane.showConfirmDialog(this, Messages.getString("DocumentView.6") + lockOwner + Messages.getString("DocumentView.7"), Messages.getString("DocumentView.8"), 0) != 0) {
                this.dispose();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            try {
                service.lockResource(this.resource, user);
            }
            catch (XMLDBException ex) {
                System.out.println(ex.getMessage());
                JOptionPane.showMessageDialog(this, Messages.getString("DocumentView.9"));
                this.setReadOnly();
            }
            this.setVisible(true);
        }
        catch (XMLDBException ex) {
            DocumentView.showErrorMessage(Messages.getString("DocumentView.10") + ex.getMessage(), ex);
        }
    }

    private static void showErrorMessage(String message, Throwable t) {
        JScrollPane scroll = null;
        JTextArea msgArea = new JTextArea(message);
        msgArea.setBorder(BorderFactory.createTitledBorder("Message:"));
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
            stacktrace.setBackground(null);
            stacktrace.setEditable(false);
            scroll = new JScrollPane(stacktrace);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setBorder(BorderFactory.createTitledBorder("Exception Stacktrace:"));
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{msgArea, scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, Messages.getString("DocumentView.13"));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    public void setReadOnly() {
        this.text.setEditable(false);
        this.saveButton.setEnabled(false);
        this.readOnly = true;
    }

    private void close() {
        this.unlockView();
    }

    private void unlockView() {
        if (this.readOnly) {
            return;
        }
        try {
            UserManagementService service = (UserManagementService)this.collection.getService("UserManagementService", "1.0");
            service.unlockResource(this.resource);
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    private void setupComponents() throws XMLDBException {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu(Messages.getString("DocumentView.16"));
        fileMenu.setMnemonic(70);
        menubar.add(fileMenu);
        JMenuItem item = new JMenuItem(Messages.getString("DocumentView.17"), 83);
        item.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("SAVE");
                DocumentView.this.save();
            }
        });
        fileMenu.add(item);
        this.setJMenuBar(menubar);
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Save24.gif");
        this.saveButton = new JButton(new ImageIcon(url));
        this.saveButton.setToolTipText(Messages.getString("DocumentView.20"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.save();
            }
        });
        toolbar.add(this.saveButton);
        url = this.getClass().getResource("icons/SaveAs24.gif");
        this.saveAsButton = new JButton(new ImageIcon(url));
        this.saveAsButton.setToolTipText(Messages.getString("DocumentView.22"));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.saveAs();
            }
        });
        toolbar.add(this.saveAsButton);
        url = this.getClass().getResource("icons/Export24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("DocumentView.24"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DocumentView.this.export();
                }
                catch (XMLDBException u) {
                    u.printStackTrace();
                }
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Copy24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("DocumentView.26"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.copy();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Cut24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("DocumentView.28"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.cut();
            }
        });
        toolbar.add(button);
        url = this.getClass().getResource("icons/Paste24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("DocumentView.30"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DocumentView.this.text.paste();
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Refresh24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("DocumentView.32"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DocumentView.this.refresh();
                }
                catch (XMLDBException u) {
                    u.printStackTrace();
                }
            }
        });
        toolbar.add(button);
        this.getContentPane().add((Component)toolbar, "North");
        this.text = new ClientTextArea(true, Messages.getString("DocumentView.33"));
        this.getContentPane().add((Component)((Object)this.text), "Center");
        Box statusbar = Box.createHorizontalBox();
        statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.statusMessage = new JTextField(20);
        this.statusMessage.setEditable(false);
        this.statusMessage.setFocusable(false);
        this.statusMessage.setText(Messages.getString("DocumentView.34") + URIUtils.urlDecodeUtf8(this.resource.getId()) + Messages.getString("DocumentView.35"));
        statusbar.add(this.statusMessage);
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(200, 30));
        this.progress.setVisible(false);
        statusbar.add(this.progress);
        this.getContentPane().add((Component)statusbar, "South");
    }

    private void save() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DocumentView.this.statusMessage.setText(Messages.getString("DocumentView.36") + URIUtils.urlDecodeUtf8(DocumentView.this.resource.getId()));
                    if (DocumentView.this.collection instanceof Observable) {
                        ((Observable)DocumentView.this.collection).addObserver(new ProgressObserver());
                    }
                    DocumentView.this.progress.setIndeterminate(true);
                    DocumentView.this.progress.setVisible(true);
                    DocumentView.this.resource.setContent((Object)DocumentView.this.text.getText());
                    DocumentView.this.collection.storeResource(DocumentView.this.resource);
                    if (DocumentView.this.collection instanceof Observable) {
                        ((Observable)DocumentView.this.collection).deleteObservers();
                    }
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(Messages.getString("DocumentView.37") + e.getMessage(), e);
                }
                finally {
                    DocumentView.this.progress.setVisible(false);
                }
            }
        }.start();
    }

    private void saveAs() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String nameres = JOptionPane.showInputDialog(null, (Object)Messages.getString("DocumentView.38"));
                if (nameres != null) {
                    try {
                        DocumentView.this.statusMessage.setText(Messages.getString("DocumentView.39") + nameres);
                        if (DocumentView.this.collection instanceof Observable) {
                            ((Observable)DocumentView.this.collection).addObserver(new ProgressObserver());
                        }
                        DocumentView.this.progress.setIndeterminate(true);
                        DocumentView.this.progress.setVisible(true);
                        XMLResource result = null;
                        result = (XMLResource)DocumentView.this.collection.createResource(URIUtils.encodeXmldbUriFor(nameres).toString(), "XMLResource");
                        result.setContent((Object)DocumentView.this.text.getText());
                        DocumentView.this.collection.storeResource((Resource)result);
                        DocumentView.this.client.reloadCollection();
                        if (DocumentView.this.collection instanceof Observable) {
                            ((Observable)DocumentView.this.collection).deleteObservers();
                        }
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(Messages.getString("DocumentView.40") + e.getMessage(), e);
                    }
                    catch (URISyntaxException e) {
                        ClientFrame.showErrorMessage(Messages.getString("DocumentView.41") + e.getMessage(), e);
                    }
                    finally {
                        DocumentView.this.progress.setVisible(false);
                    }
                }
            }
        }.start();
    }

    private void export() throws XMLDBException {
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser(workDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(new File(this.resource.getId()));
        if (chooser.showDialog(this, Messages.getString("DocumentView.44")) == 0) {
            File file = chooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, Messages.getString("DocumentView.45"), Messages.getString("DocumentView.46"), 0) == 1) {
                return;
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName(this.properties.getProperty("encoding")));
                writer.write(this.text.getText());
                writer.close();
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage(Messages.getString("DocumentView.48") + e.getMessage(), e);
            }
            File selectedDir = chooser.getCurrentDirectory();
            this.properties.setProperty("working-dir", selectedDir.getAbsolutePath());
        }
    }

    private void refresh() throws XMLDBException {
        this.unlockView();
        this.resource = this.client.retrieve(this.resourceName, this.properties.getProperty("indent", "yes"));
        this.viewDocument();
    }

    public void setText(String content) throws XMLDBException {
        this.text.setText("");
        this.text.setText(content);
        this.text.setCaretPosition(0);
        this.text.scrollToCaret();
        this.statusMessage.setText(Messages.getString("DocumentView.52") + XmldbURI.create(this.client.getCollection().getName()).append(this.resourceName) + Messages.getString("DocumentView.53") + this.properties.getProperty("uri"));
    }

    class ProgressObserver
    implements Observer {
        int mode = 0;

        ProgressObserver() {
        }

        public void update(Observable o, Object arg) {
            DocumentView.this.progress.setIndeterminate(false);
            ProgressIndicator ind = (ProgressIndicator)arg;
            DocumentView.this.progress.setValue(ind.getPercentage());
            if (o instanceof TextSearchEngine) {
                DocumentView.this.progress.setString("Storing words");
            } else if (o instanceof ElementIndex) {
                DocumentView.this.progress.setString("Storing elements");
            }
        }
    }
}

