/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.exist.util.MimeTable;

public class MimeTypeFileFilter
extends FileFilter {
    private String description = null;
    private Vector extensions = null;

    public MimeTypeFileFilter(String mimeType) {
        this.description = MimeTable.getInstance().getContentType(mimeType).getDescription();
        this.extensions = MimeTable.getInstance().getAllExtensions(mimeType);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        int extensionOffset = file.getName().lastIndexOf(46);
        if (extensionOffset == -1) {
            return false;
        }
        String fileExtension = file.getName().substring(extensionOffset).toLowerCase();
        Iterator itExtensions = this.extensions.iterator();
        while (itExtensions.hasNext()) {
            String extension = (String)itExtensions.next();
            if (!fileExtension.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        String description = this.description + " (";
        Iterator itExtensions = this.extensions.iterator();
        while (itExtensions.hasNext()) {
            description = description + (String)itExtensions.next();
            if (!itExtensions.hasNext()) continue;
            description = description + ' ';
        }
        return description + ")";
    }
}

