/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.exist.client.CollectionXConf;
import org.exist.client.InteractiveClient;
import org.exist.client.PrettyXmldbURI;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

class TriggersDialog
extends JFrame {
    private CollectionXConf cx = null;
    private JComboBox cmbCollections;
    private JTable tblTriggers;
    private TriggersTableModel triggersModel;
    private TableColumn colStoreDocument;
    private TableColumn colUpdateDocument;
    private TableColumn colRemoveDocument;
    private TableColumn colCreateCollection;
    private TableColumn colRenameCollection;
    private TableColumn colDeleteCollection;
    private InteractiveClient client;

    public TriggersDialog(String title, InteractiveClient client) {
        super(title);
        this.client = client;
        WindowAdapter windowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TriggersDialog.this.saveChanges();
                TriggersDialog.this.setVisible(false);
                TriggersDialog.this.dispose();
            }
        };
        this.addWindowListener(windowListener);
        this.setupComponents();
        this.actionGetTriggers("/db");
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel("Collection");
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        ArrayList alCollections = new ArrayList();
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList alAllCollections = this.getCollections(root, new ArrayList());
            for (int i = 0; i < alAllCollections.size(); ++i) {
                if (alAllCollections.get(i).toString().indexOf("/db/system/config") != -1) continue;
                alCollections.add(alAllCollections.get(i));
            }
        }
        catch (XMLDBException e) {
            return;
        }
        this.cmbCollections = new JComboBox<Object>(alCollections.toArray());
        this.cmbCollections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriggersDialog.this.saveChanges();
                JComboBox cb = (JComboBox)e.getSource();
                TriggersDialog.this.actionGetTriggers(cb.getSelectedItem().toString());
            }
        });
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        grid.setConstraints(this.cmbCollections, c);
        this.getContentPane().add(this.cmbCollections);
        JPanel panelTriggers = new JPanel();
        panelTriggers.setBorder(new TitledBorder("Triggers"));
        GridBagLayout panelTriggersGrid = new GridBagLayout();
        panelTriggers.setLayout(panelTriggersGrid);
        this.triggersModel = new TriggersTableModel();
        this.tblTriggers = new JTable(this.triggersModel);
        this.tblTriggers.setAutoResizeMode(1);
        this.tblTriggers.setSelectionMode(0);
        this.colStoreDocument = this.tblTriggers.getColumnModel().getColumn(1);
        this.colStoreDocument.setCellEditor(new CheckBoxCellEditor());
        this.colStoreDocument.setCellRenderer(new CheckBoxCellRenderer());
        this.colUpdateDocument = this.tblTriggers.getColumnModel().getColumn(2);
        this.colUpdateDocument.setCellEditor(new CheckBoxCellEditor());
        this.colUpdateDocument.setCellRenderer(new CheckBoxCellRenderer());
        this.colRemoveDocument = this.tblTriggers.getColumnModel().getColumn(3);
        this.colRemoveDocument.setCellEditor(new CheckBoxCellEditor());
        this.colRemoveDocument.setCellRenderer(new CheckBoxCellRenderer());
        this.colCreateCollection = this.tblTriggers.getColumnModel().getColumn(4);
        this.colCreateCollection.setCellEditor(new CheckBoxCellEditor());
        this.colCreateCollection.setCellRenderer(new CheckBoxCellRenderer());
        this.colRenameCollection = this.tblTriggers.getColumnModel().getColumn(5);
        this.colRenameCollection.setCellEditor(new CheckBoxCellEditor());
        this.colRenameCollection.setCellRenderer(new CheckBoxCellRenderer());
        this.colDeleteCollection = this.tblTriggers.getColumnModel().getColumn(6);
        this.colDeleteCollection.setCellEditor(new CheckBoxCellEditor());
        this.colDeleteCollection.setCellRenderer(new CheckBoxCellRenderer());
        JScrollPane scrollFullTextIndexes = new JScrollPane(this.tblTriggers);
        scrollFullTextIndexes.setPreferredSize(new Dimension(250, 150));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelTriggersGrid.setConstraints(scrollFullTextIndexes, c);
        panelTriggers.add(scrollFullTextIndexes);
        Box triggersToolbarBox = Box.createHorizontalBox();
        JButton btnAddTrigger = new JButton("Add");
        btnAddTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriggersDialog.this.actionAddTrigger();
            }
        });
        triggersToolbarBox.add(btnAddTrigger);
        JButton btnDeleteTrigger = new JButton("Delete");
        btnDeleteTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TriggersDialog.this.actionDeleteTrigger();
            }
        });
        triggersToolbarBox.add(btnDeleteTrigger);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelTriggersGrid.setConstraints(triggersToolbarBox, c);
        panelTriggers.add(triggersToolbarBox);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        grid.setConstraints(panelTriggers, c);
        this.getContentPane().add(panelTriggers);
        this.pack();
    }

    private void saveChanges() {
        int result;
        if (this.cx.hasChanged() && (result = JOptionPane.showConfirmDialog(this.getContentPane(), "The configuration for the collection has changed, would you like to save the changes?", "Save Changes", 0)) == 0) {
            if (this.cx.Save()) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Your changes have been saved.");
            } else {
                JOptionPane.showMessageDialog(this.getContentPane(), "Unable to save changes!");
            }
        }
    }

    private ArrayList getCollections(Collection root, ArrayList collectionsList) throws XMLDBException {
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child = root.getChildCollection(childCollections[i]);
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void actionAddTrigger() {
        this.triggersModel.addRow();
    }

    private void actionDeleteTrigger() {
        int iSelectedRow = this.tblTriggers.getSelectedRow();
        if (iSelectedRow > -1) {
            this.triggersModel.removeRow(iSelectedRow);
        }
    }

    private void actionGetTriggers(String collectionName) {
        try {
            this.cx = new CollectionXConf(collectionName, this.client);
            this.triggersModel.fireTableDataChanged();
        }
        catch (XMLDBException xMLDBException) {
            // empty catch block
        }
    }

    class TriggersTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"class", "Store Document", "Update Document", "Remove Document", "Create Collection", "Rename Collection", "Delete Collection"};

        public TriggersTableModel() {
            this.fireTableDataChanged();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String triggerClass = null;
            boolean STORE_DOCUMENT_EVENT = (Boolean)TriggersDialog.this.colStoreDocument.getCellEditor().getCellEditorValue();
            boolean UPDATE_DOCUMENT_EVENT = (Boolean)TriggersDialog.this.colUpdateDocument.getCellEditor().getCellEditorValue();
            boolean REMOVE_DOCUMENT_EVENT = (Boolean)TriggersDialog.this.colRemoveDocument.getCellEditor().getCellEditorValue();
            boolean CREATE_COLLECTION_EVENT = (Boolean)TriggersDialog.this.colCreateCollection.getCellEditor().getCellEditorValue();
            boolean RENAME_COLLECTION_EVENT = (Boolean)TriggersDialog.this.colRenameCollection.getCellEditor().getCellEditorValue();
            boolean DELETE_COLLECTION_EVENT = (Boolean)TriggersDialog.this.colDeleteCollection.getCellEditor().getCellEditorValue();
            if (columnIndex == 0) {
                triggerClass = (String)aValue;
            }
            TriggersDialog.this.cx.updateTrigger(rowIndex, triggerClass, STORE_DOCUMENT_EVENT, UPDATE_DOCUMENT_EVENT, REMOVE_DOCUMENT_EVENT, CREATE_COLLECTION_EVENT, RENAME_COLLECTION_EVENT, DELETE_COLLECTION_EVENT, null);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            TriggersDialog.this.cx.deleteTrigger(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            TriggersDialog.this.cx.addTrigger("", false, false, false, false, false, false, null);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return TriggersDialog.this.cx != null ? TriggersDialog.this.cx.getTriggerCount() : 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TriggersDialog.this.cx.getTrigger(rowIndex).getTriggerClass();
                }
                case 1: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getStoreDocumentEvent());
                }
                case 2: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getUpdateDocumentEvent());
                }
                case 3: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getRemoveDocumentEvent());
                }
                case 4: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getCreateCollectionEvent());
                }
                case 5: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getRenameCollectionEvent());
                }
                case 6: {
                    return new Boolean(TriggersDialog.this.cx.getTrigger(rowIndex).getDeleteCollectionEvent());
                }
            }
            return null;
        }
    }

    public class CheckBoxCellEditor
    extends DefaultCellEditor {
        public CheckBoxCellEditor() {
            super(new JCheckBox());
        }
    }

    public class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

