/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.cond.FunctionFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Abbreviator {
    private static final Logger LOG = Logger.getLogger((Class)Abbreviator.class);
    private static final String[][] comparisonMap = new String[][]{{"equal", "="}, {"less-than-or-equal", "<="}, {"less-than", "<"}, {"greater-than-or-equal", ">="}, {"greater-than", ">"}};
    private Map attributeIdMap = new HashMap(8);
    private Map typeMap = new HashMap(8);
    private Map functionMap = new HashMap(8);

    public String getAbbreviatedId(URI uri) {
        if (uri == null) {
            return null;
        }
        String toString = uri.toString();
        if (toString.startsWith("http://exist-db.org/xacml")) {
            int i = (toString = toString.substring("http://exist-db.org/xacml".length())).lastIndexOf(35);
            if (i == -1) {
                i = toString.lastIndexOf(47);
                if (i != -1) {
                    toString = toString.substring(i + 1);
                }
            } else {
                toString = toString.substring(i + 1);
            }
        } else if (toString.startsWith("urn:oasis:names:tc:xacml:1.0:")) {
            int i = (toString = toString.substring("urn:oasis:names:tc:xacml:1.0:".length())).lastIndexOf(58);
            if (i != -1) {
                toString = toString.substring(i + 1);
            }
        } else {
            return toString;
        }
        this.attributeIdMap.put(toString, uri);
        return toString;
    }

    public URI getFullIdURI(String abbrev) {
        return Abbreviator.get(this.attributeIdMap, abbrev);
    }

    public String getAbbreviatedType(URI type) {
        if (type == null) {
            return null;
        }
        String toString = type.toString();
        if (toString.startsWith("urn:oasis:names:tc:xacml:1.0:data-type:")) {
            toString = toString.substring("urn:oasis:names:tc:xacml:1.0:data-type:".length());
        } else if (toString.startsWith("http://www.w3.org/2001/XMLSchema")) {
            toString = toString.substring("http://www.w3.org/2001/XMLSchema".length() + 1);
        } else if (toString.startsWith("http://www.w3c.org/TR/2002/WD-xquery-operators-20020816")) {
            toString = toString.substring("http://www.w3c.org/TR/2002/WD-xquery-operators-20020816".length() + 1);
        } else {
            return toString;
        }
        this.typeMap.put(toString, type);
        return toString;
    }

    public URI getFullTypeURI(String abbrev) {
        return Abbreviator.get(this.typeMap, abbrev);
    }

    public String getAbbreviatedCombiningID(URI uri) {
        if (uri == null) {
            return null;
        }
        String toString = uri.toString();
        if (toString.startsWith("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:")) {
            toString = toString.substring("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:".length());
        } else if (toString.startsWith("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:")) {
            toString = toString.substring("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:".length());
        } else {
            return toString;
        }
        return toString;
    }

    public URI getFullCombiningURI(String abbrev, boolean isRuleAlg) {
        if (abbrev == null) {
            return null;
        }
        String prefix = isRuleAlg ? "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:" : "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:";
        return URI.create(prefix + abbrev);
    }

    public String getAbbreviatedFunctionId(URI functionId) {
        if (functionId == null) {
            return null;
        }
        String toString = functionId.toString();
        if (!toString.startsWith("urn:oasis:names:tc:xacml:1.0:function:")) {
            this.functionMap.put(functionId, toString);
            return toString;
        }
        toString = toString.substring("urn:oasis:names:tc:xacml:1.0:function:".length());
        if (toString.equals("regexp-string-match")) {
            toString = "string-match";
        }
        for (int i = 0; i < comparisonMap.length; ++i) {
            if (!toString.endsWith(comparisonMap[i][0])) continue;
            toString = comparisonMap[i][1];
            return toString;
        }
        this.functionMap.put(functionId, toString);
        return toString;
    }

    public URI getFullFunctionId(String abbrev, URI dataType) {
        if (abbrev == null || dataType == null) {
            return null;
        }
        URI uri = (URI)this.functionMap.get(abbrev);
        if (uri != null) {
            return uri;
        }
        String abbrevType = this.getAbbreviatedType(dataType);
        if (abbrev.equals("match") && abbrevType.equals("string")) {
            return URI.create("urn:oasis:names:tc:xacml:1.0:function:regexp-string-match");
        }
        for (int i = 0; i < comparisonMap.length; ++i) {
            if (!abbrev.equals(comparisonMap[i][1])) continue;
            abbrev = abbrevType + "-" + comparisonMap[i][0];
            break;
        }
        return URI.create("urn:oasis:names:tc:xacml:1.0:function:" + abbrev);
    }

    public Set getAbbreviatedTargetFunctions(URI dataType) {
        FunctionFactory factory = FunctionFactory.getTargetInstance();
        Set functionIds = factory.getSupportedFunctions();
        HashSet<String> ret = new HashSet<String>();
        String abbrevType = this.getAbbreviatedType(dataType);
        Iterator it = functionIds.iterator();
        while (it.hasNext()) {
            String functionId = (String)it.next();
            if ((functionId = this.abbrevTargetFunctionId(functionId, abbrevType)) == null) continue;
            ret.add(functionId);
        }
        return ret;
    }

    public String getAbbreviatedTargetFunctionId(URI functionId, URI dataType) {
        if (functionId == null || dataType == null) {
            return null;
        }
        return this.abbrevTargetFunctionId(functionId.toString(), this.getAbbreviatedType(dataType));
    }

    private String abbrevTargetFunctionId(String functionId, String abbrevType) {
        if (!functionId.startsWith("urn:oasis:names:tc:xacml:1.0:function:")) {
            return null;
        }
        functionId = functionId.substring("urn:oasis:names:tc:xacml:1.0:function:".length());
        if (functionId.equals("regexp-string-match")) {
            functionId = "string-match";
        }
        if (functionId.startsWith(abbrevType)) {
            functionId = functionId.substring(abbrevType.length() + 1);
            for (int i = 0; i < comparisonMap.length; ++i) {
                if (!functionId.equals(comparisonMap[i][0])) continue;
                functionId = comparisonMap[i][1];
                return functionId;
            }
            return functionId;
        }
        return null;
    }

    private static URI get(Map map, String abbrev) {
        URI ret = (URI)map.get(abbrev);
        return ret == null ? Abbreviator.parse(abbrev) : ret;
    }

    private static URI parse(String abbrev) {
        try {
            return new URI(abbrev);
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Invalid URI '" + abbrev + "'"), (Throwable)e);
            return null;
        }
    }
}

