/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Rule;
import com.sun.xacml.Target;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.RuleNode;
import org.exist.client.xacml.XACMLTreeNode;

public class PolicyNode
extends AbstractPolicyNode {
    private List rules;
    private List originalRules;

    public PolicyNode(NodeContainer parent, Policy policy) {
        this(parent, null, policy);
    }

    public PolicyNode(NodeContainer parent, String documentName, Policy policy) {
        super(parent, documentName, (AbstractPolicy)policy);
        List children = policy.getChildren();
        this.rules = new ArrayList(children.size());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this.rules.add(new RuleNode((NodeContainer)this, (Rule)it.next()));
        }
        this.originalRules = new ArrayList(this.rules);
    }

    public PolicyTreeElement create() {
        return this.createPolicy();
    }

    public PolicyTreeElement create(URI id) {
        return this.createPolicy(id);
    }

    public Policy createPolicy() {
        return this.createPolicy(null);
    }

    public Policy createPolicy(URI id) {
        Target target = this.getTarget().getTarget();
        RuleCombiningAlgorithm algorithm = (RuleCombiningAlgorithm)this.getCombiningAlgorithm();
        ArrayList<Rule> rawRules = new ArrayList<Rule>(this.rules.size());
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            rawRules.add(((RuleNode)it.next()).createRule());
        }
        URI useId = id == null ? this.getId() : id;
        return new Policy(useId, algorithm, this.getDescription(), target, rawRules);
    }

    public void add(PolicyTreeElement element) {
        this.add(-1, element);
    }

    public void add(int index, PolicyTreeElement element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof Rule)) {
            throw new IllegalArgumentException("Policies can only contain rules.");
        }
        this.add(index, new RuleNode((NodeContainer)this, (Rule)element));
    }

    public void add(PolicyElementNode node) {
        this.add(-1, node);
    }

    public void add(int index, PolicyElementNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof RuleNode) {
            if (index < 0) {
                index = this.rules.size() + 1;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Cannot insert Rule before Target");
            }
        } else {
            throw new IllegalArgumentException("PolicyNodes can only contain RuleNodes.");
        }
        this.rules.add(index - 1, node);
        this.setModified(true);
        this.nodeAdded(node, index);
    }

    public void remove(PolicyElementNode node) {
        if (node == null) {
            return;
        }
        int index = this.rules.indexOf(node);
        if (index < 0) {
            return;
        }
        this.rules.remove(index);
        this.setModified(true);
        this.nodeRemoved(node, index + 1);
    }

    public boolean containsId(String id) {
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            if (!((RuleNode)it.next()).getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.rules.size() + 1;
    }

    public XACMLTreeNode getChild(int index) {
        return index == 0 ? this.getTarget() : (XACMLTreeNode)this.rules.get(index - 1);
    }

    public int indexOfChild(Object child) {
        if (child == this.getTarget()) {
            return 0;
        }
        int ret = this.rules.indexOf(child);
        return ret >= 0 ? ret + 1 : -1;
    }

    public boolean isModified(boolean deep) {
        if (super.isModified(deep)) {
            return true;
        }
        if (deep) {
            Iterator it = this.rules.iterator();
            while (it.hasNext()) {
                if (!((RuleNode)it.next()).isModified(true)) continue;
                return true;
            }
        }
        return false;
    }

    public void revert(boolean deep) {
        this.rules = new ArrayList(this.originalRules);
        if (deep) {
            Iterator it = this.rules.iterator();
            while (it.hasNext()) {
                ((RuleNode)it.next()).revert(true);
            }
        }
        super.revert(deep);
    }

    public void commit(boolean deep) {
        this.originalRules = new ArrayList(this.rules);
        if (deep) {
            Iterator it = this.rules.iterator();
            while (it.hasNext()) {
                ((RuleNode)it.next()).commit(true);
            }
        }
        super.commit(deep);
    }
}

